/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class CTabFolderRenderer {
    protected CTabFolder parent;
    int[] curve;
    int[] topCurveHighlightStart;
    int[] topCurveHighlightEnd;
    int curveWidth = 0;
    int curveIndent = 0;
    int lastTabHeight = -1;
    Color fillColor;
    Color selectionHighlightGradientBegin = null;
    Color[] selectionHighlightGradientColorsCache = null;
    Color selectedOuterColor = null;
    Color selectedInnerColor = null;
    Color tabAreaColor = null;
    Color lastBorderColor = null;
    static final String COLOR_CACHE = "org.eclipse.swt.custom.CTabFolderRenderer.ColorCache";
    static final int[] TOP_LEFT_CORNER_HILITE = new int[]{5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6};
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_UNSELECTED_INNER_CORNER;
    static final int[] TOP_LEFT_CORNER_BORDERLESS;
    static final int[] TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final RGB CLOSE_FILL;
    static final int BUTTON_SIZE = 18;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int BORDER1_COLOR = 18;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 2;
    static final int ITEM_LEFT_MARGIN = 4;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";
    public static final int PART_BODY = -1;
    public static final int PART_HEADER = -2;
    public static final int PART_BORDER = -3;
    public static final int PART_BACKGROUND = -4;
    public static final int PART_MAX_BUTTON = -5;
    public static final int PART_MIN_BUTTON = -6;
    public static final int PART_CHEVRON_BUTTON = -7;
    public static final int PART_CLOSE_BUTTON = -8;
    public static final int MINIMUM_SIZE = 0x1000000;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
        SIMPLE_UNSELECTED_INNER_CORNER = new int[2];
        int[] nArray9 = new int[12];
        nArray9[1] = 6;
        nArray9[2] = 1;
        nArray9[3] = 5;
        nArray9[4] = 1;
        nArray9[5] = 4;
        nArray9[6] = 4;
        nArray9[7] = 1;
        nArray9[8] = 5;
        nArray9[9] = 1;
        nArray9[10] = 6;
        TOP_LEFT_CORNER_BORDERLESS = nArray9;
        int[] nArray10 = new int[12];
        nArray10[0] = -7;
        nArray10[2] = -6;
        nArray10[3] = 1;
        nArray10[4] = -5;
        nArray10[5] = 1;
        nArray10[6] = -2;
        nArray10[7] = 4;
        nArray10[8] = -2;
        nArray10[9] = 5;
        nArray10[10] = -1;
        nArray10[11] = 6;
        TOP_RIGHT_CORNER_BORDERLESS = nArray10;
        int[] nArray11 = new int[16];
        nArray11[1] = -6;
        nArray11[2] = 1;
        nArray11[3] = -6;
        nArray11[4] = 1;
        nArray11[5] = -5;
        nArray11[6] = 2;
        nArray11[7] = -4;
        nArray11[8] = 4;
        nArray11[9] = -2;
        nArray11[10] = 5;
        nArray11[11] = -1;
        nArray11[12] = 6;
        nArray11[13] = -1;
        nArray11[14] = 6;
        BOTTOM_LEFT_CORNER_BORDERLESS = nArray11;
        int[] nArray12 = new int[16];
        nArray12[0] = -7;
        nArray12[2] = -7;
        nArray12[3] = -1;
        nArray12[4] = -6;
        nArray12[5] = -1;
        nArray12[6] = -5;
        nArray12[7] = -2;
        nArray12[8] = -3;
        nArray12[9] = -4;
        nArray12[10] = -2;
        nArray12[11] = -5;
        nArray12[12] = -2;
        nArray12[13] = -6;
        nArray12[14] = -1;
        nArray12[15] = -6;
        BOTTOM_RIGHT_CORNER_BORDERLESS = nArray12;
        int[] nArray13 = new int[6];
        nArray13[1] = 2;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = 2;
        SIMPLE_TOP_LEFT_CORNER_BORDERLESS = nArray13;
        int[] nArray14 = new int[6];
        nArray14[0] = -3;
        nArray14[2] = -2;
        nArray14[3] = 1;
        nArray14[4] = -1;
        nArray14[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER_BORDERLESS = nArray14;
        int[] nArray15 = new int[8];
        nArray15[1] = -3;
        nArray15[2] = 1;
        nArray15[3] = -2;
        nArray15[4] = 2;
        nArray15[5] = -1;
        nArray15[6] = 3;
        SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS = nArray15;
        int[] nArray16 = new int[8];
        nArray16[0] = -4;
        nArray16[2] = -3;
        nArray16[3] = -1;
        nArray16[4] = -2;
        nArray16[5] = -2;
        nArray16[6] = -1;
        nArray16[7] = -3;
        SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS = nArray16;
        CLOSE_FILL = new RGB(252, 160, 160);
    }

    protected CTabFolderRenderer(CTabFolder cTabFolder) {
        if (cTabFolder == null) {
            return;
        }
        if (cTabFolder.isDisposed()) {
            SWT.error(5);
        }
        this.parent = cTabFolder;
    }

    static Color getColor(Display display, RGB rGB) {
        Color color;
        Object[] objectArray;
        Hashtable<RGB, Object[]> hashtable = (Hashtable<RGB, Object[]>)display.getData(COLOR_CACHE);
        if (hashtable == null) {
            hashtable = new Hashtable<RGB, Object[]>();
            display.setData(COLOR_CACHE, hashtable);
        }
        if ((objectArray = (Object[])hashtable.get(rGB)) != null) {
            color = (Color)objectArray[0];
            int n = (Integer)objectArray[1];
            objectArray[1] = new Integer(n + 1);
        } else {
            color = new Color(display, rGB);
            hashtable.put(rGB, new Object[]{color, new Integer(1)});
        }
        return color;
    }

    static void releaseColor(Display display, Color color) {
        Object[] objectArray;
        RGB rGB = color.getRGB();
        Hashtable hashtable = (Hashtable)display.getData(COLOR_CACHE);
        if (hashtable == null) {
            hashtable = new Hashtable();
            display.setData(COLOR_CACHE, hashtable);
        }
        if ((objectArray = (Object[])hashtable.get(rGB)) != null) {
            int n = (Integer)objectArray[1];
            if (--n == 0) {
                hashtable.remove(rGB);
                color.dispose();
            } else {
                objectArray[1] = new Integer(n);
            }
        }
    }

    void antialias(int[] nArray, Color color, Color color2, GC gC) {
        int n;
        int n2;
        int n3;
        if (this.parent.simple) {
            return;
        }
        String string = SWT.getPlatform();
        if ("cocoa".equals(string)) {
            return;
        }
        if ("carbon".equals(string)) {
            return;
        }
        if ("wpf".equals(string)) {
            return;
        }
        if (this.parent.getDisplay().getDepth() < 15) {
            return;
        }
        if (color2 != null) {
            int n4 = 0;
            n3 = 1;
            n2 = this.parent.onBottom ? 0 : this.parent.getSize().y;
            int[] nArray2 = new int[nArray.length];
            n = 0;
            while (n < nArray.length / 2) {
                if (n3 != 0 && n4 + 3 < nArray.length) {
                    n3 = this.parent.onBottom ? (n2 <= nArray[n4 + 3] ? 1 : 0) : (n2 >= nArray[n4 + 3] ? 1 : 0);
                    n2 = nArray[n4 + 1];
                }
                nArray2[n4] = nArray[n4++] + (n3 != 0 ? -1 : 1);
                nArray2[n4] = nArray[n4++];
                ++n;
            }
            gC.setForeground(color2);
            gC.drawPolyline(nArray2);
        }
        if (color != null) {
            int[] nArray3 = new int[nArray.length];
            n3 = 0;
            n2 = 1;
            int n5 = this.parent.onBottom ? 0 : this.parent.getSize().y;
            n = 0;
            while (n < nArray.length / 2) {
                if (n2 != 0 && n3 + 3 < nArray.length) {
                    n2 = this.parent.onBottom ? (n5 <= nArray[n3 + 3] ? 1 : 0) : (n5 >= nArray[n3 + 3] ? 1 : 0);
                    n5 = nArray[n3 + 1];
                }
                nArray3[n3] = nArray[n3++] + (n2 != 0 ? 1 : -1);
                nArray3[n3] = nArray[n3++];
                ++n;
            }
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
        }
    }

    protected Point computeSize(int n, int n2, GC gC, int n3, int n4) {
        Object object;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case -2: {
                if (this.parent.fixedTabHeight != -1) {
                    n6 = this.parent.fixedTabHeight == 0 ? 0 : this.parent.fixedTabHeight + 1;
                    break;
                }
                object = this.parent.items;
                if (((CTabItem[])object).length == 0) {
                    n6 = gC.textExtent((String)"Default", (int)9).y + 2 + 2;
                } else {
                    int n7 = 0;
                    while (n7 < ((Object)object).length) {
                        n6 = Math.max(n6, this.computeSize((int)n7, (int)0, (GC)gC, (int)n3, (int)n4).y);
                        ++n7;
                    }
                }
                gC.dispose();
                break;
            }
            case -8: 
            case -6: 
            case -5: {
                n6 = 18;
                n5 = 18;
                break;
            }
            case -7: {
                n5 = 27;
                n6 = 18;
                break;
            }
            default: {
                Object object2;
                if (n < 0 || n >= this.parent.getItemCount()) break;
                this.updateCurves();
                object = this.parent.items[n];
                if (((Widget)object).isDisposed()) {
                    return new Point(0, 0);
                }
                Image image = ((Item)object).getImage();
                if (image != null) {
                    object2 = image.getBounds();
                    if ((n2 & 2) != 0 || this.parent.showUnselectedImage) {
                        n5 += ((Rectangle)object2).width;
                    }
                    n6 = ((Rectangle)object2).height;
                }
                object2 = null;
                if ((n2 & 0x1000000) != 0) {
                    int n8 = this.parent.minChars;
                    Object object3 = object2 = n8 == 0 ? null : ((Item)object).getText();
                    if (object2 != null && ((String)object2).length() > n8) {
                        int n9;
                        if (this.useEllipses()) {
                            n9 = n8 < ELLIPSIS.length() + 1 ? n8 : n8 - ELLIPSIS.length();
                            object2 = ((String)object2).substring(0, n9);
                            if (n8 > ELLIPSIS.length() + 1) {
                                object2 = String.valueOf(object2) + ELLIPSIS;
                            }
                        } else {
                            n9 = n8;
                            object2 = ((String)object2).substring(0, n9);
                        }
                    }
                } else {
                    object2 = ((Item)object).getText();
                }
                if (object2 != null) {
                    if (n5 > 0) {
                        n5 += 4;
                    }
                    if (((CTabItem)object).font == null) {
                        Point point = gC.textExtent((String)object2, 9);
                        n5 += point.x;
                        n6 = Math.max(n6, point.y);
                    } else {
                        Font font = gC.getFont();
                        gC.setFont(((CTabItem)object).font);
                        Point point = gC.textExtent((String)object2, 9);
                        n5 += point.x;
                        n6 = Math.max(n6, point.y);
                        gC.setFont(font);
                    }
                }
                if (!this.parent.showClose && !((CTabItem)object).showClose || (n2 & 2) == 0 && !this.parent.showUnselectedClose) break;
                if (n5 > 0) {
                    n5 += 4;
                }
                n5 += this.computeSize((int)-8, (int)0, (GC)gC, (int)-1, (int)-1).x;
            }
        }
        object = this.computeTrim(n, n2, 0, 0, n5, n6);
        n5 = ((Rectangle)object).width;
        n6 = ((Rectangle)object).height;
        return new Point(n5, n6);
    }

    protected Rectangle computeTrim(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n7 = this.parent.borderVisible ? 1 : 0;
        int n9 = this.parent.onBottom ? n7 : 0;
        int n10 = this.parent.onBottom ? 0 : n7;
        int n11 = this.parent.tabHeight;
        switch (n) {
            case -1: {
                int n12;
                int n13 = this.parent.getStyle();
                int n14 = (n13 & 0x800000) != 0 ? 1 : 3;
                int n15 = n12 = (n13 & 0x800000) != 0 ? 0 : 2;
                if (this.parent.fixedTabHeight == 0 && (n13 & 0x800000) != 0 && (n13 & 0x800) == 0) {
                    n14 = 0;
                }
                int n16 = this.parent.marginWidth;
                int n17 = this.parent.marginHeight;
                n3 = n3 - n16 - n12 - n7;
                n5 = n5 + n7 + n8 + 2 * n16 + 2 * n12;
                if (this.parent.minimized) {
                    n4 = this.parent.onBottom ? n4 - n9 : n4 - n14 - n11 - n9;
                    n6 = n9 + n10 + n11 + n14;
                    break;
                }
                n4 = this.parent.onBottom ? n4 - n17 - n12 - n9 : n4 - n17 - n14 - n11 - n9;
                n6 = n6 + n9 + n10 + 2 * n17 + n11 + n14 + n12;
                break;
            }
            case -2: {
                break;
            }
            case -3: {
                n3 -= n7;
                n5 = n5 + n7 + n8;
                n4 -= n9;
                n6 = n6 + n9 + n10;
                break;
            }
            default: {
                if (n < 0 || n >= this.parent.getItemCount()) break;
                this.updateCurves();
                n3 -= 4;
                n5 = n5 + 4 + 4;
                if (!this.parent.simple && !this.parent.single && (n2 & 2) != 0) {
                    n5 += this.curveWidth - this.curveIndent;
                }
                n4 -= 2;
                n6 = n6 + 2 + 2;
            }
        }
        return new Rectangle(n3, n4, n5, n6);
    }

    void createAntialiasColors() {
        int n;
        int n2;
        int n3;
        RGB rGB;
        RGB rGB2;
        this.disposeAntialiasColors();
        Display display = this.parent.getDisplay();
        this.lastBorderColor = display.getSystemColor(18);
        RGB rGB3 = this.lastBorderColor.getRGB();
        RGB rGB4 = this.parent.selectionBackground.getRGB();
        if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
            rGB4 = null;
        }
        RGB rGB5 = this.parent.getBackground().getRGB();
        if (this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
            rGB5 = null;
        }
        if (rGB5 != null) {
            rGB2 = rGB3;
            rGB = rGB5;
            n3 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n2 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.selectedOuterColor = CTabFolderRenderer.getColor(display, new RGB(n3, n2, n));
        }
        if (rGB4 != null) {
            rGB2 = rGB3;
            rGB = rGB4;
            n3 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n2 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.selectedInnerColor = CTabFolderRenderer.getColor(display, new RGB(n3, n2, n));
        }
        if ((rGB5 = this.parent.getParent().getBackground().getRGB()) != null) {
            rGB2 = rGB3;
            rGB = rGB5;
            n3 = rGB2.red + 2 * (rGB.red - rGB2.red) / 3;
            n2 = rGB2.green + 2 * (rGB.green - rGB2.green) / 3;
            n = rGB2.blue + 2 * (rGB.blue - rGB2.blue) / 3;
            this.tabAreaColor = CTabFolderRenderer.getColor(display, new RGB(n3, n2, n));
        }
    }

    void createSelectionHighlightGradientColors(Color color) {
        this.disposeSelectionHighlightGradientColors();
        if (color == null) {
            return;
        }
        int n = this.parent.tabHeight;
        RGB rGB = color.getRGB();
        RGB rGB2 = this.parent.selectionBackground.getRGB();
        this.selectionHighlightGradientColorsCache = new Color[n];
        int n2 = n - 1;
        Display display = this.parent.getDisplay();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 - n3;
            int n5 = n3;
            int n6 = (rGB2.red * n5 + rGB.red * n4) / n2;
            int n7 = (rGB2.green * n5 + rGB.green * n4) / n2;
            int n8 = (rGB2.blue * n5 + rGB.blue * n4) / n2;
            this.selectionHighlightGradientColorsCache[n3] = CTabFolderRenderer.getColor(display, new RGB(n6, n7, n8));
            ++n3;
        }
    }

    protected void dispose() {
        this.disposeAntialiasColors();
        this.disposeSelectionHighlightGradientColors();
        if (this.fillColor != null) {
            CTabFolderRenderer.releaseColor(this.parent.getDisplay(), this.fillColor);
            this.fillColor = null;
        }
    }

    void disposeAntialiasColors() {
        Display display = this.parent.getDisplay();
        if (this.tabAreaColor != null) {
            CTabFolderRenderer.releaseColor(display, this.tabAreaColor);
        }
        if (this.selectedInnerColor != null) {
            CTabFolderRenderer.releaseColor(display, this.selectedInnerColor);
        }
        if (this.selectedOuterColor != null) {
            CTabFolderRenderer.releaseColor(display, this.selectedOuterColor);
        }
        this.selectedOuterColor = null;
        this.selectedInnerColor = null;
        this.tabAreaColor = null;
    }

    void disposeSelectionHighlightGradientColors() {
        if (this.selectionHighlightGradientColorsCache == null) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n = 0;
        while (n < this.selectionHighlightGradientColorsCache.length) {
            CTabFolderRenderer.releaseColor(display, this.selectionHighlightGradientColorsCache[n]);
            ++n;
        }
        this.selectionHighlightGradientColorsCache = null;
    }

    protected void draw(int n, int n2, Rectangle rectangle, GC gC) {
        switch (n) {
            case -4: {
                this.drawBackground(gC, rectangle, n2);
                break;
            }
            case -1: {
                this.drawBody(gC, rectangle, n2);
                break;
            }
            case -2: {
                this.drawTabArea(gC, rectangle, n2);
                break;
            }
            case -5: {
                this.drawMaximize(gC, rectangle, n2);
                break;
            }
            case -6: {
                this.drawMinimize(gC, rectangle, n2);
                break;
            }
            case -7: {
                this.drawChevron(gC, rectangle, n2);
                break;
            }
            default: {
                if (n < 0 || n >= this.parent.getItemCount()) break;
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                if ((n2 & 2) != 0) {
                    this.drawSelected(n, gC, rectangle, n2);
                    break;
                }
                this.drawUnselected(n, gC, rectangle, n2);
            }
        }
    }

    void drawBackground(GC gC, Rectangle rectangle, int n) {
        boolean bl = (n & 2) != 0;
        Color color = bl ? this.parent.selectionBackground : this.parent.getBackground();
        Image image = bl ? this.parent.selectionBgImage : null;
        Color[] colorArray = bl ? this.parent.selectionGradientColors : this.parent.gradientColors;
        int[] nArray = bl ? this.parent.selectionGradientPercents : this.parent.gradientPercents;
        boolean bl2 = bl ? this.parent.selectionGradientVertical : this.parent.gradientVertical;
        this.drawBackground(gC, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, image, colorArray, nArray, bl2);
    }

    void drawBackground(GC gC, int[] nArray, boolean bl) {
        int n;
        Color color = bl ? this.parent.selectionBackground : this.parent.getBackground();
        Image image = bl ? this.parent.selectionBgImage : null;
        Color[] colorArray = bl ? this.parent.selectionGradientColors : this.parent.gradientColors;
        int[] nArray2 = bl ? this.parent.selectionGradientPercents : this.parent.gradientPercents;
        boolean bl2 = bl ? this.parent.selectionGradientVertical : this.parent.gradientVertical;
        Point point = this.parent.getSize();
        int n2 = point.x;
        int n3 = this.parent.tabHeight + ((this.parent.getStyle() & 0x800000) != 0 ? 1 : 3);
        int n4 = 0;
        int n5 = this.parent.borderVisible ? 1 : 0;
        int n6 = this.parent.onBottom ? n5 : 0;
        int n7 = n = this.parent.onBottom ? 0 : n5;
        if (n5 > 0) {
            ++n4;
            n2 -= 2;
        }
        int n8 = this.parent.onBottom ? point.y - n - n3 : n6;
        this.drawBackground(gC, nArray, n4, n8, n2, n3, color, image, colorArray, nArray2, bl2);
    }

    void drawBackground(GC gC, int[] nArray, int n, int n2, int n3, int n4, Color color, Image image, Color[] colorArray, int[] nArray2, boolean bl) {
        Region region = null;
        Region region2 = null;
        if (nArray != null) {
            region = new Region();
            gC.getClipping(region);
            region2 = new Region();
            region2.add(nArray);
            region2.intersect(region);
            gC.setClipping(region2);
        }
        if (image != null) {
            gC.setBackground(color);
            gC.fillRectangle(n, n2, n3, n4);
            Rectangle rectangle = image.getBounds();
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2, n3, n4);
        } else if (colorArray != null) {
            if (colorArray.length == 1) {
                Color color2 = colorArray[0] != null ? colorArray[0] : color;
                gC.setBackground(color2);
                gC.fillRectangle(n, n2, n3, n4);
            } else if (bl) {
                if (this.parent.onBottom) {
                    Color color3;
                    int n5 = 0;
                    if (nArray2[nArray2.length - 1] < 100) {
                        n5 = (100 - nArray2[nArray2.length - 1]) * n4 / 100;
                        gC.setBackground(color);
                        gC.fillRectangle(n, n2, n3, n5);
                    }
                    if ((color3 = colorArray[colorArray.length - 1]) == null) {
                        color3 = color;
                    }
                    int n6 = nArray2.length - 1;
                    while (n6 >= 0) {
                        gC.setForeground(color3);
                        color3 = colorArray[n6];
                        if (color3 == null) {
                            color3 = color;
                        }
                        gC.setBackground(color3);
                        int n7 = n6 > 0 ? nArray2[n6] - nArray2[n6 - 1] : nArray2[n6];
                        int n8 = n7 * n4 / 100;
                        gC.fillGradientRectangle(n, n2 + n5, n3, n8, true);
                        n5 += n8;
                        --n6;
                    }
                } else {
                    Color color4 = colorArray[0];
                    if (color4 == null) {
                        color4 = color;
                    }
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < nArray2.length) {
                        gC.setForeground(color4);
                        color4 = colorArray[n10 + 1];
                        if (color4 == null) {
                            color4 = color;
                        }
                        gC.setBackground(color4);
                        int n11 = n10 > 0 ? nArray2[n10] - nArray2[n10 - 1] : nArray2[n10];
                        int n12 = n11 * n4 / 100;
                        gC.fillGradientRectangle(n, n2 + n9, n3, n12, true);
                        n9 += n12;
                        ++n10;
                    }
                    if (n9 < n4) {
                        gC.setBackground(color);
                        gC.fillRectangle(n, n9, n3, n4 - n9 + 1);
                    }
                }
            } else {
                n2 = 0;
                n4 = this.parent.getSize().y;
                Color color5 = colorArray[0];
                if (color5 == null) {
                    color5 = color;
                }
                int n13 = 0;
                int n14 = 0;
                while (n14 < nArray2.length) {
                    gC.setForeground(color5);
                    color5 = colorArray[n14 + 1];
                    if (color5 == null) {
                        color5 = color;
                    }
                    gC.setBackground(color5);
                    int n15 = nArray2[n14] * n3 / 100 - n13;
                    gC.fillGradientRectangle(n + n13, n2, n15, n4, false);
                    n13 += n15;
                    ++n14;
                }
                if (n13 < n3) {
                    gC.setBackground(color);
                    gC.fillRectangle(n + n13, n2, n3 - n13, n4);
                }
            }
        } else if ((this.parent.getStyle() & 0x40000) != 0 || !color.equals(this.parent.getBackground())) {
            gC.setBackground(color);
            gC.fillRectangle(n, n2, n3, n4);
        }
        if (nArray != null) {
            gC.setClipping(region);
            region.dispose();
            region2.dispose();
        }
    }

    void drawBorder(GC gC, int[] nArray) {
        gC.setForeground(this.parent.getDisplay().getSystemColor(18));
        gC.drawPolyline(nArray);
    }

    void drawBody(GC gC, Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Point point = new Point(rectangle.width, rectangle.height);
        int n7 = this.parent.selectedIndex;
        int n8 = this.parent.tabHeight;
        int n9 = n6 = this.parent.borderVisible ? 1 : 0;
        int n10 = this.parent.onBottom ? n6 : 0;
        int n11 = this.parent.onBottom ? 0 : n6;
        int n12 = this.parent.getStyle();
        int n13 = (n12 & 0x800000) != 0 ? 1 : 3;
        int n14 = n5 = (n12 & 0x800000) != 0 ? 0 : 2;
        if (!this.parent.minimized) {
            int n15;
            int n16;
            n4 = point.x - n6 - n9 - 2 * n5;
            n3 = point.y - n10 - n11 - n8 - n13 - n5;
            if (n5 > 0) {
                int[] nArray = null;
                if (this.parent.onBottom) {
                    n2 = n6;
                    n16 = n10;
                    n15 = point.x - n9;
                    int n17 = point.y - n11 - n8 - n13;
                    nArray = new int[]{n2, n16, n15, n16, n15, n17, n15 - n5, n17, n15 - n5, n16 + n5, n2 + n5, n16 + n5, n2 + n5, n17, n2, n17};
                } else {
                    n2 = n6;
                    n16 = n10 + n8 + n13;
                    n15 = point.x - n9;
                    int n18 = point.y - n11;
                    nArray = new int[]{n2, n16, n2 + n5, n16, n2 + n5, n18 - n5, n15 - n5, n18 - n5, n15 - n5, n16, n15, n16, n15, n18, n2, n18};
                }
                if (n7 != -1 && this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1 && !this.parent.selectionGradientVertical) {
                    this.drawBackground(gC, nArray, true);
                } else if (n7 == -1 && this.parent.gradientColors != null && this.parent.gradientColors.length > 1 && !this.parent.gradientVertical) {
                    this.drawBackground(gC, nArray, false);
                } else {
                    gC.setBackground(n7 == -1 ? this.parent.getBackground() : this.parent.selectionBackground);
                    gC.fillPolygon(nArray);
                }
            }
            if ((this.parent.getStyle() & 0x40000) != 0) {
                gC.setBackground(this.parent.getBackground());
                int n19 = this.parent.marginWidth;
                n2 = this.parent.marginHeight;
                n16 = n6 + n19 + n5;
                n15 = this.parent.onBottom ? n10 + n5 + n2 : n10 + n8 + n13 + n2;
                gC.fillRectangle(n16 - n19, n15 - n2, n4, n3);
            }
        } else if ((this.parent.getStyle() & 0x40000) != 0 && point.y > (n4 = n10 + n8 + n13 + n11)) {
            gC.setBackground(this.parent.getParent().getBackground());
            gC.fillRectangle(0, n4, point.x, point.y - n4);
        }
        if (n6 > 0) {
            gC.setForeground(this.parent.getDisplay().getSystemColor(18));
            n4 = n6 - 1;
            n3 = point.x - n9;
            int n20 = this.parent.onBottom ? n10 - 1 : n10 + n8;
            n2 = this.parent.onBottom ? point.y - n8 - n11 - 1 : point.y - n11;
            gC.drawLine(n4, n20, n4, n2);
            gC.drawLine(n3, n20, n3, n2);
            if (this.parent.onBottom) {
                gC.drawLine(n4, n20, n3, n20);
            } else {
                gC.drawLine(n4, n2, n3, n2);
            }
        }
    }

    void drawClose(GC gC, Rectangle rectangle, int n) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n2 = rectangle.x + Math.max(1, (rectangle.width - 9) / 2);
        int n3 = rectangle.y + Math.max(1, (rectangle.height - 9) / 2);
        n3 += this.parent.onBottom ? -1 : 1;
        Color color = display.getSystemColor(17);
        switch (n & 0x2A) {
            case 0: {
                int[] nArray = new int[]{n2, n3, n2 + 2, n3, n2 + 4, n3 + 2, n2 + 5, n3 + 2, n2 + 7, n3, n2 + 9, n3, n2 + 9, n3 + 2, n2 + 7, n3 + 4, n2 + 7, n3 + 5, n2 + 9, n3 + 7, n2 + 9, n3 + 9, n2 + 7, n3 + 9, n2 + 5, n3 + 7, n2 + 4, n3 + 7, n2 + 2, n3 + 9, n2, n3 + 9, n2, n3 + 7, n2 + 2, n3 + 5, n2 + 2, n3 + 4, n2, n3 + 2};
                gC.setBackground(display.getSystemColor(25));
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 32: {
                int[] nArray = new int[]{n2, n3, n2 + 2, n3, n2 + 4, n3 + 2, n2 + 5, n3 + 2, n2 + 7, n3, n2 + 9, n3, n2 + 9, n3 + 2, n2 + 7, n3 + 4, n2 + 7, n3 + 5, n2 + 9, n3 + 7, n2 + 9, n3 + 9, n2 + 7, n3 + 9, n2 + 5, n3 + 7, n2 + 4, n3 + 7, n2 + 2, n3 + 9, n2, n3 + 9, n2, n3 + 7, n2 + 2, n3 + 5, n2 + 2, n3 + 4, n2, n3 + 2};
                gC.setBackground(this.getFillColor());
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n2 + 1, n3 + 1, n2 + 3, n3 + 1, n2 + 5, n3 + 3, n2 + 6, n3 + 3, n2 + 8, n3 + 1, n2 + 10, n3 + 1, n2 + 10, n3 + 3, n2 + 8, n3 + 5, n2 + 8, n3 + 6, n2 + 10, n3 + 8, n2 + 10, n3 + 10, n2 + 8, n3 + 10, n2 + 6, n3 + 8, n2 + 5, n3 + 8, n2 + 3, n3 + 10, n2 + 1, n3 + 10, n2 + 1, n3 + 8, n2 + 3, n3 + 6, n2 + 3, n3 + 5, n2 + 1, n3 + 3};
                gC.setBackground(this.getFillColor());
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 8: {
                int[] nArray = new int[]{n2, n3, n2 + 10, n3, n2 + 10, n3 + 10, n2, n3 + 10};
                this.drawBackground(gC, nArray, false);
            }
        }
    }

    void drawChevron(GC gC, Rectangle rectangle, int n) {
        int n2;
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n3 = this.parent.selectedIndex;
        Display display = this.parent.getDisplay();
        Point point = display.getDPI();
        int n4 = 720 / point.y;
        FontData fontData = this.parent.getFont().getFontData()[0];
        fontData.setHeight(n4);
        Font font = new Font((Device)display, fontData);
        int n5 = font.getFontData()[0].getHeight() * point.y / 72;
        int n6 = Math.max(2, (rectangle.height - n5 - 4) / 2);
        int n7 = rectangle.x + 2;
        int n8 = rectangle.y + n6;
        int n9 = this.parent.getItemCount();
        if (this.parent.single) {
            n2 = n3 == -1 ? n9 : n9 - 1;
        } else {
            int n10 = 0;
            while (n10 < this.parent.priority.length && this.parent.items[this.parent.priority[n10]].showing) {
                ++n10;
            }
            n2 = n9 - n10;
        }
        String string = n2 > 99 ? "99+" : String.valueOf(n2);
        switch (n & 0x22) {
            case 0: {
                Color color = this.parent.single ? this.parent.getSelectionForeground() : this.parent.getForeground();
                gC.setForeground(color);
                gC.setFont(font);
                gC.drawLine(n7, n8, n7 + 2, n8 + 2);
                gC.drawLine(n7 + 2, n8 + 2, n7, n8 + 4);
                gC.drawLine(n7 + 1, n8, n7 + 3, n8 + 2);
                gC.drawLine(n7 + 3, n8 + 2, n7 + 1, n8 + 4);
                gC.drawLine(n7 + 4, n8, n7 + 6, n8 + 2);
                gC.drawLine(n7 + 6, n8 + 2, n7 + 5, n8 + 4);
                gC.drawLine(n7 + 5, n8, n7 + 7, n8 + 2);
                gC.drawLine(n7 + 7, n8 + 2, n7 + 4, n8 + 4);
                gC.drawString(string, n7 + 7, n8 + 3, true);
                break;
            }
            case 32: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                gC.drawLine(n7, n8, n7 + 2, n8 + 2);
                gC.drawLine(n7 + 2, n8 + 2, n7, n8 + 4);
                gC.drawLine(n7 + 1, n8, n7 + 3, n8 + 2);
                gC.drawLine(n7 + 3, n8 + 2, n7 + 1, n8 + 4);
                gC.drawLine(n7 + 4, n8, n7 + 6, n8 + 2);
                gC.drawLine(n7 + 6, n8 + 2, n7 + 5, n8 + 4);
                gC.drawLine(n7 + 5, n8, n7 + 7, n8 + 2);
                gC.drawLine(n7 + 7, n8 + 2, n7 + 4, n8 + 4);
                gC.drawString(string, n7 + 7, n8 + 3, true);
                break;
            }
            case 2: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                gC.drawLine(n7 + 1, n8 + 1, n7 + 3, n8 + 3);
                gC.drawLine(n7 + 3, n8 + 3, n7 + 1, n8 + 5);
                gC.drawLine(n7 + 2, n8 + 1, n7 + 4, n8 + 3);
                gC.drawLine(n7 + 4, n8 + 3, n7 + 2, n8 + 5);
                gC.drawLine(n7 + 5, n8 + 1, n7 + 7, n8 + 3);
                gC.drawLine(n7 + 7, n8 + 3, n7 + 6, n8 + 5);
                gC.drawLine(n7 + 6, n8 + 1, n7 + 8, n8 + 3);
                gC.drawLine(n7 + 8, n8 + 3, n7 + 5, n8 + 5);
                gC.drawString(string, n7 + 8, n8 + 4, true);
            }
        }
        font.dispose();
    }

    void drawHighlight(GC gC, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.parent.simple || this.parent.onBottom) {
            return;
        }
        if (this.selectionHighlightGradientBegin == null) {
            return;
        }
        Color[] colorArray = this.selectionHighlightGradientColorsCache;
        if (colorArray == null) {
            return;
        }
        int n6 = colorArray.length;
        if (n6 == 0) {
            return;
        }
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        gC.setForeground(colorArray[0]);
        gC.drawLine(TOP_LEFT_CORNER_HILITE[0] + n7 + 1, 1 + n8, n2 - this.curveIndent, 1 + n8);
        int[] nArray = TOP_LEFT_CORNER_HILITE;
        int n9 = this.parent.tabHeight - this.topCurveHighlightEnd.length / 2;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 < nArray.length / 2) {
            n5 = nArray[n13 * 2];
            n4 = nArray[n13 * 2 + 1];
            n10 = n5 + n7;
            n11 = n4 + n8;
            n12 = n4 - 1;
            gC.setForeground(colorArray[n12]);
            gC.drawPoint(n10, n11);
            ++n13;
        }
        n13 = n12;
        while (n13 < n6) {
            gC.setForeground(colorArray[n13]);
            gC.drawPoint(n10, 1 + n11++);
            ++n13;
        }
        n13 = n2 - this.curveIndent;
        n5 = 0;
        while (n5 < this.topCurveHighlightStart.length / 2) {
            n4 = this.topCurveHighlightStart[n5 * 2];
            n3 = this.topCurveHighlightStart[n5 * 2 + 1];
            n10 = n4 + n13;
            n11 = n3 + n8;
            n12 = n3 - 1;
            if (n12 >= n6) break;
            gC.setForeground(colorArray[n12]);
            gC.drawPoint(n10, n11);
            ++n5;
        }
        n5 = n12;
        while (n5 < n12 + n9) {
            if (n5 >= n6) break;
            gC.setForeground(colorArray[n5]);
            gC.drawPoint(1 + n10++, 1 + n11++);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.topCurveHighlightEnd.length / 2) {
            n4 = this.topCurveHighlightEnd[n5 * 2];
            n3 = this.topCurveHighlightEnd[n5 * 2 + 1];
            n10 = n4 + n13;
            n11 = n3 + n8;
            n12 = n3 - 1;
            if (n12 >= n6) break;
            gC.setForeground(colorArray[n12]);
            gC.drawPoint(n10, n11);
            ++n5;
        }
    }

    void drawLeftUnselectedBorder(GC gC, Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.height;
        int[] nArray = null;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : BOTTOM_LEFT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n5 = 0;
            nArray[n5++] = n2;
            nArray[n5++] = n3 - 1;
            int n6 = 0;
            while (n6 < nArray2.length / 2) {
                nArray[n5++] = n2 + nArray2[2 * n6];
                nArray[n5++] = n3 + n4 + nArray2[2 * n6 + 1] - 1;
                ++n6;
            }
        } else {
            int[] nArray3 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : TOP_LEFT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n7 = 0;
            nArray[n7++] = n2;
            nArray[n7++] = n3 + n4;
            int n8 = 0;
            while (n8 < nArray3.length / 2) {
                nArray[n7++] = n2 + nArray3[2 * n8];
                nArray[n7++] = n3 + nArray3[2 * n8 + 1];
                ++n8;
            }
        }
        this.drawBorder(gC, nArray);
    }

    void drawMaximize(GC gC, Rectangle rectangle, int n) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n2 = rectangle.x + (rectangle.width - 10) / 2;
        int n3 = rectangle.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (n & 0x22) {
            case 0: {
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 32: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n2, n3, 9, 9);
                    gC.drawRectangle(n2, n3, 9, 9);
                    gC.drawLine(n2 + 1, n3 + 2, n2 + 8, n3 + 2);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMaximized()) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 9);
                    gC.drawLine(n2 + 2, n3 + 3, n2 + 9, n3 + 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawMinimize(GC gC, Rectangle rectangle, int n) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int n2 = rectangle.x + (rectangle.width - 10) / 2;
        int n3 = rectangle.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (n & 0x22) {
            case 0: {
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 32: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n2, n3, 9, 3);
                    gC.drawRectangle(n2, n3, 9, 3);
                    break;
                }
                gC.fillRectangle(n2, n3 + 3, 5, 4);
                gC.fillRectangle(n2 + 2, n3, 5, 4);
                gC.drawRectangle(n2, n3 + 3, 5, 4);
                gC.drawRectangle(n2 + 2, n3, 5, 4);
                gC.drawLine(n2 + 3, n3 + 1, n2 + 6, n3 + 1);
                gC.drawLine(n2 + 1, n3 + 4, n2 + 4, n3 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6, 6);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
                if (!this.parent.getMinimized()) {
                    gC.fillRectangle(n2 + 1, n3 + 1, 9, 3);
                    gC.drawRectangle(n2 + 1, n3 + 1, 9, 3);
                    break;
                }
                gC.fillRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.fillRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawRectangle(n2 + 1, n3 + 4, 5, 4);
                gC.drawRectangle(n2 + 3, n3 + 1, 5, 4);
                gC.drawLine(n2 + 4, n3 + 2, n2 + 7, n3 + 2);
                gC.drawLine(n2 + 2, n3 + 5, n2 + 5, n3 + 5);
            }
        }
    }

    void drawRightUnselectedBorder(GC gC, Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int[] nArray = null;
        int n6 = n2 + n4 - 1;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : BOTTOM_RIGHT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n7 = 0;
            int n8 = 0;
            while (n8 < nArray2.length / 2) {
                nArray[n7++] = n6 + nArray2[2 * n8];
                nArray[n7++] = n3 + n5 + nArray2[2 * n8 + 1] - 1;
                ++n8;
            }
            nArray[n7++] = n6;
            nArray[n7++] = n3 - 1;
        } else {
            int[] nArray3 = this.parent.simple ? SIMPLE_UNSELECTED_INNER_CORNER : TOP_RIGHT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n9 = 0;
            int n10 = 0;
            while (n10 < nArray3.length / 2) {
                nArray[n9++] = n6 + nArray3[2 * n10];
                nArray[n9++] = n3 + nArray3[2 * n10 + 1];
                ++n10;
            }
            nArray[n9++] = n6;
            nArray[n9++] = n3 + n5;
        }
        this.drawBorder(gC, nArray);
    }

    void drawSelected(int n, GC gC, Rectangle rectangle, int n2) {
        Object object;
        int n3;
        int n4;
        int n5;
        CTabItem cTabItem = this.parent.items[n];
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.height;
        int n9 = rectangle.width;
        if (!this.parent.simple && !this.parent.single) {
            n9 -= this.curveWidth - this.curveIndent;
        }
        int n10 = n5 = this.parent.borderVisible ? 1 : 0;
        int n11 = this.parent.onBottom ? n5 : 0;
        int n12 = this.parent.onBottom ? 0 : n5;
        Point point = this.parent.getSize();
        int n13 = Math.min(n6 + n9, this.parent.getRightItemEdge(gC));
        if ((n2 & 8) != 0) {
            int n14 = (this.parent.getStyle() & 0x800000) != 0 ? 1 : 3;
            n4 = n5;
            int n15 = this.parent.onBottom ? point.y - n12 - this.parent.tabHeight - n14 : n11 + this.parent.tabHeight + 1;
            int n16 = point.x - n5 - n10;
            n3 = n14 - 1;
            int[] nArray = new int[]{n4, n15, n4 + n16, n15, n4 + n16, n15 + n3, n4, n15 + n3};
            if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                this.drawBackground(gC, nArray, true);
            } else {
                gC.setBackground(this.parent.selectionBackground);
                gC.fillRectangle(n4, n15, n16, n3);
            }
            if (this.parent.single) {
                if (!cTabItem.showing) {
                    return;
                }
            } else {
                int n17;
                int n18;
                Object object2;
                if (!cTabItem.showing) {
                    int n19 = Math.max(0, n5 - 1);
                    int n20 = this.parent.onBottom ? n7 - 1 : n7 + n8;
                    int n21 = point.x - n10;
                    gC.setForeground(this.parent.getDisplay().getSystemColor(18));
                    gC.drawLine(n19, n20, n21, n20);
                    return;
                }
                nArray = null;
                if (this.parent.onBottom) {
                    object2 = this.parent.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                    object = this.parent.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : this.curve;
                    if (n5 == 0 && n == this.parent.firstIndex) {
                        object2 = new int[]{n6, n7 + n8};
                    }
                    nArray = new int[((int[])object2).length + ((Object)object).length + 8];
                    n18 = 0;
                    nArray[n18++] = n6;
                    nArray[n18++] = n7 - 1;
                    nArray[n18++] = n6;
                    nArray[n18++] = n7 - 1;
                    n17 = 0;
                    while (n17 < ((int[])object2).length / 2) {
                        nArray[n18++] = n6 + object2[2 * n17];
                        nArray[n18++] = n7 + n8 + object2[2 * n17 + 1] - 1;
                        ++n17;
                    }
                    n17 = 0;
                    while (n17 < ((Object)object).length / 2) {
                        nArray[n18++] = this.parent.simple ? n13 - 1 + object[2 * n17] : n13 - this.curveIndent + object[2 * n17];
                        nArray[n18++] = this.parent.simple ? n7 + n8 + object[2 * n17 + 1] - 1 : n7 + object[2 * n17 + 1] - 2;
                        ++n17;
                    }
                    nArray[n18++] = this.parent.simple ? n13 - 1 : n13 + this.curveWidth - this.curveIndent;
                    nArray[n18++] = n7 - 1;
                    nArray[n18++] = this.parent.simple ? n13 - 1 : n13 + this.curveWidth - this.curveIndent;
                    nArray[n18++] = n7 - 1;
                } else {
                    object2 = this.parent.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                    object = this.parent.simple ? SIMPLE_TOP_RIGHT_CORNER : this.curve;
                    if (n5 == 0 && n == this.parent.firstIndex) {
                        object2 = new int[]{n6, n7};
                    }
                    nArray = new int[((int[])object2).length + ((Object)object).length + 8];
                    n18 = 0;
                    nArray[n18++] = n6;
                    nArray[n18++] = n7 + n8 + 1;
                    nArray[n18++] = n6;
                    nArray[n18++] = n7 + n8 + 1;
                    n17 = 0;
                    while (n17 < ((int[])object2).length / 2) {
                        nArray[n18++] = n6 + object2[2 * n17];
                        nArray[n18++] = n7 + object2[2 * n17 + 1];
                        ++n17;
                    }
                    n17 = 0;
                    while (n17 < ((Object)object).length / 2) {
                        nArray[n18++] = this.parent.simple ? n13 - 1 + object[2 * n17] : n13 - this.curveIndent + object[2 * n17];
                        nArray[n18++] = n7 + object[2 * n17 + 1];
                        ++n17;
                    }
                    nArray[n18++] = this.parent.simple ? n13 - 1 : n13 + this.curveWidth - this.curveIndent;
                    nArray[n18++] = n7 + n8 + 1;
                    nArray[n18++] = this.parent.simple ? n13 - 1 : n13 + this.curveWidth - this.curveIndent;
                    nArray[n18++] = n7 + n8 + 1;
                }
                object2 = gC.getClipping();
                object = cTabItem.getBounds();
                ++((Rectangle)object).height;
                if (this.parent.onBottom) {
                    --((Rectangle)object).y;
                }
                if ((n18 = (int)(((Rectangle)object2).intersects((Rectangle)object) ? 1 : 0)) != 0) {
                    if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                        this.drawBackground(gC, nArray, true);
                    } else {
                        Color color = this.parent.selectionBackground;
                        Image image = this.parent.selectionBgImage;
                        Color[] colorArray = this.parent.selectionGradientColors;
                        int[] nArray2 = this.parent.selectionGradientPercents;
                        boolean bl = this.parent.selectionGradientVertical;
                        n4 = n6;
                        n15 = this.parent.onBottom ? n7 - 1 : n7 + 1;
                        n16 = n9;
                        n3 = n8;
                        if (!this.parent.single && !this.parent.simple) {
                            n16 += this.curveWidth - this.curveIndent;
                        }
                        this.drawBackground(gC, nArray, n4, n15, n16, n3, color, image, colorArray, nArray2, bl);
                    }
                }
                this.drawHighlight(gC, rectangle, n2, n13);
                nArray[0] = Math.max(0, n5 - 1);
                if (n5 == 0 && n == this.parent.firstIndex) {
                    nArray[1] = this.parent.onBottom ? n7 + n8 - 1 : n7;
                    nArray[5] = nArray[3] = nArray[1];
                }
                nArray[nArray.length - 2] = point.x - n10 + 1;
                int n22 = 0;
                while (n22 < nArray.length / 2) {
                    if (nArray[2 * n22 + 1] == n7 + n8 + 1) {
                        int n23 = 2 * n22 + 1;
                        nArray[n23] = nArray[n23] - 1;
                    }
                    ++n22;
                }
                Color color = this.parent.getDisplay().getSystemColor(18);
                if (!color.equals(this.lastBorderColor)) {
                    this.createAntialiasColors();
                }
                this.antialias(nArray, this.selectedInnerColor, this.selectedOuterColor, gC);
                gC.setForeground(color);
                gC.drawPolyline(nArray);
                if (n18 == 0) {
                    return;
                }
            }
        }
        if ((n2 & 0x10) != 0) {
            Image image;
            Rectangle rectangle2 = this.computeTrim(n, 0, 0, 0, 0, 0);
            n4 = n6 - rectangle2.x;
            if (this.parent.single && (this.parent.showClose || cTabItem.showClose)) {
                n4 += cTabItem.closeRect.width;
            }
            if ((image = cTabItem.getImage()) != null) {
                Rectangle rectangle3 = image.getBounds();
                n3 = n13 - n4 - (rectangle2.width + rectangle2.x);
                if (!this.parent.single && cTabItem.closeRect.width > 0) {
                    n3 -= cTabItem.closeRect.width + 4;
                }
                if (rectangle3.width < n3) {
                    int n24 = n4;
                    int n25 = n7 + (n8 - rectangle3.height) / 2;
                    gC.drawImage(image, n24, n25 += this.parent.onBottom ? -1 : 1);
                    n4 += rectangle3.width + 4;
                }
            }
            int n26 = n13 - n4 - (rectangle2.width + rectangle2.x);
            if (!this.parent.single && cTabItem.closeRect.width > 0) {
                n26 -= cTabItem.closeRect.width + 4;
            }
            if (n26 > 0) {
                Font font = gC.getFont();
                gC.setFont(cTabItem.font == null ? this.parent.getFont() : cTabItem.font);
                if (cTabItem.shortenedText == null || cTabItem.shortenedTextWidth != n26) {
                    cTabItem.shortenedText = this.shortenText(gC, cTabItem.getText(), n26);
                    cTabItem.shortenedTextWidth = n26;
                }
                Point point2 = gC.textExtent(cTabItem.shortenedText, 9);
                int n27 = n7 + (n8 - point2.y) / 2;
                int n28 = this.parent.onBottom ? -1 : 1;
                gC.setForeground(this.parent.selectionForeground);
                gC.drawText(cTabItem.shortenedText, n4, n27 += n28, 9);
                gC.setFont(font);
                if (this.parent.isFocusControl()) {
                    object = this.parent.getDisplay();
                    if (this.parent.simple || this.parent.single) {
                        gC.setBackground(((Display)object).getSystemColor(2));
                        gC.setForeground(((Display)object).getSystemColor(1));
                        gC.drawFocus(n4 - 1, n27 - 1, point2.x + 2, point2.y + 2);
                    } else {
                        gC.setForeground(((Display)object).getSystemColor(17));
                        gC.drawLine(n4, n27 + point2.y + 1, n4 + point2.x + 1, n27 + point2.y + 1);
                    }
                }
            }
            if (this.parent.showClose || cTabItem.showClose) {
                this.drawClose(gC, cTabItem.closeRect, cTabItem.closeImageState);
            }
        }
    }

    void drawTabArea(GC gC, Rectangle rectangle, int n) {
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2;
        int n4;
        int n5;
        Point point = this.parent.getSize();
        int[] nArray3 = null;
        Color color = this.parent.getDisplay().getSystemColor(18);
        int n6 = this.parent.tabHeight;
        int n7 = this.parent.getStyle();
        int n8 = n5 = this.parent.borderVisible ? 1 : 0;
        int n9 = this.parent.onBottom ? n5 : 0;
        int n10 = this.parent.onBottom ? 0 : n5;
        int n11 = this.parent.selectedIndex;
        int n12 = n4 = (n7 & 0x800000) != 0 ? 1 : 3;
        if (n6 == 0) {
            int n13;
            if ((n7 & 0x800000) != 0 && (n7 & 0x800) == 0) {
                return;
            }
            int n14 = n5 - 1;
            int n15 = point.x - n8;
            int n16 = this.parent.onBottom ? point.y - n10 - n4 - 1 : n9 + n4;
            int n17 = n13 = this.parent.onBottom ? point.y - n10 : n9;
            if (n5 <= 0 || this.parent.onBottom) {
                // empty if block
            }
            nArray3 = new int[]{n14, n16, n14, --n13, n15, n13, n15, n16};
            if (n11 != -1 && this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1 && !this.parent.selectionGradientVertical) {
                this.drawBackground(gC, nArray3, true);
            } else if (n11 == -1 && this.parent.gradientColors != null && this.parent.gradientColors.length > 1 && !this.parent.gradientVertical) {
                this.drawBackground(gC, nArray3, false);
            } else {
                gC.setBackground(n11 == -1 ? this.parent.getBackground() : this.parent.selectionBackground);
                gC.fillPolygon(nArray3);
            }
            if (n5 > 0) {
                gC.setForeground(color);
                gC.drawPolyline(nArray3);
            }
            return;
        }
        int n18 = Math.max(0, n5 - 1);
        int n19 = this.parent.onBottom ? point.y - n10 - n6 : n9;
        int n20 = point.x - n5 - n8 + 1;
        int n21 = n6 - 1;
        boolean bl = this.parent.simple;
        if (this.parent.onBottom) {
            if ((n7 & 0x800) != 0) {
                nArray2 = bl ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                nArray = bl ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            } else {
                nArray2 = bl ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
                nArray = bl ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
            }
            nArray3 = new int[nArray2.length + nArray.length + 4];
            n3 = 0;
            nArray3[n3++] = n18;
            nArray3[n3++] = n19 - n4;
            n2 = 0;
            while (n2 < nArray2.length / 2) {
                nArray3[n3++] = n18 + nArray2[2 * n2];
                nArray3[n3++] = n19 + n21 + nArray2[2 * n2 + 1];
                if (n5 == 0) {
                    int n22 = n3 - 1;
                    nArray3[n22] = nArray3[n22] + 1;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length / 2) {
                nArray3[n3++] = n18 + n20 + nArray[2 * n2];
                nArray3[n3++] = n19 + n21 + nArray[2 * n2 + 1];
                if (n5 == 0) {
                    int n23 = n3 - 1;
                    nArray3[n23] = nArray3[n23] + 1;
                }
                ++n2;
            }
            nArray3[n3++] = n18 + n20;
            nArray3[n3++] = n19 - n4;
        } else {
            if ((n7 & 0x800) != 0) {
                nArray2 = bl ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                nArray = bl ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            } else {
                nArray2 = bl ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
                nArray = bl ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
            }
            nArray3 = new int[nArray2.length + nArray.length + 4];
            n3 = 0;
            nArray3[n3++] = n18;
            nArray3[n3++] = n19 + n21 + n4 + 1;
            n2 = 0;
            while (n2 < nArray2.length / 2) {
                nArray3[n3++] = n18 + nArray2[2 * n2];
                nArray3[n3++] = n19 + nArray2[2 * n2 + 1];
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length / 2) {
                nArray3[n3++] = n18 + n20 + nArray[2 * n2];
                nArray3[n3++] = n19 + nArray[2 * n2 + 1];
                ++n2;
            }
            nArray3[n3++] = n18 + n20;
            nArray3[n3++] = n19 + n21 + n4 + 1;
        }
        boolean bl2 = this.parent.single;
        boolean bl3 = bl2 && n11 != -1;
        this.drawBackground(gC, nArray3, bl3);
        Region region = new Region();
        region.add(new Rectangle(n18, n19, n20 + 1, n21 + 1));
        region.subtract(nArray3);
        gC.setBackground(this.parent.getParent().getBackground());
        this.fillRegion(gC, region);
        region.dispose();
        if (n11 == -1) {
            n2 = n5;
            int n24 = this.parent.onBottom ? point.y - n10 - n6 - 1 : n9 + n6;
            int n25 = point.x - n8;
            gC.setForeground(color);
            gC.drawLine(n2, n24, n25, n24);
        }
        if (n5 > 0) {
            if (!color.equals(this.lastBorderColor)) {
                this.createAntialiasColors();
            }
            this.antialias(nArray3, null, this.tabAreaColor, gC);
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
        }
    }

    void drawUnselected(int n, GC gC, Rectangle rectangle, int n2) {
        CTabItem cTabItem = this.parent.items[n];
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.height;
        int n6 = rectangle.width;
        if (!cTabItem.showing) {
            return;
        }
        Rectangle rectangle2 = gC.getClipping();
        if (!rectangle2.intersects(rectangle)) {
            return;
        }
        if ((n2 & 8) != 0) {
            if (n > 0 && n < this.parent.selectedIndex) {
                this.drawLeftUnselectedBorder(gC, rectangle, n2);
            }
            if (n > this.parent.selectedIndex) {
                this.drawRightUnselectedBorder(gC, rectangle, n2);
            }
        }
        if ((n2 & 0x10) != 0) {
            int n7;
            Rectangle rectangle3 = this.computeTrim(n, 0, 0, 0, 0, 0);
            int n8 = n3 - rectangle3.x;
            Image image = cTabItem.getImage();
            if (image != null && this.parent.showUnselectedImage) {
                Rectangle rectangle4 = image.getBounds();
                int n9 = n3 + n6 - n8 - (rectangle3.width + rectangle3.x);
                if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                    n9 -= cTabItem.closeRect.width + 4;
                }
                if (rectangle4.width < n9) {
                    int n10 = n8;
                    n7 = rectangle4.height;
                    int n11 = n4 + (n5 - n7) / 2;
                    int n12 = this.parent.onBottom ? -1 : 1;
                    int n13 = rectangle4.width * n7 / rectangle4.height;
                    gC.drawImage(image, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, n10, n11 += n12, n13, n7);
                    n8 += n13 + 4;
                }
            }
            int n14 = n3 + n6 - n8 - (rectangle3.width + rectangle3.x);
            if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                n14 -= cTabItem.closeRect.width + 4;
            }
            if (n14 > 0) {
                Font font = gC.getFont();
                gC.setFont(cTabItem.font == null ? this.parent.getFont() : cTabItem.font);
                if (cTabItem.shortenedText == null || cTabItem.shortenedTextWidth != n14) {
                    cTabItem.shortenedText = this.shortenText(gC, cTabItem.getText(), n14);
                    cTabItem.shortenedTextWidth = n14;
                }
                Point point = gC.textExtent(cTabItem.shortenedText, 9);
                n7 = n4 + (n5 - point.y) / 2;
                int n15 = this.parent.onBottom ? -1 : 1;
                gC.setForeground(this.parent.getForeground());
                gC.drawText(cTabItem.shortenedText, n8, n7 += n15, 9);
                gC.setFont(font);
            }
            if (this.parent.showUnselectedClose && (this.parent.showClose || cTabItem.showClose)) {
                this.drawClose(gC, cTabItem.closeRect, cTabItem.closeImageState);
            }
        }
    }

    void fillRegion(GC gC, Region region) {
        Region region2 = new Region();
        gC.getClipping(region2);
        region.intersect(region2);
        gC.setClipping(region);
        gC.fillRectangle(region.getBounds());
        gC.setClipping(region2);
        region2.dispose();
    }

    Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = CTabFolderRenderer.getColor(this.parent.getDisplay(), CLOSE_FILL);
        }
        return this.fillColor;
    }

    boolean isSelectionHighlightColorsCacheHit(Color color) {
        if (this.selectionHighlightGradientColorsCache == null) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length < 2) {
            return false;
        }
        Color color2 = this.selectionHighlightGradientColorsCache[0];
        Color color3 = this.selectionHighlightGradientColorsCache[this.selectionHighlightGradientColorsCache.length - 1];
        if (!color2.equals(color)) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length != this.parent.tabHeight) {
            return false;
        }
        return color3.equals(this.parent.selectionBackground);
    }

    void setSelectionHighlightGradientColor(Color color) {
        this.selectionHighlightGradientBegin = null;
        if (color == null) {
            return;
        }
        if (this.parent.getDisplay().getDepth() < 15) {
            return;
        }
        if (this.parent.selectionGradientColors.length < 2) {
            return;
        }
        this.selectionHighlightGradientBegin = color;
        if (!this.isSelectionHighlightColorsCacheHit(color)) {
            this.createSelectionHighlightGradientColors(color);
        }
    }

    String shortenText(GC gC, String string, int n) {
        return this.useEllipses() ? this.shortenText(gC, string, n, ELLIPSIS) : this.shortenText(gC, string, n, "");
    }

    String shortenText(GC gC, String string, int n, String string2) {
        if (gC.textExtent((String)string, (int)9).x <= n) {
            return string;
        }
        int n2 = gC.textExtent((String)string2, (int)9).x;
        int n3 = string.length();
        TextLayout textLayout = new TextLayout(this.parent.getDisplay());
        textLayout.setText(string);
        int n4 = textLayout.getPreviousOffset(n3, 2);
        while (n4 > 0) {
            string = string.substring(0, n4);
            int n5 = gC.textExtent((String)string, (int)9).x;
            if (n5 + n2 <= n) break;
            n4 = textLayout.getPreviousOffset(n4, 2);
        }
        textLayout.dispose();
        return n4 == 0 ? string.substring(0, 1) : String.valueOf(string) + string2;
    }

    void updateCurves() {
        int n = this.parent.tabHeight;
        if (n == this.lastTabHeight) {
            return;
        }
        if (this.parent.onBottom) {
            int n2 = n - 12;
            int[] nArray = new int[40];
            nArray[1] = 13 + n2;
            nArray[3] = 12 + n2;
            nArray[4] = 2;
            nArray[5] = 12 + n2;
            nArray[6] = 3;
            nArray[7] = 11 + n2;
            nArray[8] = 5;
            nArray[9] = 11 + n2;
            nArray[10] = 6;
            nArray[11] = 10 + n2;
            nArray[12] = 7;
            nArray[13] = 10 + n2;
            nArray[14] = 9;
            nArray[15] = 8 + n2;
            nArray[16] = 10;
            nArray[17] = 8 + n2;
            nArray[18] = 11;
            nArray[19] = 7 + n2;
            nArray[20] = 11 + n2;
            nArray[21] = 7;
            nArray[22] = 12 + n2;
            nArray[23] = 6;
            nArray[24] = 13 + n2;
            nArray[25] = 6;
            nArray[26] = 15 + n2;
            nArray[27] = 4;
            nArray[28] = 16 + n2;
            nArray[29] = 4;
            nArray[30] = 17 + n2;
            nArray[31] = 3;
            nArray[32] = 19 + n2;
            nArray[33] = 3;
            nArray[34] = 20 + n2;
            nArray[35] = 2;
            nArray[36] = 22 + n2;
            nArray[37] = 2;
            nArray[38] = 23 + n2;
            nArray[39] = 1;
            this.curve = nArray;
            this.curveWidth = 26 + n2;
            this.curveIndent = this.curveWidth / 3;
        } else {
            int n3 = n - 12;
            int[] nArray = new int[40];
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 1;
            nArray[6] = 3;
            nArray[7] = 2;
            nArray[8] = 5;
            nArray[9] = 2;
            nArray[10] = 6;
            nArray[11] = 3;
            nArray[12] = 7;
            nArray[13] = 3;
            nArray[14] = 9;
            nArray[15] = 5;
            nArray[16] = 10;
            nArray[17] = 5;
            nArray[18] = 11;
            nArray[19] = 6;
            nArray[20] = 11 + n3;
            nArray[21] = 6 + n3;
            nArray[22] = 12 + n3;
            nArray[23] = 7 + n3;
            nArray[24] = 13 + n3;
            nArray[25] = 7 + n3;
            nArray[26] = 15 + n3;
            nArray[27] = 9 + n3;
            nArray[28] = 16 + n3;
            nArray[29] = 9 + n3;
            nArray[30] = 17 + n3;
            nArray[31] = 10 + n3;
            nArray[32] = 19 + n3;
            nArray[33] = 10 + n3;
            nArray[34] = 20 + n3;
            nArray[35] = 11 + n3;
            nArray[36] = 22 + n3;
            nArray[37] = 11 + n3;
            nArray[38] = 23 + n3;
            nArray[39] = 12 + n3;
            this.curve = nArray;
            this.curveWidth = 26 + n3;
            this.curveIndent = this.curveWidth / 3;
            int[] nArray2 = new int[22];
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArray2[3] = 2;
            nArray2[4] = 2;
            nArray2[5] = 2;
            nArray2[6] = 3;
            nArray2[7] = 3;
            nArray2[8] = 4;
            nArray2[9] = 3;
            nArray2[10] = 5;
            nArray2[11] = 3;
            nArray2[12] = 6;
            nArray2[13] = 4;
            nArray2[14] = 7;
            nArray2[15] = 4;
            nArray2[16] = 8;
            nArray2[17] = 5;
            nArray2[18] = 9;
            nArray2[19] = 6;
            nArray2[20] = 10;
            nArray2[21] = 6;
            this.topCurveHighlightStart = nArray2;
            this.topCurveHighlightEnd = new int[]{10 + n3, 6 + n3, 11 + n3, 7 + n3, 12 + n3, 8 + n3, 13 + n3, 8 + n3, 14 + n3, 9 + n3, 15 + n3, 10 + n3, 16 + n3, 10 + n3, 17 + n3, 11 + n3, 18 + n3, 11 + n3, 19 + n3, 11 + n3, 20 + n3, 12 + n3, 21 + n3, 12 + n3, 22 + n3, 12 + n3};
        }
    }

    boolean useEllipses() {
        return this.parent.simple;
    }
}

