/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MARGINS;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMREBARCHEVRON;
import org.eclipse.swt.internal.win32.NMREBARCHILDSIZE;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;

public class CoolBar
extends Composite {
    CoolItem[] items;
    CoolItem[] originalItems;
    boolean locked;
    boolean ignoreResize;
    static final int ReBarProc;
    static final TCHAR ReBarClass;
    static final int SEPARATOR_WIDTH = 2;
    static final int MAX_WIDTH = Short.MAX_VALUE;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;

    static {
        ReBarClass = new TCHAR(0, "ReBarWindow32", true);
        INITCOMMONCONTROLSEX iNITCOMMONCONTROLSEX = new INITCOMMONCONTROLSEX();
        iNITCOMMONCONTROLSEX.dwSize = INITCOMMONCONTROLSEX.sizeof;
        iNITCOMMONCONTROLSEX.dwICC = 1024;
        OS.InitCommonControlsEx(iNITCOMMONCONTROLSEX);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ReBarClass, wNDCLASS);
        ReBarProc = wNDCLASS.lpfnWndProc;
    }

    public CoolBar(Composite composite, int n) {
        super(composite, CoolBar.checkStyle(n));
        if ((n & 0x200) != 0) {
            this.style |= 0x200;
            int n2 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n2 | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ReBarProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getBorderWidth();
        int n7 = n == -1 ? 16383 : n + n6 * 2;
        int n8 = n2 == -1 ? 16383 : n2 + n6 * 2;
        int n9 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n9 != 0) {
            this.ignoreResize = true;
            n3 = 0;
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.COMCTL32_MAJOR >= 6) {
                    n3 = 1;
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                } else {
                    n3 = this.getDrawing() ? 1 : 0;
                    if (n3 != 0) {
                        OS.UpdateWindow(this.handle);
                        OS.SendMessage(this.handle, 11, 0, 0);
                    }
                }
            }
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n10 = rECT.right - rECT.left;
            int n11 = rECT.bottom - rECT.top;
            int n12 = 30;
            this.SetWindowPos(this.handle, 0, 0, 0, n7, n8, n12);
            RECT rECT2 = new RECT();
            OS.SendMessage(this.handle, 1033, n9 - 1, rECT2);
            n5 = Math.max(n5, rECT2.bottom);
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 513;
            int n13 = 0;
            int n14 = 0;
            while (n14 < n9) {
                OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n14, rEBARBANDINFO);
                if ((rEBARBANDINFO.fStyle & 1) != 0) {
                    n4 = Math.max(n4, n13);
                    n13 = 0;
                }
                n13 += rEBARBANDINFO.cxIdeal + this.getMargin(n14);
                ++n14;
            }
            n4 = Math.max(n4, n13);
            if (n3 != 0) {
                if (OS.COMCTL32_MAJOR >= 6) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                } else {
                    OS.SendMessage(this.handle, 11, 1, 0);
                }
            }
            this.ignoreResize = false;
        }
        if (n4 == 0) {
            n4 = 0;
        }
        if (n5 == 0) {
            n5 = 0;
        }
        if ((this.style & 0x200) != 0) {
            n3 = n4;
            n4 = n5;
            n5 = n3;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        return new Point(n4 += n6 * 2, n5 += n6 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        int n = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n, 0);
    }

    void createItem(CoolItem coolItem, int n) {
        boolean bl;
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        int n3 = 0;
        while (n3 < this.items.length && this.items[n3] != null) {
            ++n3;
        }
        if (n3 == this.items.length) {
            CoolItem[] coolItemArray = new CoolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, coolItemArray, 0, this.items.length);
            this.items = coolItemArray;
        }
        int n4 = OS.GetProcessHeap();
        int n5 = OS.HeapAlloc(n4, 8, TCHAR.sizeof);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 261;
        rEBARBANDINFO.fStyle = 192;
        if ((coolItem.style & 4) != 0) {
            rEBARBANDINFO.fStyle |= 0x200;
        }
        rEBARBANDINFO.lpText = n5;
        rEBARBANDINFO.wID = n3;
        int n6 = this.getLastIndexOfRow(n - 1);
        boolean bl2 = bl = n == n6 + 1;
        if (bl) {
            rEBARBANDINFO.fMask |= 0x40;
            rEBARBANDINFO.cx = Short.MAX_VALUE;
        }
        if (n == 0 && n2 > 0) {
            this.getItem(0).setWrap(false);
        }
        if (OS.SendMessage(this.handle, OS.RB_INSERTBAND, n, rEBARBANDINFO) == 0) {
            this.error(14);
        }
        if (bl) {
            this.resizeToPreferredWidth(n6);
        }
        OS.HeapFree(n4, 0, n5);
        coolItem.id = n3;
        this.items[coolItem.id] = coolItem;
        int n7 = this.originalItems.length;
        CoolItem[] coolItemArray = new CoolItem[n7 + 1];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n);
        System.arraycopy(this.originalItems, n, coolItemArray, n + 1, n7 - n);
        coolItemArray[n] = coolItem;
        this.originalItems = coolItemArray;
    }

    void createWidget() {
        super.createWidget();
        this.items = new CoolItem[4];
        this.originalItems = new CoolItem[0];
    }

    void destroyItem(CoolItem coolItem) {
        Control control;
        int n;
        int n2 = OS.SendMessage(this.handle, 1040, coolItem.id, 0);
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n3 != 0 && n2 == (n = this.getLastIndexOfRow(n2))) {
            this.resizeToMaximumWidth(n - 1);
        }
        boolean bl = (control = coolItem.control) != null && !control.isDisposed() && control.getVisible();
        CoolItem coolItem2 = null;
        if (coolItem.getWrap() && n2 + 1 < n3) {
            coolItem2 = this.getItem(n2 + 1);
            boolean bl2 = this.ignoreResize = !coolItem2.getWrap();
        }
        if (OS.SendMessage(this.handle, 1026, n2, 0) == 0) {
            this.error(15);
        }
        this.items[coolItem.id] = null;
        coolItem.id = -1;
        if (this.ignoreResize) {
            coolItem2.setWrap(true);
            this.ignoreResize = false;
        }
        if (bl) {
            control.setVisible(true);
        }
        n2 = 0;
        while (n2 < this.originalItems.length) {
            if (this.originalItems[n2] == coolItem) break;
            ++n2;
        }
        int n4 = this.originalItems.length - 1;
        CoolItem[] coolItemArray = new CoolItem[n4];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n2);
        System.arraycopy(this.originalItems, n2 + 1, coolItemArray, n2, n4 - n2);
        this.originalItems = coolItemArray;
    }

    void drawThemeBackground(int n, int n2, RECT rECT) {
        Object object;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.background == -1 && (this.style & 0x800000) != 0 && (object = this.findBackgroundControl()) != null && ((Control)object).backgroundImage != null) {
            this.fillBackground(n, ((Control)object).getBackgroundPixel(), rECT);
            return;
        }
        object = new RECT();
        OS.GetClientRect(this.handle, (RECT)object);
        OS.MapWindowPoints(this.handle, n2, (RECT)object, 2);
        POINT pOINT = new POINT();
        OS.SetWindowOrgEx(n, -((RECT)object).left, -((RECT)object).top, pOINT);
        OS.SendMessage(this.handle, 791, n, 12);
        OS.SetWindowOrgEx(n, pOINT.x, pOINT.y, null);
    }

    Control findThemeControl() {
        if ((this.style & 0x800000) != 0) {
            return this;
        }
        return this.background == -1 && this.backgroundImage == null ? this : super.findThemeControl();
    }

    int getMargin(int n) {
        Object object;
        int n2 = 0;
        if (OS.COMCTL32_MAJOR >= 6) {
            object = new MARGINS();
            OS.SendMessage(this.handle, 1064, 0, (MARGINS)object);
            n2 += ((MARGINS)object).cxLeftWidth + ((MARGINS)object).cxRightWidth;
        }
        object = new RECT();
        OS.SendMessage(this.handle, 1058, n, (RECT)object);
        n2 = (this.style & 0x800000) != 0 ? ((this.style & 0x200) != 0 ? (n2 += ((RECT)object).top + 4) : (n2 += ((RECT)object).left + 4)) : ((this.style & 0x200) != 0 ? (n2 += ((RECT)object).top + ((RECT)object).bottom) : (n2 += ((RECT)object).left + ((RECT)object).right));
        if ((this.style & 0x800000) == 0 && !this.isLastItemOfRow(n)) {
            n2 += 2;
        }
        return n2;
    }

    public CoolItem getItem(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
        return this.items[rEBARBANDINFO.wID];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1036, 0, 0);
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 1036, 0, 0);
        int[] nArray = new int[n];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            CoolItem coolItem = this.items[rEBARBANDINFO.wID];
            int n3 = 0;
            while (n3 < this.originalItems.length) {
                if (this.originalItems[n3] == coolItem) break;
                ++n3;
            }
            if (n3 == this.originalItems.length) {
                this.error(8);
            }
            nArray[n2] = n3;
            ++n2;
        }
        return nArray;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 1036, 0, 0);
        CoolItem[] coolItemArray = new CoolItem[n];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            coolItemArray[n2] = this.items[rEBARBANDINFO.wID];
            ++n2;
        }
        return coolItemArray;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 1036, 0, 0);
        Point[] pointArray = new Point[n];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        int n2 = (this.style & 0x800000) == 0 ? 2 : 0;
        MARGINS mARGINS = new MARGINS();
        int n3 = 0;
        while (n3 < n) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 1033, n3, rECT);
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n3, rEBARBANDINFO);
            if (OS.COMCTL32_MAJOR >= 6) {
                OS.SendMessage(this.handle, 1064, 0, mARGINS);
                rECT.left -= mARGINS.cxLeftWidth;
                rECT.right += mARGINS.cxRightWidth;
            }
            if (!this.isLastItemOfRow(n3)) {
                rECT.right += n2;
            }
            pointArray[n3] = (this.style & 0x200) != 0 ? new Point(rEBARBANDINFO.cyChild, rECT.right - rECT.left) : new Point(rECT.right - rECT.left, rEBARBANDINFO.cyChild);
            ++n3;
        }
        return pointArray;
    }

    int getLastIndexOfRow(int n) {
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n2 == 0) {
            return -1;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        int n3 = n + 1;
        while (n3 < n2) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n3, rEBARBANDINFO);
            if ((rEBARBANDINFO.fStyle & 1) != 0) {
                return n3 - 1;
            }
            ++n3;
        }
        return n2 - 1;
    }

    boolean isLastItemOfRow(int n) {
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n + 1 == n2) {
            return true;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n + 1, rEBARBANDINFO);
        return (rEBARBANDINFO.fStyle & 1) != 0;
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.locked;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        CoolItem[] coolItemArray = this.getItems();
        int[] nArray = new int[coolItemArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < coolItemArray.length) {
            if (coolItemArray[n2].getWrap()) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public int indexOf(CoolItem coolItem) {
        this.checkWidget();
        if (coolItem == null) {
            this.error(4);
        }
        if (coolItem.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1040, coolItem.id, 0);
    }

    void resizeToPreferredWidth(int n) {
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n >= 0 && n < n2) {
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 512;
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 1058, n, rECT);
            rEBARBANDINFO.cx = rEBARBANDINFO.cxIdeal + rECT.left;
            if ((this.style & 0x800000) == 0) {
                rEBARBANDINFO.cx += rECT.right;
            }
            rEBARBANDINFO.fMask = 64;
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n, rEBARBANDINFO);
        }
    }

    void resizeToMaximumWidth(int n) {
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 64;
        rEBARBANDINFO.cx = Short.MAX_VALUE;
        OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n, rEBARBANDINFO);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                CoolItem coolItem = this.items[n];
                if (coolItem != null && !coolItem.isDisposed()) {
                    coolItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.items.length) {
            CoolItem coolItem = this.items[n];
            if (coolItem != null && coolItem.control == control) {
                coolItem.setControl(null);
            }
            ++n;
        }
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                CoolItem coolItem = this.items[n2];
                if (coolItem != null) {
                    coolItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    void setBackgroundPixel(int n) {
        if (n == -1) {
            n = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 1043, 0, n);
        this.setItemColors(OS.SendMessage(this.handle, 1046, 0, 0), n);
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n2 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n2);
        }
    }

    void setForegroundPixel(int n) {
        if (n == -1) {
            n = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 1045, 0, n);
        this.setItemColors(n, OS.SendMessage(this.handle, 1044, 0, 0));
    }

    void setItemColors(int n, int n2) {
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 2;
        rEBARBANDINFO.clrFore = n;
        rEBARBANDINFO.clrBack = n2;
        int n4 = 0;
        while (n4 < n3) {
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n4, rEBARBANDINFO);
            ++n4;
        }
    }

    public void setItemLayout(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.checkWidget();
        this.setRedraw(false);
        this.setItemOrder(nArray);
        this.setWrapIndices(nArray2);
        this.setItemSizes(pointArray);
        this.setRedraw(true);
    }

    void setItemOrder(int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n2 = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            n = nArray[n3];
            if (n < 0 || n >= n2) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            ++n3;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        n = 0;
        while (n < nArray.length) {
            int n4 = this.originalItems[nArray[n]].id;
            int n5 = OS.SendMessage(this.handle, 1040, n4, 0);
            if (n5 != n) {
                int n6 = this.getLastIndexOfRow(n5);
                int n7 = this.getLastIndexOfRow(n);
                if (n5 == n6) {
                    this.resizeToPreferredWidth(n5);
                }
                if (n == n7) {
                    this.resizeToPreferredWidth(n);
                }
                OS.SendMessage(this.handle, 1063, n5, n);
                if (n5 == n6 && n5 - 1 >= 0) {
                    this.resizeToMaximumWidth(n5 - 1);
                }
                if (n == n7) {
                    this.resizeToMaximumWidth(n);
                }
            }
            ++n;
        }
    }

    void setItemSizes(Point[] pointArray) {
        int n;
        if (pointArray == null) {
            this.error(4);
        }
        if (pointArray.length != (n = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            this.items[rEBARBANDINFO.wID].setSize(pointArray[n2].x, pointArray[n2].y);
            ++n2;
        }
    }

    public void setLocked(boolean bl) {
        this.checkWidget();
        this.locked = bl;
        int n = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            rEBARBANDINFO.fStyle = bl ? (rEBARBANDINFO.fStyle |= 0x100) : (rEBARBANDINFO.fStyle &= 0xFFFFFEFF);
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n2, rEBARBANDINFO);
            ++n2;
        }
    }

    public void setWrapIndices(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0 || nArray[n2] >= n) {
                this.error(6);
            }
            ++n2;
        }
        this.setRedraw(false);
        CoolItem[] coolItemArray = this.getItems();
        int n3 = 0;
        while (n3 < coolItemArray.length) {
            CoolItem coolItem = coolItemArray[n3];
            if (coolItem.getWrap()) {
                this.resizeToPreferredWidth(n3 - 1);
                coolItem.setWrap(false);
            }
            ++n3;
        }
        this.resizeToMaximumWidth(n - 1);
        n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n4 >= 0 && n4 < coolItemArray.length) {
                CoolItem coolItem = coolItemArray[n4];
                coolItem.setWrap(true);
                this.resizeToMaximumWidth(n4 - 1);
            }
            ++n3;
        }
        this.setRedraw(true);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 4;
        n |= 0x8200;
        if ((this.style & 0x800000) == 0) {
            n |= 0x400;
        }
        return n;
    }

    TCHAR windowClass() {
        return ReBarClass;
    }

    int windowProc() {
        return ReBarProc;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        LRESULT lRESULT = super.WM_COMMAND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            this.drawBackground(n);
            return null;
        }
        return lRESULT;
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        LRESULT lRESULT = super.WM_NOTIFY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETREDRAW(int n, int n2) {
        LRESULT lRESULT = super.WM_SETREDRAW(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            return LRESULT.ZERO;
        }
        Rectangle rectangle = this.getBounds();
        int n3 = this.callWindowProc(this.handle, 11, n, n2);
        OS.DefWindowProc(this.handle, 11, n, n2);
        if (!rectangle.equals(this.getBounds())) {
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_SIZE(int n, int n2) {
        if (this.ignoreResize) {
            int n3 = this.callWindowProc(this.handle, 5, n, n2);
            if (n3 == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(n3);
        }
        return super.WM_SIZE(n, n2);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        switch (nMHDR.code) {
            case -835: {
                int n3;
                int n4 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n4);
                OS.ScreenToClient(this.handle, pOINT);
                int n5 = n3 = this.display.lastButton != 0 ? this.display.lastButton : 1;
                if (this.sendDragEvent(n3, pOINT.x, pOINT.y)) break;
                return LRESULT.ONE;
            }
            case -839: {
                NMREBARCHILDSIZE nMREBARCHILDSIZE = new NMREBARCHILDSIZE();
                OS.MoveMemory(nMREBARCHILDSIZE, n2, NMREBARCHILDSIZE.sizeof);
                if (nMREBARCHILDSIZE.uBand == -1) break;
                CoolItem coolItem = this.items[nMREBARCHILDSIZE.wID];
                Control control = coolItem.control;
                if (control == null) break;
                int n6 = nMREBARCHILDSIZE.rcChild_right - nMREBARCHILDSIZE.rcChild_left;
                int n7 = nMREBARCHILDSIZE.rcChild_bottom - nMREBARCHILDSIZE.rcChild_top;
                control.setBounds(nMREBARCHILDSIZE.rcChild_left, nMREBARCHILDSIZE.rcChild_top, n6, n7);
                break;
            }
            case -831: {
                if (this.ignoreResize) break;
                Point point = this.getSize();
                int n8 = this.getBorderWidth();
                int n9 = OS.SendMessage(this.handle, 1051, 0, 0);
                if ((this.style & 0x200) != 0) {
                    this.setSize(n9 + 2 * n8, point.y);
                    break;
                }
                this.setSize(point.x, n9 + 2 * n8);
                break;
            }
            case -841: {
                NMREBARCHEVRON nMREBARCHEVRON = new NMREBARCHEVRON();
                OS.MoveMemory(nMREBARCHEVRON, n2, NMREBARCHEVRON.sizeof);
                CoolItem coolItem = this.items[nMREBARCHEVRON.wID];
                if (coolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                if ((this.style & 0x200) != 0) {
                    event.x = nMREBARCHEVRON.right;
                    event.y = nMREBARCHEVRON.top;
                } else {
                    event.x = nMREBARCHEVRON.left;
                    event.y = nMREBARCHEVRON.bottom;
                }
                coolItem.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                if (OS.COMCTL32_MAJOR < 6 || this.findBackgroundControl() == null && (this.style & 0x800000) == 0) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n2, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        return new LRESULT(68);
                    }
                    case 4: {
                        this.drawBackground(nMCUSTOMDRAW.hdc);
                    }
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }
}

