/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.util.List;
import java.util.Map;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.core.MeasureOptionEntry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class OptionTableViewer {
    private Map<String, MeasureOptionEntry> optionMap;
    private Messages messages;
    private TableViewer optionTableViewer;
    private final IContentProvider OPTION_TABLE_CONTENT_PROVIDER = new ArrayContentProvider(){

        public Object[] getElements(Object inputElement) {
            Map optionMap = (Map)inputElement;
            return optionMap.values().toArray();
        }
    };
    private final CellLabelProvider OPTION_TABLE_KEY_LABEL_PROVIDER = new CellLabelProvider(){

        public void update(ViewerCell cell) {
            cell.setText(((MeasureOptionEntry)cell.getElement()).getName());
        }
    };
    private final CellLabelProvider OPTION_TABLE_VALUE_LABEL_PROVIDER = new CellLabelProvider(){

        public void update(ViewerCell cell) {
            cell.setText(((MeasureOptionEntry)cell.getElement()).getValue());
        }
    };
    private final MouseListener OPTION_TABLE_CELL_SELECTED = new MouseAdapter(){

        public void mouseDown(MouseEvent event) {
            Table t = OptionTableViewer.this.optionTableViewer.getTable();
            int i = 0;
            while (i < t.getItemCount()) {
                TableItem item = t.getItem(i);
                int j = 0;
                while (j < t.getColumnCount()) {
                    if (item.getBounds(j).contains(event.x, event.y)) {
                        OptionTableViewer.this.optionTableViewer.editElement(item.getData(), 1);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
    };

    OptionTableViewer(DREFrame frame) {
        this.messages = frame.getMessages();
    }

    void setOptionMap(Map<String, MeasureOptionEntry> optionMap) {
        this.optionMap = optionMap;
        if (this.optionTableViewer != null) {
            this.optionTableViewer.setInput(optionMap);
            this.optionTableViewer.refresh();
        }
    }

    TableViewer getTableViewer() {
        return this.optionTableViewer;
    }

    void createContents(Composite parent) {
        this.optionTableViewer = new TableViewer(parent, 2560);
        this.optionTableViewer.setContentProvider(this.OPTION_TABLE_CONTENT_PROVIDER);
        this.optionTableViewer.getTable().addMouseListener(this.OPTION_TABLE_CELL_SELECTED);
        TableLayout l = new TableLayout();
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        this.optionTableViewer.getTable().setLayout((Layout)l);
        this.optionTableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn keyColumn = new TableViewerColumn(this.optionTableViewer, 0);
        keyColumn.getColumn().setText(this.messages.getString("OptionTableViewer.COLUMN.KEY"));
        keyColumn.setLabelProvider(this.OPTION_TABLE_KEY_LABEL_PROVIDER);
        TableViewerColumn valueColumn = new TableViewerColumn(this.optionTableViewer, 0);
        valueColumn.getColumn().setText(this.messages.getString("OptionTableViewer.COLUMN.VALUE"));
        valueColumn.setLabelProvider(this.OPTION_TABLE_VALUE_LABEL_PROVIDER);
        valueColumn.setEditingSupport((EditingSupport)new OptionTableEditingSupport(this.optionTableViewer));
        if (this.optionMap != null) {
            this.optionTableViewer.setInput(this.optionMap);
            this.optionTableViewer.refresh();
        }
    }

    private static class OptionTableEditingSupport
    extends EditingSupport {
        private final TableViewer tableViewer;

        public OptionTableEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.tableViewer = tableViewer;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            MeasureOptionEntry entry = (MeasureOptionEntry)element;
            if (entry.getCandidateList() != null) {
                List<String> candList = entry.getCandidateList();
                String[] cands = candList.toArray(new String[candList.size()]);
                return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), cands, 12);
            }
            return new TextCellEditor((Composite)this.tableViewer.getTable());
        }

        protected Object getValue(Object element) {
            MeasureOptionEntry entry = (MeasureOptionEntry)element;
            if (entry.getCandidateList() != null) {
                return entry.getCandidateList().indexOf(entry.getValue());
            }
            return entry.getValue();
        }

        protected void setValue(Object element, Object value) {
            MeasureOptionEntry entry = (MeasureOptionEntry)element;
            if (entry.getCandidateList() != null) {
                entry.setValue(entry.getCandidateList().get((Integer)value));
            } else {
                entry.setValue(String.valueOf(value));
            }
            this.tableViewer.refresh();
        }
    }
}

