/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.thisnor.dre.app.AllEntrySelecter;
import jp.thisnor.dre.app.CompressEntrySelecter;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.EntrySelecter;
import jp.thisnor.dre.app.FileSizeEntrySelecter;
import jp.thisnor.dre.app.FilenameEntrySelecter;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.LargerDistanceEntrySelecter;
import jp.thisnor.dre.app.LastModifiedEntrySelecter;
import jp.thisnor.dre.app.MeasureExecutePage;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PathFilterEntrySelecter;
import jp.thisnor.dre.app.PathInputViewer;
import jp.thisnor.dre.app.PickOneEntrySelecter;
import jp.thisnor.dre.app.SimilarEntrySelectPage;
import jp.thisnor.dre.app.SizeEntrySelecter;
import jp.thisnor.dre.app.SmallerDistanceEntrySelecter;
import jp.thisnor.dre.app.StorageEntrySelecter;
import jp.thisnor.dre.app.TargetEntrySelecter;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.SimilarEntry;
import jp.thisnor.dre.core.SimilarGroup;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

class SimilarEntryCheckerViewer {
    private String[] CONDITION_KEY = new String[]{"ALL", "TARGET", "SOURCE", "RANDOM_ONE", "FILE_NAME", "COMPRESS", "PIXEL_SIZE", "FILE_SIZE", "LAST_MODIFIED", "DISTANCE", "DIRECTORY"};
    private String[] MAX_MIN_KEY = new String[]{"MAX", "MIN"};
    private String[] GEQ_LEQ_KEY = new String[]{"GEQ", "LEQ"};
    private String[] CHECK_STATE_KEY = new String[]{"ON", "OFF", "TOGGLE"};
    private static final String PREFS_COND_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".cond";
    private static final String PREFS_FILENAME_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".filename";
    private static final String PREFS_COMPRESS_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".compress";
    private static final String PREFS_SIZE_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".size";
    private static final String PREFS_FILESIZE_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".filesize";
    private static final String PREFS_LASTMODIFIED_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".lastmodified";
    private static final String PREFS_DISTANCE_VALUE_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".distvalue";
    private static final String PREFS_DISTANCE_DIR_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".distdir";
    private static final String PREFS_PATH_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".path";
    private static final String PREFS_INVERSE_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".inverse";
    private static final String PREFS_CHECK_KEY = String.valueOf(SimilarEntryCheckerViewer.class.getName()) + ".check";
    private DREFrame frame;
    private Messages messages;
    private Composite rootComp;
    private ScrolledComposite condScComp;
    private Composite condComp;
    private Button[] condRadios;
    private Button[] filenameRadios;
    private Button[] compressRadios;
    private Button[] sizeRadios;
    private Button[] fileSizeRadios;
    private Button[] lastModifiedRadios;
    private Spinner distanceSpinner;
    private Button[] distanceRadios;
    private PathInputViewer pathInput;
    private Button inverseCheck;
    private Button[] checkRadios;
    private Button invokeButton;
    private final ControlListener COND_SCCOMP_RESIZED = new ControlAdapter(){

        public void controlResized(ControlEvent event) {
            Rectangle clientRect = SimilarEntryCheckerViewer.this.condScComp.getClientArea();
            SimilarEntryCheckerViewer.this.condScComp.setMinSize(SimilarEntryCheckerViewer.this.condComp.computeSize(clientRect.width, -1));
        }
    };
    private final SelectionListener UPDATE_CONTENTS_ENABLED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            SimilarEntryCheckerViewer.this.updateContentsEnabled();
        }
    };
    private final SelectionListener CHECKER_INVOKE_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            final List<SimilarGroup> simGroupList = SimilarEntryCheckerViewer.this.frame.getPage(MeasureExecutePage.class).getSimilarGroupList();
            EntrySelecter selecter0 = null;
            switch (SimilarEntryCheckerViewer.this.getSelectedCondition()) {
                case 0: {
                    selecter0 = AllEntrySelecter.INSTANCE;
                    break;
                }
                case 1: {
                    selecter0 = TargetEntrySelecter.INSTANCE;
                    break;
                }
                case 2: {
                    selecter0 = StorageEntrySelecter.INSTANCE;
                    break;
                }
                case 3: {
                    selecter0 = PickOneEntrySelecter.INSTANCE;
                    break;
                }
                case 4: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedFilename() == 0 ? FilenameEntrySelecter.LAST_SELECTER : FilenameEntrySelecter.EARLIEST_SELECTER;
                    break;
                }
                case 5: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedCompress() == 0 ? CompressEntrySelecter.MAX_SELECTER : CompressEntrySelecter.MIN_SELECTER;
                    break;
                }
                case 6: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedSize() == 0 ? SizeEntrySelecter.MAX_SELECTER : SizeEntrySelecter.MIN_SELECTER;
                    break;
                }
                case 7: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedFileSize() == 0 ? FileSizeEntrySelecter.MAX_SELECTER : FileSizeEntrySelecter.MIN_SELECTER;
                    break;
                }
                case 8: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedLastModified() == 0 ? LastModifiedEntrySelecter.LAST_SELECTER : LastModifiedEntrySelecter.EARLIEST_SELECTER;
                    break;
                }
                case 9: {
                    selecter0 = SimilarEntryCheckerViewer.this.getSelectedDistanceDir() == 0 ? new LargerDistanceEntrySelecter(SimilarEntryCheckerViewer.this.distanceSpinner.getSelection()) : new SmallerDistanceEntrySelecter(SimilarEntryCheckerViewer.this.distanceSpinner.getSelection());
                    break;
                }
                case 10: {
                    selecter0 = new PathFilterEntrySelecter(SimilarEntryCheckerViewer.this.pathInput.getPath());
                }
            }
            final AllEntrySelecter selecter = selecter0;
            final boolean inverse = SimilarEntryCheckerViewer.this.inverseCheck.getSelection();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            SimilarEntryCheckerViewer.this.invokeButton.setEnabled(false);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Set<FileEntry> selectedSet0 = selecter.select(simGroupList);
                    if (inverse) {
                        HashSet<FileEntry> wholeSet = new HashSet<FileEntry>();
                        for (SimilarGroup simGroup : simGroupList) {
                            wholeSet.add(simGroup.getFileEntry());
                            for (SimilarEntry similar : simGroup.getSimilarList()) {
                                wholeSet.add(similar.getFileEntry());
                            }
                        }
                        wholeSet.removeAll(selectedSet0);
                        selectedSet0 = wholeSet;
                    }
                    final Set<FileEntry> selectedSet = selectedSet0;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SimilarEntryCheckerViewer.this.frame.getShell().isDisposed()) {
                                return;
                            }
                            SimilarEntrySelectPage selectPage = SimilarEntryCheckerViewer.this.frame.getPage(SimilarEntrySelectPage.class);
                            switch (SimilarEntryCheckerViewer.this.getSelectedCheck()) {
                                case 0: {
                                    selectPage.setFileChecked(selectedSet, 1);
                                    break;
                                }
                                case 1: {
                                    selectPage.setFileChecked(selectedSet, 0);
                                    break;
                                }
                                case 2: {
                                    selectPage.setFileChecked(selectedSet, -1);
                                }
                            }
                            SimilarEntryCheckerViewer.this.invokeButton.setEnabled(true);
                        }
                    });
                }
            });
            executor.shutdown();
        }
    };

    SimilarEntryCheckerViewer(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    void createContents(Composite parent) {
        PreferenceStore prefs = this.frame.getPreferences();
        prefs.setDefault(PREFS_COND_KEY, 0);
        prefs.setDefault(PREFS_FILENAME_KEY, 0);
        prefs.setDefault(PREFS_COMPRESS_KEY, 0);
        prefs.setDefault(PREFS_SIZE_KEY, 0);
        prefs.setDefault(PREFS_FILESIZE_KEY, 0);
        prefs.setDefault(PREFS_LASTMODIFIED_KEY, 0);
        prefs.setDefault(PREFS_DISTANCE_VALUE_KEY, 100);
        prefs.setDefault(PREFS_DISTANCE_DIR_KEY, 0);
        prefs.setDefault(PREFS_PATH_KEY, "");
        prefs.setDefault(PREFS_INVERSE_KEY, false);
        prefs.setDefault(PREFS_CHECK_KEY, 0);
        this.rootComp = new Composite(parent, 0);
        this.rootComp.setLayout((Layout)new FormLayout());
        Group condBorderGroup = new Group(this.rootComp, 0);
        condBorderGroup.setLayout((Layout)new FillLayout());
        this.condScComp = new ScrolledComposite((Composite)condBorderGroup, 768);
        this.condScComp.setMinHeight(10000);
        this.condScComp.setExpandHorizontal(true);
        this.condScComp.setExpandVertical(true);
        this.condScComp.addControlListener(this.COND_SCCOMP_RESIZED);
        this.condComp = new Composite((Composite)this.condScComp, 0);
        this.condScComp.setContent((Control)this.condComp);
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        l.marginHeight = 8;
        l.marginWidth = 8;
        l.horizontalSpacing = 8;
        this.condComp.setLayout((Layout)l);
        this.condRadios = new Button[this.CONDITION_KEY.length];
        int i = 0;
        while (i < this.CONDITION_KEY.length) {
            FormLayout l2;
            this.condRadios[i] = new Button(this.condComp, 16);
            this.condRadios[i].setText(this.messages.getString("SimilarEntryCheckerViewer.CONDITION." + this.CONDITION_KEY[i]));
            this.condRadios[i].addSelectionListener(this.UPDATE_CONTENTS_ENABLED);
            GridData condRadioGridData = new GridData();
            this.condRadios[i].setLayoutData((Object)condRadioGridData);
            if (i == 10) {
                new Label(this.condComp, 0);
            }
            Composite condItemComp = new Composite(this.condComp, 0);
            condItemComp.setLayoutData((Object)new GridData(768));
            switch (i) {
                case 4: {
                    Group filenameGroup = new Group(condItemComp, 0);
                    filenameGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.filenameRadios = new Button[this.MAX_MIN_KEY.length];
                    int j = 0;
                    while (j < this.MAX_MIN_KEY.length) {
                        this.filenameRadios[j] = new Button((Composite)filenameGroup, 16);
                        this.filenameRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.FILE_NAME." + this.MAX_MIN_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 5: {
                    Group compressGroup = new Group(condItemComp, 0);
                    compressGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.compressRadios = new Button[this.MAX_MIN_KEY.length];
                    int j = 0;
                    while (j < this.MAX_MIN_KEY.length) {
                        this.compressRadios[j] = new Button((Composite)compressGroup, 16);
                        this.compressRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.COMPRESS." + this.MAX_MIN_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 6: {
                    Group sizeGroup = new Group(condItemComp, 0);
                    sizeGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.sizeRadios = new Button[this.MAX_MIN_KEY.length];
                    int j = 0;
                    while (j < this.MAX_MIN_KEY.length) {
                        this.sizeRadios[j] = new Button((Composite)sizeGroup, 16);
                        this.sizeRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.PIXEL_SIZE." + this.MAX_MIN_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 7: {
                    Group fileSizeGroup = new Group(condItemComp, 0);
                    fileSizeGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.fileSizeRadios = new Button[this.MAX_MIN_KEY.length];
                    int j = 0;
                    while (j < this.MAX_MIN_KEY.length) {
                        this.fileSizeRadios[j] = new Button((Composite)fileSizeGroup, 16);
                        this.fileSizeRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.FILE_SIZE." + this.MAX_MIN_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 8: {
                    Group lastModifiedGroup = new Group(condItemComp, 0);
                    lastModifiedGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.lastModifiedRadios = new Button[this.MAX_MIN_KEY.length];
                    int j = 0;
                    while (j < this.MAX_MIN_KEY.length) {
                        this.lastModifiedRadios[j] = new Button((Composite)lastModifiedGroup, 16);
                        this.lastModifiedRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.LAST_MODIFIED." + this.MAX_MIN_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 9: {
                    this.distanceSpinner = new Spinner(condItemComp, 2048);
                    this.distanceSpinner.setMinimum(0);
                    this.distanceSpinner.setMaximum(Integer.MAX_VALUE);
                    Group distanceGroup = new Group(condItemComp, 0);
                    distanceGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
                    this.distanceRadios = new Button[this.GEQ_LEQ_KEY.length];
                    int j = 0;
                    while (j < this.GEQ_LEQ_KEY.length) {
                        this.distanceRadios[j] = new Button((Composite)distanceGroup, 16);
                        this.distanceRadios[j].setText(this.messages.getString("SimilarEntryCheckerViewer.DISTANCE." + this.GEQ_LEQ_KEY[j]));
                        ++j;
                    }
                    break;
                }
                case 10: {
                    condRadioGridData.horizontalSpan = 2;
                    this.pathInput = new PathInputViewer(this.frame);
                    this.pathInput.createContents(condItemComp);
                    this.pathInput.getControl().setLayoutData((Object)new FormDataBuilder().left(0).right(100).build());
                }
            }
            if (i == 10) {
                l2 = new FormLayout();
                condItemComp.setLayout((Layout)l2);
            } else {
                l2 = new RowLayout(256);
                l2.spacing = 8;
                l2.center = true;
                condItemComp.setLayout((Layout)l2);
            }
            ++i;
        }
        Group inverseGroup = new Group(this.rootComp, 0);
        inverseGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
        this.inverseCheck = new Button((Composite)inverseGroup, 32);
        this.inverseCheck.setText(this.messages.getString("SimilarEntryCheckerViewer.INVERSE"));
        Group checkGroup = new Group(this.rootComp, 0);
        checkGroup.setLayout((Layout)this.createSpacedHorizontalLayout());
        this.checkRadios = new Button[this.CHECK_STATE_KEY.length];
        int i2 = 0;
        while (i2 < this.CHECK_STATE_KEY.length) {
            this.checkRadios[i2] = new Button((Composite)checkGroup, 16);
            this.checkRadios[i2].setText(this.messages.getString("SimilarEntryCheckerViewer.CHECK." + this.CHECK_STATE_KEY[i2]));
            ++i2;
        }
        Composite invokeComp = new Composite(this.rootComp, 0);
        invokeComp.setLayout((Layout)new FormLayout());
        this.invokeButton = new Button(invokeComp, 8);
        this.invokeButton.setText(this.messages.getString("SimilarEntryCheckerViewer.INVOKE"));
        this.invokeButton.addSelectionListener(this.CHECKER_INVOKE_BUTTON_SELECTED);
        this.invokeButton.setLayoutData((Object)new FormDataBuilder().left(100, -80).right(100).bottom(100).build());
        condBorderGroup.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)inverseGroup).build());
        inverseGroup.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom((Control)checkGroup).build());
        checkGroup.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom((Control)invokeComp).build());
        invokeComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom(100).build());
        this.select(this.condRadios, prefs.getInt(PREFS_COND_KEY));
        this.select(this.filenameRadios, prefs.getInt(PREFS_FILENAME_KEY));
        this.select(this.compressRadios, prefs.getInt(PREFS_COMPRESS_KEY));
        this.select(this.sizeRadios, prefs.getInt(PREFS_SIZE_KEY));
        this.select(this.fileSizeRadios, prefs.getInt(PREFS_FILESIZE_KEY));
        this.select(this.lastModifiedRadios, prefs.getInt(PREFS_LASTMODIFIED_KEY));
        this.distanceSpinner.setSelection(prefs.getInt(PREFS_DISTANCE_VALUE_KEY));
        this.select(this.distanceRadios, prefs.getInt(PREFS_DISTANCE_DIR_KEY));
        this.pathInput.setPath(prefs.getString(PREFS_PATH_KEY));
        this.inverseCheck.setSelection(prefs.getBoolean(PREFS_INVERSE_KEY));
        this.select(this.checkRadios, prefs.getInt(PREFS_CHECK_KEY));
        this.updateContentsEnabled();
    }

    void hiddened() {
        PreferenceStore prefs = this.frame.getPreferences();
        prefs.setValue(PREFS_COND_KEY, this.getSelectedCondition());
        prefs.setValue(PREFS_FILENAME_KEY, this.getSelectedFilename());
        prefs.setValue(PREFS_COMPRESS_KEY, this.getSelectedCompress());
        prefs.setValue(PREFS_SIZE_KEY, this.getSelectedSize());
        prefs.setValue(PREFS_FILESIZE_KEY, this.getSelectedFileSize());
        prefs.setValue(PREFS_LASTMODIFIED_KEY, this.getSelectedLastModified());
        prefs.setValue(PREFS_DISTANCE_VALUE_KEY, this.distanceSpinner.getSelection());
        prefs.setValue(PREFS_DISTANCE_DIR_KEY, this.getSelectedDistanceDir());
        prefs.setValue(PREFS_PATH_KEY, this.pathInput.getPath());
        prefs.setValue(PREFS_INVERSE_KEY, this.inverseCheck.getSelection());
        prefs.setValue(PREFS_CHECK_KEY, this.getSelectedCheck());
    }

    void updateContentsEnabled() {
        Button b;
        Button[] buttonArray = this.filenameRadios;
        int n = this.filenameRadios.length;
        int n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[4].getSelection());
            ++n2;
        }
        buttonArray = this.compressRadios;
        n = this.compressRadios.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[5].getSelection());
            ++n2;
        }
        buttonArray = this.sizeRadios;
        n = this.sizeRadios.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[6].getSelection());
            ++n2;
        }
        buttonArray = this.fileSizeRadios;
        n = this.fileSizeRadios.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[7].getSelection());
            ++n2;
        }
        buttonArray = this.lastModifiedRadios;
        n = this.lastModifiedRadios.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[8].getSelection());
            ++n2;
        }
        this.distanceSpinner.setEnabled(this.condRadios[9].getSelection());
        buttonArray = this.distanceRadios;
        n = this.distanceRadios.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(this.condRadios[9].getSelection());
            ++n2;
        }
        this.pathInput.setEnabled(this.condRadios[10].getSelection());
    }

    private void select(Button[] radios, int index) {
        if (index < 0) {
            return;
        }
        radios[index].setSelection(true);
    }

    private int getSelectedFilename() {
        int i = 0;
        while (i < this.filenameRadios.length) {
            if (this.filenameRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedCondition() {
        int i = 0;
        while (i < this.condRadios.length) {
            if (this.condRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedCompress() {
        int i = 0;
        while (i < this.compressRadios.length) {
            if (this.compressRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedSize() {
        int i = 0;
        while (i < this.sizeRadios.length) {
            if (this.sizeRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedFileSize() {
        int i = 0;
        while (i < this.fileSizeRadios.length) {
            if (this.fileSizeRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedLastModified() {
        int i = 0;
        while (i < this.lastModifiedRadios.length) {
            if (this.lastModifiedRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedDistanceDir() {
        int i = 0;
        while (i < this.distanceRadios.length) {
            if (this.distanceRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedCheck() {
        int i = 0;
        while (i < this.checkRadios.length) {
            if (this.checkRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private RowLayout createSpacedHorizontalLayout() {
        RowLayout l = new RowLayout(256);
        l.spacing = 8;
        l.center = true;
        return l;
    }
}

