/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.lls;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.lls.LLSData;

public class LLSMeasurer
implements Measurer {
    private static final File CACHE_DIR = new File("cache");
    private static final String CACHE_FILE_PATH = "jdbc:sqlite:cache/jp.thisnor.dre.lls.cache.sqlite3";
    private static final String TABLE_NAME = "tb_lls_cache";
    private volatile boolean useCache;
    private volatile int distType;
    private static final int DISTTYPE_MANHATTAN = 1;
    private static final int DISTTYPE_EUCLIDEAN = 2;
    private static final int DISTTYPE_CHEBYSHEV = 0;
    private Queue<CacheEntry> storeCacheQueue;
    private static final int PREF_QUEUE_SIZE = 64;

    @Override
    public void init(Map<String, MeasureOptionEntry> optionMap) {
        String distTypeStr;
        this.useCache = optionMap.get("useCache").getValue().equals("true");
        if (this.useCache) {
            try {
                this.initDB();
                this.storeCacheQueue = new ConcurrentLinkedQueue<CacheEntry>();
            }
            catch (SQLException e) {
                this.useCache = false;
            }
            catch (ClassNotFoundException e) {
                this.useCache = false;
            }
        }
        this.distType = "Manhattan".equals(distTypeStr = optionMap.get("distType").getValue()) ? 1 : ("Euclidean".equals(distTypeStr) ? 2 : 0);
    }

    @Override
    public Object convert(FileEntry fileEntry) throws Exception {
        LLSData data;
        if (this.useCache && (data = this.loadCache(fileEntry)) != null) {
            return data;
        }
        BufferedImage srcImage = null;
        InputStream in = null;
        try {
            try {
                in = fileEntry.open();
                srcImage = ImageIO.read(in);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed in reading: %s", fileEntry.getPath()), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (srcImage == null) {
            new IOException(String.format("Failed in reading: %s", fileEntry.getPath()));
        }
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        BufferedImage dstImage = new BufferedImage(srcWidth, srcHeight, 10);
        Graphics2D g2 = dstImage.createGraphics();
        g2.drawImage((Image)srcImage, 0, 0, null);
        g2.dispose();
        byte[] pixels = new byte[srcWidth * srcHeight];
        dstImage.getRaster().getDataElements(0, 0, srcWidth, srcHeight, pixels);
        int wssp = 8;
        int wdsp = srcWidth;
        int y = 0;
        while (y < srcHeight) {
            int sx = 0;
            int nssdx = 8;
            int sval = pixels[y * srcWidth] & 0xFF;
            int dx = 0;
            int ndsdx = wdsp;
            int dval = 0;
            int sdx = 0;
            while (sdx < srcWidth * 8) {
                if (sdx == nssdx) {
                    nssdx += 8;
                    sval = pixels[y * srcWidth + ++sx] & 0xFF;
                }
                dval += sval;
                if (++sdx != ndsdx) continue;
                pixels[y * srcWidth + dx] = (byte)(dval / wdsp);
                ++dx;
                ndsdx += wdsp;
                dval = 0;
            }
            ++y;
        }
        int hssp = 8;
        int hdsp = srcHeight;
        int x = 0;
        while (x < 8) {
            int sy = 0;
            int nssdy = 8;
            int sval = pixels[x] & 0xFF;
            int dy = 0;
            int ndsdy = hdsp;
            int dval = 0;
            int sdy = 0;
            while (sdy < srcHeight * 8) {
                if (sdy == nssdy) {
                    nssdy += 8;
                    sval = pixels[++sy * srcWidth + x] & 0xFF;
                }
                dval += sval;
                if (++sdy != ndsdy) continue;
                pixels[dy * 8 + x] = (byte)(dval / hdsp);
                ++dy;
                ndsdy += hdsp;
                dval = 0;
            }
            ++x;
        }
        int sum = 0;
        int sum2 = 0;
        int i = 0;
        while (i < 64) {
            int srcPixel = pixels[i] & 0xFF;
            sum += srcPixel;
            sum2 += srcPixel * srcPixel;
            ++i;
        }
        int mean = sum / 64;
        int var = (int)Math.sqrt(sum2 / 64 - sum * sum / 4096);
        if (var == 0) {
            var = 1;
        }
        int i2 = 0;
        while (i2 < 64) {
            int dstPixel = ((pixels[i2] & 0xFF) - mean) * 64 / var;
            if (dstPixel > 127) {
                dstPixel = 127;
            }
            if (dstPixel < -127) {
                dstPixel = -127;
            }
            pixels[i2] = (byte)dstPixel;
            ++i2;
        }
        LLSData data2 = new LLSData(Arrays.copyOf(pixels, 64));
        if (this.useCache) {
            this.storeCacheQueue.offer(new CacheEntry(fileEntry, data2));
            if (this.storeCacheQueue.size() >= 64) {
                this.storeCaches();
            }
        }
        return data2;
    }

    @Override
    public int measure(Object o1, Object o2, int threshold) {
        LLSData data1 = (LLSData)o1;
        LLSData data2 = (LLSData)o2;
        int sum = 0;
        switch (this.distType) {
            case 2: {
                int th = (threshold + 1) * (threshold + 1);
                int i = 0;
                while (i < 64) {
                    int d = data1.pixels[i] - data2.pixels[i];
                    if ((sum += d * d) >= th) break;
                    ++i;
                }
                return (int)Math.sqrt(sum);
            }
            case 1: {
                int i = 0;
                while (i < 64) {
                    if ((sum += Math.abs(data1.pixels[i] - data2.pixels[i])) > threshold) break;
                    ++i;
                }
                return sum;
            }
            case 0: {
                int max = 0;
                int i = 0;
                while (i < 64) {
                    int d = Math.abs(data1.pixels[i] - data2.pixels[i]);
                    if (d > max) {
                        max = d;
                    }
                    if (max > threshold) break;
                    ++i;
                }
                return max;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void dispose() {
        if (this.useCache) {
            this.storeCaches();
        }
    }

    private void initDB() throws SQLException, ClassNotFoundException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            this.useCache = false;
            throw e;
        }
        if (!CACHE_DIR.exists()) {
            CACHE_DIR.mkdirs();
        }
        Connection conn = null;
        try {
            try {
                conn = DriverManager.getConnection(CACHE_FILE_PATH);
                Statement stat = conn.createStatement();
                stat.execute("CREATE TABLE IF NOT EXISTS tb_lls_cache(name TEXT, date INTEGER, data BLOB);");
                stat.execute("CREATE INDEX IF NOT EXISTS id_date_size ON tb_lls_cache(name, date);");
                conn.close();
            }
            catch (SQLException e) {
                this.useCache = false;
                throw e;
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LLSData loadCache(FileEntry entry) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(CACHE_FILE_PATH);
            Statement stat = conn.createStatement();
            ResultSet res = stat.executeQuery(String.format("SELECT data FROM %s WHERE name = \"%s\" AND date = %s;", TABLE_NAME, entry.getName(), entry.getLastModified()));
            if (!res.next()) {
                return null;
            }
            byte[] data = res.getBytes(1);
            if (res.next()) {
                return null;
            }
            LLSData lLSData = new LLSData(data);
            return lLSData;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void storeCaches() {
        Connection conn = null;
        try {
            try {
                conn = DriverManager.getConnection(CACHE_FILE_PATH);
                conn.setAutoCommit(false);
                CacheEntry cacheEntry = null;
                while ((cacheEntry = this.storeCacheQueue.poll()) != null) {
                    PreparedStatement stat = conn.prepareStatement(String.format("INSERT INTO %s VALUES(\"%s\", %s, ?);", TABLE_NAME, cacheEntry.fileEntry.getName(), cacheEntry.fileEntry.getLastModified()));
                    stat.setBytes(1, ((CacheEntry)cacheEntry).data.pixels);
                    stat.executeUpdate();
                }
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static class CacheEntry {
        private final FileEntry fileEntry;
        private final LLSData data;

        private CacheEntry(FileEntry fileEntry, LLSData data) {
            this.fileEntry = fileEntry;
            this.data = data;
        }
    }
}

