/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DREDBConnection {
    private static final String ITEM_TABLE = "item";
    private static final String SIMPAIR_TABLE = "simpair";
    private static final String PARAM_TABLE = "param";
    private final String dbPath;
    private Connection conn;
    private PreparedStatement insertItemStat;
    private PreparedStatement updateItemTypeStat;
    private PreparedStatement updateItemDataStat;
    private PreparedStatement selectAllItemsStat;
    private PreparedStatement selectItemIDByPathStat;
    private PreparedStatement selectItemPathStat;
    private PreparedStatement selectItemTypeStat;
    private PreparedStatement insertSimPairStat;
    private PreparedStatement selectAllSimPairsStat;
    private PreparedStatement selectSimPairsByItemStat;
    private PreparedStatement insertParamStat;
    private PreparedStatement selectParamValueStat;

    public DREDBConnection(String dbPath) {
        this.dbPath = dbPath;
    }

    public void open() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + this.dbPath);
        this.insertItemStat = this.conn.prepareStatement(String.format("INSERT OR REPLACE INTO %s (path, type) VALUES (?, ?);", ITEM_TABLE), 1);
        this.updateItemTypeStat = this.conn.prepareStatement(String.format("UPDATE %s SET type = ? WHERE iid = ?;", ITEM_TABLE));
        this.updateItemDataStat = this.conn.prepareStatement(String.format("UPDATE %s SET data = ?, gdist = ? WHERE iid = ?;", ITEM_TABLE));
        this.selectAllItemsStat = this.conn.prepareStatement(String.format("SELECT * FROM %s ORDER BY gdist;", ITEM_TABLE));
        this.selectItemIDByPathStat = this.conn.prepareStatement(String.format("SELECT iid FROM %s WHERE path = ?;", ITEM_TABLE));
        this.selectItemPathStat = this.conn.prepareStatement(String.format("SELECT path FROM %s WHERE iid = ?;", ITEM_TABLE));
        this.selectItemTypeStat = this.conn.prepareStatement(String.format("SELECT type FROM %s WHERE iid = ?;", ITEM_TABLE));
        this.insertSimPairStat = this.conn.prepareStatement(String.format("INSERT INTO %s VALUES (?, ?, ?);", SIMPAIR_TABLE));
        this.selectAllSimPairsStat = this.conn.prepareStatement(String.format("SELECT * FROM %s ORDER BY dist;", SIMPAIR_TABLE));
        this.selectSimPairsByItemStat = this.conn.prepareStatement(String.format("SELECT * FROM %s WHERE fid1 = ?1 OR fid2 = ?1 ORDER BY dist;", SIMPAIR_TABLE));
        this.insertParamStat = this.conn.prepareStatement(String.format("INSERT INTO %s VALUES (?, ?);", PARAM_TABLE));
        this.selectParamValueStat = this.conn.prepareStatement(String.format("SELECT value FROM %s WHERE key = ?;", PARAM_TABLE));
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    void initDatabase() throws SQLException {
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            this.conn.setAutoCommit(false);
            stat.execute(String.format("DROP TABLE IF EXISTS %s;", ITEM_TABLE));
            stat.execute(String.format("DROP TABLE IF EXISTS %s;", SIMPAIR_TABLE));
            stat.execute(String.format("DROP TABLE IF EXISTS %s;", PARAM_TABLE));
            stat.execute("VACUUM;");
            stat.execute(String.format("CREATE TABLE %s (iid INTEGER PRIMARY KEY, path TEXT UNIQUE, type INTEGER, data BLOB, gdist NUMERIC);", ITEM_TABLE));
            stat.execute(String.format("CREATE TABLE %s (iid1 INTEGER, iid2 INTEGER, dist NUMERIC);", SIMPAIR_TABLE));
            stat.execute(String.format("CREATE TABLE %s (key TEXT PRIMARY KEY, value TEXT);", PARAM_TABLE));
            this.conn.commit();
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long insertItem(String path, int type) throws SQLException {
        Class<DREDBConnection> clazz = DREDBConnection.class;
        synchronized (DREDBConnection.class) {
            long itemID = this.selectItemIDByPath(path);
            if (itemID == 0L) {
                this.insertItemStat.setString(1, path);
                this.insertItemStat.setInt(2, type);
                this.insertItemStat.execute();
                ResultSet iidSet = null;
                try {
                    iidSet = this.insertItemStat.getGeneratedKeys();
                    iidSet.next();
                    itemID = iidSet.getLong("iid");
                }
                finally {
                    if (iidSet != null) {
                        try {
                            iidSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            this.updateItemTypeStat.setInt(1, type);
            this.updateItemTypeStat.setLong(2, itemID);
            this.updateItemTypeStat.execute();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return itemID;
        }
    }

    void updateItemData(int itemID, Object data, double gdist) throws SQLException {
        this.updateItemDataStat.setObject(1, data);
        this.updateItemDataStat.setDouble(2, gdist);
        this.updateItemDataStat.setLong(3, itemID);
        this.updateItemDataStat.execute();
    }

    public ResultSet selectAllItems() throws SQLException {
        return this.selectAllItemsStat.executeQuery();
    }

    public long selectItemIDByPath(String path) throws SQLException {
        ResultSet iidSet = null;
        try {
            this.selectItemIDByPathStat.setString(1, path);
            iidSet = this.selectItemIDByPathStat.executeQuery();
            long l = iidSet.next() ? iidSet.getLong("iid") : 0L;
            return l;
        }
        finally {
            if (iidSet != null) {
                try {
                    iidSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String selectItemPath(long itemID) throws SQLException {
        ResultSet pathSet = null;
        try {
            this.selectItemPathStat.setLong(1, itemID);
            pathSet = this.selectItemPathStat.executeQuery();
            String string = pathSet.next() ? pathSet.getString("path") : null;
            return string;
        }
        finally {
            if (pathSet != null) {
                try {
                    pathSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int selectItemType(long itemID) throws SQLException {
        ResultSet typeSet = null;
        try {
            this.selectItemTypeStat.setLong(1, itemID);
            typeSet = this.selectItemTypeStat.executeQuery();
            int n = typeSet.next() ? typeSet.getInt("type") : 0;
            return n;
        }
        finally {
            if (typeSet != null) {
                try {
                    typeSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void insertSimPair(long itemID1, long itemID2, double dist) throws SQLException {
        this.insertSimPairStat.setLong(1, itemID1);
        this.insertSimPairStat.setLong(2, itemID2);
        this.insertSimPairStat.setDouble(3, dist);
        this.insertSimPairStat.execute();
    }

    public ResultSet selectAllSimPairs() throws SQLException {
        return this.selectAllSimPairsStat.executeQuery();
    }

    public ResultSet selectSimPairsByItem(long itemID) throws SQLException {
        this.selectSimPairsByItemStat.setLong(1, itemID);
        return this.selectSimPairsByItemStat.executeQuery();
    }

    void insertParam(String key, String value) throws SQLException {
        this.insertParamStat.setString(1, key);
        this.insertParamStat.setString(2, value);
        this.insertParamStat.execute();
    }

    public String selectParamValue(String key) throws SQLException {
        ResultSet valueSet = null;
        try {
            this.selectParamValueStat.setString(1, key);
            valueSet = this.selectParamValueStat.executeQuery();
            String string = valueSet.next() ? valueSet.getString("value") : null;
            return string;
        }
        finally {
            if (valueSet != null) {
                try {
                    valueSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

