/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.thisnor.dre.core.DREDBConnection;

public class DRETask
implements Runnable {
    static final String DATABASE_PATH = "dre.sqlite3";
    private final List<String> pathList;
    private final Map<String, String> paramMap;
    private final PrintWriter log;

    public DRETask(List<String> pathList, Map<String, String> paramMap, OutputStream log) {
        this.pathList = pathList;
        this.paramMap = paramMap;
        this.log = new PrintWriter(log);
    }

    @Override
    public void run() {
        block17: {
            int numThreads = 1;
            String value = this.paramMap.get("numThreads");
            if (value != null) {
                try {
                    numThreads = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.log.printf("Cannot set \"%s\" into the parameter \"numThreads\". Use \"1\" instead.%n", value);
                }
            } else {
                this.log.printf("Not specified the parameter \"numThreads\", Use \"1\".%n", new Object[0]);
            }
            ExecutorService exec = Executors.newFixedThreadPool(numThreads);
            DREDBConnection gconn = null;
            try {
                try {
                    gconn = new DREDBConnection(DATABASE_PATH);
                    gconn.initDatabase();
                    for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
                        gconn.insertParam(entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    this.log.printf("%s: %s%n", e.getClass(), e.getLocalizedMessage());
                    this.log.println("Aborted.");
                    if (gconn == null) break block17;
                    try {
                        gconn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (gconn != null) {
                    try {
                        gconn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

