/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.util.List;
import jp.thisnor.dre.core.MeasureEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.core.SynchronizedCounter;

public class FirstMeasureTask
implements Runnable {
    private final Measurer measurer;
    private final List<MeasureEntry> entryList;
    private final MeasureEntry firstEntry;
    private final SynchronizedCounter counter;

    public FirstMeasureTask(List<MeasureEntry> entryList, MeasureEntry firstEntry, Measurer measurer, SynchronizedCounter counter) {
        this.measurer = measurer;
        this.entryList = entryList;
        this.firstEntry = firstEntry;
        this.counter = counter;
    }

    @Override
    public void run() {
        int index;
        while ((index = this.counter.countup()) < this.entryList.size()) {
            MeasureEntry entry = this.entryList.get(index);
            entry.firstDistance = this.measurer.measure(this.firstEntry.data, entry.data, Integer.MAX_VALUE);
            if (!Thread.interrupted()) continue;
            return;
        }
    }
}

