/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.CellGroupReference;
import jp.co.nissy.jpicosheet.core.Range;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements CellGroupReference {
    private String _name;
    private List<List<Cell>> _rows;
    private Sheet _sheet;
    private int _colSize;
    static final String TABLE_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*#";
    private static Pattern _tableNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*#");
    static final String FULLY_QUALIFIED_TABLE_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#";
    private static Pattern _fullyQualifiedTableNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#");
    static final String ADDRESS_PATTERN = "(R[0-9]+C[0-9]+)";
    private static Pattern _AddressPattern = Pattern.compile("(R[0-9]+C[0-9]+)");
    static final String TABLE_NAME_WITH_ADDRESS_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)";
    private static Pattern _tableNameWithAddressPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)");
    static final String FULLY_QUALIFIED_TABLE_NAME_WITH_ADDRESS_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)";
    private static Pattern _fullyQualifiedtableNameWithAddressPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)");
    static final String RANGE_PARSE_PATTERN = "^(?:(?:(R[0-9]+)(C[0-9]+)(:)(R[0-9]+)(C[0-9]+))|(?:(R[0-9]+)(C[0-9]+)(:)(R[0-9]+)(Cx))|(?:(R[0-9]+)(C[0-9]+)(:)(Rx)(C[0-9]+))|(?:(R[0-9]+)(C[0-9]+)(:)(Rx)(Cx))|(?:(R[0-9]+)(Cx))|(?:(Rx)(C[0-9]+))|)$";
    static final String RANGE_PATTERN_BASE = "R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+";
    static final String RANGE_PATTERN = "^(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)$";
    private static Pattern _RangeParsePattern = Pattern.compile("^(?:(?:(R[0-9]+)(C[0-9]+)(:)(R[0-9]+)(C[0-9]+))|(?:(R[0-9]+)(C[0-9]+)(:)(R[0-9]+)(Cx))|(?:(R[0-9]+)(C[0-9]+)(:)(Rx)(C[0-9]+))|(?:(R[0-9]+)(C[0-9]+)(:)(Rx)(Cx))|(?:(R[0-9]+)(Cx))|(?:(Rx)(C[0-9]+))|)$");
    private static Pattern _RangePattern = Pattern.compile("^(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)$");
    static final String TABLE_NAME_WITH_RANGE_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)";
    private static Pattern _tableNameWithRangePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)");
    static final String FULLY_QUALIFIED_TABLE_NAME_WITH_RANGE_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)";
    private static Pattern _fullyQualifiedtableNameWithRangePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)");

    Table(String tableName, int rowSize, int colSize, Sheet sheet) throws IllegalArgumentException {
        this.validateTableName(tableName);
        if (rowSize <= 0 || colSize <= 0) {
            throw new IllegalArgumentException("invalid row/col size. row=" + Integer.toString(rowSize) + " col=" + Integer.toString(colSize));
        }
        this._name = tableName;
        this._colSize = colSize;
        this._sheet = sheet;
        this._rows = new ArrayList<List<Cell>>(rowSize);
        int row = 0;
        while (row < rowSize) {
            this._rows.add(this.createRow(row));
            ++row;
        }
    }

    private void validateTableName(String tableName) throws IllegalArgumentException {
        if (!Table.isValidTableName(tableName)) {
            throw new IllegalArgumentException("invalid table name \"" + tableName + "\"");
        }
    }

    static boolean isValidTableName(String tableName) {
        return _tableNamePattern.matcher(tableName).matches();
    }

    static boolean isValidFullyQualifiedTableName(String fullyQualifiedTableName) {
        return _fullyQualifiedTableNamePattern.matcher(fullyQualifiedTableName).matches();
    }

    static boolean isValidTableNameWithAddress(String tableNameWithAddress) {
        return _tableNameWithAddressPattern.matcher(tableNameWithAddress).matches();
    }

    static boolean isValidFullyQualifiedTableNameWithAddress(String fullyQualifiedTableNameWithAddress) {
        return _fullyQualifiedtableNameWithAddressPattern.matcher(fullyQualifiedTableNameWithAddress).matches();
    }

    static boolean isValidRangeName(String rangeName) {
        return _RangePattern.matcher(rangeName).matches();
    }

    static boolean isValidTableNameWithRange(String tableNameWithRange) {
        return _tableNameWithRangePattern.matcher(tableNameWithRange).matches();
    }

    static boolean isValidFullyQualifiedTableNameWithRange(String fullyQualifiedTableNameWithRange) {
        return _fullyQualifiedtableNameWithRangePattern.matcher(fullyQualifiedTableNameWithRange).matches();
    }

    private void validateRangeName(String rangeName) throws IllegalArgumentException {
        if (!Table.isValidRangeName(rangeName)) {
            throw new IllegalArgumentException("invalid range name \"" + rangeName + "\"");
        }
    }

    public String getName() {
        return this._name;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this._sheet.getName()) + "!" + this._name;
    }

    private List<Cell> createRow(int rowNo) {
        ArrayList<Cell> rowData = new ArrayList<Cell>(this._colSize);
        String rowNoString = Integer.toString(rowNo);
        int col = 0;
        while (col < this._colSize) {
            rowData.add(this._sheet.addCell(String.valueOf(this._name) + "R" + rowNoString + "C" + Integer.toString(col), true));
            ++col;
        }
        return rowData;
    }

    public Table addRow() {
        return this.addRow(1);
    }

    public Table addRow(int addRowCount) {
        if (addRowCount < 0) {
            throw new IllegalArgumentException("invalid addRowCount: " + Integer.toString(addRowCount));
        }
        int i = 0;
        while (i < addRowCount) {
            this._rows.add(this.createRow(this._rows.size()));
            ++i;
        }
        return this;
    }

    public Table addColumn() {
        return this.addColumn(1);
    }

    public Table addColumn(int addColumnCount) {
        if (addColumnCount < 0) {
            throw new IllegalArgumentException("invalid addColumnCount: " + Integer.toString(addColumnCount));
        }
        int i = 0;
        while (i < this._rows.size()) {
            int o = 0;
            while (o < addColumnCount) {
                String newCellName = String.valueOf(this._name) + "R" + Integer.toString(i) + "C" + Integer.toString(this._rows.get(i).size());
                Cell cell = this._sheet.addCell(newCellName, true);
                this._rows.get(i).add(cell);
                ++o;
            }
            ++i;
        }
        return this;
    }

    public Table insertRow(int rowPos) {
        return this.insertRow(rowPos, 1);
    }

    public Table insertRow(int rowPos, int insertRowCount) {
        if (rowPos < 0) {
            throw new IllegalArgumentException("ingalid rowPos: " + Integer.toString(rowPos));
        }
        if (this._rows.size() <= rowPos) {
            throw new IllegalArgumentException("ingalid rowPos: " + Integer.toString(rowPos) + " table rowsize: " + Integer.toString(this._rows.size()));
        }
        if (insertRowCount < 1) {
            throw new IllegalArgumentException("ingalid insertRowCount: " + Integer.toString(insertRowCount));
        }
        StringBuilder cellName = new StringBuilder();
        StringBuilder newCellName = new StringBuilder();
        int rowIndex = this._rows.size() - 1;
        while (rowPos <= rowIndex) {
            int colIndex = this._rows.get(0).size() - 1;
            while (colIndex >= 0) {
                block8: {
                    cellName.delete(0, cellName.length());
                    newCellName.delete(0, newCellName.length());
                    cellName.append(this._name).append("R").append(rowIndex).append("C").append(colIndex);
                    newCellName.append(this._name).append("R").append(rowIndex + insertRowCount).append("C").append(colIndex);
                    try {
                        this._sheet.renameCell(cellName.toString(), newCellName.toString());
                    }
                    catch (ReferenceNotFoundException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)("Cell not found: " + cellName.toString()));
                    }
                }
                --colIndex;
            }
            --rowIndex;
        }
        rowIndex = rowPos;
        while (rowIndex < rowPos + insertRowCount) {
            this._rows.add(rowIndex, this.createRow(rowIndex));
            ++rowIndex;
        }
        return this;
    }

    public Table insertColumn(int columnPos) {
        return this.insertColumn(columnPos, 1);
    }

    public Table insertColumn(int columnPos, int insertColumnCount) {
        if (columnPos < 0) {
            throw new IllegalArgumentException("ingalid columnPos: " + Integer.toString(columnPos));
        }
        if (this._rows.get(0).size() <= columnPos) {
            throw new IllegalArgumentException("ingalid columnPos: " + Integer.toString(columnPos) + " table columnsize: " + Integer.toString(this._rows.get(0).size()));
        }
        if (insertColumnCount < 1) {
            throw new IllegalArgumentException("ingalid insertColumnCount: " + Integer.toString(insertColumnCount));
        }
        StringBuilder cellName = new StringBuilder();
        StringBuilder newCellName = new StringBuilder();
        int rowIndex = 0;
        while (rowIndex < this._rows.size()) {
            int colIndex = this._rows.get(rowIndex).size() - 1;
            while (columnPos <= colIndex) {
                block8: {
                    cellName.delete(0, cellName.length());
                    newCellName.delete(0, newCellName.length());
                    cellName.append(this._name).append("R").append(rowIndex).append("C").append(colIndex);
                    newCellName.append(this._name).append("R").append(rowIndex).append("C").append(colIndex + insertColumnCount);
                    try {
                        this._sheet.renameCell(cellName.toString(), newCellName.toString());
                    }
                    catch (ReferenceNotFoundException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)("Cell not found: " + cellName.toString()));
                    }
                }
                --colIndex;
            }
            int i = 0;
            while (i < insertColumnCount) {
                String addCellName = String.valueOf(this._name) + "R" + Integer.toString(rowIndex) + "C" + Integer.toString(columnPos + i);
                Cell cell = this._sheet.addCell(addCellName, true);
                this._rows.get(rowIndex).add(columnPos + i, cell);
                ++i;
            }
            ++rowIndex;
        }
        return this;
    }

    public int rowSize() {
        return this._rows.size();
    }

    public int colSize() {
        return this._colSize;
    }

    public Range getRange() {
        return this.getRange("R0C0:RxCx");
    }

    public Range getRange(String range) throws IllegalArgumentException {
        this.validateRangeName(range);
        String rowFromStr = "";
        String colFromStr = "";
        String rowToStr = "";
        String colToStr = "";
        int rowFrom = 0;
        int colFrom = 0;
        int rowTo = 0;
        int colTo = 0;
        Matcher matcher = _RangeParsePattern.matcher(range);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                if (matcher.group(i) != null) {
                    tokens.add(matcher.group(i));
                }
                ++i;
            }
        }
        switch (tokens.size()) {
            case 2: {
                rowFromStr = ((String)tokens.get(0)).substring(1);
                colFromStr = ((String)tokens.get(1)).substring(1);
                if (rowFromStr.equals("x")) {
                    rowFrom = 0;
                    rowTo = this._rows.size() - 1;
                } else {
                    rowTo = rowFrom = Integer.parseInt(rowFromStr);
                }
                if (colFromStr.equals("x")) {
                    colFrom = 0;
                    colTo = this._colSize - 1;
                    break;
                }
                colTo = colFrom = Integer.parseInt(colFromStr);
                break;
            }
            case 5: {
                rowFromStr = ((String)tokens.get(0)).substring(1);
                colFromStr = ((String)tokens.get(1)).substring(1);
                rowToStr = ((String)tokens.get(3)).substring(1);
                colToStr = ((String)tokens.get(4)).substring(1);
                rowFrom = Integer.parseInt(rowFromStr);
                colFrom = Integer.parseInt(colFromStr);
                rowTo = rowToStr.equals("x") ? this._rows.size() - 1 : Integer.parseInt(rowToStr);
                if (colToStr.equals("x")) {
                    colTo = this._colSize - 1;
                    break;
                }
                colTo = Integer.parseInt(colToStr);
                break;
            }
            default: {
                assert (false) : "unknown range " + range;
                break;
            }
        }
        return new Range(this, rowFrom, colFrom, rowTo, colTo);
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this._rows.get(rowIndex).get(colIndex);
    }

    @Override
    public Collection<Cell> getCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>(this._rows.size() * this._rows.get(0).size());
        int i = 0;
        while (i < this._rows.size()) {
            int o = 0;
            while (o < this._rows.get(0).size()) {
                cells.add(this._rows.get(i).get(o));
                ++o;
            }
            ++i;
        }
        return cells;
    }
}

