/**
 *
 */
package jp.co.nissy.jpicosheet.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;

import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Element.ElementType;
import jp.co.nissy.jpicosheet.core.Element.ErrorType;

/**
 * @author yusuke nishikawa
 *
 */
public class Sum extends Function {

	/* (非 Javadoc)
	 * @see jp.co.nissy.jpicosheet.function.Function#call(jp.co.nissy.jpicosheet.core.Element[], java.math.MathContext)
	 */
	@Override
	public Element call(Element[] elements, MathContext mc, Resolver resolver) {

		// elementsの値の合計を返す
		BigDecimal result = BigDecimal.ZERO;
		for(Element elem: elements) {
			try {
				switch(elem.getType()) {
				case NUMBER:
					result = result.add(elem.getNumber(), mc);
					break;
				case GROUP_REFERENCE:
				case TABLE_REFERENCE:
					// Elementがグループ参照またはテーブル参照だった場合、参照に含まれるセルを取得の上、合算する
					Collection<Cell> collection = null;
					if (elem.getType() == ElementType.GROUP_REFERENCE) {
						collection = resolver.getCellsFromGroup(elem.getGroupReference());
					} else if (elem.getType() == ElementType.TABLE_REFERENCE) {
						collection = resolver.getCellsFromTable(elem.getTableReference());
					}
					for (Cell cell: collection) {
						result = result.add(cell.getValue().getNumber());
					}
				}
			} catch (ReferenceNotFoundException e) {
				return new Element(ElementType.ERROR, ErrorType.INVALID_REFERENCES);
			}
		}

		return new Element(ElementType.NUMBER, result);
	}

}
