/**
 *
 */
package jp.co.nissy.jpicosheet.function;

import java.math.BigDecimal;
import java.math.MathContext;

import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Element.ElementType;

/**
 * @author yusuke nishikawa
 *
 */
public class avg extends Function {

	/* (非 Javadoc)
	 * @see jp.co.nissy.jpicosheet.function.Function#call(jp.co.nissy.jpicosheet.core.Element[], java.math.MathContext)
	 */
	@Override
	public Element call(Element[] elements, MathContext mc, Resolver resolver) {
		// elementsの値の平均を返す
		BigDecimal result = BigDecimal.ZERO;
		for(Element e: elements) {
			result = result.add(e.getNumber(), mc).divide(new BigDecimal(elements.length), mc);
		}

		return new Element(ElementType.NUMBER, result);
	}

}
