package jp.co.nissy.jpicosheet.shell;

import java.math.BigDecimal;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;

public class HogeCacheShell {


	Book _book;
	Sheet _sheet;

	/**
	 * このブックのロックオブジェクト
	 */
	private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);


	public HogeCacheShell() {
		_book = new Book("HogeShellBook");
		_sheet = _book.addSheet("HogeSheet");

	}


	public void putString(String key, String valueStr) {
		_readWriteLock.writeLock().lock();
		try {
			_sheet.addCell(key).setStringValue(valueStr);
		} finally {
			_readWriteLock.writeLock().unlock();
		}
	}

	public String getString(String key) {
		_readWriteLock.readLock().lock();
		try {
			return _sheet.getCell(key).getString();
		} catch (ReferenceNotFoundException e) {
			return null;
		} finally {
			_readWriteLock.readLock().unlock();
		}
	}

	public void putNumber(String key, String numberStr) {
		_readWriteLock.writeLock().lock();
		try {
			_sheet.addCell(key).setNumberValue(numberStr);
		} finally {
			_readWriteLock.writeLock().unlock();
		}
	}

	public BigDecimal getNumber(String key) {
		_readWriteLock.readLock().lock();
		try {
			return _sheet.getCell(key).getValue().getNumber();
		} catch (ReferenceNotFoundException e) {
			return null;
		} finally {
			_readWriteLock.readLock().unlock();
		}
	}


}
