package jp.co.nissy.jpicosheet.shell;

import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;
import jp.co.nissy.jpicosheet.core.Cell.CellStatus;
import jp.co.nissy.jpicosheet.core.Cell.CellType;


/**
 * シェルという考え方を検証するために作成した、テスト用シェル
 * @author yusuke nishikawa
 *
 */
public class HogeShell {

	Book _book;
	Sheet _sheet;



	public HogeShell() {
		_book = new Book("HogeShellBook");
		_sheet = _book.addSheet("HogeSheet");

	}


	public void setCellFromText(String[] dataText) {

		for (String line: dataText) {
			String[] parsedLine = line.split("\\s");
			if (parsedLine[0].toUpperCase().equals("N")) {
				_sheet.addCell(parsedLine[1]).setNumberValue(parsedLine[2]);
			} else if (parsedLine[0].toUpperCase().equals("F")) {
				_sheet.addCell(parsedLine[1]).setFormula(parsedLine[2]);
			} else {
				System.out.println("invalid line: " + line);
			}
		}
	}


	public Element getCellValue(String cellName) throws ReferenceNotFoundException {
		return _sheet.getCell(cellName).getValue();
	}

	public CellStatus getCellStatus(String cellName) throws ReferenceNotFoundException {
		return _sheet.getCell(cellName).getStatus();
	}

	public CellType getCellType(String cellName) throws ReferenceNotFoundException {
		return _sheet.getCell(cellName).getCellType();
	}

}
