/**
 *
 */
package test;

import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;
import junit.framework.TestCase;

/**
 * @author yusuke nishikawa
 *
 */
public class BookTest extends TestCase {


	private Book book;
	private final String BOOK_NAME = "myBook";
	private final String INITIAL_SHEET_NAME = "mySheet";
	private final String NEW_SHEET_NAME = "newMySheet";

	/**
	 * @param name
	 */
	public BookTest(String name) {
		super(name);
	}

	/* (非 Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		this.book = new Book(BOOK_NAME);
		this.book.addSheet(INITIAL_SHEET_NAME);
	}

	/* (非 Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#Book(java.lang.String)} のためのテスト・メソッド。
	 */
	public void testBook() {

		try {
			new Book("newBook");
		} catch (Exception e) {
			fail("Bookのnewでエラー");
		}
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#getName()} のためのテスト・メソッド。
	 */
	public void testGetName() {
		assertEquals(BOOK_NAME, this.book.getName());
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#setName(java.lang.String)} のためのテスト・メソッド。
	 */
	public void testSetName() {
		this.book.setName(NEW_SHEET_NAME);
		assertEquals(NEW_SHEET_NAME, this.book.getName());
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#addSheet(java.lang.String)} のためのテスト・メソッド。
	 */
	public void testAddSheet() {

		Sheet newSheet;
		Sheet alreadyCreatedSheet;
		try {
			newSheet = this.book.addSheet(NEW_SHEET_NAME);
			// すでに存在するシート名でシートを作成した場合、既存のSheetオブジェクトが返される
			alreadyCreatedSheet = this.book.addSheet(NEW_SHEET_NAME);
			assertSame(newSheet, alreadyCreatedSheet);
		} catch (Exception e) {
			fail("シート作成時にエラー");
		}
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#renameSheet(java.lang.String, java.lang.String)} のためのテスト・メソッド。
	 * @throws Exception
	 */
	public void testRenameSheet() throws Exception {
		this.book.renameSheet(INITIAL_SHEET_NAME, NEW_SHEET_NAME);
		this.book.renameSheet(NEW_SHEET_NAME, INITIAL_SHEET_NAME);
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#deleteSheet(java.lang.String)} のためのテスト・メソッド。
	 * @throws Exception
	 */
	public void testDeleteSheet() throws Exception {
		String sheetName = "sheetForDelete";
		this.book.addSheet(sheetName);
		try {
			this.book.deleteSheet(sheetName);
		} catch (Exception e) {
			fail("シート削除でエラー");
		}
		try {
			this.book.sheet(sheetName);
		} catch (ReferenceNotFoundException e) {
			// OK
			return;
		}
		fail("シートが削除されていない");
	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#sheet(java.lang.String)} のためのテスト・メソッド。
	 */
	public void testSheet() {
		Sheet sheet = null;
		try {
			this.book.addSheet(INITIAL_SHEET_NAME);
			sheet = this.book.sheet(INITIAL_SHEET_NAME);
			assertNotNull(sheet);
		} catch (Exception e) {
			fail("シート取得でエラー");
		}

		try {
			// 存在しないシート名を指定した場合、例外が発生する
			this.book.sheet("asdfadsfasdf");
			fail("存在しないシート名を指定したのに例外が発生しなかった");
		} catch (Exception e) {
			// OK
		}


	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#recalcEnable()} のためのテスト・メソッド。
	 */
	public void testRecalcEnable() {
		try {
			this.book.recalcEnable();
		} catch (Exception e) {
			fail("再計算の有効化でエラー");
		}

	}

	/**
	 * {@link jp.co.nissy.jpicosheet.core.Book#recalcDisable()} のためのテスト・メソッド。
	 */
	public void testRecalcDisable() {
		try {
			this.book.recalcDisable();
		} catch (Exception e) {
			fail("再計算の無効化でエラー");
		}
	}



}
