package test;

import java.math.BigDecimal;

import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Cell.CellStatus;
import jp.co.nissy.jpicosheet.core.Cell.CellType;
import jp.co.nissy.jpicosheet.shell.HogeShell;
import junit.framework.TestCase;

public class HogeShellTest extends TestCase {

	public void testHogeShell() {
		HogeShell hogeShell = new HogeShell();
	}

	public void testSetCellFromText() {
		HogeShell hogeShell = new HogeShell();
		String[] textArray = "n	hoge	1".split("\n");
		hogeShell.setCellFromText(textArray);
		textArray = "n	hoge	1\nn	fuga	10\n".split("\n");
		hogeShell.setCellFromText(textArray);
		textArray = "n	hoge	1\nn	fuga	10\nf	plusit	hoge+fuga".split("\n");
		hogeShell.setCellFromText(textArray);
	}

	public void testGetCellValue() {
		HogeShell hogeShell = new HogeShell();
		String[] textArray = "n	hoge	1".split("\n");
		hogeShell.setCellFromText(textArray);
		try {
			Element elem = hogeShell.getCellValue("hoge");
		} catch (ReferenceNotFoundException e) {
			fail();
		}
	}

	public void testGetCellStatus() {
		HogeShell hogeShell = new HogeShell();
		String[] textArray = "n	hoge	1".split("\n");
		hogeShell.setCellFromText(textArray);
		try {
			CellStatus cellStat = hogeShell.getCellStatus("hoge");
		} catch (ReferenceNotFoundException e) {
			fail();
		}
	}

	public void testGetCellType() {
		HogeShell hogeShell = new HogeShell();
		String[] textArray = "n	hoge	1".split("\n");
		hogeShell.setCellFromText(textArray);
		try {
			CellType cellType = hogeShell.getCellType("hoge");
		} catch (ReferenceNotFoundException e) {
			fail();
		}
	}


	public void testCalc() {
		HogeShell hogeShell = new HogeShell();

		String[] textArray = "n	hoge	1\nn	fuga	10\nf	plusit	hoge+fuga\nf	minusit	hoge-fuga\nf	multiit	hoge*fuga\nf	divit	hoge/fuga\n".split("\n");
		hogeShell.setCellFromText(textArray);

		try {
			Element elem = hogeShell.getCellValue("plusit");
			assertEquals(elem.getNumber(), new BigDecimal(1+10));
		} catch (ReferenceNotFoundException e) {
			fail();
		}


		String text ="n	A1	1\n" +
			"n	A1	1\n" +
			"n	A2	2\n" +
			"n	A3	3\n" +
			"n	A4	4\n" +
			"n	A5	5\n" +
			"f	A6	sum(A1,A2,A3,A4,A5)\n";
		textArray = text.split("\\n");

		hogeShell.setCellFromText(textArray);

		try {
			Element elem = hogeShell.getCellValue("A6");
			assertEquals(elem.getNumber(), new BigDecimal(15));
		} catch (ReferenceNotFoundException e) {
			fail();
		}

	}

}
