package test;

import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Range;
import jp.co.nissy.jpicosheet.core.Sheet;
import jp.co.nissy.jpicosheet.core.Table;
import junit.framework.TestCase;



public class RangeTest extends TestCase {

Book book;
Sheet sheet;
Table table;


	protected void setUp() throws Exception {
		super.setUp();
		book= new Book("myBook");
		sheet = book.addSheet("mySheet");
		table = sheet.addTable("myTable#", 10, 10);

		for (int i = 0; i < table.rowSize(); i++) {
			for (int o = 0; o < table.colSize(); o++) {
				sheet.getTable("myTable#").getCell(i, o)
					.setStringValue("R" + Integer.toString(i) + "C" + Integer.toString(o));
			}
		}
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}



	public void testGetCell() {
		Range range = table.getRange("R0C0:R4C4");

		assertEquals("R0C0", range.getCell(0,0).getString());
		assertEquals("R1C1", range.getCell(1,1).getString());
		assertEquals("R4C4", range.getCell(4,4).getString());
	}



}
