/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.ArrayList;
import java.util.Collection;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.CellGroupReference;
import jp.co.nissy.jpicosheet.core.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements CellGroupReference {
    private Table _table;
    private int _offsetRowFrom;
    private int _offsetRowTo;
    private int _offsetColFrom;
    private int _offsetColTo;

    Range(Table table, int rowNumFrom, int colNumFrom, int rowNumTo, int colNumTo) {
        if (table == null) {
            throw new NullPointerException("table is null.");
        }
        this._table = table;
        if (rowNumFrom < 0 || colNumFrom < 0 || rowNumTo < rowNumFrom || colNumTo < colNumFrom) {
            throw new IllegalArgumentException("ingalid row/col parameter. rowNumFrom=" + Integer.toString(rowNumFrom) + " colNumFrom=" + Integer.toString(colNumFrom) + " rowNumTo=" + Integer.toString(rowNumTo) + " colNumTo=" + Integer.toString(colNumTo));
        }
        this._offsetRowFrom = rowNumFrom;
        this._offsetColFrom = colNumFrom;
        this._offsetRowTo = rowNumTo;
        this._offsetColTo = colNumTo;
    }

    public Cell getCell(int rowPos, int colPos) {
        return this._table.getCell(this._offsetRowFrom + rowPos, this._offsetColFrom + colPos);
    }

    public Cell[] getRow(int rowPos) {
        Cell[] cells = new Cell[this._offsetColTo - this._offsetColFrom + 1];
        int i = 0;
        while (i < cells.length) {
            cells[i] = this._table.getCell(this._offsetRowFrom + rowPos, this._offsetColFrom + i);
            ++i;
        }
        return cells;
    }

    public Cell[] getCol(int colPos) {
        Cell[] cols = new Cell[this._offsetRowTo - this._offsetRowFrom + 1];
        int i = 0;
        while (i < cols.length) {
            cols[i] = this._table.getCell(this._offsetRowFrom + i, this._offsetColFrom + colPos);
            ++i;
        }
        return cols;
    }

    @Override
    public Collection<Cell> getCells() {
        int rowSize = this._offsetRowTo - this._offsetRowFrom + 1;
        int colSize = this._offsetColTo - this._offsetColFrom + 1;
        ArrayList<Cell> cells = new ArrayList<Cell>(rowSize * colSize);
        int i = 0;
        while (i < rowSize) {
            int o = 0;
            while (o < colSize) {
                cells.add(this._table.getCell(this._offsetRowFrom + i, this._offsetColFrom + o));
                ++o;
            }
            ++i;
        }
        return cells;
    }

    public int getRowSize() {
        return this._offsetRowTo - this._offsetRowFrom + 1;
    }

    public int getColSize() {
        return this._offsetColTo - this._offsetColFrom + 1;
    }
}

