/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Group;
import jp.co.nissy.jpicosheet.core.Range;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Sheet;
import jp.co.nissy.jpicosheet.core.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver {
    private Book _book;
    private Sheet _defaultSheet;
    private Map<String, Set<Cell>> _references;

    private Resolver() {
    }

    Resolver(Book book) {
        this._book = book;
        this._references = new HashMap<String, Set<Cell>>();
    }

    public void setDefaultSheet(Sheet defaultSheet) {
        this._defaultSheet = defaultSheet;
    }

    public Sheet getDefaultSheet() {
        return this._defaultSheet;
    }

    String getFullyQualifiedName(Sheet sheet, String name) {
        if (this.isFullyQualifiedName(name)) {
            return name;
        }
        return String.valueOf(sheet.getName()) + "!" + name;
    }

    boolean isFullyQualifiedName(String name) {
        return name.contains("!");
    }

    String getSheetNameFromFullyQualifiedName(String fullyQualifiedName) {
        if (this.isFullyQualifiedName(fullyQualifiedName)) {
            return fullyQualifiedName.substring(0, fullyQualifiedName.indexOf("!"));
        }
        throw new IllegalArgumentException(String.valueOf(fullyQualifiedName) + " is not FullyQualifiedName.");
    }

    public boolean cellExists(String cellName) {
        if (cellName.contains("!")) {
            String[] sheetCell = cellName.split("!");
            return this._book.getSheet(sheetCell[0]).cellExists(cellName);
        }
        return this._defaultSheet.cellExists(cellName);
    }

    public Cell getCell(String cellName) {
        if (cellName.contains("!")) {
            String[] sheetCell = cellName.split("!");
            return this._book.getSheet(sheetCell[0]).getCell(sheetCell[1]);
        }
        return this._defaultSheet.getCell(cellName);
    }

    public Collection<Cell> getCellsFromGroup(String groupName) {
        String targetGroup;
        Sheet targetSheet;
        if (groupName.contains("!")) {
            String[] sheetGroup = groupName.split("!");
            targetSheet = this._book.getSheet(sheetGroup[0]);
            targetGroup = sheetGroup[1];
        } else {
            targetSheet = this._defaultSheet;
            targetGroup = groupName;
        }
        return targetSheet.getGroup(targetGroup).getCells();
    }

    public Collection<Cell> getCellsFromTable(String tableName) {
        String targetTable;
        Sheet targetSheet;
        if (tableName.contains("!")) {
            String[] sheetTable = tableName.split("!");
            targetSheet = this._book.getSheet(sheetTable[0]);
            targetTable = sheetTable[1];
        } else {
            targetSheet = this._defaultSheet;
            targetTable = tableName;
        }
        int p = targetTable.indexOf(35);
        if (p > 0 && p != targetTable.length() - 1) {
            Range range = targetSheet.getTable(targetTable.substring(0, p + 1)).getRange(targetTable.substring(p + 1));
            return range.getCells();
        }
        return targetSheet.getTable(targetTable).getCells();
    }

    void registReferences(Cell referenceCell, String referencesCellName) {
        String fqn = this.getFullyQualifiedName(referenceCell.getSheet(), referencesCellName);
        if (!this._references.containsKey(fqn)) {
            this._references.put(fqn, new HashSet());
        }
        this._references.get(fqn).add(referenceCell);
    }

    void removeReferences(Cell referenceCell, String referencesCellName) {
        String fqn = this.getFullyQualifiedName(referenceCell.getSheet(), referencesCellName);
        if (this._references.containsKey(fqn)) {
            this._references.get(fqn).remove(referenceCell);
            if (this._references.get(fqn).size() == 0) {
                this._references.remove(fqn);
            }
        }
    }

    Set<Cell> getReferencingCells(Cell referenceCell) {
        HashSet<Cell> returnCell = new HashSet<Cell>();
        this.getReferencingCellsRecursive(referenceCell, returnCell);
        return returnCell;
    }

    private void getReferencingCellsRecursive(Cell cell, Set<Cell> referencingCells) {
        Set<Cell> set = this._references.get(cell.getFullyQualifiedName());
        if (set == null) {
            return;
        }
        for (Cell refCell : set) {
            if (referencingCells.contains(refCell)) continue;
            referencingCells.add(refCell);
            this.getReferencingCellsRecursive(refCell, referencingCells);
        }
    }

    Set<Cell> getReferencingCells(Group referenceGroup) {
        HashSet<Cell> returnCell = new HashSet<Cell>();
        String groupFqn = referenceGroup.getFullyQualifiedName();
        if (this._references.containsKey(groupFqn)) {
            returnCell.addAll((Collection<Cell>)this._references.get(groupFqn));
            return returnCell;
        }
        return returnCell;
    }

    public boolean groupExists(String groupName) {
        if (groupName.contains("!")) {
            String[] sheetCell = groupName.split("!");
            return this._book.getSheet(sheetCell[0]).cellExists(groupName);
        }
        return this._defaultSheet.cellExists(groupName);
    }

    public Group getGroup(String groupName) {
        if (groupName.contains("!")) {
            String[] sheetGroup = groupName.split("!");
            return this._book.getSheet(sheetGroup[0]).getGroup(sheetGroup[1]);
        }
        return this._defaultSheet.getGroup(groupName);
    }

    void registGroupReferences(Cell cell, String referenceGroupName) {
        String fqn = this.getFullyQualifiedName(cell.getSheet(), referenceGroupName);
        this.registReferences(cell, fqn);
        Group group = null;
        try {
            group = cell.getSheet().getGroup(fqn);
        }
        catch (ReferenceNotFoundException e) {
            return;
        }
        for (Cell memberCell : group.getCells()) {
            this.registReferences(cell, memberCell.getFullyQualifiedName());
        }
    }

    Set<Cell> getReferencingCells(Table referenceTable) {
        HashSet<Cell> returnCell = new HashSet<Cell>();
        String tableFql = referenceTable.getFullyQualifiedName();
        if (this._references.containsKey(tableFql)) {
            returnCell.addAll((Collection<Cell>)this._references.get(tableFql));
            return returnCell;
        }
        return returnCell;
    }

    public boolean tableExists(String tableName) {
        if (tableName.contains("!")) {
            String[] sheetCell = tableName.split("!");
            return this._book.getSheet(sheetCell[0]).cellExists(tableName);
        }
        return this._defaultSheet.cellExists(tableName);
    }

    public Table getTable(String tableName) {
        if (tableName.contains("!")) {
            String[] sheetTable = tableName.split("!");
            return this._book.getSheet(sheetTable[0]).getTable(sheetTable[1]);
        }
        return this._defaultSheet.getTable(tableName);
    }

    void registTableReferences(Cell cell, String referenceTableName) {
        String[] splitFqn = this.getFullyQualifiedName(cell.getSheet(), referenceTableName).split("#");
        String fqn = String.valueOf(splitFqn[0]) + "#";
        String range = null;
        if (splitFqn.length == 2) {
            range = splitFqn[1];
        }
        this.registReferences(cell, fqn);
        Table table = null;
        try {
            table = cell.getSheet().getTable(fqn);
        }
        catch (ReferenceNotFoundException e) {
            return;
        }
        Collection<Cell> collection = range == null ? table.getCells() : table.getRange(range).getCells();
        for (Cell memberCell : collection) {
            this.registReferences(cell, memberCell.getFullyQualifiedName());
        }
    }
}

