/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.core;

import com.nissy_ki_chi.jpicosheet.core.Calculator;
import com.nissy_ki_chi.jpicosheet.core.FunctionFactory;
import com.nissy_ki_chi.jpicosheet.core.ReferenceNotFoundException;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book {
    private String _name;
    private Calculator _calculator;
    private Resolver _resolver;
    private HashMap<String, Sheet> _sheets = new HashMap();
    private FunctionFactory _functionFactory;
    static final String BOOK_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _bookNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private Book() {
    }

    public Book(String bookName) throws IllegalArgumentException {
        this.validateBookName(bookName);
        this._name = bookName;
        this._calculator = new Calculator(this);
        this._resolver = new Resolver(this);
        this._functionFactory = new FunctionFactory();
        this._functionFactory.loadBuiltinFunctions();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String bookName) {
        this.validateBookName(bookName);
        this._name = bookName;
    }

    Calculator getCalculator() {
        return this._calculator;
    }

    public Resolver getResolver() {
        return this._resolver;
    }

    FunctionFactory getFunctionFactory() {
        return this._functionFactory;
    }

    public Sheet addSheet(String sheetName) {
        if (this._sheets.containsKey(sheetName)) {
            return this._sheets.get(sheetName);
        }
        Sheet sheet = new Sheet(sheetName, this);
        this._sheets.put(sheetName, sheet);
        if (this._resolver.getDefaultSheet() == null) {
            this._resolver.setDefaultSheet(sheet);
        }
        return sheet;
    }

    public List<Sheet> getSheets() {
        return new ArrayList<Sheet>(this._sheets.values());
    }

    public void renameSheet(String sheetName, String newSheetName) {
        if (!this._sheets.containsKey(sheetName)) {
            throw new ReferenceNotFoundException("no such sheet " + sheetName);
        }
        Sheet sheet = this._sheets.get(sheetName);
        sheet.setName(newSheetName);
        this._sheets.put(newSheetName, this._sheets.get(sheetName));
        this._sheets.remove(sheetName);
    }

    public void deleteSheet(String sheetName) {
        if (this._sheets.containsKey(sheetName)) {
            this._sheets.remove(sheetName);
            if (this._resolver.getDefaultSheet().getName().equals(sheetName)) {
                this._resolver.setDefaultSheet(null);
            }
        } else {
            throw new ReferenceNotFoundException("no such sheet " + sheetName);
        }
    }

    public Sheet getSheet(String sheetName) {
        if (this._sheets.containsKey(sheetName)) {
            return this._sheets.get(sheetName);
        }
        throw new ReferenceNotFoundException("no such sheet " + sheetName);
    }

    public void recalcEnable() {
        this._calculator.recalcEnable();
    }

    public void recalcDisable() {
        this._calculator.recalcDisable();
    }

    public boolean isRecalcEnable() {
        return this._calculator.isRecalcEnable();
    }

    public String[] getFunctionNames() {
        return this._functionFactory.getFunctionNmes();
    }

    private void validateBookName(String bookName) throws IllegalArgumentException {
        if (!Book.isValidBookName(bookName)) {
            throw new IllegalArgumentException("invalid book name \"" + bookName + "\"");
        }
    }

    public static boolean isValidBookName(String bookName) {
        return _bookNamePattern.matcher(bookName).matches();
    }
}

