/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.core;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Element;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import java.math.MathContext;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentBookWrapper {
    private static final String DEFAULT_SHEET_NAME = "Sheet1";
    private Book _book;
    private ReentrantReadWriteLock.ReadLock _readLock;
    private ReentrantReadWriteLock.WriteLock _writeLock;

    private ConcurrentBookWrapper() {
    }

    public ConcurrentBookWrapper(Book book) {
        this._book = book;
        if (this._book.getResolver().getDefaultSheet() == null) {
            this._book.addSheet(DEFAULT_SHEET_NAME);
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this._readLock = lock.readLock();
        this._writeLock = lock.writeLock();
    }

    public void setBookName(String bookName) {
        try {
            this._writeLock.lock();
            this._book.setName(bookName);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public String getBookName() {
        try {
            this._readLock.lock();
            String string = this._book.getName();
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void addSheet(String sheetName) {
        try {
            this._writeLock.lock();
            this._book.addSheet(sheetName);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void deleteSheet(String sheetName) {
        try {
            this._writeLock.lock();
            this._book.deleteSheet(sheetName);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void renameSheet(String sheetName, String newSheetName) {
        try {
            this._writeLock.lock();
            this._book.renameSheet(sheetName, newSheetName);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void setMathContext(String sheetName, MathContext mc) {
        try {
            this._writeLock.lock();
            this._book.getSheet(sheetName).setMathContext(mc);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public MathContext getMathContext(String sheetName) {
        try {
            this._readLock.lock();
            MathContext mathContext = this._book.getSheet(sheetName).getMathContext();
            return mathContext;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void setCellValue(String cellName, String value) {
        try {
            this._writeLock.lock();
            this.addCell(cellName);
            this._book.getResolver().getCell(cellName).setValue(value);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public Element getCellValue(String cellName) {
        try {
            this._readLock.lock();
            Element element = this._book.getResolver().getCell(cellName).getValue();
            return element;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public String getCellFormula(String cellName) {
        try {
            this._readLock.lock();
            String string = this._book.getResolver().getCell(cellName).getFormula();
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void addCell(String cellName) {
        try {
            String sheetName;
            this._writeLock.lock();
            Resolver resolver = this._book.getResolver();
            try {
                sheetName = resolver.getSheetNameFromFullyQualifiedName(cellName);
            }
            catch (Exception e) {
                sheetName = resolver.getDefaultSheet().getName();
            }
            this.addSheet(sheetName);
            this._book.getSheet(sheetName).addCell(cellName);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void deleteCell(String cellName) {
        try {
            this._writeLock.lock();
            Resolver resolver = this._book.getResolver();
            if (resolver.cellExists(cellName)) {
                resolver.getCell(cellName).getSheet().deleteCell(cellName);
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void renameCell(String cellName, String newCellName) {
        try {
            this._writeLock.lock();
            Resolver resolver = this._book.getResolver();
            if (resolver.cellExists(cellName)) {
                resolver.getCell(cellName).getSheet().renameCell(cellName, newCellName);
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void setCellLabel(String cellName, String label) {
        try {
            this._writeLock.lock();
            this.addCell(cellName);
            this._book.getResolver().getCell(cellName).setLabel(label);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public String getCellLabel(String cellName) {
        try {
            this._readLock.lock();
            String string = this._book.getResolver().getCell(cellName).getLabel();
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        this._writeLock.lock();
        return this._writeLock;
    }

    public void releaseWriteLock() {
        this._writeLock.unlock();
    }

    public Book getBook(ReentrantReadWriteLock.WriteLock writeLock) {
        if (writeLock == null || writeLock != this._writeLock) {
            throw new IllegalArgumentException("invalid WriteLock Object");
        }
        return this._book;
    }
}

