/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.core;

import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.Group;
import com.nissy_ki_chi.jpicosheet.core.Table;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;

public class Element {
    private static Map<Element, Element> _elementCache = new WeakHashMap<Element, Element>();
    private final ElementType _type;
    private final Object _value;
    private int _hashCode = 0;
    static final String DEFAULT_DATETIME_FORMAT_STRING = "yyyy/MM/dd HH:mm:ss";
    static final SimpleDateFormat DEFAULT_DATETIME_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static final SimpleDateFormat[] READABLE_DATETIME_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), DEFAULT_DATETIME_FORMAT, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy/MM/dd HH"), new SimpleDateFormat("yyyy-MM-dd HH"), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("HH:mm:ss.SSS"), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm")};

    private static final Element getElementFromCashe(Element newElem) {
        if (!_elementCache.containsKey(newElem)) {
            _elementCache.put(newElem, newElem);
        }
        return _elementCache.get(newElem);
    }

    public static synchronized Element newElement(ElementType elementType, Object value) {
        Element newElem = new Element(elementType, value);
        return Element.getElementFromCashe(newElem);
    }

    private Element(ElementType elementType, Object value) {
        this._type = elementType;
        switch (elementType) {
            case EMPTY: {
                this._value = null;
                break;
            }
            case NUMBER: {
                if (value instanceof BigDecimal) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("NUMBER\u306e\u5834\u5408\u3001BigDecimal\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case STRING: {
                if (value instanceof String) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("STRING\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case DATE: {
                if (value instanceof Long) {
                    this._value = value;
                    break;
                }
                if (value instanceof BigDecimal) {
                    this._value = new Long(((BigDecimal)value).longValue());
                    break;
                }
                throw new IllegalArgumentException("DATE\u306e\u5834\u5408\u3001Long\u578b\u3082\u3057\u304f\u306fBigDecimal\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    this._value = value;
                    break;
                }
                if (value instanceof String) {
                    String valueStr = ((String)value).toUpperCase();
                    if (valueStr.equals("TRUE")) {
                        this._value = new Boolean(true);
                        break;
                    }
                    if (valueStr.equals("FALSE")) {
                        this._value = new Boolean(false);
                        break;
                    }
                    throw new IllegalArgumentException("BOOLEAN\u306e\u5834\u5408\u3001Boolean\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3042\u308b\u3044\u306f\"TRUE\"\"FALSE\"\u304c\u5fc5\u8981");
                }
                throw new IllegalArgumentException("BOOLEAN\u306e\u5834\u5408\u3001Boolean\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3042\u308b\u3044\u306f\"TRUE\"\"FALSE\"\u304c\u5fc5\u8981");
            }
            case ERROR: {
                if (value instanceof ErrorType) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("ERROR\u306e\u5834\u5408\u3001ErrorType\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case FUNCTION: {
                if (value instanceof String) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("FUNCTION\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case OPERATOR: {
                if (value instanceof Operator) {
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("OPERATOR\u306e\u5834\u5408\u3001\u5217\u6319\u578b Operator\u304c\u5fc5\u8981");
            }
            case REFERENCE: {
                if (value instanceof String) {
                    if (!(Table.isValidTableNameWithAddress((String)value) || Table.isValidFullyQualifiedTableNameWithAddress((String)value) || Cell.isValidCellName((String)value) || Cell.isValidFullyQualifiedCellName((String)value))) {
                        throw new IllegalArgumentException("\u4e0d\u9069\u5207\u306a\u30bb\u30eb\u540d:" + (String)value);
                    }
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("Reference\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case GROUP_REFERENCE: {
                if (value instanceof String) {
                    if (!(Group.isValidGroupName((String)value) || Group.isValidFullyQualifiedGroupName((String)value) || Table.isValidTableName((String)value) || Table.isValidFullyQualifiedTableName((String)value))) {
                        throw new IllegalArgumentException("\u4e0d\u9069\u5207\u306a\u30b0\u30eb\u30fc\u30d7\u540d:" + (String)value);
                    }
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("GroupReference\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            case TABLE_REFERENCE: {
                if (value instanceof String) {
                    if (!(Table.isValidTableName((String)value) || Table.isValidFullyQualifiedTableName((String)value) || Table.isValidTableNameWithRange((String)value) || Table.isValidFullyQualifiedTableNameWithRange((String)value))) {
                        throw new IllegalArgumentException("\u4e0d\u9069\u5207\u306a\u30c6\u30fc\u30d6\u30eb\u540d:" + (String)value);
                    }
                    this._value = value;
                    break;
                }
                throw new IllegalArgumentException("TableReference\u306e\u5834\u5408\u3001String\u578b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5fc5\u8981");
            }
            default: {
                throw new IllegalArgumentException("invalid element type: " + (Object)((Object)this._type));
            }
        }
        this._hashCode = this.makeHashCode();
    }

    public static Element newElement(ElementType tokenType) {
        Element newElem = new Element(tokenType);
        return Element.getElementFromCashe(newElem);
    }

    private Element(ElementType tokenType) {
        this._type = tokenType;
        switch (tokenType) {
            case EMPTY: {
                this._value = null;
                break;
            }
            case NUMBER: {
                this._value = new BigDecimal("0");
                break;
            }
            case STRING: {
                this._value = "";
                break;
            }
            case DATE: {
                this._value = new Long(0L);
                break;
            }
            case BOOLEAN: {
                this._value = new Boolean(false);
            }
            case ERROR: {
                throw new IllegalArgumentException("Error\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case OPERATOR: {
                throw new IllegalArgumentException("Operator\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case REFERENCE: {
                throw new IllegalArgumentException("Reference\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            case GROUP_REFERENCE: {
                throw new IllegalArgumentException("GroupReference\u306e\u5834\u5408\u3001value\u306e\u6307\u5b9a\u304c\u5fc5\u8981");
            }
            default: {
                this._value = null;
            }
        }
    }

    public ElementType getType() {
        return this._type;
    }

    Object getValue() {
        return this._value;
    }

    public boolean hasNumberValue() {
        switch (this._type) {
            case EMPTY: 
            case NUMBER: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public ErrorType getErrorType() throws IllegalStateException {
        if (this._type != ElementType.ERROR) {
            throw new IllegalStateException("Element type is not ERROR.");
        }
        return (ErrorType)((Object)this._value);
    }

    String getCellReference() throws IllegalStateException {
        switch (this._type) {
            case REFERENCE: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not CellReference");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    String getGroupReference() {
        switch (this._type) {
            case GROUP_REFERENCE: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not GROUP_REFERENCE");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    String getTableReference() {
        switch (this._type) {
            case TABLE_REFERENCE: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not TABLE_REFERENCE");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    Operator getOperator() throws IllegalStateException {
        switch (this._type) {
            case OPERATOR: {
                if (this._value instanceof Operator) {
                    return (Operator)((Object)this._value);
                }
                throw new IllegalStateException("value is not OPERATOR");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public BigDecimal getNumber() throws IllegalStateException {
        switch (this._type) {
            case EMPTY: {
                return BigDecimal.ZERO;
            }
            case NUMBER: {
                if (this._value instanceof BigDecimal) {
                    return (BigDecimal)this._value;
                }
                throw new IllegalStateException("value is not number");
            }
            case BOOLEAN: {
                return (Boolean)this._value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case DATE: {
                return new BigDecimal((Long)this._value);
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public String getString() throws IllegalStateException {
        switch (this._type) {
            case EMPTY: {
                return "";
            }
            case STRING: 
            case FUNCTION: {
                if (this._value instanceof String) {
                    return (String)this._value;
                }
                throw new IllegalStateException("value is not STRING");
            }
            case DATE: {
                return DEFAULT_DATETIME_FORMAT.format(new Date((Long)this._value - (long)TimeZone.getDefault().getRawOffset()));
            }
            case NUMBER: 
            case BOOLEAN: 
            case ERROR: 
            case OPERATOR: 
            case REFERENCE: 
            case GROUP_REFERENCE: 
            case TABLE_REFERENCE: {
                return this._value.toString();
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public Boolean getBoolean() throws IllegalStateException {
        switch (this._type) {
            case BOOLEAN: {
                return (boolean)((Boolean)this._value);
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    public Date getDate() throws IllegalStateException {
        switch (this._type) {
            case EMPTY: {
                return new Date(0L);
            }
            case DATE: {
                if (this._value instanceof Long) {
                    return new Date((Long)this._value - (long)TimeZone.getDefault().getRawOffset());
                }
                throw new IllegalStateException("value is not Long");
            }
        }
        throw new IllegalStateException("invalid element type: " + (Object)((Object)this._type));
    }

    boolean isInnerElement() {
        switch (this.getType()) {
            case EMPTY: 
            case NUMBER: 
            case STRING: 
            case DATE: 
            case BOOLEAN: 
            case ERROR: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        switch (this._type) {
            case EMPTY: {
                return "";
            }
            case DATE: {
                return String.valueOf(this._type.toString()) + ":" + this.getString();
            }
        }
        return String.valueOf(this._type.toString()) + ":" + this._value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Element) {
            Element target = (Element)obj;
            if (target.getType() != this._type) {
                return false;
            }
            switch (target.getType()) {
                case EMPTY: {
                    return this._type == ElementType.EMPTY;
                }
                case BOOLEAN: {
                    return target.getBoolean().equals(this._value);
                }
                case NUMBER: {
                    return target.getNumber().equals(this._value);
                }
                case OPERATOR: {
                    return target.getOperator().equals(this._value);
                }
                case DATE: {
                    return target.getNumber().longValue() == ((Long)this._value).longValue();
                }
                case ERROR: {
                    return target.getErrorType().equals(this._value);
                }
                case STRING: 
                case FUNCTION: 
                case REFERENCE: 
                case GROUP_REFERENCE: 
                case TABLE_REFERENCE: {
                    return target.getString().equals(this._value);
                }
            }
            assert (false) : "invalid element type: " + (Object)((Object)this._type);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    private int makeHashCode() {
        int typeHash = this._type.hashCode();
        int valueHash = 0;
        switch (this._type) {
            case EMPTY: {
                break;
            }
            case BOOLEAN: {
                valueHash = ((Boolean)this._value).hashCode();
                break;
            }
            case NUMBER: {
                valueHash = ((BigDecimal)this._value).hashCode();
                break;
            }
            case OPERATOR: {
                valueHash = ((Operator)((Object)this._value)).hashCode();
                break;
            }
            case DATE: {
                valueHash = ((Long)this._value).hashCode();
                break;
            }
            case ERROR: {
                valueHash = ((ErrorType)((Object)this._value)).hashCode();
                break;
            }
            case STRING: 
            case FUNCTION: 
            case REFERENCE: 
            case GROUP_REFERENCE: 
            case TABLE_REFERENCE: {
                valueHash = ((String)this._value).hashCode();
                break;
            }
            default: {
                assert (false) : "invalid element type: " + (Object)((Object)this._type);
                break;
            }
        }
        int result = 17;
        result = 31 * result + typeHash;
        result = 31 * result + valueHash;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        EMPTY,
        NUMBER,
        STRING,
        DATE,
        BOOLEAN,
        ERROR,
        OPERATOR,
        FUNCTION,
        REFERENCE,
        GROUP_REFERENCE,
        TABLE_REFERENCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        DIVIDE_BY_ZERO,
        WRONG_VALUE,
        INVALID_REFERENCES,
        INVALID_FORMULA,
        UNRECOGNIZED_NAME,
        INVALID_NUMBER,
        NOT_AVAILABLE_VALUE,
        CIRCULER_REFERENCE,
        INVALID_PARAMETER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        USE_LAST_RVALUE(-1, 3),
        COMMA(0, 3),
        LEFT_PARENTHESIS(0, 3),
        RIGHT_PARENTHESIS(0, 3),
        PLUS(2, 1),
        MINUS(2, 1),
        TIMES(3, 1),
        DIVIDE(3, 1),
        POWER(3, 1),
        UNARY_PLUS(4, 1),
        UNARY_MINUS(4, 1),
        LESS_THAN(1, 0),
        LESS_EQUAL(1, 0),
        EQUALS(1, 0),
        NOT_EQUALS(1, 0),
        GRATER_EQUAL(1, 0),
        GRATOR_THAN(1, 0),
        CONCATENATE(0, 2);

        static final int OPTYPE_COMPARISON = 0;
        static final int OPTYPE_ARITHMETIC = 1;
        static final int OPTYPE_STRING = 2;
        static final int OPTYPE_OTHER = 3;
        private int _priority;
        private int _opType;

        private Operator(int priority, int opType) {
            this._priority = priority;
            this._opType = opType;
        }

        public int evalPriority(Operator arg1) {
            return this._priority - arg1._priority;
        }

        public boolean isComparisonOperator() {
            return this._opType == 0;
        }

        public boolean isArithmeticOperator() {
            return this._opType == 1;
        }

        public boolean isStringOperator() {
            return this._opType == 2;
        }

        public boolean isOtherOperator() {
            return this._opType == 3;
        }
    }
}

