/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.util;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.ReferenceNotFoundException;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import java.math.BigDecimal;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HogeCacheShell {
    Book _book;
    Sheet _sheet;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);

    public HogeCacheShell() {
        this._book = new Book("HogeShellBook");
        this._sheet = this._book.addSheet("HogeSheet");
    }

    public void putString(String key, String valueStr) {
        this._readWriteLock.writeLock().lock();
        try {
            this._sheet.addCell(key).setStringValue(valueStr);
        }
        finally {
            this._readWriteLock.writeLock().unlock();
        }
    }

    public String getString(String key) {
        this._readWriteLock.readLock().lock();
        try {
            String string = this._sheet.getCell(key).getValueString();
            return string;
        }
        catch (ReferenceNotFoundException e) {
            return null;
        }
        finally {
            this._readWriteLock.readLock().unlock();
        }
    }

    public void putNumber(String key, String numberStr) {
        this._readWriteLock.writeLock().lock();
        try {
            this._sheet.addCell(key).setNumberValue(numberStr);
        }
        finally {
            this._readWriteLock.writeLock().unlock();
        }
    }

    public BigDecimal getNumber(String key) {
        this._readWriteLock.readLock().lock();
        try {
            BigDecimal bigDecimal = this._sheet.getCell(key).getValue().getNumber();
            return bigDecimal;
        }
        catch (ReferenceNotFoundException e) {
            return null;
        }
        finally {
            this._readWriteLock.readLock().unlock();
        }
    }
}

