/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.util;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.Group;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import com.nissy_ki_chi.jpicosheet.core.Table;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriter {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSS");

    public Document write(Book book) throws Exception {
        if (book == null) {
            throw new NullPointerException();
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        Element bookElem = document.createElement("book");
        bookElem.setAttribute("name", book.getName());
        document.appendChild(bookElem);
        Object[] sortedSheets = book.getSheets().toArray(new Sheet[0]);
        Arrays.sort(sortedSheets);
        Object[] objectArray = sortedSheets;
        int n = sortedSheets.length;
        int n2 = 0;
        while (n2 < n) {
            Object sheet = objectArray[n2];
            Element sheetElem = document.createElement("sheet");
            sheetElem.setAttribute("name", ((Sheet)sheet).getName());
            sheetElem.setAttribute("precision", Integer.toString(((Sheet)sheet).getMathContext().getPrecision()));
            sheetElem.setAttribute("roundingMode", ((Sheet)sheet).getMathContext().getRoundingMode().toString());
            bookElem.appendChild(sheetElem);
            Object[] sortedCells = ((Sheet)sheet).getCells().toArray(new Cell[0]);
            Arrays.sort(sortedCells);
            Object[] objectArray2 = sortedCells;
            int n3 = sortedCells.length;
            int n4 = 0;
            while (n4 < n3) {
                Object cell = objectArray2[n4];
                if (!Table.isValidTableNameWithAddress(((Cell)cell).getName())) {
                    Element cellElem = document.createElement("cell");
                    cellElem.setAttribute("name", ((Cell)cell).getName());
                    this.setCellElement(document, cellElem, (Cell)cell);
                    sheetElem.appendChild(cellElem);
                }
                ++n4;
            }
            Object[] tables = ((Sheet)sheet).getTables().toArray(new Table[0]);
            Arrays.sort(tables);
            Object[] objectArray3 = tables;
            int n5 = tables.length;
            n3 = 0;
            while (n3 < n5) {
                Object table = objectArray3[n3];
                Element tableElem = document.createElement("table");
                tableElem.setAttribute("name", ((Table)table).getName());
                int rowSize = ((Table)table).getRowSize();
                tableElem.setAttribute("row", Integer.toString(rowSize));
                int colSize = ((Table)table).getColSize();
                tableElem.setAttribute("col", Integer.toString(colSize));
                sheetElem.appendChild(tableElem);
                int row = 0;
                while (row < rowSize) {
                    Element rowElem = null;
                    Cell[] cells = ((Table)table).getRange("R" + row + "Cx").getRow(0);
                    int col = 0;
                    while (col < colSize) {
                        if (cells[col].getCellType() != Cell.CellType.EMPTY) {
                            if (rowElem == null) {
                                rowElem = document.createElement("row");
                                rowElem.setAttribute("num", Integer.toString(row));
                            }
                            Element colElem = document.createElement("col");
                            colElem.setAttribute("num", Integer.toString(col));
                            this.setCellElement(document, colElem, cells[col]);
                            rowElem.appendChild(colElem);
                        }
                        ++col;
                    }
                    if (rowElem != null) {
                        tableElem.appendChild(rowElem);
                    }
                    ++row;
                }
                ++n3;
            }
            Object[] groups = ((Sheet)sheet).getGroups().toArray(new Group[0]);
            Arrays.sort(groups);
            Object[] objectArray4 = groups;
            int n6 = groups.length;
            n5 = 0;
            while (n5 < n6) {
                Object group = objectArray4[n5];
                Element groupElem = document.createElement("group");
                groupElem.setAttribute("name", ((Group)group).getName());
                for (Cell cell : ((Group)group).getCells()) {
                    Element cellElem = document.createElement("cell");
                    cellElem.setAttribute("name", cell.getName());
                    groupElem.appendChild(cellElem);
                }
                sheetElem.appendChild(groupElem);
                ++n5;
            }
            ++n2;
        }
        return document;
    }

    private void setCellElement(Document document, Element cellElement, Cell cell) {
        String cellType = null;
        String cellValue = null;
        switch (cell.getCellType()) {
            case BOOLEAN: {
                cellType = "bool";
                cellValue = cell.getValue().getBoolean().toString();
                break;
            }
            case EMPTY: {
                cellType = "empty";
                cellValue = "";
                break;
            }
            case NUMBER: {
                cellType = "num";
                cellValue = cell.getValue().getNumber().toString();
                break;
            }
            case STRING: {
                cellType = "str";
                cellValue = cell.getValue().getString();
                break;
            }
            case DATE: {
                cellType = "date";
                cellValue = DATE_FORMAT.format(cell.getValue().getDate());
                break;
            }
            case FORMULA: {
                cellType = "formula";
                cellValue = cell.getFormula();
                break;
            }
        }
        cellElement.setAttribute("type", cellType);
        cellElement.appendChild(document.createCDATASection(cellValue));
    }
}

