
---------------------------
--   SCRIPT STARTS HERE!
---------------------------
-- NEW/CHANGED TABLES - NEW/CHANGED AD_ENTRIES
CREATE TABLE CM_WIKITOKEN
(
   CM_WIKITOKEN_ID NUMBER(10,0) NOT NULL ,
   AD_CLIENT_ID NUMBER(10,0) NOT NULL ,
   AD_ORG_ID NUMBER(10,0) NOT NULL ,
   ISACTIVE CHAR(1 BYTE)  DEFAULT 'Y' NOT NULL ,
   CREATED DATE DEFAULT SYSDATE NOT NULL ,
   CREATEDBY NUMBER(10,0) NOT NULL ,
   UPDATED DATE DEFAULT SYSDATE NOT NULL ,
   UPDATEDBY NUMBER(10,0) NOT NULL ,
   NAME NVARCHAR2(60)  NOT NULL ,
   DESCRIPTION NVARCHAR2(255)  NULL ,
   TOKENTYPE CHAR(1 BYTE)  NOT NULL ,
   SELECTCLAUSE NVARCHAR2(2000)  NULL ,
   AD_TABLE_ID NUMBER(10,0) NULL ,
   WHERECLAUSE NVARCHAR2(2000)  NULL ,
   MACRO NVARCHAR2(2000)  NULL 
);

CREATE TABLE AD_LDAPPROCESSORLOG
(
   AD_LDAPPROCESSOR_ID NUMBER(10,0) NOT NULL ,
   AD_LDAPPROCESSORLOG_ID NUMBER(10,0) NOT NULL ,
   AD_CLIENT_ID NUMBER(10,0) NOT NULL ,
   AD_ORG_ID NUMBER(10,0) NOT NULL ,
   ISACTIVE CHAR(1 BYTE)  DEFAULT 'Y' NOT NULL ,
   CREATED DATE DEFAULT SYSDATE NOT NULL ,
   CREATEDBY NUMBER(10,0) NOT NULL ,
   UPDATED DATE DEFAULT SYSDATE NOT NULL ,
   UPDATEDBY NUMBER(10,0) NOT NULL ,
   SUMMARY NVARCHAR2(2000)  NULL ,
   ISERROR CHAR(1 BYTE)  DEFAULT 'N' NOT NULL ,
   REFERENCE NVARCHAR2(60)  NULL ,
   DESCRIPTION NVARCHAR2(255)  NULL ,
   TEXTMSG NVARCHAR2(2000)  NULL ,
   BINARYDATA BLOB NULL 
);

CREATE TABLE AD_LDAPPROCESSOR
(
   AD_LDAPPROCESSOR_ID NUMBER(10,0) NOT NULL ,
   AD_CLIENT_ID NUMBER(10,0) NOT NULL ,
   AD_ORG_ID NUMBER(10,0) NOT NULL ,
   CREATED DATE DEFAULT SYSDATE NOT NULL ,
   CREATEDBY NUMBER(10,0) NOT NULL ,
   UPDATED DATE DEFAULT SYSDATE NOT NULL ,
   UPDATEDBY NUMBER(10,0) NOT NULL ,
   ISACTIVE CHAR(1 BYTE)  DEFAULT 'Y' NOT NULL ,
   NAME NVARCHAR2(60)  NOT NULL ,
   DESCRIPTION NVARCHAR2(255)  NULL ,
   LDAPPORT NUMBER(10,0) DEFAULT 0 NOT NULL ,
   DATELASTRUN DATE NULL ,
   DATENEXTRUN DATE NULL ,
   SUPERVISOR_ID NUMBER(10,0) NOT NULL ,
   KEEPLOGDAYS NUMBER(10,0) DEFAULT 0 NOT NULL ,
   PROCESSING CHAR(1 BYTE)  NULL 
);

CREATE TABLE AD_LDAPACCESS
(
   AD_LDAPACCESS_ID NUMBER(10,0) NOT NULL ,
   AD_CLIENT_ID NUMBER(10,0) NOT NULL ,
   AD_ORG_ID NUMBER(10,0) NOT NULL ,
   ISACTIVE CHAR(1 BYTE)  DEFAULT 'Y' NOT NULL ,
   CREATED DATE DEFAULT SYSDATE NOT NULL ,
   CREATEDBY NUMBER(10,0) NOT NULL ,
   UPDATED DATE DEFAULT SYSDATE NOT NULL ,
   UPDATEDBY NUMBER(10,0) NOT NULL ,
   AD_LDAPPROCESSOR_ID NUMBER(10,0) NOT NULL ,
   AD_USER_ID NUMBER(10,0) NULL ,
   R_INTERESTAREA_ID NUMBER(10,0) NULL ,
   ISERROR CHAR(1 BYTE)  DEFAULT 'N' NOT NULL ,
   SUMMARY NVARCHAR2(2000)  NULL ,
   DESCRIPTION NVARCHAR2(255)  NULL 
);

ALTER TABLE C_DUNNINGLEVEL ADD (
   ISSHOWALLDUE CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE C_DUNNINGLEVEL ADD (
   ISSHOWNOTDUE CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE C_DUNNINGLEVEL ADD (
   ISSETCREDITSTOP CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE C_DUNNINGLEVEL ADD (
   ISSETPAYMENTTERM CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE C_DUNNINGLEVEL ADD (
   C_PAYMENTTERM_ID NUMBER(10,0) DEFAULT NULL  NULL 
);

ALTER TABLE C_DUNNING ADD (
   CREATELEVELSSEQUENTIALLY CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);

ALTER TABLE C_PAYSELECTIONCHECK ADD (
   C_BP_BANKACCOUNT_ID NUMBER(10,0) DEFAULT NULL  NULL 
);

ALTER TABLE CM_CHATTYPE ADD (
   MODERATIONTYPE CHAR(1 BYTE)  DEFAULT NULL  NULL 
);

ALTER TABLE CM_CHATENTRY ADD (
   CM_CHATENTRYPARENT_ID NUMBER(10,0) DEFAULT NULL  NULL 
);
ALTER TABLE CM_CHATENTRY ADD (
   CM_CHATENTRYGRANDPARENT_ID NUMBER(10,0) DEFAULT NULL  NULL 
);
ALTER TABLE CM_CHATENTRY ADD (
-- TEMP VALUE - REPLACE_ME: 'N'
   CHATENTRYTYPE CHAR(1 BYTE)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE CM_CHATENTRY MODIFY (
   CHATENTRYTYPE CHAR(1 BYTE)  DEFAULT NULL 
);
ALTER TABLE CM_CHATENTRY ADD (
   MODERATORSTATUS CHAR(1 BYTE)  DEFAULT NULL  NULL 
);
ALTER TABLE CM_CHATENTRY ADD (
   SUBJECT NVARCHAR2(255)  DEFAULT NULL  NULL 
);
ALTER TABLE CM_CHATENTRY ADD (
   AD_USER_ID NUMBER(10,0) DEFAULT NULL  NULL 
);

ALTER TABLE CM_CHAT ADD (
   MODERATIONTYPE CHAR(1 BYTE)  DEFAULT NULL  NULL 
);

ALTER TABLE AD_COLUMN MODIFY (
   COLUMNSQL NVARCHAR2(2000) 
);

ALTER TABLE C_INVOICE ADD (
   INVOICECOLLECTIONTYPE CHAR(1 BYTE)  DEFAULT NULL  NULL 
);

ALTER TABLE CM_CONTAINER_URL MODIFY (
   CM_CONTAINER_URL_ID NUMBER(10,0) DEFAULT NULL 
);

ALTER TABLE C_BP_BANKACCOUNT ADD (
   BPBANKACCTUSE CHAR(1 BYTE)  DEFAULT NULL  NULL 
);

ALTER TABLE R_INTERESTAREA ADD (
-- TEMP VALUE - REPLACE_ME: 'N'
   VALUE NVARCHAR2(40)  DEFAULT 'N' NOT NULL 
);
ALTER TABLE R_INTERESTAREA MODIFY (
   VALUE NVARCHAR2(40)  DEFAULT NULL 
);

ALTER TABLE AD_USER ADD (
   VALUE NVARCHAR2(40)  DEFAULT NULL  NULL 
);

ALTER TABLE R_ISSUEKNOWN DROP (
   R_ISSUERECOMMENDATION_ID
);

ALTER TABLE R_ISSUEKNOWN ADD ( 
   R_ISSUERECOMMENDATION_ID NUMBER(10) 
); 

ALTER TABLE R_ISSUERECOMMENDATION MODIFY (
   R_ISSUERECOMMENDATION_ID DEFAULT NULL 
);

ALTER TABLE AD_LDAPACCESS ADD CONSTRAINT RINTERESTAREA_ADLDAPACCESS FOREIGN KEY (R_INTERESTAREA_ID) REFERENCES R_INTERESTAREA (R_INTERESTAREA_ID);
ALTER TABLE CM_WIKITOKEN ADD CONSTRAINT ADTABLE_CMWIKITOKEN FOREIGN KEY (AD_TABLE_ID) REFERENCES AD_TABLE (AD_TABLE_ID);
ALTER TABLE AD_LDAPACCESS ADD CONSTRAINT ADUSER_ADLDAPACCESS FOREIGN KEY (AD_USER_ID) REFERENCES AD_USER (AD_USER_ID);
ALTER TABLE CM_CHATENTRY ADD CONSTRAINT ADUSER_CMCHATENTRY FOREIGN KEY (AD_USER_ID) REFERENCES AD_USER (AD_USER_ID);
ALTER TABLE AD_LDAPPROCESSOR ADD CONSTRAINT ADUSER_ADLDAPPROCESSOR FOREIGN KEY (SUPERVISOR_ID) REFERENCES AD_USER (AD_USER_ID);
ALTER TABLE C_DUNNINGLEVEL ADD CONSTRAINT CPAYMENTTERM_CDUNNINGLEVEL FOREIGN KEY (C_PAYMENTTERM_ID) REFERENCES C_PAYMENTTERM (C_PAYMENTTERM_ID);
ALTER TABLE CM_CHATENTRY ADD CONSTRAINT CMENTRTY_CMENTRYPARENT FOREIGN KEY (CM_CHATENTRYPARENT_ID) REFERENCES CM_CHATENTRY (CM_CHATENTRY_ID);
ALTER TABLE CM_CHATENTRY ADD CONSTRAINT CMCHATENTRY_GRANDPARENT FOREIGN KEY (CM_CHATENTRYGRANDPARENT_ID) REFERENCES CM_CHATENTRY (CM_CHATENTRY_ID);
ALTER TABLE AD_LDAPACCESS ADD CONSTRAINT AD_LDAPACCESS_KEY PRIMARY KEY (AD_LDAPACCESS_ID);
ALTER TABLE AD_LDAPPROCESSOR ADD CONSTRAINT AD_LDAPPROCESSOR_KEY PRIMARY KEY (AD_LDAPPROCESSOR_ID);
ALTER TABLE CM_WIKITOKEN ADD CONSTRAINT CM_WIKITOKEN_KEY PRIMARY KEY (CM_WIKITOKEN_ID);
ALTER TABLE AD_LDAPPROCESSORLOG ADD CONSTRAINT AD_LDAPPROCESSORLOG_KEY PRIMARY KEY (AD_LDAPPROCESSOR_ID, AD_LDAPPROCESSORLOG_ID);
ALTER TABLE AD_LDAPPROCESSORLOG ADD CHECK (IsActive in ('Y','N'));
ALTER TABLE AD_LDAPPROCESSORLOG ADD CHECK (IsError in ('Y','N'));
ALTER TABLE AD_LDAPPROCESSOR ADD CHECK (IsActive in ('Y','N'));
ALTER TABLE CM_WIKITOKEN ADD CHECK (IsActive in ('Y','N'));
ALTER TABLE AD_LDAPACCESS ADD CHECK (IsActive in ('Y','N'));
ALTER TABLE AD_LDAPACCESS ADD CHECK (IsError in ('Y','N'));
ALTER TABLE AD_LDAPPROCESSORLOG ADD CONSTRAINT ADLDAPPROCESSOR_ADLDAPPROCLOG FOREIGN KEY (AD_LDAPPROCESSOR_ID) REFERENCES AD_LDAPPROCESSOR (AD_LDAPPROCESSOR_ID);
ALTER TABLE AD_LDAPACCESS ADD CONSTRAINT ADLDAPPROCESSOR_ADLDAPACCESS FOREIGN KEY (AD_LDAPPROCESSOR_ID) REFERENCES AD_LDAPPROCESSOR (AD_LDAPPROCESSOR_ID);
COMMIT;
SET DEFINE OFF;
INSERT INTO AD_VAL_RULE(AD_VAL_RULE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,TYPE,CODE,ENTITYTYPE)values(268,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'All_Payment Rule - Check/DirectDebit/Deposit',null,'S','AD_Ref_List.Value IN (''S'',''T'',''D'')','D');
INSERT INTO AD_VAL_RULE(AD_VAL_RULE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,TYPE,CODE,ENTITYTYPE)values(269,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'C_BP_BankAccount of BPartner',null,'S','C_BP_BankAccount.C_BPartner_ID=@C_BPartner_ID@','D');
INSERT INTO AD_TREENODEMM(AD_TREE_ID,NODE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,PARENT_ID,SEQNO)values(10,594,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,456,4);
INSERT INTO AD_WINDOW(AD_WINDOW_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,WINDOWTYPE,ISSOTRX,ENTITYTYPE,PROCESSING,AD_IMAGE_ID,AD_COLOR_ID,ISDEFAULT,WINHEIGHT,WINWIDTH,ISBETAFUNCTIONALITY)values(389,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LDAP Server','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.','M','Y','D','N',null,null,'N',0,0,'N');
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15983,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Subject','Email Message Subject','Subject of the EMail ',0,'D','Subject',877,10,null,null,255,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',2748,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15984,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'User/Contact','User within the system - Internal or Business Partner Contact','The User identifies a unique user in the system. This could be an internal user or a business partner contact',0,'D','AD_User_ID',877,19,null,null,10,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',138,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15975,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Search Key','Search key for the record in the format required - must be unique','A search key allows you a fast method of finding a particular record. If you leave the search key empty, the system automatically creates a numeric number.  The document sequence used for this fallback number is defined in the "Maintain Sequence" window with the name "DocumentNo_<TableName>", where TableName is the actual name of the table (e.g. C_Order).',0,'D','Value',114,10,null,null,40,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',620,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15976,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Search Key','Search key for the record in the format required - must be unique','A search key allows you a fast method of finding a particular record. If you leave the search key empty, the system automatically creates a numeric number.  The document sequence used for this fallback number is defined in the "Maintain Sequence" window with the name "DocumentNo_<TableName>", where TableName is the actual name of the table (e.g. C_Order).',0,'D','Value',530,10,null,null,40,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',620,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15920,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Partner Bank Account','Bank Account of the Business Partner','The Partner Bank Account identifies the bank account to be used for this Business Partner',0,'D','C_BP_BankAccount_ID',525,19,null,269,10,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',837,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15926,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Payment Term','The terms of Payment (timing, discount)','Payment Terms identify the method and timing of payment.',0,'D','C_PaymentTerm_ID',331,19,null,null,10,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',204,null,'N','N',null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13704,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Payment Term','The terms of Payment (timing, discount)','Payment Terms identify the method and timing of payment.','Y',268,15926,null,'Y','@IsSetPaymentTerm@=Y',10,'N',200,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13754,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Search Key','Search key for the record in the format required - must be unique','A search key allows you a fast method of finding a particular record. If you leave the search key empty, the system automatically creates a numeric number.  The document sequence used for this fallback number is defined in the "Maintain Sequence" window with the name "DocumentNo_<TableName>", where TableName is the actual name of the table (e.g. C_Order).','Y',438,15976,null,'Y',null,20,'N',30,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13755,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Search Key','Search key for the record in the format required','7 bit lower case alpha numeric - max length 8 - can be used for operating system names.','N',118,15975,null,'Y',null,20,'N',40,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13762,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Subject','Email Message Subject','Subject of the EMail ','Y',822,15983,null,'Y',null,255,'N',80,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13763,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'User/Contact','User within the system - Internal or Business Partner Contact','The User identifies a unique user in the system. This could be an internal user or a business partner contact','Y',822,15984,null,'Y',null,10,'N',120,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3086,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'BPBankAcctUse','D','Account Usage','Account Usage','Business Partner Bank Account usage','Determines how the bank account is used.',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3092,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'InvoiceCollectionType','D','Collection Status','Collection Status','Invoice Collection Status','Status of the invoice collection process',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3093,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapProcessor_ID','D','Ldap Processor','Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3094,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LdapPort','D','Ldap Port','Ldap Port','The port the server is listening','The default LDAP port is 389',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3095,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapProcessorLog_ID','D','Ldap Processor Log','Ldap Log','LDAP Server Log',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3096,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapAccess_ID','D','Ldap Access','Ldap Access','Ldap Access Log','Access via LDAP',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3083,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),0,to_date('2006-10-25','RRRR-MM-DD'),0,'AmtAcctOpenDr','D','Acct Open Dr','Acct Open Dr','Open Debit in document curreny & rate',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3084,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),0,to_date('2006-10-25','RRRR-MM-DD'),0,'AmtAcctOpenCr','D','Acct Open Cr','Acct Open Cr','Open Credit in document curreny & rate',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3085,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),0,to_date('2006-10-25','RRRR-MM-DD'),0,'AmtAcctOpenBalance','D','Acct Open Balance','Acct Open Balance','Open Balance in document curreny & rate',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3097,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'ModerationType','D','Moderation Type','Moderation Type','Type of moderation',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3098,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_ChatEntryParent_ID','D','Chat Entry Parent','Chat Entry Parent','Link to direct Parent',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3099,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_ChatEntryGrandParent_ID','D','Chat Entry Grandparent','Chat Entry Grandparent','Link to Grand Parent (root level)',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3100,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'ChatEntryType','D','Chat Entry Type','Chat Entry Type','Type of Chat/Forum Entry',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3101,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'ModeratorStatus','D','Moderation Status','Moderation Status','Status of Moderation',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3102,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_WikiToken_ID','D','Wiki Token','Wiki Token','Wiki Token',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3103,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'TokenType','D','TokenType','Token Type','Wiki Token Type',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3104,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Macro','D','Macro','Macro','Macro',null,null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3087,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'CreateLevelsSequentially','D','Create levels sequentially','Sequential','Create Dunning Letter by level sequentially','If selected, the dunning letters are created in the sequence of the dunning levels.  Otherwise, the dunning level is based on the days (over)due.',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3088,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'IsShowAllDue','D','Show All Due','Show All Due','Show/print all due invoices','The dunning letter with this level incudes all due invoices.',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3089,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'IsShowNotDue','D','Show Not Due','Show Not Due','Show/print all invoices which are not due (yet).','The dunning letter with this level incudes all not due invoices.',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3090,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'IsSetCreditStop','D','Credit Stop','Credit Stop','Set the business partner to credit stop','If a dunning letter of this level is created, the business partner is set to Credit Stop (needs to be manually changed).',null,null,null,null);
INSERT INTO AD_ELEMENT(AD_ELEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,COLUMNNAME,ENTITYTYPE,NAME,PRINTNAME,DESCRIPTION,HELP,PO_NAME,PO_PRINTNAME,PO_DESCRIPTION,PO_HELP)values(3091,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'IsSetPaymentTerm','D','Set Payment Term','Set Payment Term','Set the payment term of the Business Partner','If a dunning letter of this level is created, the payment term of this business partner is overwritten.',null,null,null,null);
INSERT INTO AD_MENU(AD_MENU_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,NAME,UPDATEDBY,DESCRIPTION,ISSUMMARY,ISSOTRX,ISREADONLY,ACTION,AD_WINDOW_ID,AD_WORKFLOW_ID,AD_TASK_ID,AD_PROCESS_ID,AD_FORM_ID,AD_WORKBENCH_ID,ENTITYTYPE)values(594,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),'LDAP Server',0,'LDAP Server to authenticate and authorize external systems based on Compiere','N','N','N','W',389,null,null,null,null,null,'D');
INSERT INTO AD_LDAPPROCESSOR(AD_LDAPPROCESSOR_ID,AD_CLIENT_ID,AD_ORG_ID,CREATED,CREATEDBY,UPDATED,UPDATEDBY,ISACTIVE,NAME,DESCRIPTION,LDAPPORT,DATELASTRUN,DATENEXTRUN,SUPERVISOR_ID,KEEPLOGDAYS,PROCESSING)values(100,0,0,to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Y','Compiere LDAP Server',null,389,null,null,0,7,'N');
INSERT INTO AD_MESSAGE(AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)values(885,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'PaymentBPBankNotFound','Bank account for business partner not found',null,'E','D');
INSERT INTO AD_MESSAGE(AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)values(886,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'UserNotVerified','User EMail address was not verified - Please verify EMail',null,'E','D');
INSERT INTO AD_MESSAGE(AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)values(887,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'UserNotSubscribed','User Subscription not found',null,'E','D');
INSERT INTO AD_MESSAGE(AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)values(888,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-31','RRRR-MM-DD'),0,'SelectAll','Select &All',null,'M','D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(394,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'C_Invice InvoiceCollectionType',null,null,'L',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(399,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_ChatEntry',null,null,'T',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(395,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_Chat ModerationType',null,null,'L',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(396,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_ChatEntry ModeratorStatus',null,null,'L',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(397,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_WikiToken Type',null,null,'L',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(398,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_Chat EntryType',null,null,'L',null,'D');
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,VALIDATIONTYPE,VFORMAT,ENTITYTYPE)values(393,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'C_BPartner BPBankAcctUse',null,null,'L',null,'D');
INSERT INTO AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,AD_PRINTFORMAT_ID,NAME,PRINTNAME,ISPRINTED,PRINTAREATYPE,SEQNO,PRINTFORMATTYPE,AD_COLUMN_ID,AD_PRINTFORMATCHILD_ID,ISRELATIVEPOSITION,ISNEXTLINE,XSPACE,YSPACE,XPOSITION,YPOSITION,MAXWIDTH,ISHEIGHTONELINE,MAXHEIGHT,FIELDALIGNMENTTYPE,LINEALIGNMENTTYPE,AD_PRINTCOLOR_ID,AD_PRINTFONT_ID,ISORDERBY,SORTNO,ISGROUPBY,ISPAGEBREAK,ISSUMMARIZED,IMAGEISATTACHED,IMAGEURL,ISAVERAGED,ISCOUNTED,ISSETNLPOSITION,ISSUPPRESSNULL,BELOWCOLUMN,AD_PRINTGRAPH_ID,ISFIXEDWIDTH,ISNEXTPAGE,PRINTNAMESUFFIX,ISMINCALC,ISMAXCALC,ISRUNNINGTOTAL,RUNNINGTOTALLINES,ISVARIANCECALC,ISDEVIATIONCALC,ISFILLEDRECTANGLE,LINEWIDTH,ARCDIAMETER,SHAPETYPE,ISCENTRALLYMAINTAINED,ISIMAGEFIELD,BARCODETYPE)values(2400,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,167,'Created','Created','N','C',0,'F',2805,null,'Y','N',0,0,0,0,0,'N',0,'L','X',null,null,'N',0,'N','N','N','N',null,'N','N','N','N',null,null,'N','N',null,'N','N','N',null,'N','N','N',1,0,'N','Y','N',null);
INSERT INTO AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,AD_PRINTFORMAT_ID,NAME,PRINTNAME,ISPRINTED,PRINTAREATYPE,SEQNO,PRINTFORMATTYPE,AD_COLUMN_ID,AD_PRINTFORMATCHILD_ID,ISRELATIVEPOSITION,ISNEXTLINE,XSPACE,YSPACE,XPOSITION,YPOSITION,MAXWIDTH,ISHEIGHTONELINE,MAXHEIGHT,FIELDALIGNMENTTYPE,LINEALIGNMENTTYPE,AD_PRINTCOLOR_ID,AD_PRINTFONT_ID,ISORDERBY,SORTNO,ISGROUPBY,ISPAGEBREAK,ISSUMMARIZED,IMAGEISATTACHED,IMAGEURL,ISAVERAGED,ISCOUNTED,ISSETNLPOSITION,ISSUPPRESSNULL,BELOWCOLUMN,AD_PRINTGRAPH_ID,ISFIXEDWIDTH,ISNEXTPAGE,PRINTNAMESUFFIX,ISMINCALC,ISMAXCALC,ISRUNNINGTOTAL,RUNNINGTOTALLINES,ISVARIANCECALC,ISDEVIATIONCALC,ISFILLEDRECTANGLE,LINEWIDTH,ARCDIAMETER,SHAPETYPE,ISCENTRALLYMAINTAINED,ISIMAGEFIELD,BARCODETYPE)values(2401,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,167,'Created By','Created By','N','C',0,'F',2806,null,'Y','N',0,0,0,0,0,'N',0,'L','X',null,null,'N',0,'N','N','N','N',null,'N','N','N','N',null,null,'N','N',null,'N','N','N',null,'N','N','N',1,0,'N','Y','N',null);
INSERT INTO AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,AD_PRINTFORMAT_ID,NAME,PRINTNAME,ISPRINTED,PRINTAREATYPE,SEQNO,PRINTFORMATTYPE,AD_COLUMN_ID,AD_PRINTFORMATCHILD_ID,ISRELATIVEPOSITION,ISNEXTLINE,XSPACE,YSPACE,XPOSITION,YPOSITION,MAXWIDTH,ISHEIGHTONELINE,MAXHEIGHT,FIELDALIGNMENTTYPE,LINEALIGNMENTTYPE,AD_PRINTCOLOR_ID,AD_PRINTFONT_ID,ISORDERBY,SORTNO,ISGROUPBY,ISPAGEBREAK,ISSUMMARIZED,IMAGEISATTACHED,IMAGEURL,ISAVERAGED,ISCOUNTED,ISSETNLPOSITION,ISSUPPRESSNULL,BELOWCOLUMN,AD_PRINTGRAPH_ID,ISFIXEDWIDTH,ISNEXTPAGE,PRINTNAMESUFFIX,ISMINCALC,ISMAXCALC,ISRUNNINGTOTAL,RUNNINGTOTALLINES,ISVARIANCECALC,ISDEVIATIONCALC,ISFILLEDRECTANGLE,LINEWIDTH,ARCDIAMETER,SHAPETYPE,ISCENTRALLYMAINTAINED,ISIMAGEFIELD,BARCODETYPE)values(2402,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,167,'Updated','Updated','N','C',0,'F',2807,null,'Y','N',0,0,0,0,0,'N',0,'L','X',null,null,'N',0,'N','N','N','N',null,'N','N','N','N',null,null,'N','N',null,'N','N','N',null,'N','N','N',1,0,'N','Y','N',null);
INSERT INTO AD_PRINTFORMATITEM(AD_PRINTFORMATITEM_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,AD_PRINTFORMAT_ID,NAME,PRINTNAME,ISPRINTED,PRINTAREATYPE,SEQNO,PRINTFORMATTYPE,AD_COLUMN_ID,AD_PRINTFORMATCHILD_ID,ISRELATIVEPOSITION,ISNEXTLINE,XSPACE,YSPACE,XPOSITION,YPOSITION,MAXWIDTH,ISHEIGHTONELINE,MAXHEIGHT,FIELDALIGNMENTTYPE,LINEALIGNMENTTYPE,AD_PRINTCOLOR_ID,AD_PRINTFONT_ID,ISORDERBY,SORTNO,ISGROUPBY,ISPAGEBREAK,ISSUMMARIZED,IMAGEISATTACHED,IMAGEURL,ISAVERAGED,ISCOUNTED,ISSETNLPOSITION,ISSUPPRESSNULL,BELOWCOLUMN,AD_PRINTGRAPH_ID,ISFIXEDWIDTH,ISNEXTPAGE,PRINTNAMESUFFIX,ISMINCALC,ISMAXCALC,ISRUNNINGTOTAL,RUNNINGTOTALLINES,ISVARIANCECALC,ISDEVIATIONCALC,ISFILLEDRECTANGLE,LINEWIDTH,ARCDIAMETER,SHAPETYPE,ISCENTRALLYMAINTAINED,ISIMAGEFIELD,BARCODETYPE)values(2403,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,167,'Updated By','Updated By','N','C',0,'F',2808,null,'Y','N',0,0,0,0,0,'N',0,'L','X',null,null,'N',0,'N','N','N','N',null,'N','N','N','N',null,null,'N','N',null,'N','N','N',null,'N','N','N',1,0,'N','Y','N',null);
INSERT INTO AD_PROCESS_PARA(AD_PROCESS_PARA_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_PROCESS_ID,SEQNO,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,COLUMNNAME,ISCENTRALLYMAINTAINED,FIELDLENGTH,ISMANDATORY,ISRANGE,DEFAULTVALUE,DEFAULTVALUE2,VFORMAT,VALUEMIN,VALUEMAX,AD_ELEMENT_ID,ENTITYTYPE)values(719,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Collection Status','Invoice Collection Status','Status of the invoice collection process',145,30,17,394,null,'InvoiceCollectionType','Y',0,'N','N',null,null,null,null,null,3092,'D');
INSERT INTO AD_PROCESS_PARA(AD_PROCESS_PARA_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_PROCESS_ID,SEQNO,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,COLUMNNAME,ISCENTRALLYMAINTAINED,FIELDLENGTH,ISMANDATORY,ISRANGE,DEFAULTVALUE,DEFAULTVALUE2,VFORMAT,VALUEMIN,VALUEMAX,AD_ELEMENT_ID,ENTITYTYPE)values(720,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-11-02','RRRR-MM-DD'),0,'Include All Currencies','Report not just foreign currency Invoices',null,289,45,20,null,null,'IsAllCurrencies','Y',0,'Y','N','N',null,null,null,null,2897,'D');
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID)values(902,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor','LDAP Server',null,'AD_LdapProcessor','N','4','D',389,null,0,'N','Y','N','N','N','L',null);
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID)values(903,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor Log','LDAP Server Log',null,'AD_LdapProcessorLog','N','4','D',389,null,0,'N','Y','N','N','N','L',null);
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID)values(904,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Access','Ldap Access Log',null,'AD_LdapAccess','N','7','D',108,null,0,'N','Y','N','N','N','L',null);
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID)values(905,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Wiki Token','Wiki Token',null,'CM_WikiToken','N','7','D',null,null,0,'N','Y','N','N','N','L',null);
INSERT INTO C_BANKSTATEMENT(C_BANKSTATEMENT_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,C_BANKACCOUNT_ID,NAME,DESCRIPTION,ISMANUAL,STATEMENTDATE,BEGINNINGBALANCE,ENDINGBALANCE,STATEMENTDIFFERENCE,CREATEFROM,PROCESSING,PROCESSED,POSTED,EFTSTATEMENTREFERENCE,EFTSTATEMENTDATE,MATCHSTATEMENT,ISAPPROVED,DOCSTATUS,DOCACTION)values(101,11,11,'Y',to_date('2006-10-31','RRRR-MM-DD'),100,to_date('2006-10-31','RRRR-MM-DD'),100,100,'2006-10-31 00:00:00',null,'Y',to_date('2006-10-31','RRRR-MM-DD'),0,0,0,'N','N','N','N',null,null,'N','N','DR','CO');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(1291,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),100,to_date('2006-10-29','RRRR-MM-DD'),100,'DocumentNo_AD_User','DocumentNo/Value for Table AD_User',null,'Y',1,1000000,1000001,100,'N','N',null,null,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(1288,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapProcessor','Table AD_LdapProcessor',null,'Y',1,1000000,1000000,101,'N','Y',null,null,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(1289,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapProcessorLog','Table AD_LdapProcessorLog',null,'Y',1,1000000,1000000,100,'N','Y',null,null,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(1290,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'AD_LdapAccess','Table AD_LdapAccess',null,'Y',1,1000000,1000000,100,'N','Y',null,null,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(1292,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'CM_WikiToken','Table CM_WikiToken',null,'Y',1,1000000,1000000,100,'N','Y',null,null,'N');
INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)values(849,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LDAP Server','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.',902,389,10,0,'Y','N','N','N',null,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'Y','N');
INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)values(850,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LDAP Server Log','Log of the LDAP Server',null,903,389,20,1,'N','N','N','Y',null,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'N','N');
INSERT INTO AD_SESSION(AD_SESSION_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,WEBSESSION,REMOTE_ADDR,REMOTE_HOST,PROCESSED)values(2687,11,11,'Y',to_date('2006-11-02','RRRR-MM-DD'),100,to_date('2006-11-02','RRRR-MM-DD'),100,null,'10.104.139.154','ws-jj','Y');
INSERT INTO AD_SESSION(AD_SESSION_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,WEBSESSION,REMOTE_ADDR,REMOTE_HOST,PROCESSED)values(2688,11,11,'Y',to_date('2006-11-02','RRRR-MM-DD'),100,to_date('2006-11-02','RRRR-MM-DD'),100,null,'10.104.139.154','ws-jj','N');
INSERT INTO AD_SESSION(AD_SESSION_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,WEBSESSION,REMOTE_ADDR,REMOTE_HOST,PROCESSED)values(2689,11,11,'Y',to_date('2006-11-02','RRRR-MM-DD'),100,to_date('2006-11-02','RRRR-MM-DD'),100,null,'10.104.139.154','ws-jj','Y');
INSERT INTO AD_REF_TABLE(AD_REFERENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,AD_TABLE_ID,AD_KEY,AD_DISPLAY,ISVALUEDISPLAYED,WHERECLAUSE,ORDERBYCLAUSE,ENTITYTYPE)values(399,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,877,15517,15983,'N',null,null,'D');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID,AD_ROLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,ISREADWRITE)values(389,0,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Y');
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15962,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',904,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',102,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15963,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',904,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',113,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15964,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',904,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',348,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15965,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',904,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',245,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15966,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',904,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',246,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15967,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',904,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',607,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15968,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',904,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',608,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15969,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.',0,'D','AD_LdapProcessor_ID',904,19,null,null,10,null,'N','Y','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3093,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15970,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'User/Contact','User within the system - Internal or Business Partner Contact','The User identifies a unique user in the system. This could be an internal user or a business partner contact',0,'D','AD_User_ID',904,19,null,null,10,null,'N','N','N','N',null,'Y',1,'N','N',null,null,null,null,'N',138,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15971,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Interest Area','Interest Area or Topic','Interest Areas reflect interest in a topic by a contact. Interest areas can be used for marketing campaigns.',0,'D','R_InterestArea_ID',904,19,null,null,10,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',1893,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15972,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Error','An Error occured in the execution',null,0,'D','IsError',904,20,null,null,1,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',2395,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15973,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Summary','Textual summary of this request','The Summary allows free form text entry of a recap of this request.',0,'D','Summary',904,14,null,null,2000,null,'N','N','N','N',null,'Y',2,'N','N',null,null,null,null,'N',1521,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15974,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Description','Optional short description of the record','A description is limited to 255 characters.',0,'D','Description',904,10,null,null,255,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',275,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15977,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Moderation Type','Type of moderation',null,0,'D','ModerationType',874,17,395,null,1,'N','N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3097,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15978,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Moderation Type','Type of moderation',null,0,'D','ModerationType',876,17,395,null,1,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3097,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15979,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Chat Entry Parent','Link to direct Parent',null,0,'D','CM_ChatEntryParent_ID',877,18,399,null,10,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3098,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15980,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Chat Entry Grandparent','Link to Grand Parent (root level)',null,0,'D','CM_ChatEntryGrandParent_ID',877,18,399,null,10,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3099,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15981,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Chat Entry Type','Type of Chat/Forum Entry',null,0,'D','ChatEntryType',877,17,398,null,1,'N','N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3100,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15982,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Moderation Status','Status of Moderation',null,0,'D','ModeratorStatus',877,17,396,null,1,'P','N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3101,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15985,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Wiki Token','Wiki Token',null,0,'D','CM_WikiToken_ID',905,13,null,null,10,null,'Y','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3102,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15986,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',905,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',102,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15987,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',905,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',113,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15988,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',905,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',348,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15989,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',905,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',245,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15990,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',905,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',246,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15991,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',905,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',607,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15992,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',905,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',608,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15993,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Name','Alphanumeric identifier of the entity','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',0,'D','Name',905,10,null,null,120,null,'N','N','Y','Y',null,'Y',1,'N','N',null,null,null,null,'N',469,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15994,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Description','Optional short description of the record','A description is limited to 255 characters.',0,'D','Description',905,10,null,null,255,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',275,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15995,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'TokenType','Wiki Token Type',null,0,'D','TokenType',905,17,397,null,1,'I','N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3103,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15996,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Sql SELECT','SQL SELECT clause','The Select Clause indicates the SQL SELECT clause to use for selecting the record for a measure calculation. Do not include the SELECT itself.',0,'D','SelectClause',905,14,null,null,2000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',1599,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15997,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Table','Database Table information','The Database Table provides the information of the table definition',0,'D','AD_Table_ID',905,19,null,null,10,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',126,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15998,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Sql WHERE','Fully qualified SQL WHERE clause','The Where Clause indicates the SQL WHERE clause to use for record selection. The WHERE clause is added to the query. Fully qualified means "tablename.columnname".',0,'D','WhereClause',905,14,null,null,2000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',630,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15999,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),to_date('2006-10-30','RRRR-MM-DD'),0,0,'Macro','Macro',null,0,'D','Macro',905,14,null,null,2000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3104,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15915,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),to_date('2006-10-25','RRRR-MM-DD'),0,0,'Acct Open Dr','Open Debit in document curreny & rate',null,0,'D','AmtAcctOpenDr',804,12,null,null,22,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',3083,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15916,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),to_date('2006-10-25','RRRR-MM-DD'),0,0,'Acct Open Cr','Open Credit in document curreny & rate',null,0,'D','AmtAcctOpenCr',804,12,null,null,22,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',3084,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15917,0,0,'Y',to_date('2006-10-25','RRRR-MM-DD'),to_date('2006-10-25','RRRR-MM-DD'),0,0,'Acct Open Balance','Open Balance in document curreny & rate',null,0,'D','AmtAcctOpenBalance',804,12,null,null,22,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',3085,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15927,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Collection Status','Invoice Collection Status','Status of the invoice collection process',0,'D','InvoiceCollectionType',318,17,394,null,1,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3092,null,'N','Y',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15930,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.',0,'D','AD_LdapProcessor_ID',902,13,null,null,10,null,'Y','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3093,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15931,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',902,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',102,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15932,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',902,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',113,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15933,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',902,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',245,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15934,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',902,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',246,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15935,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',902,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',607,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15936,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',902,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',608,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15937,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',902,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',348,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15938,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Name','Alphanumeric identifier of the entity','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',0,'D','Name',902,10,null,null,60,null,'N','N','Y','Y',null,'Y',1,'N','N',null,null,null,null,'N',469,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15939,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Description','Optional short description of the record','A description is limited to 255 characters.',0,'D','Description',902,10,null,null,255,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',275,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15940,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Port','The port the server is listening','The default LDAP port is 389',0,'D','LdapPort',902,11,null,null,10,'389','N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3094,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15941,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Date last run','Date the process was last run.','The Date Last Run indicates the last time that a process was run.',0,'D','DateLastRun',902,16,null,null,7,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',1089,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15942,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Date next run','Date the process will run next','The Date Next Run indicates the next time this process will run.',0,'D','DateNextRun',902,16,null,null,7,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',1090,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15943,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Supervisor','Supervisor for this user/organization - used for escalation and approval','The Supervisor indicates who will be used for forwarding and escalating issues for this user - or for approvals.',0,'D','Supervisor_ID',902,18,110,null,10,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',1522,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15922,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Show All Due','Show/print all due invoices','The dunning letter with this level incudes all due invoices.',0,'D','IsShowAllDue',331,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3088,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15921,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Create levels sequentially','Create Dunning Letter by level sequentially','If selected, the dunning letters are created in the sequence of the dunning levels.  Otherwise, the dunning level is based on the days (over)due.',0,'D','CreateLevelsSequentially',301,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3087,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15923,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Show Not Due','Show/print all invoices which are not due (yet).','The dunning letter with this level incudes all not due invoices.',0,'D','IsShowNotDue',331,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3089,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15924,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Credit Stop','Set the business partner to credit stop','If a dunning letter of this level is created, the business partner is set to Credit Stop (needs to be manually changed).',0,'D','IsSetCreditStop',331,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3090,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15925,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Set Payment Term','Set the payment term of the Business Partner','If a dunning letter of this level is created, the payment term of this business partner is overwritten.',0,'D','IsSetPaymentTerm',331,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',3091,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15944,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Days to keep Log','Number of days to keep the log entries','Older Log entries may be deleted',0,'D','KeepLogDays',902,11,null,null,10,'7','N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',2407,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15945,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Process Now',null,null,0,'D','Processing',902,20,null,null,1,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',524,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15946,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.',0,'D','AD_LdapProcessor_ID',903,19,null,null,10,null,'N','Y','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3093,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15947,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Processor Log','LDAP Server Log',null,0,'D','AD_LdapProcessorLog_ID',903,13,null,null,10,null,'Y','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3095,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15948,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',903,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',102,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15949,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',903,19,null,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',113,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15950,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',903,16,null,null,7,null,'N','N','Y','N',null,'Y',1,'N','N',null,null,null,null,'N',245,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15951,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',903,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',246,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15952,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',903,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',607,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15953,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',903,18,110,null,10,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',608,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15928,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Collection Status','Invoice Collection Status','Status of the invoice collection process',0,'D','InvoiceCollectionType',423,17,394,null,1,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',3092,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15929,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Collection Status','Invoice Collection Status','Status of the invoice collection process',0,'D','InvoiceCollectionType',413,17,394,null,1,null,'N','N','N','N',null,'N',null,'N','N',null,null,null,null,'N',3092,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15918,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),to_date('2006-10-28','RRRR-MM-DD'),0,0,'Account Usage','Business Partner Bank Account usage','Determines how the bank account is used.',0,'D','BPBankAcctUse',298,17,393,null,1,'B','N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',3086,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15954,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Summary','Textual summary of this request','The Summary allows free form text entry of a recap of this request.',0,'D','Summary',903,14,null,null,2000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',1521,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15955,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Reference','Reference for this record','The Reference displays the source document number.',0,'D','Reference',903,10,null,null,60,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',539,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15956,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Description','Optional short description of the record','A description is limited to 255 characters.',0,'D','Description',903,10,null,null,255,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',275,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15957,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Text Message','Text Message',null,0,'D','TextMsg',903,14,null,null,2000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',2438,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15958,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'BinaryData','Binary Data','The Binary field stores binary data.',0,'D','BinaryData',903,23,null,null,4000,null,'N','N','N','Y',null,'N',null,'N','N',null,null,null,null,'N',174,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15959,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',903,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',348,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15960,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Error','An Error occured in the execution',null,0,'D','IsError',903,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',2395,null,'N','N',null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL)values(15961,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),to_date('2006-10-29','RRRR-MM-DD'),0,0,'Ldap Access','Ldap Access Log','Access via LDAP',0,'D','AD_LdapAccess_ID',904,13,null,null,10,null,'Y','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',3096,null,'N','N',null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13731,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Error','An Error occured in the execution',null,'Y',850,15960,null,'Y',null,1,'N',60,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13701,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Collection Status','Invoice Collection Status','Status of the invoice collection process','Y',290,15927,null,'N',null,1,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13699,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Account Usage','Business Partner Bank Account usage','Determines how the bank account is used.','Y',226,15918,null,'Y','@IsACH@=Y',1,'N',70,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13700,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Collection Status','Invoice Collection Status','Status of the invoice collection process','Y',263,15927,null,'Y','@Processed@=Y',1,'N',400,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13702,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Create levels sequentially','Create Dunning Letter by level sequentially','If selected, the dunning letters are created in the sequence of the dunning levels.  Otherwise, the dunning level is based on the days (over)due.','Y',231,15921,null,'Y',null,1,'N',null,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13703,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Credit Stop','Set the business partner to credit stop','If a dunning letter of this level is created, the business partner is set to Credit Stop (needs to be manually changed).','Y',268,15924,null,'Y',null,1,'N',180,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13705,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Set Payment Term','Set the payment term of the Business Partner','If a dunning letter of this level is created, the payment term of this business partner is overwritten.','Y',268,15925,null,'Y',null,1,'N',190,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13706,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Show All Due','Show/print all due invoices','The dunning letter with this level incudes all due invoices.','Y',268,15922,null,'Y',null,1,'N',100,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13707,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'Show Not Due','Show/print all invoices which are not due (yet).','The dunning letter with this level incudes all not due invoices.','Y',268,15923,null,'Y',null,1,'N',80,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13708,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',849,15937,null,'Y',null,1,'N',50,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13709,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',849,15931,null,'Y',null,10,'N',10,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13710,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Date last run','Date the process was last run.','The Date Last Run indicates the last time that a process was run.','Y',849,15941,null,'Y',null,7,'Y',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13711,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Date next run','Date the process will run next','The Date Next Run indicates the next time this process will run.','Y',849,15942,null,'Y',null,7,'Y',100,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13712,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Days to keep Log','Number of days to keep the log entries','Older Log entries may be deleted','Y',849,15944,null,'Y',null,10,'N',80,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13713,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Description','Optional short description of the record','A description is limited to 255 characters.','Y',849,15939,null,'Y',null,255,'N',40,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13714,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Port','The port the server is listening','The default LDAP port is 389','Y',849,15940,null,'Y',null,10,'N',60,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13715,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.','Y',849,15930,null,'N',null,10,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13716,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Name','Alphanumeric identifier of the entity','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.','Y',849,15938,null,'Y',null,60,'N',30,1,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13717,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',849,15932,null,'Y',null,10,'N',20,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13718,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Process Now',null,null,'Y',849,15945,null,'N',null,1,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13719,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Supervisor','Supervisor for this user/organization - used for escalation and approval','The Supervisor indicates who will be used for forwarding and escalating issues for this user - or for approvals.','Y',849,15943,null,'Y',null,10,'N',70,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13720,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'BinaryData','Binary Data','The Binary field stores binary data.','Y',850,15958,null,'N',null,4000,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13721,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',850,15948,null,'Y',null,10,'N',10,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13722,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Description','Optional short description of the record','A description is limited to 255 characters.','Y',850,15956,null,'Y',null,255,'N',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13723,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.','Y',850,15946,null,'Y',null,10,'N',30,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13724,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor Log','LDAP Server Log',null,'Y',850,15947,null,'N',null,10,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13725,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',850,15949,null,'Y',null,10,'N',20,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13726,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Reference','Reference for this record','The Reference displays the source document number.','Y',850,15955,null,'Y',null,60,'N',70,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13727,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Summary','Textual summary of this request','The Summary allows free form text entry of a recap of this request.','Y',850,15954,null,'Y',null,2000,'N',50,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13728,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Text Message','Text Message',null,'Y',850,15957,null,'Y',null,2000,'N',80,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13729,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Created','Date this record was created','The Created field indicates the date that this record was created.','Y',850,15950,null,'Y',null,0,'N',40,-1,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13730,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',850,15959,null,'N',null,1,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13756,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Moderation Type','Type of moderation',null,'Y',819,15977,null,'Y',null,1,'N',70,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13757,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Moderation Type','Type of moderation',null,'Y',821,15978,null,'Y',null,1,'N',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13758,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Chat Entry Grandparent','Link to Grand Parent (root level)',null,'Y',822,15980,null,'Y',null,10,'Y',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13759,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Chat Entry Parent','Link to direct Parent',null,'Y',822,15979,null,'Y',null,10,'Y',100,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13760,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Chat Entry Type','Type of Chat/Forum Entry',null,'Y',822,15981,null,'Y',null,1,'N',70,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13761,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Moderation Status','Status of Moderation',null,'Y',822,15982,null,'Y',null,1,'N',50,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(928,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'N','Not moderated',null,395,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(929,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'B','Before Publishing',null,395,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(930,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'A','After Publishing',null,395,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(931,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'N','Not Displayed',null,396,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(932,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'P','Published',null,396,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(933,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'R','To be reviewed',null,396,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(934,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'S','Suspicious',null,396,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(935,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'Q','SQL Command',null,397,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(936,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'I','Internal Link',null,397,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(937,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'E','External Link',null,397,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(939,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'S','Style',null,397,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(940,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'W','Wiki',null,398,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(941,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'N','Note (flat)',null,398,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(942,0,0,'Y',to_date('2006-10-30','RRRR-MM-DD'),0,to_date('2006-10-30','RRRR-MM-DD'),0,'F','Forum (threaded)',null,398,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(920,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'N','None',null,393,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(921,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'B','Both',null,393,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(922,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'D','Direct Debit',null,393,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(923,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'T','Direct Deposit',null,393,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(924,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'D','Dunning',null,394,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(925,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'C','Collection Agency',null,394,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(926,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'L','Legal Procedure',null,394,null,null,'D');
INSERT INTO AD_REF_LIST(AD_REF_LIST_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,VALUE,NAME,DESCRIPTION,AD_REFERENCE_ID,VALIDFROM,VALIDTO,ENTITYTYPE)values(927,0,0,'Y',to_date('2006-10-28','RRRR-MM-DD'),0,to_date('2006-10-28','RRRR-MM-DD'),0,'U','Uncollectable',null,394,null,null,'D');
INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)values(852,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LDAP Access','User Access via LDAP',null,904,245,30,1,'N','N','N','Y',15971,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'N','Y');
INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)values(851,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'LDAP Access','User Access via LDAP',null,904,108,80,1,'N','N','N','Y',15970,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'N','N');
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13742,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Created','Date this record was created','The Created field indicates the date that this record was created.','Y',851,15965,null,'Y',null,0,'N',60,-1,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13732,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',851,15964,null,'N',null,1,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13733,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',851,15962,null,'Y',null,10,'N',10,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13734,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Description','Optional short description of the record','A description is limited to 255 characters.','Y',851,15974,null,'Y',null,255,'N',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13735,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Error','An Error occured in the execution',null,'Y',851,15972,null,'Y',null,1,'N',70,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13736,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Interest Area','Interest Area or Topic','Interest Areas reflect interest in a topic by a contact. Interest areas can be used for marketing campaigns.','Y',851,15971,null,'Y',null,10,'N',50,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13737,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Access','Ldap Access Log','Access via LDAP','Y',851,15961,null,'N',null,10,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13738,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.','Y',851,15969,null,'Y',null,10,'N',40,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13739,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',851,15963,null,'Y',null,10,'N',20,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13740,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Summary','Textual summary of this request','The Summary allows free form text entry of a recap of this request.','Y',851,15973,null,'Y',null,2000,'N',80,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13741,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'User/Contact','User within the system - Internal or Business Partner Contact','The User identifies a unique user in the system. This could be an internal user or a business partner contact','Y',851,15970,null,'Y',null,10,'N',30,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13743,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',852,15964,null,'N',null,1,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13747,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Interest Area','Interest Area or Topic','Interest Areas reflect interest in a topic by a contact. Interest areas can be used for marketing campaigns.','Y',852,15971,null,'Y',null,10,'N',30,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13748,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Access','Ldap Access Log','Access via LDAP','Y',852,15961,null,'N',null,10,'N',0,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13749,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Ldap Processor','LDAP Server to authenticate and authorize external systems based on Compiere','The LDAP Server allows third party software (e.g. Apache) to use the users defined in the system to authentificate and authorize them.  There is only one server per Compiere system.  The "o" is the Client key and the optional "ou" is the Interest Area key.','Y',852,15969,null,'Y',null,10,'N',40,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13750,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',852,15963,null,'Y',null,10,'N',20,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13751,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Summary','Textual summary of this request','The Summary allows free form text entry of a recap of this request.','Y',852,15973,null,'Y',null,2000,'N',80,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13744,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',852,15962,null,'Y',null,10,'N',10,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13745,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Description','Optional short description of the record','A description is limited to 255 characters.','Y',852,15974,null,'Y',null,255,'N',90,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13746,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Error','An Error occured in the execution',null,'Y',852,15972,null,'Y',null,1,'N',70,null,'Y','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13752,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'User/Contact','User within the system - Internal or Business Partner Contact','The User identifies a unique user in the system. This could be an internal user or a business partner contact','Y',852,15970,null,'Y',null,10,'N',50,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(13753,0,0,'Y',to_date('2006-10-29','RRRR-MM-DD'),0,to_date('2006-10-29','RRRR-MM-DD'),0,'Created','Date this record was created','The Created field indicates the date that this record was created.','Y',852,15965,null,'Y',null,0,'N',60,-1,'N','N','N','N','D',null,null,null);
COMMIT;
SET DEFINE OFF;
UPDATE AD_ATTACHMENT SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,AD_TABLE_ID=259,RECORD_ID=102,TITLE='Distribution.gif',BINARYDATA=null,TEXTMSG='This is some attachment text' WHERE AD_ATTACHMENT_ID=100;
UPDATE AD_ATTACHMENT SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,AD_TABLE_ID=389,RECORD_ID=104,TITLE='zip',BINARYDATA=null,TEXTMSG='Open Requisitions' WHERE AD_ATTACHMENT_ID=101;
UPDATE AD_VAL_RULE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='All_Payment Rule - Check/DirectDeposit',DESCRIPTION=null,TYPE='S',CODE='AD_Ref_List.Value IN (''S'',''T'')',ENTITYTYPE='D' WHERE AD_VAL_RULE_ID=162;
UPDATE AD_TREENODEMM SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,PARENT_ID=456,SEQNO=1 WHERE AD_TREE_ID=10 AND NODE_ID=200;
UPDATE AD_TREENODEMM SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,PARENT_ID=456,SEQNO=2 WHERE AD_TREE_ID=10 AND NODE_ID=439;
UPDATE AD_TREENODEMM SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,PARENT_ID=456,SEQNO=3 WHERE AD_TREE_ID=10 AND NODE_ID=440;
UPDATE C_CONVERSION_RATE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_CURRENCY_ID=102,C_CURRENCY_ID_TO=100,MULTIPLYRATE=1.17647058823529411764705882352941176471E00,DIVIDERATE=8.49999999999999977795539507496869191527E-01,C_CONVERSIONTYPE_ID=114 WHERE C_CONVERSION_RATE_ID=136;
UPDATE C_CONVERSION_RATE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_CURRENCY_ID=100,C_CURRENCY_ID_TO=102,MULTIPLYRATE=8.0064051240992794235388310648518815052E-01,DIVIDERATE=1.2489999999999998880895191177842207253E00,C_CONVERSIONTYPE_ID=114 WHERE C_CONVERSION_RATE_ID=137;
UPDATE C_CONVERSION_RATE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_CURRENCY_ID=102,C_CURRENCY_ID_TO=100,MULTIPLYRATE=1.249,DIVIDERATE=8.00640512409927840309364910353906452656E-01,C_CONVERSIONTYPE_ID=114 WHERE C_CONVERSION_RATE_ID=138;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MMR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1725;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MMS',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1726;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='PJI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1727;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='CMA',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1728;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MXI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1729;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MMP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1730;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='GLD',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1731;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='CMC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1732;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MXP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1733;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MMM',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1734;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='MMI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1735;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='ARF',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1736;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='CMB',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1737;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='API',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1739;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='APC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1740;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='GLJ',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1741;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='ARI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1742;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='ARC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1744;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='ARR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1745;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='APP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1748;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='POO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1749;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='POR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1750;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=203,DOCBASETYPE='SOO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1751;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MMR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1760;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MMS',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1761;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='PJI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1762;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='CMA',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1763;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MXI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1764;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MMP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1765;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='GLD',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1766;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='CMC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1767;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MXP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1768;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MMM',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1769;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='MMI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1770;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='ARF',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1771;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='CMB',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1772;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='API',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1774;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='APC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1775;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='GLJ',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1776;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='ARI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1777;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='ARC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1779;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='ARR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1780;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='APP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1783;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='POO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1784;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='POR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1785;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=204,DOCBASETYPE='SOO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1786;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MMR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1795;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MMS',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1796;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='PJI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1797;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='CMA',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1798;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MXI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1799;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MMP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1800;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='GLD',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1801;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='CMC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1802;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MXP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1803;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MMM',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1804;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='MMI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1805;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='ARF',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1806;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='CMB',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1807;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='API',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1809;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='APC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1810;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='GLJ',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1811;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='ARI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1812;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='ARC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1814;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='ARR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1815;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='APP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1818;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='POO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1819;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='POR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1820;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=205,DOCBASETYPE='SOO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1821;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MMR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1830;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MMS',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1831;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='PJI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1832;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='CMA',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1833;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MXI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1834;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MMP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1835;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='GLD',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1836;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='CMC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1837;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MXP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1838;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MMM',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1839;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='MMI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1840;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='ARF',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1841;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='CMB',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1842;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='API',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1844;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='APC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1845;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='GLJ',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1846;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='ARI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1847;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='ARC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1849;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='ARR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1850;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='APP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1853;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='POO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1854;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='POR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1855;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=206,DOCBASETYPE='SOO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1856;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MMR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1865;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MMS',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1866;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='PJI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1867;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='CMA',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1868;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MXI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1869;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MMP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1870;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='GLD',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1871;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='CMC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1872;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MXP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1873;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MMM',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1874;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='MMI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1875;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='ARF',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1876;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='CMB',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1877;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='API',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1879;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='APC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1880;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='GLJ',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1881;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='ARI',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1882;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='ARC',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1884;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='ARR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1885;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='APP',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1888;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='POO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1889;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='POR',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1890;
UPDATE C_PERIODCONTROL SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_PERIOD_ID=207,DOCBASETYPE='SOO',PERIODSTATUS='O',PERIODACTION='N',PROCESSING='N' WHERE C_PERIODCONTROL_ID=1891;
UPDATE I_CONVERSION_RATE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,C_CONVERSION_RATE_ID=137,ISO_CODE='USD',C_CURRENCY_ID=100,ISO_CODE_TO='EUR',C_CURRENCY_ID_TO=102,CONVERSIONTYPEVALUE='S',C_CONVERSIONTYPE_ID=114,MULTIPLYRATE=8.0064051240992794235388310648518815052E-01,DIVIDERATE=1.249,CREATERECIPROCALRATE='Y',I_ISIMPORTED='Y',I_ERRORMSG=null,PROCESSING='N',PROCESSED='Y' WHERE I_CONVERSION_RATE_ID=101;
UPDATE W_ADVERTISEMENT SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='ComPiere, Inc.',DESCRIPTION='USA, Oregon',HELP='Help ??',ISSELFSERVICE='Y',C_BPARTNER_ID=113,AD_USER_ID=101,W_CLICKCOUNT_ID=100,W_COUNTERCOUNT_ID=100,IMAGEURL='http://www1.compiere.com/images/ComPiereCom120x60.gif',ADTEXT='ComPiere, Inc. privides Support and Services for Compiere, the  premier Open Source business application.  Guaranteed <b>Support</b> is available in Gold/Silver/Bronze level you want to keep your mission critical system running and up-to-date.  All support offerings include all licenses you may need for Compiere.  We offer Intensive <b>Training</b> to get you started fast end allow you to implement Compiere efficiently. The Technical Training gives you a head start when extending Compiere to meet specific business requiredments. <p>Some Unicode test:  <br> Some Extended Characters: <br> European Characters: -<br> Characters > 100h: ??<br> Greek: ?????<br> Cyrillic: ?????????<br> Arabic: ??????<br> If you see ? or squares in the above in the Java client, your database character set is not UTF.  ',WEBPARAM1='Compiere Contributor',WEBPARAM2='http://www.compiere.com/images/partner_x.gif',WEBPARAM3='Using Compiere Internally',WEBPARAM4='Compiere <a href="http://www1.compiere.org/about/references.html">Success Stories</a>',PUBLISHSTATUS='T',VERSION=null,PROCESSING=null WHERE W_ADVERTISEMENT_ID=100;
UPDATE W_STORE SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=100,NAME='GardenWorld',DESCRIPTION=null,HELP=null,WSTOREEMAIL=null,WSTOREUSER=null,WSTOREUSERPW=null,WEBINFO=null,WEBPARAM1='gwr_logo.gif',WEBPARAM2='<h1>Web Store</h1>',WEBPARAM3='Parameter3',WEBPARAM4='Parameter4',WEBPARAM5='Parameter5',WEBPARAM6='Parameter6',ISMENUASSETS='Y',ISMENUORDERS='Y',ISMENUINVOICES='Y',ISMENUSHIPMENTS='Y',ISMENUPAYMENTS='Y',ISMENURFQS='Y',ISMENUREQUESTS='Y',ISMENUINTERESTS='Y',ISMENUREGISTRATIONS='Y',ISMENUCONTACT='Y',EMAILHEADER=null,EMAILFOOTER=null,SALESREP_ID=101,M_WAREHOUSE_ID=103,M_PRICELIST_ID=101,WEBCONTEXT='/wstore',WEBORDEREMAIL=null,C_PAYMENTTERM_ID=105,ISDEFAULT='N',URL='http://localhost',STYLESHEET='gardenworld.css' WHERE W_STORE_ID=11;
UPDATE C_REGION SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='???',DESCRIPTION='???(Aomori)',C_COUNTRY_ID=216,ISDEFAULT='N' WHERE C_REGION_ID=397;
UPDATE C_REGION SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='????',DESCRIPTION='????(Kanagawa)',C_COUNTRY_ID=216,ISDEFAULT='N' WHERE C_REGION_ID=408;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_WINDOW_ID=385 AND AD_ROLE_ID=0;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_WINDOW_ID=386 AND AD_ROLE_ID=0;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_WINDOW_ID=387 AND AD_ROLE_ID=0;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_WINDOW_ID=388 AND AD_ROLE_ID=0;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,ISREADWRITE='Y' WHERE AD_WINDOW_ID=386 AND AD_ROLE_ID=102;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,ISREADWRITE='Y' WHERE AD_WINDOW_ID=387 AND AD_ROLE_ID=102;
UPDATE AD_WINDOW_ACCESS SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,ISREADWRITE='Y' WHERE AD_WINDOW_ID=388 AND AD_ROLE_ID=102;
UPDATE R_REQUESTUPDATE SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,R_REQUEST_ID=100,CONFIDENTIALTYPEENTRY='C',QTYSPENT=0,QTYINVOICED=0,M_PRODUCTSPENT_ID=null,RESULT='Some Unicode test: Some Extended Characters:  European Characters: - Characters > 100h: ?? Greek: ????? Cyrillic: ????????? Arabic: ??????' WHERE R_REQUESTUPDATE_ID=100;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Routing No',DESCRIPTION='Bank Routing Number',HELP='The Bank Routing Number (ABA Number) identifies a legal Bank.  It is used in routing checks and electronic transactions.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='RoutingNo',AD_TABLE_ID=296,AD_REFERENCE_ID=10,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=20,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='Y',SEQNO=2,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=964,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=3040;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=0,NAME='Column SQL',DESCRIPTION='Virtual Column (r/o)',HELP='You can define virtual columns (not stored in the database). If defined, the Column name is the synonym of the SQL expression defined here. The SQL expression must be valid.<br> Example: "Updated-Created" would list the age of the entry in days',VERSION=0,ENTITYTYPE='D',COLUMNNAME='ColumnSQL',AD_TABLE_ID=101,AD_REFERENCE_ID=10,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=2000,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='N',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=null,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2699,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=13448;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Count (?)',DESCRIPTION='Count number of not empty elements',HELP='Calculate the total number (?) of not empty (NULL) elements (maximum is the number of lines).',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsCounted',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1835,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=7060;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Sum (?)',DESCRIPTION='Calculate the Sum of numeric content or length',HELP='Calculate the Sum (?) of the data if the field is numeric, otherwise total sum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsSummarized',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1241,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=6956;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Mean (?)',DESCRIPTION='Calculate Average of numeric content or length',HELP='Calculate the Mean (?) of the data if the field is numeric, otherwise calculate the average length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsAveraged',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1834,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=7061;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Variance (?)',DESCRIPTION='Calculate Variance',HELP='The Variance (?) is the a measure of dispersion - used in combination with the Mean (?)',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsVarianceCalc',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2276,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=10258;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Deviation (?)',DESCRIPTION='Calculate Standard Deviation',HELP='The Standard Deviation (?) is the a measure of dispersion - used in combination with the Mean (?)',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsDeviationCalc',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2275,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=10259;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Minimum (?)',DESCRIPTION='Calculate the minimum amount',HELP='Calculate the Minimum (?) of the data if the field is numeric, otherwise minimum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsMinCalc',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2208,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=9967;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Maximim (?)',DESCRIPTION='Calculate the maximim amount',HELP='Calculate the Maximum (?)  of the data if the field is numeric, otherwise maximum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsMaxCalc',AD_TABLE_ID=489,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='Y',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2207,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=9964;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Sum (?)',DESCRIPTION='Calculate the Sum of numeric content or length',HELP='Calculate the Sum (?) of the data if the field is numeric, otherwise total sum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsSummarized',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1241,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12498;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Deviation (?)',DESCRIPTION='Calculate Standard Deviation',HELP='The Standard Deviation (?) is the a measure of dispersion - used in combination with the Mean (?)',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsDeviationCalc',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2275,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12521;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Maximim (?)',DESCRIPTION='Calculate the maximim amount',HELP='Calculate the Maximum (?)  of the data if the field is numeric, otherwise maximum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsMaxCalc',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2207,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12503;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Mean (?)',DESCRIPTION='Calculate Average of numeric content or length',HELP='Calculate the Mean (?) of the data if the field is numeric, otherwise calculate the average length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsAveraged',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1834,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12513;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Variance (?)',DESCRIPTION='Calculate Variance',HELP='The Variance (?) is the a measure of dispersion - used in combination with the Mean (?)',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsVarianceCalc',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2276,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12526;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Count (?)',DESCRIPTION='Count number of not empty elements',HELP='Calculate the total number (?) of not empty (NULL) elements (maximum is the number of lines).',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsCounted',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=1835,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12509;
UPDATE AD_COLUMN SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Minimum (?)',DESCRIPTION='Calculate the minimum amount',HELP='Calculate the Minimum (?) of the data if the field is numeric, otherwise minimum length of the field.',VERSION=1,ENTITYTYPE='D',COLUMNNAME='IsMinCalc',AD_TABLE_ID=739,AD_REFERENCE_ID=20,AD_REFERENCE_VALUE_ID=null,AD_VAL_RULE_ID=null,FIELDLENGTH=1,DEFAULTVALUE=null,ISKEY='N',ISPARENT='N',ISMANDATORY='Y',ISUPDATEABLE='N',READONLYLOGIC=null,ISIDENTIFIER='N',SEQNO=0,ISTRANSLATED='N',ISENCRYPTED='N',CALLOUT=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,ISSELECTIONCOLUMN='N',AD_ELEMENT_ID=2208,AD_PROCESS_ID=null,ISSYNCDATABASE='N',ISALWAYSUPDATEABLE='N',COLUMNSQL=null WHERE AD_COLUMN_ID=12465;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment Term',DESCRIPTION='The terms of Payment (timing, discount)',HELP='Payment Terms identify the method and timing of payment.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2187,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@PaymentRule@=''P'' | @PaymentRule@=''D''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=330,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1099;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Currency',DESCRIPTION='The Currency for this record',HELP='Indicates the Currency to be used when processing or reporting on this record',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2191,AD_FIELDGROUP_ID=131,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=260,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1103;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Active',DESCRIPTION='The record is active in the system',HELP='There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=622,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=70,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=303;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Total Lines',DESCRIPTION='Total of all document lines',HELP='The Total amount displays the total of all lines in document currency',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2200,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='Y',SEQNO=400,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1112;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Price List',DESCRIPTION='Unique identifier of a Price List',HELP='Price Lists are used to determine the pricing, margin and cost of items purchased or sold.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2204,AD_FIELDGROUP_ID=131,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=250,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1077;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Order',DESCRIPTION='Order',HELP='The Order is a control document.  The  Order is complete when the quantity ordered is the same as the quantity shipped and invoiced.  When you cloase an order, unshipped (backordered) quantities are cancelled.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2161,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1078;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Warehouse',DESCRIPTION='Storage Warehouse and Service Point',HELP='The Warehouse identifies a unique Warehouse where products are stored or Services are provided.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2202,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=180,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1114;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Grand Total',DESCRIPTION='Total amount of document',HELP='The Grand Total displays the total amount including Tax and Freight in document currency',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2201,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='Y',SEQNO=410,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1113;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Name',DESCRIPTION='Alphanumeric identifier of the entity',HELP='The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=213,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=30,SORTNO=1,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=300;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Description',DESCRIPTION='Optional short description of the record',HELP='A description is limited to 255 characters.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=214,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=50,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=301;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Password',DESCRIPTION='Password of any length (case sensitive)',HELP='The Password for this User.  Passwords are required to identify authorized users.  For Compiere Users, you can change the password via the Process "Reset Password".',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=417,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=110,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='Y',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=302;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Document No',DESCRIPTION='Document sequence number of the document',HELP='The document number is usually automatically generated by the system and determined by the document type of the document. If the document is not saved, the preliminary number is displayed in "<>".  If the document type of your document has no automatic document sequence defined, the field is empty if you create a new document. This is for documents which usually have an external number (like vendor invoice).  If you leave the field empty, the system will generate a document number for you. The document sequence used for this fallback number is defined in the "Maintain Sequence" window with the name "DocumentNo_<TableName>", where TableName is the actual name of the table (e.g. C_Order).',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2169,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=30,SORTNO=-1,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1081;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Active',DESCRIPTION='The record is active in the system',HELP='There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2164,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1080;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Routing No',DESCRIPTION='Bank Routing Number',HELP='The Bank Routing Number (ABA Number) identifies a legal Bank.  It is used in routing checks and electronic transactions.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3104,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@IsACH@=Y & @C_Bank_ID@=0',DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=100,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2204;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Date Ordered',DESCRIPTION='Date of Order',HELP='Indicates the Date an item was ordered.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2181,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=80,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1093;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Date Promised',DESCRIPTION='Date Order was promised',HELP='The Date Promised indicates the date, if any, that an Order was promised for.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2182,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''OB'' | @OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=90,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1094;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Account Date',DESCRIPTION='Accounting Date',HELP='The Accounting Date indicates the date to be used on the General Ledger account entries generated from this document. It is also used for any currency conversion.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2183,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1095;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Freight Amount',DESCRIPTION='Freight Amount ',HELP='The Freight Amount indicates the amount charged for Freight in the document currency.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2195,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO'' & @FreightCostRule@=''F''',DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=230,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1107;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Delivery Via',DESCRIPTION='How the order will be delivered',HELP='The Delivery Via indicates how the products should be delivered. For example, will the order be picked up or shipped.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2196,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=200,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1108;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Grand Total',DESCRIPTION='Total amount of document',HELP='The Grand Total displays the total amount including Tax and Freight in document currency',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3507,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='Y',SEQNO=310,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2780;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Client',DESCRIPTION='Client/Tenant for this installation.',HELP='A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2162,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=10,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1079;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User/Contact',DESCRIPTION='User within the system - Internal or Business Partner Contact',HELP='The User identifies a unique user in the system. This could be an internal user or a business partner contact',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2763,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=140,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1572;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Transferred',DESCRIPTION='Transferred to General Ledger (i.e. accounted)',HELP='The transferred checkbox indicates if the transactions associated with this document should be transferred to the General Ledger.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2180,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1092;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Shipper',DESCRIPTION='Method or manner of product delivery',HELP='The Shipper indicates the method of delivering product',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2197,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@DeliveryViaRule@=''S'' & @OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=210,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1109;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Partner Location',DESCRIPTION='Identifies the (ship to) address for this Business Partner',HELP='The Partner address indicates the location of a Business Partner',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3400,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=120,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2590;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Invoice Rule',DESCRIPTION='Frequency and method of invoicing ',HELP='The Invoice Rule defines how a Business Partner is invoiced and the frequency of invoicing.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2192,AD_FIELDGROUP_ID=131,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO'' | @OrderType@=''WP''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=240,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1104;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Sales Representative',DESCRIPTION='Sales Representative or Company Agent',HELP='The Sales Representative indicates the Sales Rep for this Region.  Any Sales Rep must be a valid internal user.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2186,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=280,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1098;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Order Reference',DESCRIPTION='Transaction Reference Number (Sales Order, Purchase Order) of your Business Partner',HELP='The business partner order reference is the order reference for this specific transaction; Often Purchase Order numbers are given to print on Invoices for easier reference.  A standard number can be defined in the Business Partner (Customer) window.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3045,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=11,ISREADONLY='N',SEQNO=40,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2111;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge',DESCRIPTION='Additional document charges',HELP='The Charge indicates a type of Charge (Handling, Shipping, Restocking)',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3046,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@HasCharges@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=300,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2112;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Partner Bank Account',DESCRIPTION='Bank Account of the Business Partner',HELP='The Partner Bank Account identifies the bank account to be used for this Business Partner',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3094,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2201;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Description',DESCRIPTION='Optional short description of the record',HELP='A description is limited to 255 characters.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2174,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=50,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1086;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Approved',DESCRIPTION='Indicates if this document requires approval',HELP='The Approved checkbox indicates if this document requires approval before it can be processed.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2175,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC='@OrderType@=''SO'' ',DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1087;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Credit Approved',DESCRIPTION='Credit  has been approved',HELP='Credit Approved indicates if the credit approval was successful for Orders',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2176,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC='@OrderType@=''SO''',DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1088;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Delivered',DESCRIPTION=null,HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2177,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1089;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Invoiced',DESCRIPTION='Is this invoiced?',HELP='If selected, invoices are created',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2178,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1090;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Printed',DESCRIPTION='Indicates if this document / line is printed',HELP='The Printed checkbox indicates if this document or line will included when printing.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2179,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1091;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Project',DESCRIPTION='Financial Project',HELP='A Project allows you to track and control internal or external activities.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3402,AD_FIELDGROUP_ID=104,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_PJ@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=340,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2593;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Days between dunning',DESCRIPTION='Days between sending dunning notices',HELP='The Days Between Dunning indicates the number of days between sending dunning notices.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3712,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=11,ISREADONLY='N',SEQNO=90,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2916;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Active',DESCRIPTION='The record is active in the system',HELP='There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3099,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=50,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2203;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Document Type',DESCRIPTION='Document type or rules',HELP='The Document Type determines document sequence and processing rules',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2172,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=430,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1084;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Target Document Type',DESCRIPTION='Target document type for conversing documents',HELP='You can convert document types (e.g. from Offer to Order or Invoice).  The conversion is then reflected in the current type.  This processing is initiated by selecting the appropriate Document Action.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2173,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=60,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1085;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Discount Printed',DESCRIPTION='Print Discount on Invoice and Order',HELP='The Discount Printed Checkbox indicates if the discount will be printed on the document.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=4303,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=190,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3273;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Processed',DESCRIPTION='The document has been processed',HELP='The Processed checkbox indicates that a document has been processed.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3398,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2594;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Organization',DESCRIPTION='Organizational entity within client',HELP='An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2163,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=20,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2052;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Client',DESCRIPTION='Client/Tenant for this installation.',HELP='A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3095,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=10,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2198;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Organization',DESCRIPTION='Organizational entity within client',HELP='An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3096,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=20,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2199;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Document Status',DESCRIPTION='The current status of the document',HELP='The Document Status indicates the status of a document at this time.  If you want to change the document status, use the Document Action field',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2170,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=420,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1082;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Sales Transaction',DESCRIPTION='This is a Sales Transaction',HELP='The Sales Transaction checkbox indicates if this item is a Sales Transaction.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3718,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2879;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Process Order',DESCRIPTION=null,HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2453,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1323;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Campaign',DESCRIPTION='Marketing Campaign',HELP='The Campaign defines a unique marketing program.  Projects can be associated with a pre defined Marketing Campaign.  You can then report based on a specific Campaign.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2454,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_MC@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=360,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1324;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Business Partner ',DESCRIPTION='Identifies a Business Partner',HELP='A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3102,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=30,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2202;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Business Partner ',DESCRIPTION='Identifies a Business Partner',HELP='A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2762,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=100,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1573;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Process Order',DESCRIPTION=null,HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2171,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=450,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1083;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Bank',DESCRIPTION='Bank',HELP='The Bank is a unique identifier of a Bank for this Organization or for a Business Partner with whom this Organization transacts.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=3103,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@IsACH@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=80,SORTNO=1,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2200;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge Interest',DESCRIPTION='Indicates if interest will be charged on overdue invoices',HELP='The Charge Interest checkbox indicates if interest will be charged on overdue invoice amounts.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3714,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=130,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2914;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Delivery Rule',DESCRIPTION='Defines the timing of Delivery',HELP='The Delivery Rule indicates when an order should be delivered. For example should the order be delivered when the entire order is complete, when a line is complete or as the products become available.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3721,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=160,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2877;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Freight Cost Rule',DESCRIPTION='Method for charging Freight',HELP='The Freight Cost Rule indicates the method used when charging for freight.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3722,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=220,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2878;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Activity',DESCRIPTION='Business Activity',HELP='Activities indicate tasks that are performed and used to utilize Activity based Costing',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3403,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_AY@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=350,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2589;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Priority',DESCRIPTION='Priority of a document',HELP='The Priority indicates the importance (high, medium, low) of this document',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=2198,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=170,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=1110;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Account Date',DESCRIPTION='Accounting Date',HELP='The Accounting Date indicates the date to be used on the General Ledger account entries generated from this document. It is also used for any currency conversion.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3508,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=110,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2776;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='EMail Address',DESCRIPTION='Electronic Mail Address',HELP='The Email Address is the Electronic Mail ID for this User and should be fully qualified (e.g. joe.smith@company.com). The Email Address is used to access the self service application functionality from the web.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=5396,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=100,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4260;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Total Lines',DESCRIPTION='Total of all document lines',HELP='The Total amount displays the total of all lines in document currency',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3506,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='Y',SEQNO=300,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2786;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Interest in percent',DESCRIPTION='Percentage interest to charge on overdue invoices',HELP='The Interest amount in percent indicates the interest to be charged on overdue invoices.  This field displays only if the charge interest checkbox has been selected.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3715,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@ChargeInterest@=''Y''',DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=140,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2918;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Document Type',DESCRIPTION='Document type or rules',HELP='The Document Type determines document sequence and processing rules',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3493,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=330,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2771;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Activity',DESCRIPTION='Business Activity',HELP='Activities indicate tasks that are performed and used to utilize Activity based Costing',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3511,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_AY@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=250,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2764;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User/Contact',DESCRIPTION='User within the system - Internal or Business Partner Contact',HELP='The User identifies a unique user in the system. This could be an internal user or a business partner contact',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3513,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=140,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2765;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='ACH',DESCRIPTION='Automatic Clearing House',HELP='The ACH checkbox indicates if this Bank Account accepts ACH transactions.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=5225,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=60,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4111;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Print Text',DESCRIPTION='The label text to be printed on a document or correspondence.',HELP='The Label to be printed indicates the name that will be printed on a document or correspondence. The max length is 2000 characters.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3710,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=150,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2921;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment Rule',DESCRIPTION='How you pay the invoice',HELP='The Payment Rule indicates the method of invoice payment.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=4019,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=320,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3113;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Account Name',DESCRIPTION='Name on Credit Card or Account holder',HELP='The Name of the Credit Card or Account holder.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=5232,AD_FIELDGROUP_ID=104,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=170,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4100;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Note',DESCRIPTION='Optional additional user defined information',HELP='The Note field allows for optional entry of user defined information regarding this record',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3713,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=160,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2920;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Fee Amount',DESCRIPTION='Fee amount in invoice currency',HELP='The Fee Amount indicates the charge amount on a dunning letter for overdue invoices.  This field will only display if the charge fee checkbox has been selected.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3717,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@ChargeFee@=''Y''',DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=120,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2917;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge fee',DESCRIPTION='Indicates if fees will be charged for overdue invoices',HELP='The Charge Fee checkbox indicates if the dunning letter will include fees for overdue invoices',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=3716,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=110,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2913;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Business Partner ',DESCRIPTION='Identifies a Business Partner',HELP='A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3499,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=120,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2766;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Partner Location',DESCRIPTION='Identifies the (ship to) address for this Business Partner',HELP='The Partner address indicates the location of a Business Partner',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3501,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=130,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2767;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Posted',DESCRIPTION='Posting status',HELP='The Posted field indicates the status of the Generation of General Ledger Accounting Lines ',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=4650,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y & @#ShowAcct@=Y',DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=460,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3660;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Price includes Tax',DESCRIPTION='Tax is included in the price ',HELP='The Tax Included checkbox indicates if the prices include tax.  This is also known as the gross price.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=4651,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3661;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Campaign',DESCRIPTION='Marketing Campaign',HELP='The Campaign defines a unique marketing program.  Projects can be associated with a pre defined Marketing Campaign.  You can then report based on a specific Campaign.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3509,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_MC@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=260,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2768;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Currency',DESCRIPTION='The Currency for this record',HELP='Indicates the Currency to be used when processing or reporting on this record',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3505,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=160,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2770;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Price List',DESCRIPTION='Unique identifier of a Price List',HELP='Price Lists are used to determine the pricing, margin and cost of items purchased or sold.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3789,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=150,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2961;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Sum (?)',DESCRIPTION='Calculate the Sum of numeric content or length',HELP='Calculate the Sum (?) of the data if the field is numeric, otherwise total sum length of the field.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=6956,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=450,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5680;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Paid',DESCRIPTION='The document is paid',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=5025,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y',DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=390,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3899;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Paid',DESCRIPTION='The document is paid',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=290,AD_COLUMN_ID=5025,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y',DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=400,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3900;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Bank Account Type',DESCRIPTION='Bank Account Type',HELP='The Bank Account Type field indicates the type of account (savings, checking etc) this account  is defined as.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=5236,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@IsACH@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=90,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4104;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Dunning Print Format',DESCRIPTION='Print Format for printing Dunning Letters',HELP='You need to define a Print Format to print the document.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=268,AD_COLUMN_ID=7036,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=170,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5738;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Project',DESCRIPTION='Financial Project',HELP='A Project allows you to track and control internal or external activities.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3510,AD_FIELDGROUP_ID=104,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_PJ@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=240,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2775;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Date Invoiced',DESCRIPTION='Date printed on Invoice',HELP='The Date Invoice indicates the date printed on the invoice.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3783,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=100,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2958;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Organization',DESCRIPTION='Organizational entity within client',HELP='An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=438,AD_COLUMN_ID=7788,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=20,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5871;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Discount Printed',DESCRIPTION='Print Discount on Invoice and Order',HELP='The Discount Printed Checkbox indicates if the discount will be printed on the document.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=4298,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=290,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3272;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Date printed',DESCRIPTION='Date the document was printed.',HELP='Indicates the Date that a document was printed.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3719,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2876;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge amount',DESCRIPTION='Charge Amount',HELP='The Charge Amount indicates the amount for an additional charge.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=3047,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@HasCharges@=''Y''',DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=310,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2109;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Selected',DESCRIPTION=null,HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=4699,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3704;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment Term',DESCRIPTION='The terms of Payment (timing, discount)',HELP='Payment Terms identify the method and timing of payment.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3500,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@PaymentRule@=''P'' | @PaymentRule@=''D''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=230,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2774;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='EMail User ID',DESCRIPTION='User Name (ID) in the Mail System',HELP='The user name in the mail system is usually the string before the @ of your email address.  Required if the mail server requires authentification to send emails.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=7793,AD_FIELDGROUP_ID=121,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=200,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5883;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment Rule',DESCRIPTION='How you pay the invoice',HELP='The Payment Rule indicates the method of invoice payment.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=4020,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=220,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3112;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Count (?)',DESCRIPTION='Count number of not empty elements',HELP='Calculate the total number (?) of not empty (NULL) elements (maximum is the number of lines).',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=7060,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=470,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5757;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment',DESCRIPTION='Payment identifier',HELP='The Payment is a unique identifier of this payment.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=5348,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4234;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Posted',DESCRIPTION='Posting status',HELP='The Posted field indicates the status of the Generation of General Ledger Accounting Lines ',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=4649,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y & @#ShowAcct@=Y',DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=380,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=3663;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge',DESCRIPTION='Additional document charges',HELP='The Charge indicates a type of Charge (Handling, Shipping, Restocking)',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3787,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@HasCharges@=''Y''',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=200,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2953;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Sales Representative',DESCRIPTION='Sales Representative or Company Agent',HELP='The Sales Representative indicates the Sales Rep for this Region.  Any Sales Rep must be a valid internal user.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3512,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=180,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2763;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Client',DESCRIPTION='Client/Tenant for this installation.',HELP='A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=438,AD_COLUMN_ID=7784,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=10,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5869;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='EMail User Password',DESCRIPTION='Password of your email user id',HELP='Required if the mail server requires authentification to send emails.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=7794,AD_FIELDGROUP_ID=121,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=210,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='Y',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5884;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Charge amount',DESCRIPTION='Charge Amount',HELP='The Charge Amount indicates the amount for an additional charge.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3788,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@HasCharges@=''Y''',DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=210,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2956;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Business Partner ',DESCRIPTION='Identifies a Business Partner',HELP='A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=5844,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=80,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4623;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Send EMail',DESCRIPTION='Enable sending Document EMail',HELP='Send emails with document attached (e.g. Invoice, Delivery Note, etc.)',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8166,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6227;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Trx Organization',DESCRIPTION='Performing or initiating organization',HELP='The organization which performs or initiates this transaction (for another organization).  The owning Organization may not be the transaction organization in a service bureau environment, with centralized services, and inter-organization transactions.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=9333,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_OT@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=270,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6935;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Supervisor',DESCRIPTION='Supervisor for this user/organization - used for escalation and approval',HELP='The Supervisor indicates who will be used for forwarding and escalating issues for this user - or for approvals.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=5397,AD_FIELDGROUP_ID=121,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=220,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4261;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Phone',DESCRIPTION='Identifies a telephone number',HELP='The Phone field identifies a telephone number',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8747,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=140,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6517;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Fax',DESCRIPTION='Facsimile number',HELP='The Fax identifies a facsimile number for this Business Partner or  Location',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8748,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=160,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6518;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Cash Journal Line',DESCRIPTION='Cash Journal Line',HELP='The Cash Journal Line indicates a unique line in a cash journal.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=5349,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=26,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4233;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Greeting',DESCRIPTION='Greeting to print on correspondence',HELP='The Greeting identifies the greeting to print on correspondence.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8743,AD_FIELDGROUP_ID=122,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=260,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6513;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Variance (?)',DESCRIPTION='Calculate Variance',HELP='The Variance (?) is the a measure of dispersion - used in combination with the Mean (?)',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=10258,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=520,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8604;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Title',DESCRIPTION='Name this entity is referred to as',HELP='The Title indicates the name that an entity is referred to as.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8751,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=120,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6521;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Comments',DESCRIPTION='Comments or additional information',HELP='The Comments field allows for free form entry of additional information.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8752,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=60,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6522;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Last Result',DESCRIPTION='Result of last contact',HELP='The Last Result identifies the result of the last contact made.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8749,AD_FIELDGROUP_ID=122,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=60,ISREADONLY='N',SEQNO=300,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6519;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Last Contact',DESCRIPTION='Date this individual was last contacted',HELP='The Last Contact indicates the date that this Business Partner Contact was last contacted.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8750,AD_FIELDGROUP_ID=122,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=280,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6520;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Deviation (?)',DESCRIPTION='Calculate Standard Deviation',HELP='The Standard Deviation (?) is the a measure of dispersion - used in combination with the Mean (?)',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=10259,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=530,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8605;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Document Status',DESCRIPTION='The current status of the document',HELP='The Document Status indicates the status of a document at this time.  If you want to change the document status, use the Document Action field',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3494,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='Y',SEQNO=320,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2778;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Copy Lines',DESCRIPTION='Copy Lines from other Invoice',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=8770,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=360,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6564;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Self-Service',DESCRIPTION='This is a Self-Service entry or this entry can be changed via Self-Service',HELP='Self-Service allows users to enter data or update their data.  The flag indicates, that this record was entered or created via Self-Service or that the user can change it via the Self-Service functionality.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=290,AD_COLUMN_ID=8835,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6533;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Currency Type',DESCRIPTION='Currency Conversion Rate Type',HELP='The Currency Conversion Rate Type lets you define different type of rates, e.g. Spot, Corporate and/or Sell/Buy rates.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=10264,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@C_Currency_ID@!@$C_Currency_ID@',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=170,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8648;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Self-Service',DESCRIPTION='This is a Self-Service entry or this entry can be changed via Self-Service',HELP='Self-Service allows users to enter data or update their data.  The flag indicates, that this record was entered or created via Self-Service or that the user can change it via the Self-Service functionality.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=8835,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=90,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6565;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Invoice Contact',DESCRIPTION='Business Partner Contact for invoicing',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8763,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=150,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6558;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Copy Lines',DESCRIPTION='Copy Lines from other Order',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8765,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=440,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6560;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Invoice Location',DESCRIPTION='Business Partner Location for invoicing',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8766,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=130,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6561;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Interest Area',DESCRIPTION='Interest Area or Topic',HELP='Interest Areas reflect interest in a topic by a contact. Interest areas can be used for marketing campaigns.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=438,AD_COLUMN_ID=7783,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5868;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Mean (?)',DESCRIPTION='Calculate Average of numeric content or length',HELP='Calculate the Mean (?) of the data if the field is numeric, otherwise calculate the average length of the field.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=7061,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=510,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=5758;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Process Invoice',DESCRIPTION=null,HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=3495,AD_FIELDGROUP_ID=101,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=23,ISREADONLY='N',SEQNO=370,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=2777;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Trx Organization',DESCRIPTION='Performing or initiating organization',HELP='The organization which performs or initiates this transaction (for another organization).  The owning Organization may not be the transaction organization in a service bureau environment, with centralized services, and inter-organization transactions.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=9331,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_OT@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=370,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=7038;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Minimum (?)',DESCRIPTION='Calculate the minimum amount',HELP='Calculate the Minimum (?) of the data if the field is numeric, otherwise minimum length of the field.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=9967,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=490,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8295;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Self-Service',DESCRIPTION='This is a Self-Service entry or this entry can be changed via Self-Service',HELP='Self-Service allows users to enter data or update their data.  The flag indicates, that this record was entered or created via Self-Service or that the user can change it via the Self-Service functionality.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8832,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=70,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6562;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Trx Organization',DESCRIPTION='Performing or initiating organization',HELP='The organization which performs or initiates this transaction (for another organization).  The owning Organization may not be the transaction organization in a service bureau environment, with centralized services, and inter-organization transactions.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8976,AD_FIELDGROUP_ID=121,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=240,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6511;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='2nd Phone',DESCRIPTION='Identifies an alternate telephone number.',HELP='The 2nd Phone field identifies an alternate telephone number.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8744,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=150,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6514;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Birthday',DESCRIPTION='Birthday or Anniversary day',HELP='Birthday or Anniversary day',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8745,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=130,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6515;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Partner Location',DESCRIPTION='Identifies the (ship to) address for this Business Partner',HELP='The Partner address indicates the location of a Business Partner',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=8746,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=90,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6516;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User/Contact',DESCRIPTION='User within the system - Internal or Business Partner Contact',HELP='The User identifies a unique user in the system. This could be an internal user or a business partner contact',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=226,AD_COLUMN_ID=5224,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=40,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=4105;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User List 1',DESCRIPTION='User defined list element #1',HELP='The user defined element displays the optional elements that have been defined for this account combination.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=9579,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_U1@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=280,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=7794;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User List 2',DESCRIPTION='User defined list element #2',HELP='The user defined element displays the optional elements that have been defined for this account combination.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=9580,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_U2@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=290,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=7795;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Calculate Maximim (?)',DESCRIPTION='Calculate the maximim amount',HELP='Calculate the Maximum (?)  of the data if the field is numeric, otherwise maximum length of the field.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=426,AD_COLUMN_ID=9964,AD_FIELDGROUP_ID=128,ISDISPLAYED='Y',DISPLAYLOGIC='@PrintFormatType@=F',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=500,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8292;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Invoice Partner',DESCRIPTION='Business Partner to be invoiced',HELP='If empty the shipment business partner will be invoiced',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=8764,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=110,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=6559;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Pay Schedule valid',DESCRIPTION='Is the Payment Schedule is valid',HELP='Payment Schedules allow to have multiple due dates.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=10326,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='Y',SEQNO=340,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8657;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User List 2',DESCRIPTION='User defined list element #2',HELP='The user defined element displays the optional elements that have been defined for this account combination.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=9568,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_U2@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=390,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=7825;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='User List 1',DESCRIPTION='User defined list element #1',HELP='The user defined element displays the optional elements that have been defined for this account combination.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=9569,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@$Element_U1@=Y',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=380,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=7826;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Drop Shipment',DESCRIPTION='Drop Shipments are sent from the Vendor directly to the Customer',HELP='Drop Shipments do not cause any Inventory reservations or movements as the Shipment is from the Vendor''s inventory. The Shipment of the Vendor to the Customer must be confirmed.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=11580,AD_FIELDGROUP_ID=130,ISDISPLAYED='Y',DISPLAYLOGIC='@OrderType@=''SO'' ',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=190,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=10124;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Currency Type',DESCRIPTION='Currency Conversion Rate Type',HELP='The Currency Conversion Rate Type lets you define different type of rates, e.g. Spot, Corporate and/or Sell/Buy rates.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=10297,AD_FIELDGROUP_ID=131,ISDISPLAYED='Y',DISPLAYLOGIC='@C_Currency_ID@!@$C_Currency_ID@',DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=270,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8653;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Verification Info',DESCRIPTION='Verification information of EMail Address',HELP='The field contains additional information how the EMail Address has been verified',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=9884,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=290,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=8342;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='In Dispute',DESCRIPTION='Document is in dispute',HELP='The document is in dispute. Use Requests to track details.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=263,AD_COLUMN_ID=12398,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=350,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=10485;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment Location',DESCRIPTION='Location of the Business Partner responsible for the payment',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=10924,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=9427;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Payment BPartner',DESCRIPTION='Business Partner responsible for the payment',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=10925,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=9428;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Referenced Order',DESCRIPTION='Reference to corresponding Sales/Purchase Order',HELP='Reference of the Sales Order Line to the corresponding Purchase Order Line or vice versa.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=186,AD_COLUMN_ID=10926,AD_FIELDGROUP_ID=null,ISDISPLAYED='N',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=0,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=9429;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='In Dispute',DESCRIPTION='Document is in dispute',HELP='The document is in dispute. Use Requests to track details.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=290,AD_COLUMN_ID=12398,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC='@Processed@=Y',DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=360,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=10486;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=100,NAME='LDAP User Name',DESCRIPTION='User Name used for authorization via LDAP (directory) services',HELP='Optional LDAP system user name for the user. If not defined, the normal Name of the user is used. This allows to use the internal (LDAP) user id (e.g. jjanke) and the normal display name (e.g. Jorg Janke).  The LDAP User Name can also be used without LDAP enables (see system window).  This would allow to sign in as jjanke and use the display name of Jorg Janke.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=12401,AD_FIELDGROUP_ID=121,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=25,ISREADONLY='N',SEQNO=230,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=10491;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='EMail Verify',DESCRIPTION='Date Email was verified',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=13600,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=20,ISREADONLY='N',SEQNO=270,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=11525;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Notification Type',DESCRIPTION='Type of Notifications',HELP='Emails or Notification sent out for Request Updates, etc.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=13773,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=14,ISREADONLY='N',SEQNO=170,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=11679;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Full BP Access',DESCRIPTION='The user/concat has full access to Business Partner information and resources',HELP='If selected, the user has full access to the Business Partner (BP) information (Business Documents like Orders, Invoices - Requests) or resources (Assets, Downloads). If you deselet it, the user has no access rights unless, you explicitly grant it in tab "BP Access"',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=14336,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=190,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=12323;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Position',DESCRIPTION='Job Position',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=14396,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=180,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=12324;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Confidentiality',DESCRIPTION='Type of Confidentiality',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=822,AD_COLUMN_ID=15526,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=60,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=13403;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Name',DESCRIPTION='Alphanumeric identifier of the entity',HELP='The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=833,AD_COLUMN_ID=15630,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=120,ISREADONLY='N',SEQNO=30,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=13524;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=0,NAME='Organization',DESCRIPTION='Organizational entity within client',HELP='An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=833,AD_COLUMN_ID=15624,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=10,ISREADONLY='N',SEQNO=20,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=13525;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Character Data',DESCRIPTION='Long Character Field',HELP=null,ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=822,AD_COLUMN_ID=15527,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=4000,ISREADONLY='N',SEQNO=110,SORTNO=null,ISSAMELINE='N',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=13399;
UPDATE AD_FIELD SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Connection Profile',DESCRIPTION='How a Java Client connects to the server(s)',HELP='Depending on the connection profile, different protocols are used and tasks are performed on the server rather then the client. Usually the user can select different profiles, unless it is enforced by the User or Role definition. The User level profile overwrites the Role based profile.',ISCENTRALLYMAINTAINED='Y',AD_TAB_ID=118,AD_COLUMN_ID=14619,AD_FIELDGROUP_ID=null,ISDISPLAYED='Y',DISPLAYLOGIC=null,DISPLAYLENGTH=1,ISREADONLY='N',SEQNO=250,SORTNO=null,ISSAMELINE='Y',ISHEADING='N',ISFIELDONLY='N',ISENCRYPTED='N',ENTITYTYPE='D',OBSCURETYPE=null,AD_REFERENCE_ID=null,ISMANDATORY=null WHERE AD_FIELD_ID=12640;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsSummarized',ENTITYTYPE='D',NAME='Calculate Sum (?)',PRINTNAME='Sum',DESCRIPTION='Calculate the Sum of numeric content or length',HELP='Calculate the Sum (?) of the data if the field is numeric, otherwise total sum length of the field.',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=1241;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsAveraged',ENTITYTYPE='D',NAME='Calculate Mean (?)',PRINTNAME='Mean',DESCRIPTION='Calculate Average of numeric content or length',HELP='Calculate the Mean (?) of the data if the field is numeric, otherwise calculate the average length of the field.',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=1834;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsCounted',ENTITYTYPE='D',NAME='Calculate Count (?)',PRINTNAME='Count',DESCRIPTION='Count number of not empty elements',HELP='Calculate the total number (?) of not empty (NULL) elements (maximum is the number of lines).',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=1835;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsDeviationCalc',ENTITYTYPE='D',NAME='Calculate Deviation (?)',PRINTNAME='Deviation',DESCRIPTION='Calculate Standard Deviation',HELP='The Standard Deviation (?) is the a measure of dispersion - used in combination with the Mean (?)',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=2275;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsVarianceCalc',ENTITYTYPE='D',NAME='Calculate Variance (?)',PRINTNAME='Variance',DESCRIPTION='Calculate Variance',HELP='The Variance (?) is the a measure of dispersion - used in combination with the Mean (?)',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=2276;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsMinCalc',ENTITYTYPE='D',NAME='Calculate Minimum (?)',PRINTNAME='Calc Min',DESCRIPTION='Calculate the minimum amount',HELP='Calculate the Minimum (?) of the data if the field is numeric, otherwise minimum length of the field.',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=2208;
UPDATE AD_ELEMENT SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,COLUMNNAME='IsMaxCalc',ENTITYTYPE='D',NAME='Calculate Maximim (?)',PRINTNAME='Calc Max',DESCRIPTION='Calculate the maximim amount',HELP='Calculate the Maximum (?)  of the data if the field is numeric, otherwise maximum length of the field.',PO_NAME=null,PO_PRINTNAME=null,PO_DESCRIPTION=null,PO_HELP=null WHERE AD_ELEMENT_ID=2207;
UPDATE C_ACCTSCHEMA SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=100,NAME='GardenWorld US/A/US Dollar',DESCRIPTION=null,GAAP='UN',ISACCRUAL='Y',COSTINGMETHOD='I',C_CURRENCY_ID=100,AUTOPERIODCONTROL='N',C_PERIOD_ID=null,PERIOD_OPENHISTORY=100,PERIOD_OPENFUTURE=100,SEPARATOR='-',HASALIAS='Y',HASCOMBINATION='N',ISTRADEDISCOUNTPOSTED='N',ISDISCOUNTCORRECTSTAX='N',M_COSTTYPE_ID=100,COSTINGLEVEL='C',ISADJUSTCOGS='Y',AD_ORGONLY_ID=null,ISPOSTSERVICES='N',ISEXPLICITCOSTADJUSTMENT='N',COMMITMENTTYPE='N',PROCESSING=null,TAXCORRECTIONTYPE='B' WHERE C_ACCTSCHEMA_ID=101;
UPDATE AD_IMAGE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='/Users/ys/Desktop/gwr_header.jpg',IMAGEURL='/Users/ys/Desktop/gwr_header.jpg',BINARYDATA=null,ENTITYTYPE='D',DESCRIPTION=null WHERE AD_IMAGE_ID=109;
UPDATE AD_IMAGE SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='/Users/ys/Desktop/gwr_footertile.jpg',IMAGEURL='/Users/ys/Desktop/gwr_footertile.jpg',BINARYDATA=null,ENTITYTYPE='D',DESCRIPTION=null WHERE AD_IMAGE_ID=110;
UPDATE AD_PROCESS_PARA SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Overwrite Payment Rule',DESCRIPTION='Overwrite how to pay the invoice',HELP='The Payment Rule indicates how the incoice will be settled - you can overwrite the value from the invoice.',AD_PROCESS_ID=155,SEQNO=10,AD_REFERENCE_ID=17,AD_REFERENCE_VALUE_ID=195,AD_VAL_RULE_ID=268,COLUMNNAME='PaymentRule',ISCENTRALLYMAINTAINED='N',FIELDLENGTH=0,ISMANDATORY='N',ISRANGE='N',DEFAULTVALUE=null,DEFAULTVALUE2=null,VFORMAT=null,VALUEMIN=null,VALUEMAX=null,AD_ELEMENT_ID=1143,ENTITYTYPE='D' WHERE AD_PROCESS_PARA_ID=302;
UPDATE AD_PROCESS_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_PROCESS_ID=349 AND AD_ROLE_ID=0;
UPDATE AD_PROCESS_ACCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,ISREADWRITE='Y' WHERE AD_PROCESS_ID=352 AND AD_ROLE_ID=0;
UPDATE AD_PROCESS_ACCESS SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,ISREADWRITE='Y' WHERE AD_PROCESS_ID=350 AND AD_ROLE_ID=102;
UPDATE AD_PROCESS_ACCESS SET AD_CLIENT_ID=11,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,ISREADWRITE='Y' WHERE AD_PROCESS_ID=352 AND AD_ROLE_ID=102;
UPDATE AD_PROCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,VALUE='AD_Table_CreateColumns',NAME='Create Columns from DB',DESCRIPTION='Create Dictionary Columns of Table not existing as a Column but in the Database',HELP='If you have added columns in the database to this table, this procedure creates the Column records in the Dictionary.  Please be aware, that they may deleted, if the entity type is not set to User.',ACCESSLEVEL='4',ENTITYTYPE='D',PROCEDURENAME=null,ISREPORT='N',ISDIRECTPRINT='N',AD_REPORTVIEW_ID=null,CLASSNAME='org.compiere.process.TableCreateColumns',STATISTIC_COUNT=0,STATISTIC_SECONDS=0,AD_PRINTFORMAT_ID=null,WORKFLOWVALUE=null,AD_WORKFLOW_ID=null,ISBETAFUNCTIONALITY='N',ISSERVERPROCESS='N' WHERE AD_PROCESS_ID=173;
UPDATE AD_PROCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,VALUE='AD_Tab_CreateFields',NAME='Create Fields',DESCRIPTION='Create Field from Table Column, which do not exist in the Tab yet',HELP='Based on the table columns of this Tab, this procedure creates the missing Fields',ACCESSLEVEL='4',ENTITYTYPE='D',PROCEDURENAME=null,ISREPORT='N',ISDIRECTPRINT='N',AD_REPORTVIEW_ID=null,CLASSNAME='org.compiere.process.TabCreateFields',STATISTIC_COUNT=0,STATISTIC_SECONDS=0,AD_PRINTFORMAT_ID=null,WORKFLOWVALUE=null,AD_WORKFLOW_ID=null,ISBETAFUNCTIONALITY='N',ISSERVERPROCESS='N' WHERE AD_PROCESS_ID=174;
UPDATE AD_PROCESS SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,VALUE='AD_Role_AccessUpdate',NAME='Role Access Update',DESCRIPTION='Update the access rights of a role or roles of a client',HELP='Update the access rights of a role or all roles of a client to windows, forms, processes and workflows. If run for System, all roles of all clients are updated. Note that a role is only updated if it is not marked as manual.',ACCESSLEVEL='6',ENTITYTYPE='D',PROCEDURENAME=null,ISREPORT='N',ISDIRECTPRINT='N',AD_REPORTVIEW_ID=null,CLASSNAME='org.compiere.process.RoleAccessUpdate',STATISTIC_COUNT=0,STATISTIC_SECONDS=0,AD_PRINTFORMAT_ID=null,WORKFLOWVALUE=null,AD_WORKFLOW_ID=null,ISBETAFUNCTIONALITY='N',ISSERVERPROCESS='N' WHERE AD_PROCESS_ID=295;
UPDATE AD_TABLE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='T_InvoiceGL',DESCRIPTION='Gain/Loss - actual data shown id T_InvoiceGL_v',HELP=null,TABLENAME='T_InvoiceGL',ISVIEW='N',ACCESSLEVEL='3',ENTITYTYPE='D',AD_WINDOW_ID=null,AD_VAL_RULE_ID=null,LOADSEQ=145,ISSECURITYENABLED='N',ISDELETEABLE='Y',ISHIGHVOLUME='N',IMPORTTABLE=null,ISCHANGELOG='N',REPLICATIONTYPE='L',PO_WINDOW_ID=null WHERE AD_TABLE_ID=803;
UPDATE AD_TABLE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='T_InvoiceGL_v',DESCRIPTION='Gain/Loss',HELP=null,TABLENAME='T_InvoiceGL_v',ISVIEW='Y',ACCESSLEVEL='3',ENTITYTYPE='D',AD_WINDOW_ID=null,AD_VAL_RULE_ID=null,LOADSEQ=150,ISSECURITYENABLED='N',ISDELETEABLE='N',ISHIGHVOLUME='N',IMPORTTABLE=null,ISCHANGELOG='N',REPLICATIONTYPE='L',PO_WINDOW_ID=null WHERE AD_TABLE_ID=804;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_PInstance',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=1497,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=197;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Sequence',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=1293,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=16;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='AD_Issue',DESCRIPTION='Table AD_Issue',VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=902,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=1191;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_ChangeLog',DESCRIPTION='Ad_Changelog',VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=7455,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=735;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Session',DESCRIPTION='Ad_Session',VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000014,CURRENTNEXTSYS=2690,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=721;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Process_Para',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=721,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=200;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Reference',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=400,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=14;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='C_BankStatement',DESCRIPTION='C_Bankstatement',VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=102,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=329;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Table',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=906,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=21;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Field',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=13764,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=4;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Menu',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=595,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=7;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Message',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=889,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=9;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Ref_List',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=943,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=11;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Window',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=390,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=27;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Column',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=16000,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=3;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Tab',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=853,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=19;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Element',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=3105,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=188;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_PrintFormatItem',DESCRIPTION='Ad_Printformatitem',VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=2404,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=575;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_User',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=108,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=25;
UPDATE AD_SEQUENCE SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='AD_Val_Rule',DESCRIPTION=null,VFORMAT=null,ISAUTOSEQUENCE='Y',INCREMENTNO=1,STARTNO=1000000,CURRENTNEXT=1000000,CURRENTNEXTSYS=270,ISAUDITED='N',ISTABLEID='Y',PREFIX=null,SUFFIX=null,STARTNEWYEAR='N' WHERE AD_SEQUENCE_ID=26;
UPDATE AD_TAB SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=0,UPDATEDBY=0,NAME='Subscriptions',DESCRIPTION='User Subscriptions',HELP=null,AD_TABLE_ID=528,AD_WINDOW_ID=245,SEQNO=20,TABLEVEL=1,ISSINGLEROW='N',ISINFOTAB='N',ISTRANSLATIONTAB='N',ISREADONLY='N',AD_COLUMN_ID=7768,HASTREE='N',WHERECLAUSE=null,ORDERBYCLAUSE=null,COMMITWARNING=null,AD_PROCESS_ID=null,PROCESSING='N',AD_IMAGE_ID=null,IMPORTFIELDS='N',AD_COLUMNSORTORDER_ID=null,AD_COLUMNSORTYESNO_ID=null,ISSORTTAB='N',ENTITYTYPE='D',INCLUDED_TAB_ID=null,READONLYLOGIC=null,DISPLAYLOGIC=null,ISINSERTRECORD='Y',ISADVANCEDTAB='N' WHERE AD_TAB_ID=536;
UPDATE AD_TAB SET AD_CLIENT_ID=0,AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=0,NAME='User Mail',DESCRIPTION='Mail sent to the user',HELP='Archive of mails sent to users',AD_TABLE_ID=782,AD_WINDOW_ID=108,SEQNO=60,TABLEVEL=1,ISSINGLEROW='N',ISINFOTAB='N',ISTRANSLATIONTAB='N',ISREADONLY='Y',AD_COLUMN_ID=null,HASTREE='N',WHERECLAUSE=null,ORDERBYCLAUSE=null,COMMITWARNING=null,AD_PROCESS_ID=null,PROCESSING='N',AD_IMAGE_ID=null,IMPORTFIELDS='N',AD_COLUMNSORTORDER_ID=null,AD_COLUMNSORTYESNO_ID=null,ISSORTTAB='N',ENTITYTYPE='D',INCLUDED_TAB_ID=null,READONLYLOGIC=null,DISPLAYLOGIC=null,ISINSERTRECORD='N',ISADVANCEDTAB='Y' WHERE AD_TAB_ID=709;
UPDATE AD_SYSTEM SET AD_ORG_ID=0,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='?',USERNAME='?',INFO='?',VERSION='2006-11-02',RELEASENO='260a',SUPPORTUNITS=0,PASSWORD='?',REPLICATIONTYPE='L',IDRANGESTART=null,IDRANGEEND=null,LDAPHOST=null,CUSTOMPREFIX=null,ISJUSTMIGRATED='N',DBINSTANCE=null,DBADDRESS=null,NOPROCESSORS=null,SUMMARY=null,ENCRYPTIONKEY=null,LDAPDOMAIN=null,ISAUTOERRORREPORT='Y',RECORD_ID=null,PROCESSING=null,SUPPORTEMAIL=null,ISALLOWSTATISTICS='Y',STATISTICSINFO=null,PROFILEINFO=null,OLDNAME=null,DESCRIPTION=null,SYSTEMSTATUS='E' WHERE AD_SYSTEM_ID=0 AND AD_CLIENT_ID=0;
UPDATE R_INTERESTAREA SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Tree Planting',DESCRIPTION=null,ISSELFSERVICE='Y',VALUE='TreePanting' WHERE R_INTERESTAREA_ID=100;
UPDATE R_INTERESTAREA SET AD_CLIENT_ID=11,AD_ORG_ID=11,ISACTIVE='Y',CREATEDBY=100,UPDATEDBY=100,NAME='Lawn Care',DESCRIPTION=null,ISSELFSERVICE='Y',VALUE='LawnCare' WHERE R_INTERESTAREA_ID=101;
COMMIT;


-- NEW OR CHANGED FUNCTIONS/PROCEDURES
CREATE OR REPLACE FUNCTION daysBetween
(
    p_date1     DATE,
    p_date2     DATE
)
 	RETURN NUMBER
AS
BEGIN
    RETURN (TRUNC(p_date1) - TRUNC(p_date2));
END;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION currencyRound
(
	p_Amount		IN	NUMBER,
	p_CurTo_ID	IN	NUMBER,
	p_Costing		IN	VARCHAR2		--	Default 'N'
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Currency_Round.SQL,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Round amount for Traget Currency
 * Description:
 *		Round Amount using Costing or Standard Precision
 *		Returns unmodified amount if currency not found
 * Test:
 *		SELECT C_Currency_Round(C_Currency_Convert(100,116,100,null,null),100,null) FROM DUAL => 64.72 
 ************************************************************************/
AS
	v_StdPrecision		NUMBER;
	v_CostPrecision		NUMBER;
BEGIN
	--	Nothing to convert
	IF (p_Amount IS NULL OR p_CurTo_ID IS NULL) THEN
		RETURN p_Amount;
	END IF;

	--	Ger Precision
	SELECT	MAX(StdPrecision), MAX(CostingPrecision)
	  INTO	v_StdPrecision, v_CostPrecision
	FROM	C_Currency
	  WHERE	C_Currency_ID = p_CurTo_ID;
	--	Currency Not Found
	IF (v_StdPrecision IS NULL) THEN
		RETURN p_Amount;
	END IF;

	IF (p_Costing = 'Y') THEN
		RETURN ROUND (p_Amount, v_CostPrecision);
	END IF;

	RETURN ROUND (p_Amount, v_StdPrecision);
END currencyRound;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION paymentTermDiscount
(
	Amount			IN	NUMBER,
    Currency_ID     IN  NUMBER,
	PaymentTerm_ID	IN	NUMBER,
	DocDate			IN	DATE,
	PayDate			IN	DATE
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_PaymentTerm_Discount.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Discount
 * Description:
 *	Calculate the allowable Discount Amount of the Payment Term
 *
 *	Test:	SELECT C_PaymentTerm_Discount(17777, 103, '10-DEC-1999') FROM DUAL
 ************************************************************************/

AS
	Discount			NUMBER := 0;
	CURSOR Cur_PT	IS
		SELECT	*
		FROM	C_PaymentTerm
		WHERE	C_PaymentTerm_ID = PaymentTerm_ID;
	Discount1Date		DATE;
	Discount2Date		DATE;
	Add1Date			NUMBER := 0;
	Add2Date			NUMBER := 0;
BEGIN
	--	No Data - No Discount
	IF (Amount IS NULL OR PaymentTerm_ID IS NULL OR DocDate IS NULL) THEN
		RETURN 0;
	END IF;

	FOR p IN Cur_PT LOOP	--	for convineance only
--		DBMS_OUTPUT.PUT_LINE(p.Name || ' - Doc = ' || TO_CHAR(DocDate));
		Discount1Date := TRUNC(DocDate + p.DiscountDays + p.GraceDays);
		Discount2Date := TRUNC(DocDate + p.DiscountDays2 + p.GraceDays);

		--	Next Business Day
		IF (p.IsNextBusinessDay='Y') THEN
			--	Not fully correct - only does weekends (7=Saturday, 1=Sunday)
			SELECT 	DECODE(TO_CHAR(Discount1Date,'D'), '7',2, '1',1, 0),
					DECODE(TO_CHAR(Discount2Date,'D'), '7',2, '1',1, 0)
			  INTO	Add1Date, Add2Date
			FROM 	DUAL;
			Discount1Date := Discount1Date+Add1Date;
			Discount2Date := Discount2Date+Add2Date;
		END IF;

		--	Discount 1
		IF (Discount1Date >= TRUNC(PayDate)) THEN
--			DBMS_OUTPUT.PUT_LINE('Discount 1 ' || TO_CHAR(Discount1Date) || ' ' || p.Discount);
			Discount := Amount * p.Discount / 100;
		--	Discount 2
		ELSIF (Discount2Date >= TRUNC(PayDate)) THEN
--			DBMS_OUTPUT.PUT_LINE('Discount 2 ' || TO_CHAR(Discount2Date) || ' ' || p.Discount2);
			Discount := Amount * p.Discount2 / 100;
		END IF;	
	END LOOP;
	--
    RETURN ROUND(NVL(Discount,0), 2);	--	fixed rounding
END paymentTermDiscount;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION paymentTermDueDate
(
	PaymentTerm_ID	IN	NUMBER,
	DocDate			IN	DATE
)
RETURN DATE
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_PaymentTerm_DueDate.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Get Due Date
 * Description:
 *	Returns the due date
 ************************************************************************/
AS
 	Days				NUMBER := 0;
	DueDate				DATE := TRUNC(DocDate);
	--
	CURSOR Cur_PT	IS
		SELECT	*
		FROM	C_PaymentTerm
		WHERE	C_PaymentTerm_ID = PaymentTerm_ID;
	FirstDay			DATE;
	NoDays				NUMBER;
BEGIN
	FOR p IN Cur_PT LOOP	--	for convineance only
	--	DBMS_OUTPUT.PUT_LINE(p.Name || ' - Doc = ' || TO_CHAR(DocDate));
		--	Due 15th of following month
		IF (p.IsDueFixed = 'Y') THEN		
		--	DBMS_OUTPUT.PUT_LINE(p.Name || ' - Day = ' || p.FixMonthDay);
			FirstDay := TRUNC(DocDate, 'MM');
			NoDays := TRUNC(DocDate) - FirstDay;
			DueDate := FirstDay + (p.FixMonthDay-1);	--	starting on 1st
			DueDate := ADD_MONTHS(DueDate, p.FixMonthOffset);
			IF (NoDays > p.FixMonthCutoff) THEN
				DueDate := ADD_MONTHS(DueDate, 1);
			END IF;
		ELSE
		--	DBMS_OUTPUT.PUT_LINE('Net = ' || p.NetDays);
			DueDate := TRUNC(DocDate) + p.NetDays;
		END IF;
	END LOOP;
--	DBMS_OUTPUT.PUT_LINE('Due = ' || TO_CHAR(DueDate) || ', Pay = ' || TO_CHAR(PayDate));

	RETURN DueDate;
END paymentTermDueDate;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION paymentTermDueDays
(
	PaymentTerm_ID	IN	NUMBER,
	DocDate			IN	DATE,
	PayDate			IN	DATE
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_PaymentTerm_DueDays.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Get Due Days
 * Description:
 *	Returns the days due (positive) or the days till due (negative)
 *	Grace days are not considered!
 *	If record is not found it assumes due immediately
 *
 *	Test:	SELECT C_PaymentTerm_DueDays(103, '01-DEC-2000', '15-DEC-2000') FROM DUAL
 ************************************************************************/
AS
 	Days				NUMBER := 0;
	DueDate				DATE := TRUNC(DocDate);
	--
	CURSOR Cur_PT	IS
		SELECT	*
		FROM	C_PaymentTerm
		WHERE	C_PaymentTerm_ID = PaymentTerm_ID;
	FirstDay			DATE;
	NoDays				NUMBER;
BEGIN
	FOR p IN Cur_PT LOOP	--	for convineance only
	--	DBMS_OUTPUT.PUT_LINE(p.Name || ' - Doc = ' || TO_CHAR(DocDate));
		--	Due 15th of following month
		IF (p.IsDueFixed = 'Y') THEN		
		--	DBMS_OUTPUT.PUT_LINE(p.Name || ' - Day = ' || p.FixMonthDay);
			FirstDay := TRUNC(DocDate, 'MM');
			NoDays := TRUNC(DocDate) - FirstDay;
			DueDate := FirstDay + (p.FixMonthDay-1);	--	starting on 1st
			DueDate := ADD_MONTHS(DueDate, p.FixMonthOffset);
			IF (NoDays > p.FixMonthCutoff) THEN
				DueDate := ADD_MONTHS(DueDate, 1);
			END IF;
		ELSE
		--	DBMS_OUTPUT.PUT_LINE('Net = ' || p.NetDays);
			DueDate := TRUNC(DocDate) + p.NetDays;
		END IF;
	END LOOP;
--	DBMS_OUTPUT.PUT_LINE('Due = ' || TO_CHAR(DueDate) || ', Pay = ' || TO_CHAR(PayDate));

	Days := TRUNC(PayDate) - DueDate;
	RETURN Days;
END paymentTermDueDays;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION currencyRate
(
	p_CurFrom_ID		IN	NUMBER,
	p_CurTo_ID		    IN	NUMBER,
	p_ConvDate		    IN	DATE,
	p_ConversionType_ID	IN	NUMBER,
	p_Client_ID		    IN	NUMBER,
	p_Org_ID			IN	NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Currency_Rate.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Return Conversion Rate
 * Description:
 *		from CurrencyFrom_ID to CurrencyTo_ID
 *		Returns NULL, if rate not found
 * Test
 *		SELECT C_Currency_Rate(116, 100, null, null) FROM DUAL;     => .647169
 *		SELECT C_Currency_Rate(116, 100) FROM DUAL;                 => .647169
 ************************************************************************/
AS
	--	Currency From variables
	cf_IsEuro			CHAR(1);
	cf_IsEMUMember		CHAR(1);
	cf_EMUEntryDate	DATE;
	cf_EMURate		NUMBER;
	--	Currency To variables
	ct_IsEuro			CHAR(1);
	ct_IsEMUMember		CHAR(1);
	ct_EMUEntryDate	DATE;
	ct_EMURate		NUMBER;
	--	Triangle
	v_CurrencyFrom		NUMBER;
	v_CurrencyTo		NUMBER;
	v_CurrencyEuro		NUMBER;
	--
	v_ConvDate		    DATE := SysDate;
	v_ConversionType_ID	NUMBER := 0;
	v_Rate			    NUMBER;
BEGIN
	--	No Conversion
	IF (p_CurFrom_ID = p_CurTo_ID) THEN
		RETURN 1;
	END IF;
	--	Default Date Parameter
	IF (p_ConvDate IS NOT NULL) THEN
		v_ConvDate := p_ConvDate;   --  SysDate
	END IF;
    --  Default Conversion Type
	IF (p_ConversionType_ID IS NULL OR p_ConversionType_ID = 0) THEN
        BEGIN
            SELECT C_ConversionType_ID 
              INTO v_ConversionType_ID
            FROM C_ConversionType 
            WHERE IsDefault='Y'
              AND AD_Client_ID IN (0,p_Client_ID)
              AND ROWNUM=1
            ORDER BY AD_Client_ID DESC;
        EXCEPTION WHEN OTHERS THEN
            DBMS_OUTPUT.PUT_LINE('Conversion Type Not Found');
        END;
    ELSE
        v_ConversionType_ID := p_ConversionType_ID;
	END IF;

	--	Get Currency Info
	SELECT	MAX(IsEuro), MAX(IsEMUMember), MAX(EMUEntryDate), MAX(EMURate)
	  INTO	cf_IsEuro, cf_IsEMUMember, cf_EMUEntryDate, cf_EMURate
	FROM		C_Currency
	  WHERE	C_Currency_ID = p_CurFrom_ID;
	-- Not Found
	IF (cf_IsEuro IS NULL) THEN
		DBMS_OUTPUT.PUT_LINE('From Currency Not Found');
		RETURN NULL;
	END IF;
	SELECT	MAX(IsEuro), MAX(IsEMUMember), MAX(EMUEntryDate), MAX(EMURate)
	  INTO	ct_IsEuro, ct_IsEMUMember, ct_EMUEntryDate, ct_EMURate
	FROM		C_Currency
	  WHERE	C_Currency_ID = p_CurTo_ID;
	-- Not Found
	IF (ct_IsEuro IS NULL) THEN
		DBMS_OUTPUT.PUT_LINE('To Currency Not Found');
		RETURN NULL;
	END IF;

	--	Fixed - From Euro to EMU
	IF (cf_IsEuro = 'Y' AND ct_IsEMUMember ='Y' AND v_ConvDate >= ct_EMUEntryDate) THEN
		RETURN ct_EMURate;
	END IF;

	--	Fixed - From EMU to Euro
	IF (ct_IsEuro = 'Y' AND cf_IsEMUMember ='Y' AND v_ConvDate >= cf_EMUEntryDate) THEN
		RETURN 1 / cf_EMURate;
	END IF;

	--	Fixed - From EMU to EMU
	IF (cf_IsEMUMember = 'Y' AND cf_IsEMUMember ='Y'
			AND v_ConvDate >= cf_EMUEntryDate AND v_ConvDate >= ct_EMUEntryDate) THEN
		RETURN ct_EMURate / cf_EMURate;
	END IF;

	--	Flexible Rates
	v_CurrencyFrom := p_CurFrom_ID;
	v_CurrencyTo := p_CurTo_ID;

	-- if EMU Member involved, replace From/To Currency
	IF ((cf_isEMUMember = 'Y' AND v_ConvDate >= cf_EMUEntryDate)
	  OR (ct_isEMUMember = 'Y' AND v_ConvDate >= ct_EMUEntryDate)) THEN
		SELECT	MAX(C_Currency_ID)
		  INTO	v_CurrencyEuro
		FROM		C_Currency
		WHERE	IsEuro = 'Y';
		-- Conversion Rate not Found
		IF (v_CurrencyEuro IS NULL) THEN
			DBMS_OUTPUT.PUT_LINE('Euro Not Found');
			RETURN NULL;
		END IF;
		IF (cf_isEMUMember = 'Y' AND v_ConvDate >= cf_EMUEntryDate) THEN
			v_CurrencyFrom := v_CurrencyEuro;
		ELSE
			v_CurrencyTo := v_CurrencyEuro;
		END IF;
	END IF;

	--	Get Rate
	DECLARE
		CURSOR	CUR_Rate	IS
			SELECT	MultiplyRate
			FROM	C_Conversion_Rate
			WHERE	C_Currency_ID=v_CurrencyFrom AND C_Currency_ID_To=v_CurrencyTo
			  AND	C_ConversionType_ID=v_ConversionType_ID
			  AND	v_ConvDate BETWEEN ValidFrom AND ValidTo
			  AND	AD_Client_ID IN (0,p_Client_ID) AND AD_Org_ID IN (0,p_Org_ID)
			ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC;
	BEGIN
		FOR c IN CUR_Rate LOOP
			v_Rate := c.MultiplyRate;
			EXIT;	--	only first
		END LOOP;
	END;
	--	Not found
	IF (v_Rate IS NULL) THEN
		DBMS_OUTPUT.PUT_LINE('Conversion Rate Not Found');
		RETURN NULL;
	END IF;

	--	Currency From was EMU
	IF (cf_isEMUMember = 'Y' AND v_ConvDate >= cf_EMUEntryDate) THEN
		RETURN v_Rate / cf_EMURate;
	END IF;

	--	Currency To was EMU
	IF (ct_isEMUMember = 'Y' AND v_ConvDate >= ct_EMUEntryDate) THEN
		RETURN v_Rate * ct_EMURate;
	END IF;

	RETURN v_Rate;

EXCEPTION WHEN OTHERS THEN
	DBMS_OUTPUT.PUT_LINE(SQLERRM);
	RETURN NULL;

END currencyRate;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION currencyConvert
(
	p_Amount			IN	NUMBER,
	p_CurFrom_ID		IN	NUMBER,
	p_CurTo_ID		    IN	NUMBER,
	p_ConvDate		    IN	DATE,
	p_ConversionType_ID IN	NUMBER,
	p_Client_ID		    IN	NUMBER,
	p_Org_ID			IN	NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Currency_Convert.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Convert Amount (using IDs)
 * Description:
 *		from CurrencyFrom_ID to CurrencyTo_ID
 *		Returns NULL, if conversion not found
 *		Standard Rounding
 * Test:
 *		SELECT C_Currency_Convert(100,116,100,null,null) FROM DUAL  => 64.72
 *		SELECT C_Currency_Convert(100,116,100) FROM DUAL            => 64.72
 ************************************************************************/
AS
	v_Rate				NUMBER;
BEGIN
	--	Return Amount
	IF (p_Amount = 0 OR p_CurFrom_ID = p_CurTo_ID) THEN
		RETURN p_Amount;
	END IF;
	--	Return NULL
	IF (p_Amount IS NULL OR p_CurFrom_ID IS NULL OR p_CurTo_ID IS NULL) THEN
		RETURN NULL;
	END IF;

	--	Get Rate
	v_Rate := currencyRate (p_CurFrom_ID, p_CurTo_ID, p_ConvDate, p_ConversionType_ID, p_Client_ID, p_Org_ID);
	IF (v_Rate IS NULL) THEN
		RETURN NULL;
	END IF;

	--	Standard Precision
	RETURN currencyRound(p_Amount * v_Rate, p_CurTo_ID, null);	
END currencyConvert;
/

SHOW ERRORS;
CREATE OR REPLACE FUNCTION acctBalance
(
    p_Account_ID    IN NUMBER,
    p_AmtDr         IN NUMBER,
    p_AmtCr         IN NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2004 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: Acct_Balance.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Aclculate Balance based on Account Sign + Type
 * Description:
 *  If an account is specified and found
 *  - If the account sign is Natural it sets it based on Account Type
 *  Returns Credit or Debit Balance
 * Test:
    SELECT Acct_Balance (0,11,22) FROM DUAL
    SELECT AccountType, AccountSign, 
        Acct_Balance(C_ElementValue_ID, 20, 10) "DR Balance",
        Acct_Balance(C_ElementValue_ID, 10, 20) "CR Balance"
    FROM C_ElementValue
    WHERE AccountSign<>'N'
    ORDER BY AccountSign
 ************************************************************************/
AS
    v_balance           NUMBER;
    v_AccountType       C_ElementValue.AccountType%TYPE;
    v_AccountSign       C_ElementValue.AccountSign%TYPE;
BEGIN
    v_balance := p_AmtDr - p_AmtCr;
    --  
    IF (p_Account_ID > 0) THEN
        SELECT AccountType, AccountSign
          INTO v_AccountType, v_AccountSign
        FROM C_ElementValue
        WHERE C_ElementValue_ID=p_Account_ID;
   --   DBMS_OUTPUT.PUT_LINE('Type=' || v_AccountType || ' - Sign=' || v_AccountSign);
        --  Natural Account Sign
        IF (v_AccountSign='N') THEN
            IF (v_AccountType IN ('A','E')) THEN
                v_AccountSign := 'D';
            ELSE
                v_AccountSign := 'C';
            END IF;
        --  DBMS_OUTPUT.PUT_LINE('Type=' || v_AccountType || ' - Sign=' || v_AccountSign);
        END IF;
        --  Debit Balance
        IF (v_AccountSign = 'C') THEN
            v_balance := p_AmtCr - p_AmtDr;
        END IF;
    END IF;
    --
    RETURN v_balance;
EXCEPTION WHEN OTHERS THEN
    -- In case Acct not found
    RETURN  p_AmtDr - p_AmtCr;
END acctBalance;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION currencyBase
(
	p_Amount			IN	NUMBER,
	p_CurFrom_ID		IN	NUMBER,
	p_ConvDate			IN	DATE,
	p_Client_ID			IN	NUMBER,
	p_Org_ID			IN NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Base_Convert.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Convert Amount to Base Currency of Client
 * Description:
 *		Get CurrencyTo from Client
 *		Returns NULL, if conversion not found
 *		Standard Rounding
 * Test:
 *		SELECT C_Base_Convert(100,116,11,null) FROM DUAL => 64.72
 ************************************************************************/
AS
	v_CurTo_ID			NUMBER;
BEGIN
	--	Get Currency
	SELECT	MAX(ac.C_Currency_ID)
	  INTO	v_CurTo_ID
	FROM	AD_ClientInfo ci, C_AcctSchema ac
	WHERE	ci.C_AcctSchema1_ID=ac.C_AcctSchema_ID
	  AND	ci.AD_Client_ID=p_Client_ID;
	--	Same as Currency_Conversion - if currency/rate not found - return 0
	IF (v_CurTo_ID IS NULL) THEN
		RETURN NULL;
	END IF;
	--	Same currency
	IF (p_CurFrom_ID = v_CurTo_ID) THEN
		RETURN p_Amount;
	END IF;

	RETURN currencyConvert (p_Amount, p_CurFrom_ID, v_CurTo_ID, p_ConvDate, null, p_Client_ID, p_Org_ID);
END currencyBase;
/

SHOW ERRORS;

CREATE OR REPLACE FUNCTION productAttribute
(
    p_M_AttributeSetInstance_ID     IN NUMBER
)
RETURN NVARCHAR2
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: M_Attribute_Name.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Return Instance Attribute Info
 * Description:
 *		
 * Test:
    SELECT M_Attribute_Name (M_AttributeSetInstance_ID) 
    FROM M_InOutLine WHERE M_AttributeSetInstance_ID > 0
    --
    SELECT p.Name
    FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID);
    SELECT p.Name || M_Attribute_Name (il.M_AttributeSetInstance_ID) 
    FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID);
    
 ************************************************************************/
AS
    v_Name          NVARCHAR2(2000) := NULL;
    v_NameAdd       NVARCHAR2(2000) := '';
    --
    v_Lot           M_AttributeSetInstance.Lot%TYPE;
    v_LotStart      M_AttributeSet.LotCharSOverwrite%TYPE;
    v_LotEnd        M_AttributeSet.LotCharEOverwrite%TYPE;
    v_SerNo         M_AttributeSetInstance.SerNo%TYPE;
    v_SerNoStart    M_AttributeSet.SerNoCharSOverwrite%TYPE;
    v_SerNoEnd      M_AttributeSet.SerNoCharEOverwrite%TYPE;
    v_GuaranteeDate M_AttributeSetInstance.GuaranteeDate%TYPE;
    --
    CURSOR CUR_Attributes IS
        SELECT ai.Value, a.Name
        FROM M_AttributeInstance ai
          INNER JOIN M_Attribute a ON (ai.M_Attribute_ID=a.M_Attribute_ID AND a.IsInstanceAttribute='Y')
        WHERE ai.M_AttributeSetInstance_ID=p_M_AttributeSetInstance_ID;

BEGIN
/*    --  Get Product Name
    SELECT Name 
      INTO v_Name
    FROM M_Product WHERE M_Product_ID=p_M_Product_ID;
*/
    --  Get Product Attribute Set Instance
    IF (p_M_AttributeSetInstance_ID > 0) THEN
        SELECT asi.Lot, asi.SerNo, asi.GuaranteeDate,
            COALESCE(a.SerNoCharSOverwrite, N'#'), COALESCE(a.SerNoCharEOverwrite, N''),
            COALESCE(a.LotCharSOverwrite, N''), COALESCE(a.LotCharEOverwrite, N'')
          INTO v_Lot, v_SerNo, v_GuaranteeDate,
            v_SerNoStart, v_SerNoEnd, v_LotStart, v_LotEnd
        FROM M_AttributeSetInstance asi
          INNER JOIN M_AttributeSet a ON (asi.M_AttributeSet_ID=a.M_AttributeSet_ID)
        WHERE asi.M_AttributeSetInstance_ID=p_M_AttributeSetInstance_ID;
        --
        IF (v_SerNo IS NOT NULL) THEN
            v_NameAdd := v_NameAdd || v_SerNoStart || v_SerNo || v_SerNoEnd || ' ';
        END IF;
        IF (v_Lot IS NOT NULL) THEN
            v_NameAdd := v_NameAdd || v_LotStart || v_Lot || v_LotEnd || ' ';
        END IF;
        IF (v_GuaranteeDate IS NOT NULL) THEN
            v_NameAdd := v_NameAdd || v_GuaranteeDate || ' ';
        END IF;
        --
        FOR a IN CUR_Attributes LOOP
            v_NameAdd := v_NameAdd || a.Name || ':' || a.Value || ' ';
        END LOOP;
        --
        IF (LENGTH(v_NameAdd) > 0) THEN
            v_Name := v_Name || ' (' || TRIM(v_NameAdd) || ')';
        END IF;
    END IF;
    
    RETURN v_Name;
END productAttribute;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bpartnerRemitLocation
(
	p_C_BPartner_ID	  C_BPartner.C_BPartner_ID%TYPE
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2002 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_BPartner_RemitLocation.SQL,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:   Return the first RemitTo C_Location_ID of a Business Partner
 * Description:
 *      
 ************************************************************************/
AS
	v_C_Location_ID			NUMBER := NULL;
	CURSOR	CUR_BPLoc	IS
		SELECT	IsRemitTo, C_Location_ID
		FROM	C_BPartner_Location
		WHERE	C_BPartner_ID=p_C_BPartner_ID
		ORDER BY IsRemitTo DESC;
BEGIN
	FOR l IN CUR_BPLoc LOOP
		IF (v_C_Location_ID IS NULL) THEN
			v_C_Location_ID := l.C_Location_ID;
		END IF;
	END LOOP;
	RETURN v_C_Location_ID;
END bpartnerRemitLocation;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomQtyOrdered
(
	p_Product_ID 		IN NUMBER,
    p_Warehouse_ID		IN NUMBER,
	p_Locator_ID		IN NUMBER	--	Only used, if warehouse is null
)
RETURN NUMBER
/******************************************************************************
 * ** Compiere Product **             Copyright (c) 1999-2001 Accorto, Inc. USA
 * Open  Source  Software        Provided "AS IS" without warranty or liability
 * When you use any parts (changed or unchanged), add  "Powered by Compiere" to
 * your product name;  See license details http://www.compiere.org/license.html
 ******************************************************************************
 *	Return quantity ordered for BOM
 */
AS
	v_Warehouse_ID		NUMBER;
 	v_Quantity			NUMBER := 99999;	--	unlimited
	v_IsBOM				CHAR(1);
	v_IsStocked			CHAR(1);
	v_ProductType		CHAR(1);
 	v_ProductQty		NUMBER;
	v_StdPrecision		NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM, p.IsStocked, p.ProductType
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=p_Product_ID;
	--
BEGIN
	--	Check Parameters
	v_Warehouse_ID := p_Warehouse_ID;
	IF (v_Warehouse_ID IS NULL) THEN
		IF (p_Locator_ID IS NULL) THEN
			RETURN 0;
		ELSE
			SELECT 	MAX(M_Warehouse_ID) INTO v_Warehouse_ID
			FROM	M_Locator
			WHERE	M_Locator_ID=p_Locator_ID;
		END IF;
	END IF;
	IF (v_Warehouse_ID IS NULL) THEN
		RETURN 0;
	END IF;
--	DBMS_OUTPUT.PUT_LINE('Warehouse=' || v_Warehouse_ID);

	--	Check, if product exists and if it is stocked
	BEGIN
		SELECT	IsBOM, ProductType, IsStocked
		  INTO	v_IsBOM, v_ProductType, v_IsStocked
		FROM 	M_Product
		WHERE 	M_Product_ID=p_Product_ID;
		--
	EXCEPTION	--	not found
		WHEN OTHERS THEN
			RETURN 0;
	END;

	--	No reservation for non-stocked
	IF (v_IsBOM='N' AND (v_ProductType<>'I' OR v_IsStocked='N')) THEN
		RETURN 0;
	--	Stocked item
	ELSIF (v_IsStocked='Y') THEN
		--	Get ProductQty
		SELECT 	NVL(SUM(QtyOrdered), 0)
		  INTO	v_ProductQty
		FROM 	M_Storage s
		WHERE 	M_Product_ID=p_Product_ID
		  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
		  	AND l.M_Warehouse_ID=v_Warehouse_ID);
		--
		RETURN v_ProductQty;
	END IF;

	--	Go though BOM
--	DBMS_OUTPUT.PUT_LINE('BOM');
	FOR bom IN CUR_BOM LOOP
		--	Stocked Items "leaf node"
		IF (bom.ProductType = 'I' AND bom.IsStocked = 'Y') THEN
			--	Get ProductQty
			SELECT 	NVL(SUM(QtyOrdered), 0)
			  INTO	v_ProductQty
			FROM 	M_Storage s
			WHERE 	M_Product_ID=bom.M_ProductBOM_ID
			  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
			  	AND l.M_Warehouse_ID=v_Warehouse_ID);
			--	Get Rounding Precision
			SELECT 	NVL(MAX(u.StdPrecision), 0)
			  INTO	v_StdPrecision
			FROM 	C_UOM u, M_Product p 
			WHERE 	u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=bom.M_ProductBOM_ID;
			--	How much can we make with this product
			v_ProductQty := ROUND (v_ProductQty/bom.BOMQty, v_StdPrecision);
			--	How much can we make overall
			IF (v_ProductQty < v_Quantity) THEN
				v_Quantity := v_ProductQty;
			END IF;
		--	Another BOM
		ELSIF (bom.IsBOM = 'Y') THEN
			v_ProductQty := bomQtyOrdered (bom.M_ProductBOM_ID, v_Warehouse_ID, p_Locator_ID);
			--	How much can we make overall
			IF (v_ProductQty < v_Quantity) THEN
				v_Quantity := v_ProductQty;
			END IF;
		END IF;
	END LOOP;	--	BOM

	--	Unlimited (e.g. only services)
	IF (v_Quantity = 99999) THEN
		RETURN 0;
	END IF;

	IF (v_Quantity > 0) THEN
		--	Get Rounding Precision for Product
		SELECT 	NVL(MAX(u.StdPrecision), 0)
		  INTO	v_StdPrecision
		FROM 	C_UOM u, M_Product p 
		WHERE 	u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=p_Product_ID;
		--
		RETURN ROUND (v_Quantity, v_StdPrecision);
	END IF;
	--
	RETURN 0;
END bomQtyOrdered;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION paymentAvailable
(
	p_C_Payment_ID	IN	NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Payment_Available.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Available Payment Amount in Payment Currency
 * Description:
 *		similar to C_Invoice_Open
 ************************************************************************/
AS
	v_Currency_ID		NUMBER(10);
	v_AvailableAmt		NUMBER := 0;
    v_IsReceipt         C_Payment.IsReceipt%TYPE;
    v_Amt               NUMBER := 0;
	CURSOR	Cur_Alloc	IS
		SELECT	a.AD_Client_ID, a.AD_Org_ID, al.Amount, a.C_Currency_ID, a.DateTrx
		FROM	C_AllocationLine al
          INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID=a.C_AllocationHdr_ID)
		WHERE	al.C_Payment_ID = p_C_Payment_ID
          AND   a.IsActive='Y';
		--  AND	al.C_Invoice_ID IS NOT NULL;
BEGIN
    --  Charge - fully allocated
    SELECT MAX(PayAmt) 
      INTO v_Amt
    FROM C_Payment 
    WHERE C_Payment_ID=p_C_Payment_ID AND C_Charge_ID > 0;
    IF (v_Amt IS NOT NULL) THEN
        RETURN v_Amt;
    END IF;

	--	Get Currency
	SELECT	C_Currency_ID, PayAmt, IsReceipt
	  INTO	v_Currency_ID, v_AvailableAmt, v_IsReceipt
	FROM	C_Payment_v     -- corrected for AP/AR
	WHERE	C_Payment_ID = p_C_Payment_ID;
--  DBMS_OUTPUT.PUT_LINE('== C_Payment_ID=' || p_C_Payment_ID || ', PayAmt=' || v_AvailableAmt || ', Receipt=' || v_IsReceipt);

	--	Calculate Allocated Amount
	FOR a IN Cur_Alloc LOOP
        v_Amt := currencyConvert(a.Amount, a.C_Currency_ID, v_Currency_ID, a.DateTrx, null, a.AD_Client_ID, a.AD_Org_ID);
	    v_AvailableAmt := v_AvailableAmt - v_Amt;
--      DBMS_OUTPUT.PUT_LINE('  Allocation=' || a.Amount || ' - Available=' || v_AvailableAmt);
	END LOOP;
	--	Ignore Rounding
	IF (v_AvailableAmt BETWEEN -0.00999 AND 0.00999) THEN
		v_AvailableAmt := 0;
	END IF;
	--	Round to penny
	v_AvailableAmt := ROUND(NVL(v_AvailableAmt,0), 2);
	RETURN	v_AvailableAmt;
END paymentAvailable;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomQtyOnHand
( 
	Product_ID 		IN NUMBER,
    Warehouse_ID	IN NUMBER,
	Locator_ID		IN NUMBER	--	Only used, if warehouse is null
)
RETURN NUMBER
/******************************************************************************
 * ** Compiere Product **             Copyright (c) 1999-2001 Accorto, Inc. USA
 * Open  Source  Software        Provided "AS IS" without warranty or liability
 * When you use any parts (changed or unchanged), add  "Powered by Compiere" to
 * your product name;  See license details http://www.compiere.org/license.html
 ******************************************************************************
 *	Return quantity on hand for BOM
 */
AS
	myWarehouse_ID	NUMBER;
 	Quantity		NUMBER := 99999;	--	unlimited
	IsBOM			CHAR(1);
	IsStocked		CHAR(1);
	ProductType		CHAR(1);
 	ProductQty		NUMBER;
	StdPrecision	NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM, p.IsStocked, p.ProductType
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=Product_ID;
	--
BEGIN
	--	Check Parameters
	myWarehouse_ID := Warehouse_ID;
	IF (myWarehouse_ID IS NULL) THEN
		IF (Locator_ID IS NULL) THEN
			RETURN 0;
		ELSE
			SELECT 	SUM(M_Warehouse_ID) INTO myWarehouse_ID
			FROM	M_Locator
			WHERE	M_Locator_ID=Locator_ID;
		END IF;
	END IF;
	IF (myWarehouse_ID IS NULL) THEN
		RETURN 0;
	END IF;
--	DBMS_OUTPUT.PUT_LINE('Warehouse=' || myWarehouse_ID);

	--	Check, if product exists and if it is stocked
	BEGIN
		SELECT	IsBOM, ProductType, IsStocked
	 	  INTO	IsBOM, ProductType, IsStocked
		FROM M_Product
		WHERE M_Product_ID=Product_ID;
		--
	EXCEPTION	--	not found
		WHEN OTHERS THEN
			RETURN 0;
	END;
	--	Unimited capacity if no item
	IF (IsBOM='N' AND (ProductType<>'I' OR IsStocked='N')) THEN
		RETURN Quantity;
	--	Stocked item
	ELSIF (IsStocked='Y') THEN
		--	Get ProductQty
		SELECT 	NVL(SUM(QtyOnHand), 0)
		  INTO	ProductQty
		FROM 	M_Storage s
		WHERE M_Product_ID=Product_ID
		  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
		  	AND l.M_Warehouse_ID=myWarehouse_ID);
		--
	--	DBMS_OUTPUT.PUT_LINE('Qty=' || ProductQty);
		RETURN ProductQty;
	END IF;

	--	Go though BOM
--	DBMS_OUTPUT.PUT_LINE('BOM');
	FOR bom IN CUR_BOM LOOP
		--	Stocked Items "leaf node"
		IF (bom.ProductType = 'I' AND bom.IsStocked = 'Y') THEN
			--	Get ProductQty
			SELECT 	NVL(SUM(QtyOnHand), 0)
			  INTO	ProductQty
			FROM 	M_Storage s
			WHERE M_Product_ID=bom.M_ProductBOM_ID
			  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
			  	AND l.M_Warehouse_ID=myWarehouse_ID);
			--	Get Rounding Precision
			SELECT 	NVL(MAX(u.StdPrecision), 0)
			  INTO	StdPrecision
			FROM 	C_UOM u, M_Product p 
			WHERE u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=bom.M_ProductBOM_ID;
			--	How much can we make with this product
			ProductQty := ROUND (ProductQty/bom.BOMQty, StdPrecision);
			--	How much can we make overall
			IF (ProductQty < Quantity) THEN
				Quantity := ProductQty;
			END IF;
		--	Another BOM
		ELSIF (bom.IsBOM = 'Y') THEN
			ProductQty := bomQtyOnHand (bom.M_ProductBOM_ID, myWarehouse_ID, Locator_ID);
			--	How much can we make overall
			IF (ProductQty < Quantity) THEN
				Quantity := ProductQty;
			END IF;
		END IF;
	END LOOP;	--	BOM

	IF (Quantity > 0) THEN
		--	Get Rounding Precision for Product
		SELECT 	NVL(MAX(u.StdPrecision), 0)
		  INTO	StdPrecision
		FROM 	C_UOM u, M_Product p 
		WHERE u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=Product_ID;
		--
		RETURN ROUND (Quantity, StdPrecision);
	END IF;
	RETURN 0;
END bomQtyOnHand;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomPriceLimit
( 
	Product_ID 				IN NUMBER,
	PriceList_Version_ID	IN NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2002 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: BOM_PriceLimit.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Return Limit Price of Product/BOM
 * Description:
 *			if not found: 0
 ************************************************************************/
AS
	v_Price			NUMBER;
	v_ProductPrice	NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=Product_ID;
	--
BEGIN
	--	Try to get price from PriceList directly
	SELECT	COALESCE (SUM(PriceLimit), 0)
      INTO	v_Price
   	FROM	M_ProductPrice
	WHERE M_PriceList_Version_ID=PriceList_Version_ID AND M_Product_ID=Product_ID;
--	DBMS_OUTPUT.PUT_LINE('Price=' || v_Price);

	--	No Price - Check if BOM
	IF (v_Price = 0) THEN
		FOR bom IN CUR_BOM LOOP
			v_ProductPrice := bomPriceLimit (bom.M_ProductBOM_ID, PriceList_Version_ID);
			v_Price := v_Price + (bom.BOMQty * v_ProductPrice);
		END LOOP;	
	END IF;
	--
	RETURN v_Price;
END bomPriceLimit;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomPriceList
( 
	Product_ID 				IN NUMBER,
	PriceList_Version_ID	IN NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2002 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: BOM_PriceList.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Return List Price of Product/BOM
 * Description:
 *			if not found: 0
 ************************************************************************/
AS
	v_Price			NUMBER;
	v_ProductPrice	NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=Product_ID;
	--
BEGIN
	--	Try to get price from pricelist directly
	SELECT	COALESCE (SUM(PriceList), 0)
      INTO	v_Price
   	FROM	M_ProductPrice
	WHERE M_PriceList_Version_ID=PriceList_Version_ID AND M_Product_ID=Product_ID;
--	DBMS_OUTPUT.PUT_LINE('Price=' || Price);

	--	No Price - Check if BOM
	IF (v_Price = 0) THEN
		FOR bom IN CUR_BOM LOOP
			v_ProductPrice := bomPriceList (bom.M_ProductBOM_ID, PriceList_Version_ID);
			v_Price := v_Price + (bom.BOMQty * v_ProductPrice);
		--	DBMS_OUTPUT.PUT_LINE('Qry=' || bom.BOMQty || ' @ ' || v_ProductPrice || ', Price=' || v_Price);
		END LOOP;	--	BOM
	END IF;
	--
	RETURN v_Price;
END bomPriceList;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomPriceStd
( 
	Product_ID 				IN NUMBER,
	PriceList_Version_ID	IN NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2002 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: BOM_PriceStd.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Return Standard Price of Product/BOM
 * Description:
 *			if not found: 0
 ************************************************************************/
AS
	v_Price			NUMBER;
	v_ProductPrice	NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=Product_ID;
	--
BEGIN
	--	Try to get price from pricelist directly
	SELECT	COALESCE(SUM(PriceStd), 0)
      INTO	v_Price
   	FROM	M_ProductPrice
	WHERE M_PriceList_Version_ID=PriceList_Version_ID AND M_Product_ID=Product_ID;
--	DBMS_OUTPUT.PUT_LINE('Price=' || v_Price);

	--	No Price - Check if BOM
	IF (v_Price = 0) THEN
		FOR bom IN CUR_BOM LOOP
			v_ProductPrice := bomPriceStd (bom.M_ProductBOM_ID, PriceList_Version_ID);
			v_Price := v_Price + (bom.BOMQty * v_ProductPrice);
		--	DBMS_OUTPUT.PUT_LINE('Price=' || v_Price);
		END LOOP;	--	BOM
	END IF;
	--
	RETURN v_Price;
END bomPriceStd;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomQtyAvailable
( 
	Product_ID 		IN NUMBER,
    Warehouse_ID	IN NUMBER,
	Locator_ID		IN NUMBER	--	Only used, if warehouse is null
)
RETURN NUMBER
/******************************************************************************
 * ** Compiere Product **             Copyright (c) 1999-2001 Accorto, Inc. USA
 * Open  Source  Software        Provided "AS IS" without warranty or liability
 * When you use any parts (changed or unchanged), add  "Powered by Compiere" to
 * your product name;  See license details http://www.compiere.org/license.html
 ******************************************************************************
 *	Return quantity available for BOM
 */
AS
BEGIN
	RETURN bomQtyOnHand(Product_ID, Warehouse_ID, Locator_ID)
		- bomQtyReserved(Product_ID, Warehouse_ID, Locator_ID);
END bomQtyAvailable;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION invoiceDiscount
(
	p_C_Invoice_ID		        IN NUMBER,
	p_PayDate			        IN	DATE,
	p_C_InvoicePaySchedule_ID	IN	NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Invoice_Discount.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Payment Discount Amount
 * Description:
 *			- Calculate discountable amount (i.e. with or without tax)
 *			- Calculate and return payment discount
 ************************************************************************/
AS
	v_Amount			NUMBER;
	v_IsDiscountLineAmt	CHAR(1);
	v_GrandTotal		NUMBER;
	v_TotalLines		NUMBER;
	v_C_PaymentTerm_ID	NUMBER(10);
	v_DocDate			DATE;
	v_PayDate			DATE := SysDate;
    v_IsPayScheduleValid    CHAR(1);

BEGIN
	SELECT 	ci.IsDiscountLineAmt, i.GrandTotal, i.TotalLines,
		i.C_PaymentTerm_ID, i.DateInvoiced, i.IsPayScheduleValid
	  INTO 	v_IsDiscountLineAmt, v_GrandTotal, v_TotalLines,
		v_C_PaymentTerm_ID, v_DocDate, v_IsPayScheduleValid
	FROM 	AD_ClientInfo ci, C_Invoice i
	WHERE 	ci.AD_Client_ID=i.AD_Client_ID
	  AND 	i.C_Invoice_ID=p_C_Invoice_ID;
	--	What Amount is the Discount Base?
 	IF (v_IsDiscountLineAmt = 'Y') THEN
		v_Amount := v_TotalLines;
	ELSE
		v_Amount := v_GrandTotal;
	END IF;

	--	Anything to discount?
	IF (v_Amount = 0) THEN
		RETURN 0;
   	END IF;
	IF (p_PayDate IS NOT NULL) THEN
		v_PayDate := p_PayDate;
  	END IF;

    --  Valid Payment Schedule
    IF (v_IsPayScheduleValid='Y' AND p_C_InvoicePaySchedule_ID > 0) THEN
        SELECT COALESCE(MAX(DiscountAmt),0)
          INTO v_Amount
        FROM C_InvoicePaySchedule
        WHERE C_InvoicePaySchedule_ID=p_C_InvoicePaySchedule_ID
          AND DiscountDate <= v_PayDate;
        --
        RETURN v_Amount;
    END IF;

	--	return discount amount	
	RETURN paymentTermDiscount (v_Amount, 0, v_C_PaymentTerm_ID, v_DocDate, p_PayDate);

--	Most likely if invoice not found
EXCEPTION
	WHEN OTHERS THEN
		RETURN NULL;
END invoiceDiscount;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION invoiceOpen
(
	p_C_Invoice_ID	            IN	NUMBER,
    p_C_InvoicePaySchedule_ID   IN  NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Invoice_Open.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Open Item Amount in Invoice Currency 
 * Description:
 *	Add up total amount open for C_Invoice_ID if no split payment.
 *  Grand Total minus Sum of Allocations in Invoice Currency
 *
 *  For Split Payments:
 *  Allocate Payments starting from first schedule.

SELECT C_Invoice_Open (109) FROM DUAL;
SELECT C_Invoice_Open (109, null) FROM DUAL;
SELECT C_Invoice_Open (109, 11) FROM DUAL;
SELECT C_Invoice_Open (109, 102) FROM DUAL;
SELECT C_Invoice_Open (109, 103) FROM DUAL;
SELECT * FROM RV_OpenItem WHERE C_Invoice_ID=109;
SELECT C_InvoicePaySchedule_ID, DueAmt FROM C_InvoicePaySchedule WHERE C_Invoice_ID=109 ORDER BY DueDate;

 *  Cannot be used for IsPaid as mutating
 ************************************************************************/
AS
	v_Currency_ID		NUMBER(10);
	v_TotalOpenAmt  	NUMBER := 0;
	v_PaidAmt  	        NUMBER := 0;
	v_Remaining	        NUMBER := 0;
    v_MultiplierAP      NUMBER := 0;
    v_MultiplierCM      NUMBER := 0;
    v_Temp              NUMBER := 0;
    --
	CURSOR	Cur_Alloc	IS
		SELECT	a.AD_Client_ID, a.AD_Org_ID, 
            al.Amount, al.DiscountAmt, al.WriteOffAmt, 
            a.C_Currency_ID, a.DateTrx
		FROM	C_AllocationLine al
          INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID=a.C_AllocationHdr_ID)
		WHERE	al.C_Invoice_ID = p_C_Invoice_ID
          AND   a.IsActive='Y';
    --
	CURSOR	Cur_PaySchedule	IS
        SELECT  C_InvoicePaySchedule_ID, DueAmt 
        FROM    C_InvoicePaySchedule 
		WHERE	C_Invoice_ID = p_C_Invoice_ID
          AND   IsValid='Y'
        ORDER BY DueDate;

BEGIN
	--	Get Currency
	BEGIN
		SELECT	MAX(C_Currency_ID), SUM(GrandTotal), MAX(MultiplierAP), MAX(Multiplier)
		  INTO	v_Currency_ID, v_TotalOpenAmt, v_MultiplierAP, v_MultiplierCM
		FROM	C_Invoice_v		--	corrected for CM / Split Payment
		WHERE	C_Invoice_ID = p_C_Invoice_ID;
	EXCEPTION	--	Invoice in draft form
		WHEN OTHERS THEN
            DBMS_OUTPUT.PUT_LINE('InvoiceOpen - ' || SQLERRM);
			RETURN NULL;
	END;
--  DBMS_OUTPUT.PUT_LINE('== C_Invoice_ID=' || p_C_Invoice_ID || ', Total=' || v_TotalOpenAmt || ', AP=' || v_MultiplierAP || ', CM=' || v_MultiplierCM);

	--	Calculate Allocated Amount
	FOR a IN Cur_Alloc LOOP
        v_Temp := a.Amount + a.DisCountAmt + a.WriteOffAmt;
		v_PaidAmt := v_PaidAmt
        -- Allocation
			+ currencyConvert(v_Temp * v_MultiplierAP,
				a.C_Currency_ID, v_Currency_ID, a.DateTrx, null, a.AD_Client_ID, a.AD_Org_ID);
      DBMS_OUTPUT.PUT_LINE('   PaidAmt=' || v_PaidAmt || ', Allocation=' || v_Temp || ' * ' || v_MultiplierAP);
	END LOOP;
    
    --  Do we have a Payment Schedule ?
    IF (p_C_InvoicePaySchedule_ID > 0) THEN --   if not valid = lists invoice amount
        v_Remaining := v_PaidAmt;
        FOR s IN Cur_PaySchedule LOOP
            IF (s.C_InvoicePaySchedule_ID = p_C_InvoicePaySchedule_ID) THEN
                v_TotalOpenAmt := (s.DueAmt*v_MultiplierCM) + v_Remaining;
                IF (s.DueAmt - v_Remaining < 0) THEN
                    v_TotalOpenAmt := 0;
                END IF;
            --  DBMS_OUTPUT.PUT_LINE('Sched Total=' || v_TotalOpenAmt || ', Due=' || s.DueAmt || ',Remaining=' || v_Remaining || ',CM=' || v_MultiplierCM);
            ELSE -- calculate amount, which can be allocated to next schedule
                v_Remaining := v_Remaining - s.DueAmt;
                IF (v_Remaining < 0) THEN
                    v_Remaining := 0;
                END IF;
            --  DBMS_OUTPUT.PUT_LINE('Remaining=' || v_Remaining);
            END IF;
        END LOOP;
    ELSE
        v_TotalOpenAmt := v_TotalOpenAmt - v_PaidAmt;
    END IF;
--  DBMS_OUTPUT.PUT_LINE('== Total=' || v_TotalOpenAmt);

	--	Ignore Rounding
	IF (v_TotalOpenAmt BETWEEN -0.00999 AND 0.00999) THEN
		v_TotalOpenAmt := 0;
	END IF;
    
	--	Round to penny
	v_TotalOpenAmt := ROUND(COALESCE(v_TotalOpenAmt,0), 2);
	RETURN	v_TotalOpenAmt;
END invoiceOpen;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION invoicePaid
(
	p_C_Invoice_ID		IN	NUMBER,
	p_C_Currency_ID	    IN	NUMBER,
	p_MultiplierAP		IN	NUMBER	-- DEFAULT 1
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html 
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either 
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Invoice_Paid.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Paid/Allocated amount in Currency
 * Description:
 *	Add up total amount paid for for C_Invoice_ID.
 *  Split Payments are ignored.
 *  all allocation amounts  converted to invoice C_Currency_ID
 *	round it to the nearest cent
 *	and adjust for CreditMemos by using C_Invoice_v
 *  and for Payments with the multiplierAP (-1, 1)
 *
    SELECT C_Invoice_ID, IsPaid, IsSOTrx, GrandTotal, 
    C_Invoice_Paid (C_Invoice_ID, C_Currency_ID, MultiplierAP)
    FROM C_Invoice_v;
    --
    UPDATE C_Invoice_v1	
 	SET IsPaid = CASE WHEN C_Invoice_Paid(C_Invoice_ID,C_Currency_ID,MultiplierAP)=GrandTotal THEN 'Y' ELSE 'N' END 
    WHERE C_Invoice_ID>1000000
 *	
 ************************************************************************/
AS
	v_MultiplierAP		NUMBER := 1;
	v_PaymentAmt		NUMBER := 0;
	CURSOR	Cur_Alloc	IS
		SELECT	a.AD_Client_ID, a.AD_Org_ID, 
            al.Amount, al.DiscountAmt, al.WriteOffAmt, 
            a.C_Currency_ID, a.DateTrx
		FROM	C_AllocationLine al
          INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID=a.C_AllocationHdr_ID)
		WHERE	al.C_Invoice_ID = p_C_Invoice_ID
          AND   a.IsActive='Y';
BEGIN
	--	Default
	IF (p_MultiplierAP IS NOT NULL) THEN
		v_MultiplierAP := p_MultiplierAP;
	END IF;
	--	Calculate Allocated Amount
	FOR a IN Cur_Alloc LOOP
		v_PaymentAmt := v_PaymentAmt
			+ currencyConvert(a.Amount + a.DisCountAmt + a.WriteOffAmt,
				a.C_Currency_ID, p_C_Currency_ID, a.DateTrx, null, a.AD_Client_ID, a.AD_Org_ID);
	END LOOP;
	--
	RETURN	ROUND(NVL(v_PaymentAmt,0), 2) * v_MultiplierAP;
END invoicePaid;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION bomQtyReserved
(
	p_Product_ID 		IN NUMBER,
    p_Warehouse_ID		IN NUMBER,
	p_Locator_ID		IN NUMBER	--	Only used, if warehouse is null
)
RETURN NUMBER
/******************************************************************************
 * ** Compiere Product **             Copyright (c) 1999-2001 Accorto, Inc. USA
 * Open  Source  Software        Provided "AS IS" without warranty or liability
 * When you use any parts (changed or unchanged), add  "Powered by Compiere" to
 * your product name;  See license details http://www.compiere.org/license.html
 ******************************************************************************
 *	Return quantity reserved for BOM
 */
AS
	v_Warehouse_ID		NUMBER;
 	v_Quantity			NUMBER := 99999;	--	unlimited
	v_IsBOM				CHAR(1);
	v_IsStocked			CHAR(1);
	v_ProductType		CHAR(1);
 	v_ProductQty		NUMBER;
	v_StdPrecision		NUMBER;
	--	Get BOM Product info
	CURSOR CUR_BOM IS
		SELECT b.M_ProductBOM_ID, b.BOMQty, p.IsBOM, p.IsStocked, p.ProductType
		FROM M_Product_BOM b, M_Product p
		WHERE b.M_ProductBOM_ID=p.M_Product_ID
		  AND b.M_Product_ID=p_Product_ID;
	--
BEGIN
	--	Check Parameters
	v_Warehouse_ID := p_Warehouse_ID;
	IF (v_Warehouse_ID IS NULL) THEN
		IF (p_Locator_ID IS NULL) THEN
			RETURN 0;
		ELSE
			SELECT 	MAX(M_Warehouse_ID) INTO v_Warehouse_ID
			FROM	M_Locator
			WHERE	M_Locator_ID=p_Locator_ID;
		END IF;
	END IF;
	IF (v_Warehouse_ID IS NULL) THEN
		RETURN 0;
	END IF;
--	DBMS_OUTPUT.PUT_LINE('Warehouse=' || v_Warehouse_ID);

	--	Check, if product exists and if it is stocked
	BEGIN
		SELECT	IsBOM, ProductType, IsStocked
		  INTO	v_IsBOM, v_ProductType, v_IsStocked
		FROM M_Product
		WHERE M_Product_ID=p_Product_ID;
		--
	EXCEPTION	--	not found
		WHEN OTHERS THEN
			RETURN 0;
	END;

	--	No reservation for non-stocked
	IF (v_IsBOM='N' AND (v_ProductType<>'I' OR v_IsStocked='N')) THEN
		RETURN 0;
	--	Stocked item
	ELSIF (v_IsStocked='Y') THEN
		--	Get ProductQty
		SELECT 	NVL(SUM(QtyReserved), 0)
		  INTO	v_ProductQty
		FROM 	M_Storage s
		WHERE M_Product_ID=p_Product_ID
		  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
		  	AND l.M_Warehouse_ID=v_Warehouse_ID);
		--
		RETURN v_ProductQty;
	END IF;

	--	Go though BOM
--	DBMS_OUTPUT.PUT_LINE('BOM');
	FOR bom IN CUR_BOM LOOP
		--	Stocked Items "leaf node"
		IF (bom.ProductType = 'I' AND bom.IsStocked = 'Y') THEN
			--	Get ProductQty
			SELECT 	NVL(SUM(QtyReserved), 0)
			  INTO	v_ProductQty
			FROM 	M_Storage s
			WHERE 	M_Product_ID=bom.M_ProductBOM_ID
			  AND EXISTS (SELECT * FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID
			  	AND l.M_Warehouse_ID=v_Warehouse_ID);
			--	Get Rounding Precision
			SELECT 	NVL(MAX(u.StdPrecision), 0)
			  INTO	v_StdPrecision
			FROM 	C_UOM u, M_Product p 
			WHERE 	u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=bom.M_ProductBOM_ID;
			--	How much can we make with this product
			v_ProductQty := ROUND (v_ProductQty/bom.BOMQty, v_StdPrecision);
			--	How much can we make overall
			IF (v_ProductQty < v_Quantity) THEN
				v_Quantity := v_ProductQty;
			END IF;
		--	Another BOM
		ELSIF (bom.IsBOM = 'Y') THEN
			v_ProductQty := bomQtyReserved (bom.M_ProductBOM_ID, v_Warehouse_ID, p_Locator_ID);
			--	How much can we make overall
			IF (v_ProductQty < v_Quantity) THEN
				v_Quantity := v_ProductQty;
			END IF;
		END IF;
	END LOOP;	--	BOM

	--	Unlimited (e.g. only services)
	IF (v_Quantity = 99999) THEN
		RETURN 0;
	END IF;

	IF (v_Quantity > 0) THEN
		--	Get Rounding Precision for Product
		SELECT 	NVL(MAX(u.StdPrecision), 0)
		  INTO	v_StdPrecision
		FROM 	C_UOM u, M_Product p 
		WHERE 	u.C_UOM_ID=p.C_UOM_ID AND p.M_Product_ID=p_Product_ID;
		--
		RETURN ROUND (v_Quantity, v_StdPrecision);
	END IF;
	RETURN 0;
END bomQtyReserved;
/

SHOW ERRORS;

/* This object may not be sorted properly in the script due to cirular references */
CREATE OR REPLACE FUNCTION paymentAllocated
(
	p_C_Payment_ID	IN	NUMBER,
	p_C_Currency_ID	IN	NUMBER
)
RETURN NUMBER
/*************************************************************************
 * The contents of this file are subject to the Compiere License.  You may
 * obtain a copy of the License at    http://www.compiere.org/license.html
 * Software is on an  "AS IS" basis,  WITHOUT WARRANTY OF ANY KIND, either
 * express or implied. See the License for details. Code: Compiere ERP+CRM
 * Copyright (C) 1999-2001 Jorg Janke, ComPiere, Inc. All Rights Reserved.
 *************************************************************************
 * $Id: C_Payment_Allocated.sql,v 1.1 2006/04/21 17:51:58 jjanke Exp $
 ***
 * Title:	Calculate Allocated Payment Amount in Payment Currency
 * Description:
    --
    SELECT C_Payment_Allocated(C_Payment_ID,C_Currency_ID), PayAmt, IsAllocated
    FROM C_Payment_v 
    WHERE C_Payment_ID>=1000000;
    --
    UPDATE C_Payment_v 
    SET IsAllocated=CASE WHEN C_Payment_Allocated(C_Payment_ID, C_Currency_ID)=PayAmt THEN 'Y' ELSE 'N' END
    WHERE C_Payment_ID>=1000000;
 
 ************************************************************************/
AS
	v_AllocatedAmt		NUMBER := 0;
    v_PayAmt            NUMBER;
	CURSOR	Cur_Alloc	IS
		SELECT	a.AD_Client_ID, a.AD_Org_ID, al.Amount, a.C_Currency_ID, a.DateTrx
		FROM	C_AllocationLine al
          INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID=a.C_AllocationHdr_ID)
		WHERE	al.C_Payment_ID = p_C_Payment_ID
          AND   a.IsActive='Y';
		--  AND	al.C_Invoice_ID IS NOT NULL;
BEGIN
    --  Charge - nothing available
    SELECT MAX(PayAmt) 
      INTO v_PayAmt
    FROM C_Payment 
    WHERE C_Payment_ID=p_C_Payment_ID AND C_Charge_ID > 0;
    IF (v_PayAmt IS NOT NULL) THEN
        RETURN 0;
    END IF;
    
	--	Calculate Allocated Amount
	FOR a IN Cur_Alloc LOOP
		v_AllocatedAmt := v_AllocatedAmt
			+ currencyConvert(a.Amount, a.C_Currency_ID, p_C_Currency_ID, a.DateTrx, null, a.AD_Client_ID, a.AD_Org_ID);
	END LOOP;
	--	Round to penny
	v_AllocatedAmt := ROUND(NVL(v_AllocatedAmt,0), 2);
	RETURN	v_AllocatedAmt;
END paymentAllocated;
/

SHOW ERRORS;

-- NEW VIEWS

-- CHANGED VIEWS - but check them first - don't overwrite your customizations...

CREATE OR REPLACE FORCE VIEW C_INVOICE_V
AS SELECT i.C_Invoice_ID, i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy, 
    i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, i.Processing, i.Processed, i.C_DocType_ID, 
    i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, i.IsTransferred, 
    i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct, i.C_BPartner_ID, i.C_BPartner_Location_ID, 
    i.AD_User_ID, i.POReference, i.DateOrdered, i.C_Currency_ID, i.C_ConversionType_ID, i.PaymentRule, 
    i.C_PaymentTerm_ID, i.C_Charge_ID, i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID, 
    i.C_Activity_ID, i.IsPrinted, i.IsDiscountPrinted, i.IsPaid, i.IsInDispute,
    i.IsPayScheduleValid, null AS C_InvoicePaySchedule_ID, i.InvoiceCollectionType,
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.ChargeAmt*-1 ELSE i.ChargeAmt END AS ChargeAmt, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.TotalLines*-1 ELSE i.TotalLines END AS TotalLines, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.GrandTotal*-1 ELSE i.GrandTotal END AS GrandTotal, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END AS Multiplier,
    CASE WHEN charAt(d.DocBaseType,2)='P' THEN -1 ELSE 1 END AS MultiplierAP,
    d.DocBaseType
FROM C_Invoice i
    INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
WHERE i.IsPayScheduleValid<>'Y'
UNION
SELECT i.C_Invoice_ID, i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy, 
    i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, i.Processing, i.Processed, i.C_DocType_ID, 
    i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, i.IsTransferred, 
    i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct, i.C_BPartner_ID, i.C_BPartner_Location_ID, 
    i.AD_User_ID, i.POReference, i.DateOrdered, i.C_Currency_ID, i.C_ConversionType_ID, i.PaymentRule, 
    i.C_PaymentTerm_ID, i.C_Charge_ID, i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID, 
    i.C_Activity_ID, i.IsPrinted, i.IsDiscountPrinted, i.IsPaid, i.IsInDispute,
    i.IsPayScheduleValid, ips.C_InvoicePaySchedule_ID, i.InvoiceCollectionType,
    null AS ChargeAmt, 
    null AS TotalLines, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN ips.DueAmt*-1 ELSE ips.DueAmt END AS GrandTotal, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END AS Multiplier,
    CASE WHEN charAt(d.DocBaseType,2)='P' THEN -1 ELSE 1 END AS MultiplierAP,
    d.DocBaseType
FROM C_Invoice i
    INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
    INNER JOIN C_InvoicePaySchedule ips ON (i.C_Invoice_ID=ips.C_Invoice_ID)
WHERE i.IsPayScheduleValid='Y'
    AND ips.IsValid='Y'
;

CREATE OR REPLACE FORCE VIEW RV_C_INVOICE
AS SELECT i.C_Invoice_ID, 
	i.AD_Client_ID,i.AD_Org_ID,i.IsActive,i.Created,i.CreatedBy,i.Updated,i.UpdatedBy,
	i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, 
	i.IsPrinted, i.IsDiscountPrinted, i.Processing, i.Processed, i.IsTransferred, i.IsPaid,
	i.C_DocType_ID, i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, 
	i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct,
	i.C_BPartner_ID, i.C_BPartner_Location_ID, i.AD_User_ID, b.C_BP_Group_ID,
	i.POReference, i.DateOrdered, i.C_Currency_ID, C_ConversionType_ID, i.PaymentRule, i.C_PaymentTerm_ID,
	i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, 
    i.IsPayScheduleValid, i.InvoiceCollectionType,
    loc.C_Country_ID, loc.C_Region_ID, loc.Postal, loc.City,
	--	Amounts
	i.C_Charge_ID,
	CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.ChargeAmt*-1 ELSE i.ChargeAmt END AS ChargeAmt,
	CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.TotalLines*-1 ELSE i.TotalLines END AS TotalLines,
	CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.GrandTotal*-1 ELSE i.GrandTotal END AS GrandTotal,
	CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END AS Multiplier
FROM  C_Invoice i
 INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
 INNER JOIN C_BPartner b ON (i.C_BPartner_ID=b.C_BPartner_ID)
 INNER JOIN C_BPartner_Location bpl ON (i.C_BPartner_Location_ID=bpl.C_BPartner_Location_ID)
 INNER JOIN C_Location loc ON (bpl.C_Location_ID=loc.C_Location_ID)
;

CREATE OR REPLACE FORCE VIEW C_INVOICE_LINETAX_V
AS SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	'en_US' AS AD_Language,
	il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    il.C_Tax_ID, il.TaxAmt, il.LineTotalAmt, t.TaxIndicator,
	il.Line, p.M_Product_ID,
	CASE WHEN il.QtyInvoiced<>0 OR il.M_Product_ID IS NOT NULL THEN il.QtyInvoiced END AS QtyInvoiced, 
    CASE WHEN il.QtyEntered<>0 OR il.M_Product_ID IS NOT NULL THEN il.QtyEntered END AS QtyEntered, 
    CASE WHEN il.QtyEntered<>0 OR il.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
	COALESCE(c.Name,p.Name||productAttribute(il.M_AttributeSetInstance_ID), il.Description) AS Name, -- main line
	CASE WHEN COALESCE(c.Name,p.Name) IS NOT NULL THEN il.Description END AS Description, -- second line
	p.DocumentNote, -- third line
    p.UPC, p.SKU, COALESCE(pp.VendorProductNo,p.Value) AS ProductValue,
	ra.Description AS ResourceDescription, -- forth line
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList<>0 
        THEN il.PriceList END AS PriceList,
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList<>0 AND il.QtyEntered<>0
        THEN il.PriceList*il.QtyInvoiced/il.QtyEntered END AS PriceEnteredList,
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList>il.PriceActual AND il.PriceList<>0
        THEN (il.PriceList-il.PriceActual)/il.PriceList*100 END AS Discount,
	CASE WHEN il.PriceActual<>0 OR il.M_Product_ID IS NOT NULL THEN il.PriceActual END AS PriceActual, 
	CASE WHEN il.PriceEntered<>0 OR il.M_Product_ID IS NOT NULL THEN il.PriceEntered END AS PriceEntered, 
	CASE WHEN il.LineNetAmt<>0 OR il.M_Product_ID IS NOT NULL THEN il.LineNetAmt END AS LineNetAmt,
    il.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, 
    asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate, 
    p.Description as ProductDescription, p.ImageURL,
    il.C_Campaign_ID, il.C_Project_ID, il.C_Activity_ID, il.C_ProjectPhase_ID, il.C_ProjectTask_ID
FROM C_InvoiceLine il
	INNER JOIN C_UOM uom ON (il.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID)
    LEFT OUTER JOIN C_Tax t ON (il.C_Tax_ID=t.C_Tax_ID)
	LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN C_Charge c ON (il.C_Charge_ID=c.C_Charge_ID)
    LEFT OUTER JOIN C_BPartner_Product pp ON (il.M_Product_ID=pp.M_Product_ID AND i.C_BPartner_ID=pp.C_BPartner_ID)
	LEFT OUTER JOIN S_ResourceAssignment ra ON (il.S_ResourceAssignment_ID=ra.S_ResourceAssignment_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (il.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
UNION   --  bom lines
SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	'en_US' AS AD_Language,
	il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    il.C_Tax_ID, il.TaxAmt, il.LineTotalAmt, t.TaxIndicator,
	il.Line+(b.Line/100) AS Line, p.M_Product_ID,
	il.QtyInvoiced*b.BOMQty AS QtyInvoiced,
    il.QtyEntered*b.BOMQty AS QtyEntered,
    uom.UOMSymbol,
	p.Name,	-- main
	b.Description,
	p.DocumentNote, p.UPC, p.SKU, p.Value AS ProductValue,
	null, null, null, null, null, null, null,
    il.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    p.Description as ProductDescription, p.ImageURL,
    il.C_Campaign_ID, il.C_Project_ID, il.C_Activity_ID, il.C_ProjectPhase_ID, il.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN C_InvoiceLine il ON (b.M_Product_ID=il.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=il.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsInvoicePrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM uom ON (p.C_UOM_ID=uom.C_UOM_ID)
    LEFT OUTER JOIN C_Tax t ON (il.C_Tax_ID=t.C_Tax_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (il.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
UNION   --  comment lines
SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	'en_US', il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    null, null, null, null,
	il.Line, null,
	null, null, null,
	il.Description,
	null, null, null, null, null, null,
	null, null, null, null, null, null,
    null, null, null, null, null, null, null, null,
    null, null, null, null, null
FROM C_InvoiceLine il
WHERE il.C_UOM_ID IS NULL
UNION   --  empty line
SELECT AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,
	'en_US', C_Invoice_ID, null,
    null, null, null, null,
	9998, null,
	null, null, null,
	null,
	null, null, null, null, null, null,
	null, null, null, null, null, null,
    null, null, null, null, null, null, null, null,
    null, null, null, null, null
FROM C_Invoice
UNION   --   tax lines
SELECT it.AD_Client_ID, it.AD_Org_ID, it.IsActive, it.Created, it.CreatedBy, it.Updated, it.UpdatedBy,
	'en_US', it.C_Invoice_ID, null,
    it.C_Tax_ID, null, null, t.TaxIndicator,
	9999, null,
	null, null, null,
	t.Name,
	null, null, null, null, null, null,
	null, null, null, 
    CASE WHEN it.IsTaxIncluded='Y' THEN it.TaxAmt ELSE it.TaxBaseAmt END, 
    CASE WHEN it.IsTaxIncluded='Y' THEN it.TaxAmt ELSE it.TaxBaseAmt END, 
    CASE WHEN it.IsTaxIncluded='Y' THEN NULL ELSE it.TaxAmt END,
    null, null, null, null, null, null, null, null,
    null, null, null, null, null
FROM C_InvoiceTax it
	INNER JOIN C_Tax t ON (it.C_Tax_ID=t.C_Tax_ID)
;

CREATE OR REPLACE FORCE VIEW C_INVOICE_LINETAX_VT
AS SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	uom.AD_Language,
	il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    il.C_Tax_ID, il.TaxAmt, il.LineTotalAmt, t.TaxIndicator,
	il.Line, p.M_Product_ID,
	CASE WHEN il.QtyInvoiced<>0 OR il.M_Product_ID IS NOT NULL THEN il.QtyInvoiced END AS QtyInvoiced, 
    CASE WHEN il.QtyEntered<>0 OR il.M_Product_ID IS NOT NULL THEN il.QtyEntered END AS QtyEntered, 
	CASE WHEN il.QtyEntered<>0 OR il.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
	COALESCE(c.Name,COALESCE(pt.Name,p.Name)||productAttribute(il.M_AttributeSetInstance_ID), il.Description) AS Name, -- main line
	CASE WHEN COALESCE(c.Name,pt.Name,p.Name) IS NOT NULL THEN il.Description END AS Description, -- second line
	COALESCE(pt.DocumentNote,p.DocumentNote) AS DocumentNote, -- third line
    p.UPC, p.SKU, COALESCE(pp.VendorProductNo,p.Value) AS ProductValue,
	ra.Description AS ResourceDescription, -- forth line
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList<>0 
        THEN il.PriceList END AS PriceList,
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList<>0 AND il.QtyEntered<>0
        THEN il.PriceList*il.QtyInvoiced/il.QtyEntered END AS PriceEnteredList,
	CASE WHEN i.IsDiscountPrinted='Y' AND il.PriceList>il.PriceActual AND il.PriceList<>0
        THEN (il.PriceList-il.PriceActual)/il.PriceList*100 END AS Discount,
	CASE WHEN il.PriceActual<>0 OR il.M_Product_ID IS NOT NULL THEN il.PriceActual END AS PriceActual, 
	CASE WHEN il.PriceEntered<>0 OR il.M_Product_ID IS NOT NULL THEN il.PriceEntered END AS PriceEntered, 
	CASE WHEN il.LineNetAmt<>0 OR il.M_Product_ID IS NOT NULL THEN il.LineNetAmt END AS LineNetAmt,
    il.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    pt.Description as ProductDescription, p.ImageURL,
    il.C_Campaign_ID, il.C_Project_ID, il.C_Activity_ID, il.C_ProjectPhase_ID, il.C_ProjectTask_ID
FROM C_InvoiceLine il
	INNER JOIN C_UOM_Trl uom ON (il.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID)
    LEFT OUTER JOIN C_Tax_Trl t ON (il.C_Tax_ID=t.C_Tax_ID AND uom.AD_Language=t.AD_Language)
	LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN C_Charge c ON (il.C_Charge_ID=c.C_Charge_ID)
    LEFT OUTER JOIN C_BPartner_Product pp ON (il.M_Product_ID=pp.M_Product_ID AND i.C_BPartner_ID=pp.C_BPartner_ID)
	LEFT OUTER JOIN M_Product_Trl pt ON (il.M_Product_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
	LEFT OUTER JOIN S_ResourceAssignment ra ON (il.S_ResourceAssignment_ID=ra.S_ResourceAssignment_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (il.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
UNION   --  bom lines
SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	uom.AD_Language,
	il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    il.C_Tax_ID, il.TaxAmt, il.LineTotalAmt, t.TaxIndicator,
	il.Line+(b.Line/100) AS Line, p.M_Product_ID,
	il.QtyInvoiced*b.BOMQty AS QtyInvoiced,
    il.QtyEntered*b.BOMQty AS QtyEntered,
	uom.UOMSymbol,
	COALESCE(pt.Name,p.Name) AS Name,	-- main
	b.Description,
	COALESCE(pt.DocumentNote,p.DocumentNote) AS DocumentNote, p.UPC, p.SKU, p.Value AS ProductValue,
	null, null, null, null, null, null, null,
    il.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    pt.Description as ProductDescription, p.ImageURL,
    il.C_Campaign_ID, il.C_Project_ID, il.C_Activity_ID, il.C_ProjectPhase_ID, il.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN C_InvoiceLine il ON (b.M_Product_ID=il.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=il.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsInvoicePrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM_Trl uom ON (p.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN M_Product_Trl pt ON (b.M_ProductBOM_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
    LEFT OUTER JOIN C_Tax t ON (il.C_Tax_ID=t.C_Tax_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (il.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
UNION   --  comment line
SELECT il.AD_Client_ID, il.AD_Org_ID, il.IsActive, il.Created, il.CreatedBy, il.Updated, il.UpdatedBy,
	l.AD_Language, il.C_Invoice_ID, il.C_InvoiceLine_ID, 
    null, null, null, null,
	il.Line, null,
	null, null, null,
	il.Description,
	null, null, null, null, null, null,
	null, null,	null, null, null, null,
    null, null, null, null, null, null, null, null,
    null,null,null,null,null
FROM C_InvoiceLine il, AD_Language l
WHERE il.C_UOM_ID IS NULL
  AND l.IsBaseLanguage='N' AND l.IsSystemLanguage='Y'
UNION   --  empty line
SELECT i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy,
	AD_Language, i.C_Invoice_ID, null,
    null, null, null, null,
	9998, null,
	null, null, null,
	null,
	null, null, null, null, null, null,
	null, null,	null, null, null, null,
    null, null, null, null, null, null, null, null,
    null,null,null,null,null
FROM C_Invoice i, AD_Language l
WHERE l.IsBaseLanguage='N' AND l.IsSystemLanguage='Y'
UNION   --  tax lines
SELECT it.AD_Client_ID, it.AD_Org_ID, it.IsActive, it.Created, it.CreatedBy, it.Updated, it.UpdatedBy,
	t.AD_Language, it.C_Invoice_ID, null,
    it.C_Tax_ID, null, null, t.TaxIndicator,
	9999, null,
	null, null, null,
	t.Name,
	null, null, null, null, null, null,
	null, null, null,
    CASE WHEN it.IsTaxIncluded='Y' THEN it.TaxAmt ELSE it.TaxBaseAmt END, 
    CASE WHEN it.IsTaxIncluded='Y' THEN it.TaxAmt ELSE it.TaxBaseAmt END, 
    CASE WHEN it.IsTaxIncluded='Y' THEN NULL ELSE it.TaxAmt END,
    null, null, null, null, null, null, null, null,
    null,null,null,null,null
FROM C_InvoiceTax it
	INNER JOIN C_Tax_Trl t ON (it.C_Tax_ID=t.C_Tax_ID)
;

CREATE OR REPLACE FORCE VIEW C_ORDER_LINETAX_V
AS SELECT ol.AD_Client_ID, ol.AD_Org_ID, ol.IsActive, ol.Created, ol.CreatedBy, ol.Updated, ol.UpdatedBy,
	'en_US' AS AD_Language,
	ol.C_Order_ID, ol.C_OrderLine_ID, ol.C_Tax_ID, t.TaxIndicator,
    ol.C_BPartner_ID, ol.C_BPartner_Location_ID, bp.Name AS BPName, bpl.C_Location_ID,
	ol.Line, p.M_Product_ID,
	CASE WHEN ol.QtyOrdered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.QtyOrdered END AS QtyOrdered, 
    CASE WHEN ol.QtyEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.QtyEntered END AS QtyEntered, 
    CASE WHEN ol.QtyEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
	COALESCE(c.Name,p.Name||productAttribute(ol.M_AttributeSetInstance_ID), ol.Description) AS Name, -- main line
	CASE WHEN COALESCE(c.Name,p.Name) IS NOT NULL THEN ol.Description END AS Description, -- second line
	p.DocumentNote, -- third line
    p.UPC, p.SKU, COALESCE(pp.VendorProductNo,p.Value) AS ProductValue,
	ra.Description AS ResourceDescription, -- forth line
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList<>0
        THEN ol.PriceList END AS PriceList,
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList<>0 AND ol.QtyEntered<>0
        THEN ol.PriceList*ol.QtyOrdered/ol.QtyEntered END AS PriceEnteredList,
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList>ol.PriceActual AND ol.PriceList<>0
        THEN (ol.PriceList-ol.PriceActual)/ol.PriceList*100 END AS Discount,
	CASE WHEN ol.PriceActual<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.PriceActual END AS PriceActual, 
	CASE WHEN ol.PriceEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.PriceEntered END AS PriceEntered, 
	CASE WHEN ol.LineNetAmt<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.LineNetAmt END AS LineNetAmt,
    p.Description as ProductDescription, p.ImageURL,
    ol.C_Campaign_ID, ol.C_Project_ID, ol.C_Activity_ID, ol.C_ProjectPhase_ID, ol.C_ProjectTask_ID
FROM C_OrderLine ol
	INNER JOIN C_UOM uom ON (ol.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN C_Order i ON (ol.C_Order_ID=i.C_Order_ID)
	LEFT OUTER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN S_ResourceAssignment ra ON (ol.S_ResourceAssignment_ID=ra.S_ResourceAssignment_ID)
	LEFT OUTER JOIN C_Charge c ON (ol.C_Charge_ID=c.C_Charge_ID)
    LEFT OUTER JOIN C_BPartner_Product pp ON (ol.M_Product_ID=pp.M_Product_ID AND i.C_BPartner_ID=pp.C_BPartner_ID)
	INNER JOIN C_BPartner bp ON (ol.C_BPartner_ID=bp.C_BPartner_ID)
	INNER JOIN C_BPartner_Location bpl ON (ol.C_BPartner_Location_ID=bpl.C_BPartner_Location_ID)
	LEFT OUTER JOIN C_Tax t ON (ol.C_Tax_ID=t.C_Tax_ID)
UNION
SELECT ol.AD_Client_ID, ol.AD_Org_ID, ol.IsActive, ol.Created, ol.CreatedBy, ol.Updated, ol.UpdatedBy,
	'en_US' AS AD_Language,
	ol.C_Order_ID, ol.C_OrderLine_ID, ol.C_Tax_ID, null,
    null, null, null, null,
	ol.Line+(b.Line/100) AS Line, p.M_Product_ID,
	ol.QtyOrdered*b.BOMQty AS QtyInvoiced, ol.QtyEntered*b.BOMQty AS QtyEntered, uom.UOMSymbol,
	p.Name,	-- main
	b.Description,
	p.DocumentNote, p.UPC, p.SKU, p.Value AS ProductValue,
	null, null, null, null, null, null, null, p.Description as ProductDescription, p.ImageURL,
    ol.C_Campaign_ID, ol.C_Project_ID, ol.C_Activity_ID, ol.C_ProjectPhase_ID, ol.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN C_OrderLine ol ON (b.M_Product_ID=ol.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=ol.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsInvoicePrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM uom ON (p.C_UOM_ID=uom.C_UOM_ID)
UNION
SELECT AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,
	'en_US', C_Order_ID, null, null, null,
	null,
	null, null, null,
    null, null, null, null,
	null, null,
	null, null, null, null, null, null,
	null, null, null, null, null, null, null, null,
    null,null,null,null,null
FROM C_Order
UNION
SELECT ot.AD_Client_ID, ot.AD_Org_ID, ot.IsActive, ot.Created, ot.CreatedBy, ot.Updated, ot.UpdatedBy,
	'en_US', ot.C_Order_ID, null, ot.C_Tax_ID, t.TaxIndicator,
    null, null, null, null,
	null, null,
	null, null, null,
	t.Name,
	null, null, null, null, null, null,
	null, null, null, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN ot.TaxAmt ELSE ot.TaxBaseAmt END, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN ot.TaxAmt ELSE ot.TaxBaseAmt END, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN NULL ELSE ot.TaxAmt END,
    null, null,
    null,null,null,null,null
FROM C_OrderTax ot
	INNER JOIN C_Tax t ON (ot.C_Tax_ID=t.C_Tax_ID)
;

CREATE OR REPLACE FORCE VIEW C_ORDER_LINETAX_VT
AS SELECT ol.AD_Client_ID, ol.AD_Org_ID, ol.IsActive, ol.Created, ol.CreatedBy, ol.Updated, ol.UpdatedBy,
	uom.AD_Language,
	ol.C_Order_ID, ol.C_OrderLine_ID, ol.C_Tax_ID, t.TaxIndicator,
    ol.C_BPartner_ID, ol.C_BPartner_Location_ID, bp.Name AS BPName, bpl.C_Location_ID,
	ol.Line, p.M_Product_ID,
	CASE WHEN ol.QtyOrdered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.QtyOrdered END AS QtyOrdered, 
    CASE WHEN ol.QtyEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.QtyEntered END AS QtyEntered, 
    CASE WHEN ol.QtyEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
	COALESCE(c.Name,p.Name||productAttribute(ol.M_AttributeSetInstance_ID), ol.Description) AS Name, -- main line
	CASE WHEN COALESCE(c.Name,pt.Name, p.Name) IS NOT NULL THEN ol.Description END AS Description, -- second line
	COALESCE(pt.DocumentNote, p.DocumentNote) AS DocumentNote, -- third line
    p.UPC, p.SKU, COALESCE(pp.VendorProductNo,p.Value) AS ProductValue,
	ra.Description AS ResourceDescription, -- forth line
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList<>0
        THEN ol.PriceList END AS PriceList,
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList<>0 AND ol.QtyEntered<>0
        THEN ol.PriceList*ol.QtyOrdered/ol.QtyEntered END AS PriceEnteredList,
	CASE WHEN i.IsDiscountPrinted='Y' AND ol.PriceList>ol.PriceActual AND ol.PriceList<>0
        THEN (ol.PriceList-ol.PriceActual)/ol.PriceList*100 END AS Discount,
	CASE WHEN ol.PriceActual<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.PriceActual END AS PriceActual, 
	CASE WHEN ol.PriceEntered<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.PriceEntered END AS PriceEntered, 
	CASE WHEN ol.LineNetAmt<>0 OR ol.M_Product_ID IS NOT NULL THEN ol.LineNetAmt END AS LineNetAmt,
    pt.Description as ProductDescription, p.ImageURL,
    ol.C_Campaign_ID, ol.C_Project_ID, ol.C_Activity_ID, ol.C_ProjectPhase_ID, ol.C_ProjectTask_ID
FROM C_OrderLine ol
	INNER JOIN C_UOM_Trl uom ON (ol.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN C_Order i ON (ol.C_Order_ID=i.C_Order_ID)
	LEFT OUTER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN M_Product_Trl pt ON (ol.M_Product_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
	LEFT OUTER JOIN S_ResourceAssignment ra ON (ol.S_ResourceAssignment_ID=ra.S_ResourceAssignment_ID)
	LEFT OUTER JOIN C_Charge c ON (ol.C_Charge_ID=c.C_Charge_ID)
    LEFT OUTER JOIN C_BPartner_Product pp ON (ol.M_Product_ID=pp.M_Product_ID AND i.C_BPartner_ID=pp.C_BPartner_ID)
	INNER JOIN C_BPartner bp ON (ol.C_BPartner_ID=bp.C_BPartner_ID)
	INNER JOIN C_BPartner_Location bpl ON (ol.C_BPartner_Location_ID=bpl.C_BPartner_Location_ID)
	LEFT OUTER JOIN C_Tax_Trl t ON (ol.C_Tax_ID=t.C_Tax_ID AND uom.AD_Language=t.AD_Language)
UNION
SELECT ol.AD_Client_ID, ol.AD_Org_ID, ol.IsActive, ol.Created, ol.CreatedBy, ol.Updated, ol.UpdatedBy,
	uom.AD_Language,
	ol.C_Order_ID, ol.C_OrderLine_ID, ol.C_Tax_ID, null,
    null, null, null, null,
	ol.Line+(b.Line/100) AS Line, p.M_Product_ID,
	ol.QtyOrdered*b.BOMQty AS QtyInvoiced, ol.QtyEntered*b.BOMQty AS QtyEntered, uom.UOMSymbol,
	COALESCE(pt.Name, p.Name) AS Name,	-- main
	b.Description,
	COALESCE(pt.DocumentNote, p.DocumentNote) AS DocumentNote, p.UPC, p.SKU, p.Value AS ProductValue,
	null, null, null, null, null, null, null, pt.Description AS ProductDescription, p.ImageURL,
    ol.C_Campaign_ID, ol.C_Project_ID, ol.C_Activity_ID, ol.C_ProjectPhase_ID, ol.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN C_OrderLine ol ON (b.M_Product_ID=ol.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=ol.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsInvoicePrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM_Trl uom ON (p.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN M_Product_Trl pt ON (b.M_ProductBOM_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
UNION
SELECT o.AD_Client_ID, o.AD_Org_ID, o.IsActive, o.Created, o.CreatedBy, o.Updated, o.UpdatedBy,
	l.AD_Language, o.C_Order_ID, null, null, null,
	null,
	null, null, null,
    null, null, null, null,
	null, null,
	null, null, null, null, null, null,
	null, null, null, null, null, null, null, null,
    null,null,null,null,null
FROM C_Order o, AD_Language l
WHERE l.IsBaseLanguage='N' AND l.IsSystemLanguage='Y'
UNION
SELECT ot.AD_Client_ID, ot.AD_Org_ID, ot.IsActive, ot.Created, ot.CreatedBy, ot.Updated, ot.UpdatedBy,
	t.AD_Language, ot.C_Order_ID, null, ot.C_Tax_ID, t.TaxIndicator,
    null, null, null, null,
	null, null,
	null, null, null,
	t.Name,
	null, null, null, null, null, null,
	null, null, null, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN ot.TaxAmt ELSE ot.TaxBaseAmt END, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN ot.TaxAmt ELSE ot.TaxBaseAmt END, 
    CASE WHEN ot.IsTaxIncluded='Y' THEN NULL ELSE ot.TaxAmt END,
    null, null,
    null,null,null,null,null
FROM C_OrderTax ot
	INNER JOIN C_Tax_Trl t ON (ot.C_Tax_ID=t.C_Tax_ID)
;

CREATE OR REPLACE FORCE VIEW M_INOUT_LINE_V
AS SELECT iol.AD_Client_ID, iol.AD_Org_ID, iol.IsActive, iol.Created, iol.CreatedBy, iol.Updated, iol.UpdatedBy,
	'en_US' AS AD_Language,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line, p.M_Product_ID,
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN iol.MovementQty END AS MovementQty, 
	CASE WHEN iol.QtyEntered<>0 OR iol.M_Product_ID IS NOT NULL THEN iol.QtyEntered END AS QtyEntered, 
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
    ol.QtyOrdered, ol.QtyDelivered, 
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN ol.QtyOrdered-ol.QtyDelivered END AS QtyBackOrdered,
	COALESCE(p.Name||productAttribute(iol.M_AttributeSetInstance_ID), c.Name, iol.Description) AS Name, -- main line
	CASE WHEN COALESCE(c.Name,p.Name) IS NOT NULL THEN iol.Description END AS Description, -- second line
	p.DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    p.Description AS ProductDescription, p.ImageURL,
    iol.C_Campaign_ID, iol.C_Project_ID, iol.C_Activity_ID, iol.C_ProjectPhase_ID, iol.C_ProjectTask_ID
FROM M_InOutLine iol
	INNER JOIN C_UOM uom ON (iol.C_UOM_ID=uom.C_UOM_ID)
	LEFT OUTER JOIN M_Product p ON (iol.M_Product_ID=p.M_Product_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
    LEFT OUTER JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID)
    LEFT OUTER JOIN C_Charge c ON (iol.C_Charge_ID=c.C_Charge_ID)
UNION   --  BOM lines
SELECT iol.AD_Client_ID, iol.AD_Org_ID, iol.IsActive, iol.Created, iol.CreatedBy, iol.Updated, iol.UpdatedBy,
	'en_US' AS AD_Language,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line+(b.Line/100) AS Line, p.M_Product_ID,
	iol.MovementQty*b.BOMQty AS QtyInvoiced, iol.QtyEntered*b.BOMQty AS QtyEntered, uom.UOMSymbol, 
    null, null, null,
	p.Name, -- main line
	b.Description, -- second line
	p.DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    p.Description AS ProductDescription, p.ImageURL,
    iol.C_Campaign_ID, iol.C_Project_ID, iol.C_Activity_ID, iol.C_ProjectPhase_ID, iol.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN M_InOutLine iol ON (b.M_Product_ID=iol.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=iol.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsPickListPrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM uom ON (p.C_UOM_ID=uom.C_UOM_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
;

CREATE OR REPLACE FORCE VIEW M_INOUT_LINE_VT
AS SELECT iol.AD_Client_ID, iol.AD_Org_ID, iol.IsActive, iol.Created, iol.CreatedBy, iol.Updated, iol.UpdatedBy,
	uom.AD_Language,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line, p.M_Product_ID,
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN iol.MovementQty END AS MovementQty, 
	CASE WHEN iol.QtyEntered<>0 OR iol.M_Product_ID IS NOT NULL THEN iol.QtyEntered END AS QtyEntered, 
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN uom.UOMSymbol END AS UOMSymbol, 
    ol.QtyOrdered, ol.QtyDelivered,
	CASE WHEN iol.MovementQty<>0 OR iol.M_Product_ID IS NOT NULL THEN ol.QtyOrdered-ol.QtyDelivered END AS QtyBackOrdered,
	COALESCE(COALESCE(pt.Name,p.Name)||productAttribute(iol.M_AttributeSetInstance_ID), c.Name, iol.Description) AS Name, -- main line
	CASE WHEN COALESCE(pt.Name,p.Name,c.Name) IS NOT NULL THEN iol.Description END AS Description, -- second line
	COALESCE(pt.DocumentNote, p.DocumentNote) AS DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    pt.Description AS ProductDescription, p.ImageURL,
    iol.C_Campaign_ID, iol.C_Project_ID, iol.C_Activity_ID, iol.C_ProjectPhase_ID, iol.C_ProjectTask_ID
FROM	M_InOutLine iol
	INNER JOIN C_UOM_Trl uom ON (iol.C_UOM_ID=uom.C_UOM_ID)
	LEFT OUTER JOIN M_Product p ON (iol.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN M_Product_Trl pt ON (iol.M_Product_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
    LEFT OUTER JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID)
    LEFT OUTER JOIN C_Charge c ON (iol.C_Charge_ID=c.C_Charge_ID)
UNION
SELECT iol.AD_Client_ID, iol.AD_Org_ID, iol.IsActive, iol.Created, iol.CreatedBy, iol.Updated, iol.UpdatedBy,
	uom.AD_Language,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line+(b.Line/100) AS Line, p.M_Product_ID,
	iol.MovementQty*b.BOMQty AS QtyInvoiced, iol.QtyEntered*b.BOMQty AS QtyEntered, uom.UOMSymbol, 
    null, null, null,
	COALESCE (pt.Name, p.Name) AS Name, -- main line
	b.Description, -- second line
	COALESCE (pt.DocumentNote, p.DocumentNote) AS DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate,
    pt.Description AS ProductDescription, p.ImageURL,
    iol.C_Campaign_ID, iol.C_Project_ID, iol.C_Activity_ID, iol.C_ProjectPhase_ID, iol.C_ProjectTask_ID
FROM M_Product_BOM b	-- BOM lines
	INNER JOIN M_InOutLine iol ON (b.M_Product_ID=iol.M_Product_ID)
	INNER JOIN M_Product bp ON (bp.M_Product_ID=iol.M_Product_ID -- BOM Product
		AND bp.IsBOM='Y' AND bp.IsVerified='Y' AND bp.IsPickListPrintDetails='Y')
	INNER JOIN M_Product p ON (b.M_ProductBOM_ID=p.M_Product_ID) -- BOM line product
	INNER JOIN C_UOM_Trl uom ON (p.C_UOM_ID=uom.C_UOM_ID)
	INNER JOIN M_Product_Trl pt ON (iol.M_Product_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
;

CREATE OR REPLACE FORCE VIEW M_INOUT_LINECONFIRM_V
AS SELECT iolc.AD_Client_ID, iolc.AD_Org_ID, iolc.IsActive, iolc.Created, iolc.CreatedBy, iolc.Updated, iolc.UpdatedBy,
	'en_US' AS AD_Language,
    iolc.M_InOutLineConfirm_ID, iolc.M_InOutConfirm_ID,
    iolc.TargetQty, iolc.ConfirmedQty, iolc.DifferenceQty, iolc.ScrappedQty,
    iolc.Description, iolc.Processed,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line, p.M_Product_ID,
	iol.MovementQty, uom.UOMSymbol, ol.QtyOrdered-ol.QtyDelivered AS QtyBackOrdered,
	COALESCE(p.Name, iol.Description) AS Name, -- main line
	CASE WHEN p.Name IS NOT NULL THEN iol.Description END AS ShipDescription, -- second line
	p.DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate
FROM M_InOutLineConfirm iolc
    INNER JOIN M_InOutLine iol ON (iolc.M_InOutLine_ID=iol.M_InOutLine_ID)
	INNER JOIN C_UOM uom ON (iol.C_UOM_ID=uom.C_UOM_ID)
	LEFT OUTER JOIN M_Product p ON (iol.M_Product_ID=p.M_Product_ID)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
    LEFT OUTER JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID)
;

CREATE OR REPLACE FORCE VIEW M_INOUT_LINECONFIRM_VT
AS SELECT iolc.AD_Client_ID, iolc.AD_Org_ID, iolc.IsActive, iolc.Created, iolc.CreatedBy, iolc.Updated, iolc.UpdatedBy,
	uom.AD_Language,
    iolc.M_InOutLineConfirm_ID, iolc.M_InOutConfirm_ID,
    iolc.TargetQty, iolc.ConfirmedQty, iolc.DifferenceQty, iolc.ScrappedQty,
    iolc.Description, iolc.Processed,
	iol.M_InOut_ID, iol.M_InOutLine_ID, 
	iol.Line, p.M_Product_ID,
	iol.MovementQty, uom.UOMSymbol, ol.QtyOrdered-ol.QtyDelivered AS QtyBackOrdered,
	COALESCE(COALESCE(pt.Name,p.Name), iol.Description) AS Name, -- main line
	CASE WHEN COALESCE(pt.Name,p.Name) IS NOT NULL THEN iol.Description END AS ShipDescription, -- second line
	COALESCE(pt.DocumentNote, p.DocumentNote) AS DocumentNote, -- third line
    p.UPC, p.SKU, p.Value AS ProductValue,
	iol.M_Locator_ID, l.M_Warehouse_ID, l.X, l.Y, l.Z,
    iol.M_AttributeSetInstance_ID, asi.M_AttributeSet_ID, asi.SerNo, asi.Lot, asi.M_Lot_ID,asi.GuaranteeDate
FROM M_InOutLineConfirm iolc
    INNER JOIN M_InOutLine iol ON (iolc.M_InOutLine_ID=iol.M_InOutLine_ID)
	INNER JOIN C_UOM_Trl uom ON (iol.C_UOM_ID=uom.C_UOM_ID)
	LEFT OUTER JOIN M_Product p ON (iol.M_Product_ID=p.M_Product_ID)
	LEFT OUTER JOIN M_Product_Trl pt ON (iol.M_Product_ID=pt.M_Product_ID AND uom.AD_Language=pt.AD_Language)
    LEFT OUTER JOIN M_AttributeSetInstance asi ON (iol.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)
    LEFT OUTER JOIN M_Locator l ON (iol.M_Locator_ID=l.M_Locator_ID)
    LEFT OUTER JOIN C_OrderLine ol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID)
;

CREATE OR REPLACE FORCE VIEW C_INVOICE_V1
AS SELECT i.C_Invoice_ID, i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy, 
    i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, i.Processing, i.Processed, i.C_DocType_ID, 
    i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, i.IsTransferred, 
    i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct, i.C_BPartner_ID, i.C_BPartner_Location_ID, 
    i.AD_User_ID, i.POReference, i.DateOrdered, i.C_Currency_ID, i.C_ConversionType_ID, i.PaymentRule, 
    i.C_PaymentTerm_ID, i.C_Charge_ID, i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID, 
    i.C_Activity_ID, i.IsPrinted, i.IsDiscountPrinted, i.IsPaid, i.IsInDispute,
    i.IsPayScheduleValid, null AS C_InvoicePaySchedule_ID, i.InvoiceCollectionType,
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.ChargeAmt*-1 ELSE i.ChargeAmt END AS ChargeAmt, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.TotalLines*-1 ELSE i.TotalLines END AS TotalLines, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.GrandTotal*-1 ELSE i.GrandTotal END AS GrandTotal, 
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END AS Multiplier,
    CASE WHEN charAt(d.DocBaseType,2)='P' THEN -1 ELSE 1 END AS MultiplierAP,
    d.DocBaseType
FROM C_Invoice i
    INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
;

CREATE OR REPLACE FORCE VIEW T_INVOICEGL_V
AS SELECT i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created,i.CreatedBy, i.Updated,i.UpdatedBy,
    i.C_Invoice_ID, i.IsSOTrx, i.DocumentNo, i.DocStatus, i.C_DocType_ID, i.C_Order_ID,
    i.Description, i.SalesRep_ID, i.DateInvoiced, i.DateAcct, i.C_PaymentTerm_ID,
    i.C_BPartner_ID, i.C_BPartner_Location_ID, i.AD_User_ID, i.IsSelfService,
    i.C_Currency_ID, i.C_ConversionType_ID, i.GrandTotal, i.IsTaxIncluded,
--  References
    i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, 
    i.AD_OrgTrx_ID, i.User1_ID, i.User2_ID,
    fa.C_LocFrom_ID, fa.C_LocTo_ID, fa.C_SalesRegion_ID,
--  Accounting
    fa.Fact_Acct_ID, fa.C_AcctSchema_ID, fa.Account_ID, fa.C_Period_ID, fa.GL_Category_ID, fa.GL_Budget_ID,
    fa.C_Tax_ID, fa.M_Locator_ID,
    fa.PostingType, fa.AmtSourceDr, fa.AmtSourceCr, 
    fa.AmtAcctDr, fa.AmtAcctCr, 
    fa.C_UOM_ID, fa.Qty,
--  Gain/Loss
    gl.AD_PInstance_ID, gl.APAR, gl.OpenAmt, gl.Percent,
    gl.AmtRevalDr, gl.AmtRevalCr, gl.DateReval, gl.C_ConversionTypeReval_ID,
    gl.AmtSourceBalance, gl.AmtAcctBalance, 
    gl.C_DocTypeReval_ID,
    gl.AmtRevalDrDiff, gl.AmtRevalCrDiff, gl.IsAllCurrencies,
    (fa.AmtAcctDr*gl.Percent/100) AS AmtAcctOpenDr, (fa.AmtAcctCr*gl.Percent/100) AS AmtAcctOpenCr,
    ((fa.AmtAcctDr-fa.AmtAcctCr)*gl.Percent/100) AS AmtAcctOpenBalance
FROM T_InvoiceGL gl
  INNER JOIN C_Invoice i ON (gl.C_Invoice_ID=i.C_Invoice_ID)
  INNER JOIN Fact_Acct fa ON (gl.Fact_Acct_ID=fa.Fact_Acct_ID)
;

CREATE OR REPLACE FORCE VIEW T_INVOICEGL_VT
AS SELECT i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created,i.CreatedBy, i.Updated,i.UpdatedBy,
    i.C_Invoice_ID, i.IsSOTrx, i.DocumentNo, i.DocStatus, i.C_DocType_ID, i.C_Order_ID,
    i.Description, i.SalesRep_ID, i.DateInvoiced, i.DateAcct, i.C_PaymentTerm_ID,
    i.C_BPartner_ID, i.C_BPartner_Location_ID, i.AD_User_ID, i.IsSelfService,
    i.C_Currency_ID, i.C_ConversionType_ID, i.GrandTotal, i.IsTaxIncluded,
--  References
    i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, 
    i.AD_OrgTrx_ID, i.User1_ID, i.User2_ID,
    fa.C_LocFrom_ID, fa.C_LocTo_ID, fa.C_SalesRegion_ID,
--  Accounting
    fa.Fact_Acct_ID, fa.C_AcctSchema_ID, fa.Account_ID, fa.C_Period_ID, fa.GL_Category_ID, fa.GL_Budget_ID,
    fa.C_Tax_ID, fa.M_Locator_ID,
    fa.PostingType, fa.AmtSourceDr, fa.AmtSourceCr, 
    fa.AmtAcctDr, fa.AmtAcctCr,
    fa.C_UOM_ID, fa.Qty, 
--  Gain/Loss
    gl.AD_PInstance_ID, gl.APAR, gl.OpenAmt, gl.Percent,
    gl.AmtRevalDr, gl.AmtRevalCr, gl.DateReval, gl.C_ConversionTypeReval_ID,
    gl.AmtSourceBalance, gl.AmtAcctBalance, 
    gl.C_DocTypeReval_ID,
    gl.AmtRevalDrDiff, gl.AmtRevalCrDiff, gl.IsAllCurrencies,
    (fa.AmtAcctDr*gl.Percent/100) AS AmtAcctOpenDr, (fa.AmtAcctCr*gl.Percent/100) AS AmtAcctOpenCr,
    ((fa.AmtAcctDr-fa.AmtAcctCr)*gl.Percent/100) AS AmtAcctOpenBalance
FROM T_InvoiceGL gl
  INNER JOIN C_Invoice i ON (gl.C_Invoice_ID=i.C_Invoice_ID)
  INNER JOIN Fact_Acct fa ON (gl.Fact_Acct_ID=fa.Fact_Acct_ID)
;

CREATE OR REPLACE FORCE VIEW RV_OPENITEM
AS SELECT i.AD_Org_ID, i.AD_Client_ID, 
	i.DocumentNo, i.C_Invoice_ID, i.C_Order_ID, i.C_BPartner_ID, i.IsSOTrx,
	i.DateInvoiced, i.DateAcct,
    p.NetDays, 
	paymentTermDueDate(i.C_PaymentTerm_ID, i.DateInvoiced) AS DueDate,
	paymentTermDueDays(i.C_PaymentTerm_ID, i.DateInvoiced, getdate()) AS DaysDue,
    addDays(i.DateInvoiced,p.DiscountDays) AS DiscountDate, 
    ROUND(i.GrandTotal*p.Discount/100,2) AS DiscountAmt,
	i.GrandTotal, 
	invoicePaid(i.C_Invoice_ID, i.C_Currency_ID, 1) AS PaidAmt,
	invoiceOpen(i.C_Invoice_ID,0) AS OpenAmt,
    i.C_Currency_ID, i.C_ConversionType_ID, 
    i.C_PaymentTerm_ID,
    i.IsPayScheduleValid, null AS C_InvoicePaySchedule_ID, i.InvoiceCollectionType,
    i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID
FROM RV_C_Invoice i
    INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID=p.C_PaymentTerm_ID)
WHERE --    i.IsPaid='N'
    invoiceOpen(i.C_Invoice_ID,0) <> 0
    AND i.IsPayScheduleValid<>'Y'
    AND i.DocStatus<>'DR'
UNION
SELECT i.AD_Org_ID, i.AD_Client_ID, 
    i.DocumentNo, i.C_Invoice_ID, i.C_Order_ID, i.C_BPartner_ID, i.IsSOTrx,
	i.DateInvoiced, i.DateAcct,
    daysBetween(ips.DueDate,i.DateInvoiced) AS NetDays,
    ips.DueDate,
    daysBetween(getdate(),ips.DueDate) AS DaysDue,
    ips.DiscountDate, 
    ips.DiscountAmt,
	ips.DueAmt AS GrandTotal, 
	invoicePaid(i.C_Invoice_ID, i.C_Currency_ID, 1) AS PaidAmt,
	invoiceOpen(i.C_Invoice_ID, ips.C_InvoicePaySchedule_ID) AS OpenAmt,
    i.C_Currency_ID, i.C_ConversionType_ID, 
    i.C_PaymentTerm_ID,
    i.IsPayScheduleValid, ips.C_InvoicePaySchedule_ID, i.InvoiceCollectionType,
    i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID
FROM RV_C_Invoice i
    INNER JOIN C_InvoicePaySchedule ips ON (i.C_Invoice_ID=ips.C_Invoice_ID)
WHERE  --   i.IsPaid='N'
    invoiceOpen(i.C_Invoice_ID,ips.C_InvoicePaySchedule_ID) <> 0
    AND i.IsPayScheduleValid='Y'
    AND i.DocStatus<>'DR'
    AND ips.IsValid='Y'
;


-- DROP FUNCTIONS/PROCEDURES
 DROP FUNCTION COMPIEREPROPERTIES;
 DROP FUNCTION COMPIEREPROPERTY;
 DROP FUNCTION COMPIEREVERSION;
 DROP FUNCTION ADEMPIEREPROPERTY;
 DROP FUNCTION ADEMPIEREPROPERTIES;
 DROP FUNCTION ADEMPIEREVERSION;

-- DROP TRIGGERS

-- DROP INDEXES

-- NEW OR CHANGED INDEXES
CREATE UNIQUE INDEX AD_LDAPPROCESSORPORT ON AD_LDAPPROCESSOR (LDAPPORT);

-- globalqss - integrate changes on _Project-ID-ADempiere/sqls_3.1.1

----------------------------------------
-- Integrate 2Pack
----------------------------------------

CREATE TABLE ad_package_imp_backup
(
  ad_package_imp_backup_id  NUMBER(10)          NOT NULL,
  ad_client_id              NUMBER(10)          NOT NULL,
  ad_org_id                 NUMBER(10)          NOT NULL,
  isactive                  CHAR(1 BYTE)        DEFAULT 'Y'                   NOT NULL,
  created                   DATE                DEFAULT SYSDATE               NOT NULL,
  createdby                 NUMBER(10)          NOT NULL,
  updated                   DATE                DEFAULT SYSDATE               NOT NULL,
  updatedby                 NUMBER(10)          NOT NULL,
  ad_package_imp_id         NUMBER(10)          NOT NULL,
  ad_package_imp_detail_id  NUMBER(10)          NOT NULL,
  ad_table_id               NUMBER(10),
  ad_column_id              NUMBER(10),
  ad_reference_id           NUMBER(10),
  ad_package_imp_bck_dir    NVARCHAR2(255),
  ad_package_imp_org_dir    NVARCHAR2(255),
  colvalue                  NVARCHAR2(2000),
  uninstall                 CHAR(1 BYTE)
);


CREATE TABLE ad_package_imp
(
  ad_package_imp_id  NUMBER(10)                 NOT NULL,
  ad_client_id       NUMBER(10)                 NOT NULL,
  ad_org_id          NUMBER(10)                 NOT NULL,
  isactive           CHAR(1 BYTE)               DEFAULT 'Y'                   NOT NULL,
  created            DATE                       DEFAULT SYSDATE               NOT NULL,
  createdby          NUMBER(10)                 NOT NULL,
  updated            DATE                       DEFAULT SYSDATE               NOT NULL,
  updatedby          NUMBER(10)                 NOT NULL,
  NAME               NVARCHAR2(60)              NOT NULL,
  pk_status          NVARCHAR2(22),
  releaseno          NVARCHAR2(20),
  pk_version         NVARCHAR2(20),
  VERSION            NVARCHAR2(20),
  description        NVARCHAR2(1000)            NOT NULL,
  email              NVARCHAR2(60),
  processed          CHAR(1 BYTE)               DEFAULT 'N',
  processing         CHAR(1 BYTE)               DEFAULT 'N'                   NOT NULL,
  creator            NVARCHAR2(60),
  creatorcontact     NVARCHAR2(255),
  createddate        NVARCHAR2(25),
  updateddate        NVARCHAR2(25),
  uninstall          CHAR(1 BYTE)
);


CREATE TABLE ad_package_imp_inst
(
  ad_package_imp_inst_id  NUMBER(10)            NOT NULL,
  ad_client_id            NUMBER(10),
  ad_org_id               NUMBER(10),
  isactive                CHAR(1 BYTE)          DEFAULT 'Y',
  created                 DATE                  DEFAULT SYSDATE,
  createdby               NUMBER(10),
  updated                 DATE                  DEFAULT SYSDATE,
  updatedby               NUMBER(10),
  NAME                    NVARCHAR2(240),
  pk_status               NVARCHAR2(44),
  releaseno               NVARCHAR2(40),
  pk_version              NVARCHAR2(40),
  VERSION                 NVARCHAR2(40),
  description             NVARCHAR2(2000),
  email                   NVARCHAR2(120),
  processed               CHAR(1 BYTE)          DEFAULT 'N',
  processing              CHAR(1 BYTE)          DEFAULT 'N',
  creator                 NVARCHAR2(120),
  creatorcontact          NVARCHAR2(510),
  createddate             NVARCHAR2(50),
  updateddate             NVARCHAR2(50),
  uninstall               CHAR(1 BYTE)
);


CREATE TABLE ad_package_imp_detail
(
  ad_package_imp_detail_id  NUMBER(10)          NOT NULL,
  ad_client_id              NUMBER(10)          NOT NULL,
  ad_org_id                 NUMBER(10)          NOT NULL,
  isactive                  CHAR(1 BYTE)        DEFAULT 'Y'                   NOT NULL,
  created                   DATE                DEFAULT SYSDATE               NOT NULL,
  createdby                 NUMBER(10)          NOT NULL,
  updated                   DATE                DEFAULT SYSDATE               NOT NULL,
  updatedby                 NUMBER(10)          NOT NULL,
  NAME                      NVARCHAR2(60),
  ad_package_imp_id         NUMBER(10)          NOT NULL,
  ad_original_id            NUMBER(10)          NOT NULL,
  ad_backup_id              NUMBER(10),
  action                    NVARCHAR2(20),
  success                   NVARCHAR2(20),
  TYPE                      NVARCHAR2(60),
  tablename                 NVARCHAR2(60),
  ad_table_id               NUMBER(10),
  uninstall                 CHAR(1 BYTE)
);


CREATE TABLE ad_package_exp
(
  ad_package_exp_id  NUMBER(10)                 NOT NULL,
  ad_client_id       NUMBER(10)                 NOT NULL,
  ad_org_id          NUMBER(10)                 NOT NULL,
  isactive           CHAR(1 BYTE)               DEFAULT 'Y'                   NOT NULL,
  created            DATE                       DEFAULT SYSDATE               NOT NULL,
  createdby          NUMBER(10)                 NOT NULL,
  updated            DATE                       DEFAULT SYSDATE               NOT NULL,
  updatedby          NUMBER(10)                 NOT NULL,
  ad_package_type    NVARCHAR2(1),
  email              NVARCHAR2(30)              NOT NULL,
  instructions       NVARCHAR2(1000)            NOT NULL,
  pk_name            NVARCHAR2(60)              NOT NULL,
  processed          CHAR(1 BYTE),
  releaseno          NVARCHAR2(20)              NOT NULL,
  VERSION            NVARCHAR2(20)              NOT NULL,
  username           NVARCHAR2(30)              NOT NULL,
  processing         CHAR(1 BYTE)               NOT NULL,
  pk_version         NVARCHAR2(20)              NOT NULL,
  file_directory     NVARCHAR2(255)             NOT NULL,
  description        NVARCHAR2(1000)            NOT NULL
);


CREATE TABLE ad_package_exp_detail
(
  ad_package_exp_detail_id  NUMBER(10)          NOT NULL,
  ad_client_id              NUMBER(10)          NOT NULL,
  ad_org_id                 NUMBER(10)          NOT NULL,
  isactive                  CHAR(1 BYTE)        DEFAULT 'Y'                   NOT NULL,
  created                   DATE                DEFAULT SYSDATE               NOT NULL,
  createdby                 NUMBER              NOT NULL,
  updated                   DATE                DEFAULT SYSDATE               NOT NULL,
  updatedby                 NUMBER              NOT NULL,
  ad_form_id                NUMBER(10),
  ad_impformat_id           NUMBER(10),
  ad_menu_id                NUMBER(10),
  ad_process_id             NUMBER(10),
  ad_role_id                NUMBER(10),
  ad_window_id              NUMBER(10),
  ad_workflow_id            NUMBER(10),
  file_directory            NVARCHAR2(255),
  filename                  NVARCHAR2(255),
  destination_filename      NVARCHAR2(255),
  destination_directory     NVARCHAR2(255),
  description               NVARCHAR2(1000)     NOT NULL,
  dbtype                    NVARCHAR2(22),
  TYPE                      NVARCHAR2(10)       NOT NULL,
  target_directory          NVARCHAR2(255),
  sqlstatement              NVARCHAR2(2000),
  releaseno                 NVARCHAR2(20),
  processing                CHAR(1 BYTE)        NOT NULL,
  processed                 CHAR(1 BYTE),
  pk_name                   NVARCHAR2(60)       NOT NULL,
  name2                     NVARCHAR2(60),
  line                      NUMBER,
  ad_workbench_id           NUMBER(10),
  ad_table_id               NUMBER(10),
  ad_reportview_id          NUMBER(10),
  ad_package_exp_id         NUMBER(10)          NOT NULL,
  ad_package_code_new       NVARCHAR2(2000),
  ad_package_code_old       NVARCHAR2(2000)
);


CREATE TABLE ad_package_exp_common
(
  ad_package_exp_common_id  NUMBER(10)          NOT NULL,
  ad_client_id              NUMBER(10)          NOT NULL,
  ad_org_id                 NUMBER(10)          NOT NULL,
  isactive                  CHAR(1 BYTE)        DEFAULT 'Y'                   NOT NULL,
  created                   DATE                DEFAULT SYSDATE               NOT NULL,
  createdby                 NUMBER(10)          NOT NULL,
  updated                   DATE                DEFAULT SYSDATE               NOT NULL,
  updatedby                 NUMBER(10)          NOT NULL,
  ad_form_id                NUMBER(10),
  ad_impformat_id           NUMBER(10),
  ad_reportview_id          NUMBER(10),
  ad_table_id               NUMBER(10),
  ad_workbench_id           NUMBER(10),
  dbtype                    NVARCHAR2(22),
  processed                 CHAR(1 BYTE),
  pk_name                   NVARCHAR2(60),
  name2                     NVARCHAR2(60),
  line                      NUMBER,
  file_directory            NVARCHAR2(255),
  filename                  NVARCHAR2(255),
  destination_directory     NVARCHAR2(255),
  description               NVARCHAR2(1000),
  TYPE                      NVARCHAR2(10),
  target_directory          NVARCHAR2(255),
  sqlstatement              NVARCHAR2(255),
  processing                CHAR(1 BYTE),
  ad_workflow_id            NUMBER(10),
  ad_window_id              NUMBER(10),
  ad_role_id                NUMBER(10),
  ad_process_id             NUMBER(10),
  ad_menu_id                NUMBER(10)
);


CREATE TABLE ad_package_imp_proc
(
  ad_package_imp_proc_id  NUMBER(10)            NOT NULL,
  ad_client_id            NUMBER(10)            NOT NULL,
  ad_org_id               NUMBER(10)            NOT NULL,
  isactive                CHAR(1 BYTE)          DEFAULT 'Y'                   NOT NULL,
  created                 DATE                  DEFAULT SYSDATE               NOT NULL,
  createdby               NUMBER(10)            NOT NULL,
  updated                 DATE                  DEFAULT SYSDATE               NOT NULL,
  updatedby               NUMBER(10)            NOT NULL,
  ad_override_dict        CHAR(1 BYTE),
  ad_package_dir          NVARCHAR2(255),
  ad_package_source       NVARCHAR2(255),
  ad_package_source_type  NVARCHAR2(10)         NOT NULL,
  processing              CHAR(1 BYTE)
);


ALTER TABLE ad_package_imp_backup ADD (
  PRIMARY KEY
 (ad_package_imp_backup_id));


ALTER TABLE ad_package_imp ADD (
  PRIMARY KEY
 (ad_package_imp_id));


ALTER TABLE ad_package_imp_inst ADD (
  PRIMARY KEY
 (ad_package_imp_inst_id));


ALTER TABLE ad_package_imp_detail ADD (
  PRIMARY KEY
 (ad_package_imp_detail_id));


ALTER TABLE ad_package_exp ADD (
  PRIMARY KEY
 (ad_package_exp_id));


ALTER TABLE ad_package_exp_detail ADD (
  PRIMARY KEY
 (ad_package_exp_detail_id));


ALTER TABLE ad_package_exp_common ADD (
  PRIMARY KEY
 (ad_package_exp_common_id));


ALTER TABLE ad_package_imp_proc ADD (
  PRIMARY KEY
 (ad_package_imp_proc_id));

--------------------------

Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:28', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_PACKAGE_IMP_INST_ID', 'U', 'AD_PACKAGE_IMP_INST_ID', 'AD_PACKAGE_IMP_INST_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'CreatedDate', 'U', 'CreatedDate', 'CreatedDate');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PK_Version', 'U', 'PK_Version', 'PK_Version');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'UpdatedDate', 'U', 'UpdatedDate', 'UpdatedDate');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:34', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Uninstall', 'U', 'Uninstall', 'Uninstall');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PK_Status', 'U', 'PK_Status', 'PK_Status');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Creator', 'U', 'Creator', 'Creator');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'CreatorContact', 'U', 'CreatorContact', 'CreatorContact');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50009, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Backup_ID', 'U', 'AD_Package_Imp_Backup_ID', 'AD_Package_Imp_Backup_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50010, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Detail_ID', 'U', 'AD_Package_Imp_Detail_ID', 'AD_Package_Imp_Detail_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50011, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Org_Dir', 'U', 'AD_Package_Imp_Org_Dir', 'AD_Package_Imp_Org_Dir');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50012, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 'ColValue', 'U', 'ColValue', 'ColValue');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50013, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_ID', 'U', 'AD_Package_Imp_ID', 'AD_Package_Imp_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50014, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Bck_Dir', 'U', 'AD_Package_Imp_Bck_Dir', 'AD_Package_Imp_Bck_Dir');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50015, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:10', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Original_ID', 'U', 'AD_Original_ID', 'AD_Original_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50016, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:11', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Ad_Backup_ID', 'U', 'Ad_Backup_ID', 'Ad_Backup_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50017, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:13', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Success', 'U', 'Success', 'Success');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50018, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:19', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_ID', 'U', 'AD_Package_Exp_ID', 'AD_Package_Exp_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50019, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Type', 'U', 'AD_Package_Type', 'AD_Package_Type');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50020, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Instructions', 'U', 'Instructions', 'Instructions');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50021, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PK_Name', 'U', 'PK_Name', 'PK_Name');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50022, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:27', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 'File_Directory', 'U', 'File_Directory', 'File_Directory');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50023, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:34', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Detail_ID', 'U', 'AD_Package_Exp_Detail_ID', 'AD_Package_Exp_Detail_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50024, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Destination_FileName', 'U', 'Destination_FileName', 'Destination_FileName');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50025, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Destination_Directory', 'U', 'Destination_Directory', 'Destination_Directory');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50026, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 'DBType', 'U', 'DBType', 'DBType');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50027, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Target_Directory', 'U', 'Target_Directory', 'Target_Directory');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50028, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SQLStatement', 'U', 'SQLStatement', 'SQLStatement');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50029, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Code_New', 'U', 'AD_Package_Code_New', 'AD_Package_Code_New');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50030, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Code_Old', 'U', 'AD_Package_Code_Old', 'AD_Package_Code_Old');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50031, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:05', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Common_ID', 'U', 'AD_Package_Exp_Common_ID', 'AD_Package_Exp_Common_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50032, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:42', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Override_Dict', 'U', 'AD_Override_Dict', 'AD_Override_Dict');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50033, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Dir', 'U', 'AD_Package_Dir', 'AD_Package_Dir');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50034, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Proc_ID', 'U', 'AD_Package_Imp_Proc_ID', 'AD_Package_Imp_Proc_ID');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50035, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Source', 'U', 'AD_Package_Source', 'AD_Package_Source');
Insert into AD_ELEMENT
   (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME)
 Values
   (50036, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Source_Type', 'U', 'AD_Package_Source_Type', 'AD_Package_Source_Type');
COMMIT;

Insert into AD_ROLE
   (AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, USERLEVEL, AMTAPPROVAL, ISMANUAL, ISSHOWACCT, ISPERSONALLOCK, ISPERSONALACCESS, ISCANEXPORT, ISCANREPORT, ISCANAPPROVEOWNDOC, ISACCESSALLORGS, ISCHANGELOG, PREFERENCETYPE, OVERWRITEPRICELIMIT, ISUSEUSERORGACCESS, CONFIRMQUERYRECORDS, MAXQUERYRECORDS)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:50', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:43', 'MM/DD/YYYY HH24:MI:SS'), 'Packaging User', 0, 'Packaging User', ' CO', 0, 'N', 'N', 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'O', 'N', 'N', 0, 0);
COMMIT;

Insert into AD_REFERENCE
   (AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, VALIDATIONTYPE, ENTITYTYPE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:19', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Type', 'Defines the type of packages available', 'L', 'U');
Insert into AD_REFERENCE
   (AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, VALIDATIONTYPE, ENTITYTYPE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:22', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package_Releases', 'List of Package Releases', 'Indicates what release the package is for.  Entering no specific release indicates the package is for all releases.', 'L', 'U');
Insert into AD_REFERENCE
   (AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, VALIDATIONTYPE, ENTITYTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_DB', 'List of database types', 'This is a list of database types used by the inbound packaging processing to determine if the sql statement is fired.', 'L', 'U');
Insert into AD_REFERENCE
   (AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, VALIDATIONTYPE, ENTITYTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Build_Type', 'L', 'U');
Insert into AD_REFERENCE
   (AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, VALIDATIONTYPE, ENTITYTYPE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Source_Type', 'List of package source types', 'L', 'U');
COMMIT;

Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50001, 0, 0, 'N', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'L', 'Local Transfer', 'This type of transfer will transfer objects to the same Adempiere instance', 50001, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50002, 0, 0, 'N', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 'R', 'Remote Transfer', 'This type of transfer will transfer objects to another Adempiere installation accessible by network.', 50001, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 'X', 'XML File', 'This type of transfer will create a XML file ', 50001, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:22', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.2a', 'Release 2.5.2a', 'Release 2.5.2a', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:22', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.2b', 'Release 2.5.2b', 'Release 2.5.2b', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.2c', 'Release 2.5.2c', 'Release 2.5.2c', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.2d', 'Release 2.5.2d', 'Release 2.5.2d', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.2e', 'Release 2.5.2e', 'Release 2.5.2e', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50009, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:20', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.3a', 'Release 2.5.3a', 'Release 2.5.3a', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50010, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release 2.5.3b', 'Release 2.5.3b', 'Release 2.5.3b', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50011, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:11:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'all', 'No specific release', 'No specific release', 50002, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50012, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'ALL', 'All Database Types', 'Use this when a SQL command syntax is the same between database types', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50013, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'DB2', 'DB2', 'DB2 Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50014, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:33', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Firebird', 'Firebird', 'Firebird Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50015, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'MySQL', 'MySQL', 'MySQL Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50016, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Oracle', 'Oracle', 'Oracle Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50017, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Postgres', 'Postgres', 'Postgres Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50018, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SQL', 'SQL Server', 'SQL Server Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50019, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Sybase', 'Sybase', 'Sybase Database', 50003, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50020, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 'B', 'Workbench', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50021, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 'C', 'File - Code or other', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50022, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'D', 'Data', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50023, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 'F', 'Workflow', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50024, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IMP', 'Import Format', 'Exports Import Format', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50025, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'M', 'Application or Module', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50026, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'P', 'Process/Report', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50027, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 'R', 'ReportView', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50028, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:16', 'MM/DD/YYYY HH24:MI:SS'), 0, 'S', 'Role', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50029, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SNI', 'Code Snipit', 'Replace a code snipit with in a file', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50030, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SQL', 'SQL Statement', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50031, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'T', 'Table', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50032, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:20', 'MM/DD/YYYY HH24:MI:SS'), 0, 'W', 'Window', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50033, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'X', 'Form', 50004, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50034, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'File', 'File', 'Package is file based', 50005, 'U');
Insert into AD_REF_LIST
   (AD_REF_LIST_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, AD_REFERENCE_ID, ENTITYTYPE)
 Values
   (50035, 0, 0, 'N', TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'WS', 'WebService', 'Package is available via WebService', 50005, 'U');
COMMIT;

Insert into AD_PROCESS
   (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, ACCESSLEVEL, ENTITYTYPE, ISREPORT, ISDIRECTPRINT, CLASSNAME, STATISTIC_COUNT, STATISTIC_SECONDS, ISBETAFUNCTIONALITY, ISSERVERPROCESS)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:57', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:05:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackRoll', 'PackRoll', '4', 'U', 'N', 'N', 'org.compiere.PackOut.PackRoll', 0, 0, 'N', 'N');
Insert into AD_PROCESS
   (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, ACCESSLEVEL, ENTITYTYPE, ISREPORT, ISDIRECTPRINT, CLASSNAME, STATISTIC_COUNT, STATISTIC_SECONDS, ISBETAFUNCTIONALITY, ISSERVERPROCESS)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:25', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:08:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackOut', 'PackOut', 'Process to create package export', '7', 'U', 'N', 'N', 'org.compiere.PackOut.PackOut', 0, 0, 'N', 'N');
Insert into AD_PROCESS
   (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, ACCESSLEVEL, ENTITYTYPE, ISREPORT, ISDIRECTPRINT, CLASSNAME, STATISTIC_COUNT, STATISTIC_SECONDS, ISBETAFUNCTIONALITY, ISSERVERPROCESS)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:10:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 'File_Select', 'File_Select', 'Select a file', '7', 'U', 'N', 'N', 'com.compiere.packbuilder.Select_File', 0, 0, 'N', 'N');
Insert into AD_PROCESS
   (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, HELP, ACCESSLEVEL, ENTITYTYPE, ISREPORT, ISDIRECTPRINT, CLASSNAME, STATISTIC_COUNT, STATISTIC_SECONDS, ISBETAFUNCTIONALITY, ISSERVERPROCESS)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackIn', 'PackIn', 'Import Package', 'Import a package', '7', 'U', 'N', 'N', 'org.compiere.PackOut.IntPackIn', 0, 0, 'N', 'N');
Insert into AD_PROCESS
   (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, ACCESSLEVEL, ENTITYTYPE, ISREPORT, ISDIRECTPRINT, CLASSNAME, STATISTIC_COUNT, STATISTIC_SECONDS, ISBETAFUNCTIONALITY, ISSERVERPROCESS)
 Values
   (50010, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:02', 'MM/DD/YYYY HH24:MI:SS'), 0, 'CopyRole', 'CopyRole', 'Copy Role', '7', 'U', 'N', 'N', 'org.compiere.process.CopyRole', 1, 1, 'N', 'N');
COMMIT;

Insert into AD_PROCESS_PARA
   (AD_PROCESS_PARA_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_PROCESS_ID, SEQNO, AD_REFERENCE_ID, COLUMNNAME, ISCENTRALLYMAINTAINED, FIELDLENGTH, ISMANDATORY, ISRANGE, AD_ELEMENT_ID, ENTITYTYPE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'From Role', 50010, 10, 19, 'AD_Role_ID', 'Y', 0, 'Y', 'N', 123, 'U');
Insert into AD_PROCESS_PARA
   (AD_PROCESS_PARA_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_PROCESS_ID, SEQNO, AD_REFERENCE_ID, COLUMNNAME, ISCENTRALLYMAINTAINED, FIELDLENGTH, ISMANDATORY, ISRANGE, AD_ELEMENT_ID, ENTITYTYPE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'To Role', 50010, 10, 19, 'AD_Role_ID', 'Y', 0, 'Y', 'N', 123, 'U');
Insert into AD_PROCESS_PARA
   (AD_PROCESS_PARA_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, AD_PROCESS_ID, SEQNO, AD_REFERENCE_ID, COLUMNNAME, ISCENTRALLYMAINTAINED, FIELDLENGTH, ISMANDATORY, ISRANGE, AD_ELEMENT_ID, ENTITYTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:50', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Client', 50010, 20, 19, 'AD_Client_ID', 'Y', 0, 'N', 'N', 102, 'U');
Insert into AD_PROCESS_PARA
   (AD_PROCESS_PARA_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, AD_PROCESS_ID, SEQNO, AD_REFERENCE_ID, COLUMNNAME, ISCENTRALLYMAINTAINED, FIELDLENGTH, ISMANDATORY, ISRANGE, AD_ELEMENT_ID, ENTITYTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:50', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Organization', 50010, 30, 19, 'AD_Org_ID', 'Y', 0, 'N', 'N', 113, 'U');
COMMIT;

Insert into AD_WINDOW
   (AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, ISDEFAULT, ISBETAFUNCTIONALITY)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:25', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:01:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Packages Installed', 'List of packages installed', 'M', 'N', 'U', 'N', 'N', 'N');
Insert into AD_WINDOW
   (AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, ISDEFAULT, ISBETAFUNCTIONALITY)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Maintenance', 'Package installation history and maintenance', 'Review package installation.  Also perform package rollback if required', 'M', 'N', 'U', 'N', 'N', 'N');
Insert into AD_WINDOW
   (AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, ISDEFAULT, ISBETAFUNCTIONALITY)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackOut - Create a package', 'Package build Application', 'M', 'N', 'U', 'N', 'N', 'N');
Insert into AD_WINDOW
   (AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, ISDEFAULT, ISBETAFUNCTIONALITY)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:04', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Common Package Details', 'Maintain Common Package Details', 'Create and maintain common package element details', 'M', 'Y', 'U', 'N', 'N', 'N');
Insert into AD_WINDOW
   (AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, ISDEFAULT, ISBETAFUNCTIONALITY)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackIn - Import a package', 'Imports a package', 'Imports a package previously created by PackOut', 'M', 'Y', 'U', 'N', 'N', 'N');
COMMIT;

Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:25', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:01:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Inst', 'Packages Installed', 'AD_Package_Imp_Inst', 'N', '4', 'U', 50002, 'N', 'N', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Backup', 'Backup of any columns that are updated by a package install', 'AD_Package_Imp_Backup', 'N', '4', 'U', 50002, 'N', 'N', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:54', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp', 'AD_Package_Imp', 'N', '4', 'U', 50002, 'N', 'N', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Detail', 'Package Import Details', 'AD_Package_Imp_Detail', 'N', '4', 'U', 50002, 'N', 'N', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp', 'Table to facilitate Package Building', 'AD_Package_Exp', 'N', '4', 'U', 50003, 'N', 'Y', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:32', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Detail', 'AD_Package_Exp_Detail', 'N', '4', 'U', 50003, 'N', 'Y', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:04', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Common', 'Mainain common elements that are used in all packages', 'This table contains detail package elements that are used in all packages that are created from this instance.', 'AD_Package_Exp_Common', 'N', '4', 'U', 50004, 'N', 'Y', 'N', 'N', 'N', 'L');
Insert into AD_TABLE
   (AD_TABLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TABLENAME, ISVIEW, ACCESSLEVEL, ENTITYTYPE, AD_WINDOW_ID, ISSECURITYENABLED, ISDELETEABLE, ISHIGHVOLUME, IMPORTTABLE, ISCHANGELOG, REPLICATIONTYPE)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Proc', 'Process Inbound Packages from with in Adempiere', 'AD_Package_Imp_Proc', 'N', '4', 'U', 50005, 'N', 'Y', 'N', 'N', 'N', 'L');
COMMIT;

Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:25', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:01:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Name', 'Alphanumeric identifier of the entity', 'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.', 0, 'U', 'Name', 50001, 10, 240, 'N', 'N', 'N', 'Y', 'Y', 1, 'N', 'N', 'N', 469, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:26', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:01:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 0, 'U', 'AD_Client_ID', 50001, 19, 10, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:27', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 0, 'U', 'AD_Org_ID', 50001, 19, 10, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:27', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_PACKAGE_IMP_INST_ID', 0, 'U', 'AD_PACKAGE_IMP_INST_ID', 50001, 13, 10, 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 50001, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:28', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 'Date this record was created', 'The Created field indicates the date that this record was created.', 0, 'U', 'Created', 50001, 16, 7, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:28', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created By', 'User who created this records', 'The Created By field indicates the user who created this record.', 0, 'U', 'CreatedBy', 50001, 18, 110, 10, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedDate', 0, 'U', 'CreatedDate', 50001, 10, 50, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 50002, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:29', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Version', 0, 'U', 'PK_Version', 50001, 10, 40, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50003, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50009, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:30', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Process Now', 0, 'U', 'Processing', 50001, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 524, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50010, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:30', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:20', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Version', 'Version of the table definition', 'The Version indicates the version of this table definition.', 0, 'U', 'Version', 50001, 10, 40, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 624, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50011, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:31', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedDate', 0, 'U', 'UpdatedDate', 50001, 10, 50, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50004, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50012, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated By', 'User who updated this records', 'The Updated By field indicates the user who updated this record.', 0, 'U', 'UpdatedBy', 50001, 18, 110, 10, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50013, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 'Date this record was updated', 'The Updated field indicates the date that this record was updated.', 0, 'U', 'Updated', 50001, 16, 7, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50014, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Uninstall', 0, 'U', 'Uninstall', 50001, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50005, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50015, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Release No', 'Internal Release Number', 0, 'U', 'ReleaseNo', 50001, 10, 40, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 2122, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50016, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processed', 'The document has been processed', 'The Processed checkbox indicates that a document has been processed.', 0, 'U', 'Processed', 50001, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1047, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50017, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Status', 0, 'U', 'PK_Status', 50001, 10, 44, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50006, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50018, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Creator', 0, 'U', 'Creator', 50001, 10, 120, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50007, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50019, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:37', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatorContact', 0, 'U', 'CreatorContact', 50001, 14, 510, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50008, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50020, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:37', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 0, 'U', 'Description', 50001, 14, 2000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 275, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50021, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:37', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'EMail Address', 'Electronic Mail Address', 'The Email Address is the Electronic Mail ID for this User and should be fully qualified (e.g. joe.smith@company.com). The Email Address is used to access the self service application functionality from the web.', 0, 'U', 'EMail', 50001, 10, 120, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 881, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50022, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:38', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:02:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 0, 'U', 'IsActive', 50001, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50023, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Backup_ID', 0, 'U', 'AD_Package_Imp_Backup_ID', 50002, 13, 22, 'Y', 'N', 'Y', 'N', 'Y', 1, 'N', 'N', 'N', 50009, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50024, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Client_ID', 0, 'U', 'AD_Client_ID', 50002, 19, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50025, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Column_ID', 0, 'U', 'AD_Column_ID', 50002, 18, 251, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 104, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50026, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Detail_ID', 0, 'U', 'AD_Package_Imp_Detail_ID', 50002, 13, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 50010, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50027, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:44', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Org_Dir', 0, 'U', 'AD_Package_Imp_Org_Dir', 50002, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50011, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50028, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Table_ID', 0, 'U', 'AD_Table_ID', 50002, 13, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 126, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50029, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 0, 'U', 'Created', 50002, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50030, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:47', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'IsActive', 0, 'U', 'IsActive', 50002, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50031, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:47', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:03:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 0, 'U', 'Updated', 50002, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50032, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:47', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedBy', 0, 'U', 'UpdatedBy', 50002, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50033, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:48', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Uninstall', 0, 'U', 'Uninstall', 50002, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50005, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50034, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:48', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:06', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedBy', 0, 'U', 'CreatedBy', 50002, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50035, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'ColValue', 0, 'U', 'ColValue', 50002, 10, 2000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50012, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50036, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Reference_ID', 0, 'U', 'AD_Reference_ID', 50002, 18, 1, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 120, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50037, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:49', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_ID', 0, 'U', 'AD_Package_Imp_ID', 50002, 13, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 50013, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50038, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:51', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:16', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Bck_Dir', 0, 'U', 'AD_Package_Imp_Bck_Dir', 50002, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50014, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50039, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:51', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Org_ID', 0, 'U', 'AD_Org_ID', 50002, 13, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50040, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:54', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_ID', 0, 'U', 'AD_Package_Imp_ID', 50003, 13, 22, 'Y', 'N', 'Y', 'N', 'Y', 1, 'N', 'N', 'N', 50013, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50041, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:54', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:54', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Client_ID', 0, 'U', 'AD_Client_ID', 50003, 19, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50042, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 0, 'U', 'Created', 50003, 16, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50043, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:04:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedDate', 0, 'U', 'CreatedDate', 50003, 10, 25, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50002, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50044, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatorContact', 0, 'U', 'CreatorContact', 50003, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50008, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50045, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:56', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'EMail', 0, 'U', 'EMail', 50003, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 881, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50046, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:56', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Name', 0, 'U', 'Name', 50003, 10, 60, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 469, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50047, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:57', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Version', 0, 'U', 'PK_Version', 50003, 10, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50003, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50048, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:57', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processing', 0, 'U', 'Processing', 50003, 28, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 524, 50002, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50049, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:59', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Version', 0, 'U', 'Version', 50003, 10, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 624, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50050, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:59', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedDate', 0, 'U', 'UpdatedDate', 50003, 10, 25, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50004, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50051, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:59', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:25', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedBy', 0, 'U', 'UpdatedBy', 50003, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50052, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 0, 'U', 'Updated', 50003, 16, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50053, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Uninstall', 0, 'U', 'Uninstall', 50003, 20, 1, 'N', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50005, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50054, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'ReleaseNo', 0, 'U', 'ReleaseNo', 50003, 10, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 2122, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50055, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:01', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processed', 0, 'U', 'Processed', 50003, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1047, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50056, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:02', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Status', 'Status of package installation', 0, 'U', 'PK_Status', 50003, 10, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50006, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50057, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:03', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'IsActive', 0, 'U', 'IsActive', 50003, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50058, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:03', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Description', 0, 'U', 'Description', 50003, 34, 1000, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 275, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50059, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:03', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Creator', 0, 'U', 'Creator', 50003, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50007, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50060, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:04', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedBy', 0, 'U', 'CreatedBy', 50003, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50061, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:04', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:05:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Org_ID', 0, 'U', 'AD_Org_ID', 50003, 19, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50062, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:09', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Client_ID', 0, 'U', 'AD_Client_ID', 50004, 19, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50063, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:09', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Org_ID', 0, 'U', 'AD_Org_ID', 50004, 19, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50064, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:10', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Original_ID', 0, 'U', 'AD_Original_ID', 50004, 13, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50015, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50065, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:10', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Detail_ID', 0, 'U', 'AD_Package_Imp_Detail_ID', 50004, 13, 22, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 50010, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50066, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:10', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_ID', 0, 'U', 'AD_Package_Imp_ID', 50004, 13, 60, 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 50013, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50067, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:11', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Table_ID', 0, 'U', 'AD_Table_ID', 50004, 13, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 126, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50068, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:11', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Action', 0, 'U', 'Action', 50004, 10, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 152, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50069, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:11', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:06:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Ad_Backup_ID', 0, 'U', 'Ad_Backup_ID', 50004, 13, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50016, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50070, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:12', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 0, 'U', 'Created', 50004, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50071, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:12', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedBy', 0, 'U', 'CreatedBy', 50004, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50072, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:13', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'IsActive', 0, 'U', 'IsActive', 50004, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50073, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:13', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Name', 0, 'U', 'Name', 50004, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 469, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50074, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:13', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Success', 'Indicates Success', 'Indicates if the process was successful or not', 0, 'U', 'Success', 50004, 10, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50017, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50075, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:14', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'TableName', 0, 'U', 'TableName', 50004, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 587, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50076, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:14', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Type', 0, 'U', 'Type', 50004, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 600, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50077, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:14', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Uninstall', 'Indicates if an object has been uninstalled or reversed', 'Indicates if an object has been uninstalled or reset since the object was installed or updated by the package installation process', 0, 'U', 'Uninstall', 50004, 20, 1, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 50005, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50078, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:15', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 0, 'U', 'Updated', 50004, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50079, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:15', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedBy', 0, 'U', 'UpdatedBy', 50004, 18, 110, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50080, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:19', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Exp_ID', 0, 'U', 'AD_Package_Exp_ID', 50005, 13, 22, 'Y', 'N', 'Y', 'Y', '@Processed@="Y"', 'Y', 1, 'N', 'N', 'N', 50018, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50081, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:19', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:07:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Client_ID', 0, 'U', 'AD_Client_ID', 50005, 19, 22, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50082, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:02', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Type', 'Defines the type of package.  XML File Local and Remote', 0, 'U', 'AD_Package_Type', 50005, 17, 50001, 1, '''X''', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50019, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50083, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:20', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedBy', 0, 'U', 'CreatedBy', 50005, 18, 110, 22, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50084, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Email Address', 'Email Address creator of the package', 0, 'U', 'EMail', 50005, 10, 30, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 881, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50085, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Instructions', 0, 'U', 'Instructions', 50005, 34, 1000, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50020, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50086, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:21', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Name', 'Name of Package', 0, 'U', 'PK_Name', 50005, 10, 60, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50021, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50087, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:22', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processed', 0, 'U', 'Processed', 50005, 20, 1, 'N', 'N', 'N', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 1047, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50088, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:23', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'ReleaseNo', 'Release Number', 0, 'U', 'ReleaseNo', 50005, 17, 50002, 20, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 2122, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50089, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:24', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Version', 0, 'U', 'Version', 50005, 10, 20, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 624, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50090, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:24', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UserName', 'Creator of Package', 0, 'U', 'UserName', 50005, 10, 30, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 1903, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50091, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:24', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedBy', 0, 'U', 'UpdatedBy', 50005, 18, 110, 22, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50092, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:25', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 0, 'U', 'Updated', 50005, 16, 7, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50093, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:25', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processing', 'Process to create package export', 0, 'U', 'Processing', 50005, 28, 1, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 524, 50004, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50094, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:27', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Version', 'Package Version', 0, 'U', 'PK_Version', 50005, 10, 20, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50003, 'N', 'Y');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50095, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:27', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'IsActive', 0, 'U', 'IsActive', 50005, 20, 1, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50096, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:27', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'File_Directory', 0, 'U', 'File_Directory', 50005, 14, 255, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 50022, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50097, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:28', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Description', 0, 'U', 'Description', 50005, 34, 1000, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 275, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50098, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:28', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 0, 'U', 'Created', 50005, 16, 7, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50099, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:28', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:08:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Org_ID', 0, 'U', 'AD_Org_ID', 50005, 19, 22, 'N', 'N', 'Y', 'Y', '@Processed@="Y"', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50100, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Exp_Detail_ID', 0, 'U', 'AD_Package_Exp_Detail_ID', 50006, 13, 22, 'Y', 'N', 'Y', 'Y', 'Y', 1, 'N', 'N', 'N', 50023, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50101, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Client_ID', 0, 'U', 'AD_Client_ID', 50006, 19, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50102, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Form_ID', 0, 'U', 'AD_Form_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1298, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50103, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:54', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_ImpFormat_ID', 'AD_ImpFormat_ID', 'Contains the Impformat ID', 0, 'U', 'AD_ImpFormat_ID', 50006, 19, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1311, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50104, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Menu_ID', 0, 'U', 'AD_Menu_ID', 50006, 19, 105, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 110, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50105, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:09:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Process_ID', 0, 'U', 'AD_Process_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 117, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50106, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:36', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:02', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Role_ID', 'Role', 0, 'U', 'AD_Role_ID', 50006, 19, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 123, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50107, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:36', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Window_ID', 0, 'U', 'AD_Window_ID', 50006, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 143, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50108, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:36', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Workflow_ID', 0, 'U', 'AD_Workflow_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 144, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50109, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:37', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'IsActive', 0, 'U', 'IsActive', 50006, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50110, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:37', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'File_Directory', 0, 'U', 'File_Directory', 50006, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50022, 50006, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50111, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:38', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'FileName', 0, 'U', 'FileName', 50006, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 2295, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50112, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:38', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Destination_FileName', 0, 'U', 'Destination_FileName', 50006, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50024, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50113, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:39', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Destination_Directory', 0, 'U', 'Destination_Directory', 50006, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50025, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50114, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:40', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:25', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Description', 0, 'U', 'Description', 50006, 34, 1000, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 275, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50115, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:41', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'DBType', 'Indicates type of database', 'Indicates the type of database used that the SQL command is for.', 0, 'U', 'DBType', 50006, 17, 50003, 22, '''ALL''', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50026, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50116, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'CreatedBy', 0, 'U', 'CreatedBy', 50006, 11, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50117, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 0, 'U', 'Created', 50006, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50118, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'UpdatedBy', 0, 'U', 'UpdatedBy', 50006, 11, 22, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50119, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:10:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 0, 'U', 'Updated', 50006, 15, 7, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50120, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Type', 0, 'U', 'Type', 50006, 17, 50004, 10, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 600, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50121, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Target_Directory', 'Directory where the file to be distributed will be copied to', 0, 'U', 'Target_Directory', 50006, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50027, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50122, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:46', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'SQLStatement', 0, 'U', 'SQLStatement', 50006, 34, 2000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50028, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50123, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:53', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'ReleaseNo', 0, 'U', 'ReleaseNo', 50006, 17, 50002, 20, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 2122, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50124, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:54', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processing', 0, 'U', 'Processing', 50006, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 524, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50125, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:54', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processed', 0, 'U', 'Processed', 50006, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1047, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50126, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:54', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Name', 'Name of package', 0, 'U', 'PK_Name', 50006, 10, 60, '@SQL=SELECT PK_Name FROM AD_Package_Exp_Detail WHERE AD_Package_Exp_ID=@AD_Package_Exp_ID@', 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50021, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50127, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Name2', 0, 'U', 'Name2', 50006, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1111, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50128, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Line', 0, 'U', 'Line', 50006, 11, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 439, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50129, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:55', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Workbench_ID', 0, 'U', 'AD_Workbench_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1646, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50130, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:56', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Table_ID', 0, 'U', 'AD_Table_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 126, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50131, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:56', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_ReportView_ID', 'Contain the Report View ID', 0, 'U', 'AD_ReportView_ID', 50006, 30, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1252, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50132, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:56', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Exp_ID', 0, 'U', 'AD_Package_Exp_ID', 50006, 13, 22, 'N', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', 50018, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50133, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Org_ID', 0, 'U', 'AD_Org_ID', 50006, 19, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50134, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:54', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Code_New', 0, 'U', 'AD_Package_Code_New', 50006, 34, 2000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50029, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50135, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:57', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:11:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Code_Old', 0, 'U', 'AD_Package_Code_Old', 50006, 34, 2000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50030, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50136, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:05', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Exp_Common_ID', 0, 'U', 'AD_Package_Exp_Common_ID', 50007, 13, 10, 'Y', 'N', 'Y', 'N', 'Y', 1, 'N', 'N', 'N', 50031, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50137, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:05', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 0, 'U', 'AD_Client_ID', 50007, 19, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50138, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:05', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Special Form', 'Special Form', 'The Special Form field identifies a unique Special Form in the system.', 0, 'U', 'AD_Form_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1298, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50139, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:06', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:20', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Import Format', 0, 'U', 'AD_ImpFormat_ID', 50007, 19, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1311, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50140, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:06', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Report View', 'View used to generate this report', 'The Report View indicates the view used to generate this report.', 0, 'U', 'AD_ReportView_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1252, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50141, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:06', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:25', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Table', 'Table for the Fields', 'The Table indicates the table in which a field or fields reside.', 0, 'U', 'AD_Table_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 126, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50142, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:07', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Workbench', 'Collection of windows reports', 0, 'U', 'AD_Workbench_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1646, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50143, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:07', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 'Date this record was created', 'The Created field indicates the date that this record was created.', 0, 'U', 'Created', 50007, 15, 7, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50144, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:15', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'DBType', 'Indicates the type of database.', 'This field indicates the type of database.', 0, 'U', 'DBType', 50007, 17, 50003, 22, '''ALL''', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50026, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50145, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:15', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processed', 'The document has been processed', 'The Processed checkbox indicates that a document has been processed.', 0, 'U', 'Processed', 50007, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1047, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50146, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:15', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'PK_Name', 0, 'U', 'PK_Name', 50007, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50021, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50147, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:16', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Name 2', 'Additional Name', 0, 'U', 'Name2', 50007, 10, 60, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 1111, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50148, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:16', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Line No', 'Unique line for this document', 'Indicates the unique line for a document.  It will also control the display order of the lines within a document.', 0, 'U', 'Line', 50007, 11, 22, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 439, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50149, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:16', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 0, 'U', 'IsActive', 50007, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50150, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:17', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'File_Directory', 0, 'U', 'File_Directory', 50007, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50022, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50151, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:17', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:13:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'File Name', 'Name of the local file or URL', 'Name of a file in the local directory space - or URL (file://.. http://.. ftp://..)', 0, 'U', 'FileName', 50007, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 2295, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50152, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:17', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Destination_Directory', 0, 'U', 'Destination_Directory', 50007, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50025, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50153, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:18', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 0, 'U', 'Description', 50007, 34, 1000, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 275, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50154, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:18', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated By', 'User who updated this records', 'The Updated By field indicates the user who updated this record.', 0, 'U', 'UpdatedBy', 50007, 18, 110, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 608, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50155, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:19', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 'Date this record was updated', 'The Updated field indicates the date that this record was updated.', 0, 'U', 'Updated', 50007, 16, 7, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50156, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:32', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Type', 'Type of Validation (SQL Java Script Java Language)', 'The Type indicates the type of validation that will occur.  This can be SQL Java Script or Java Language.', 0, 'U', 'Type', 50007, 17, 50004, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 600, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50157, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:32', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Target_Directory', 0, 'U', 'Target_Directory', 50007, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50027, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50158, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:32', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'SQLStatement', 0, 'U', 'SQLStatement', 50007, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50028, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50159, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Process Now', 0, 'U', 'Processing', 50007, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 524, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50160, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created By', 'User who created this records', 'The Created By field indicates the user who created this record.', 0, 'U', 'CreatedBy', 50007, 18, 110, 22, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50161, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:33', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Workflow', 'Workflow or combination of tasks', 'The Workflow field identifies a unique Workflow in the system.', 0, 'U', 'AD_Workflow_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 144, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50162, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Window', 'Data entry or display window', 'The Window field identifies a unique Window in the system.', 0, 'U', 'AD_Window_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 143, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50163, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Role', 'Responsibility Role', 'The Role determines security and access a user who has this Role will have in the System.', 0, 'U', 'AD_Role_ID', 50007, 19, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 123, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50164, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:34', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Process', 'Process or Report', 'The Process field identifies a unique Process or Report in the system.', 0, 'U', 'AD_Process_ID', 50007, 30, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 117, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50165, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Menu', 'Identifies a Menu', 'The Menu identifies a unique Menu.  Menus are used to control the display of those screens a user has access to.', 0, 'U', 'AD_Menu_ID', 50007, 19, 10, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 110, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50166, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:35', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:14:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 0, 'U', 'AD_Org_ID', 50007, 19, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50167, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:41', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 0, 'U', 'AD_Client_ID', 50008, 19, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 102, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50168, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:16', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 0, 'U', 'AD_Org_ID', 50008, 19, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 113, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50169, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:42', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Override_Dict', 0, 'U', 'AD_Override_Dict', 50008, 20, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50032, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50170, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Dir', 'Where the package directory is located', 0, 'U', 'AD_Package_Dir', 50008, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50033, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50171, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Imp_Proc_ID', 0, 'U', 'AD_Package_Imp_Proc_ID', 50008, 13, 10, 'Y', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 50034, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50172, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:43', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Source', 'Where the package is located', 0, 'U', 'AD_Package_Source', 50008, 10, 255, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 50035, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50173, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:44', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'AD_Package_Source_Type', 0, 'U', 'AD_Package_Source_Type', 50008, 17, 50005, 10, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 50036, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50174, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created', 'Date this record was created', 'The Created field indicates the date that this record was created.', 0, 'U', 'Created', 50008, 16, 7, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 245, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50175, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Created By', 'User who created this records', 'The Created By field indicates the user who created this record.', 0, 'U', 'CreatedBy', 50008, 18, 110, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 246, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50176, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:45', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 0, 'U', 'IsActive', 50008, 20, 1, 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 348, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50177, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:46', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Processing', 'Start the import process', 0, 'U', 'Processing', 50008, 28, 1, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 524, 50008, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50178, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:46', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:49', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated', 'Date this record was updated', 'The Updated field indicates the date that this record was updated.', 0, 'U', 'Updated', 50008, 16, 7, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 607, 'N', 'N');
Insert into AD_COLUMN
   (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, FIELDLENGTH, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, ISIDENTIFIER, ISTRANSLATED, ISENCRYPTED, ISSELECTIONCOLUMN, AD_ELEMENT_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE)
 Values
   (50179, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:47', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('12/12/2006 00:16:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 0, 'Updated By', 'User who updated this records', 'The Updated By field indicates the user who updated this record.', 0, 'U', 'UpdatedBy', 50008, 18, 110, 10, 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 608, 'N', 'N');
COMMIT;

Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:02:53', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Packages Installed', 'Packages Installed', 50001, 50001, 10, 0, 'N', 'N', 'N', 'Y', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Object Backups', 'Details by column original values before the record was overwritten', 'Displays values for each column for each record that was updated by a package install.  This backup is used in the package reversal process.', 50002, 50002, 30, 2, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:04', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:05:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Installation Log', 'Installation history of packages', 50003, 50002, 10, 0, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:15', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Objects Installed', 50004, 50002, 20, 1, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:02', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Export Package', 50005, 50003, 10, 0, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, ORDERBYCLAUSE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:58', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Details', 50006, 50003, 20, 1, 'N', 'N', 'N', 'N', 'N', 'Line ASC', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:35', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Common Details', 50007, 50004, 10, 0, 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
Insert into AD_TAB
   (AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, HASTREE, PROCESSING, ISSORTTAB, ENTITYTYPE, ISINSERTRECORD, ISADVANCEDTAB)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:47', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:16:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PackIn', 'Import a package created by PackOut', 50008, 50005, 10, 0, 'Y', 'N', 'N', 'N', 'N', 'N', 'N', 'U', 'Y', 'N');
COMMIT;

Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:02:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_PACKAGE_IMP_INST_ID', 'Y', 50001, 50004, 'N', 10, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:02:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 50001, 50022, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:02:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Release No', 'Internal Release Number', 'Y', 50001, 50015, 'N', 40, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Version', 'Version of the table definition', 'The Version indicates the version of this table definition.', 'Y', 50001, 50010, 'N', 40, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Creator', 'Y', 50001, 50018, 'N', 120, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 'CreatorContact', 'Y', 50001, 50019, 'N', 510, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Process Now', 'Y', 50001, 50009, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed', 'The document has been processed', 'The Processed checkbox indicates that a document has been processed.', 'Y', 50001, 50016, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50009, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:10', 'MM/DD/YYYY HH24:MI:SS'), 0, 'EMail Address', 'Electronic Mail Address', 'The Email Address is the Electronic Mail ID for this User and should be fully qualified (e.g. joe.smith@company.com). The Email Address is used to access the self service application functionality from the web.', 'Y', 50001, 50021, 'N', 120, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50010, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 50001, 50002, 'Y', 10, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50011, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 'Y', 50001, 50003, 'Y', 10, 'N', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50012, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:16', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Name', 'Alphanumeric identifier of the entity', 'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.', 'Y', 50001, 50001, 'Y', 240, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50013, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Version', 'Y', 50001, 50008, 'Y', 40, 'N', 40, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50014, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 'Y', 50001, 50020, 'Y', 2000, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50015, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Status', 'Y', 50001, 50017, 'Y', 44, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50016, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Created', 'Date Installed', 'Y', 50001, 50005, 'Y', 0, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50017, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Updated', 'Date last Updated', 'Y', 50001, 50013, 'Y', 0, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50018, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:42', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:03:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Uninstalled?', 'Y', 50001, 50014, 'Y', 1, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50019, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IsActive', 'Y', 50002, 50030, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50020, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Y', 50002, 50024, 'Y', 22, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50021, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Y', 50002, 50039, 'Y', 22, 'N', 20, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50022, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Import ID', 'Y', 50002, 50037, 'Y', 22, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50023, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Imp Detail ID', 'Y', 50002, 50026, 'Y', 22, 'N', 40, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50024, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:33', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Imp Backup ID', 'Y', 50002, 50023, 'Y', 22, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50025, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Table ID', 'Y', 50002, 50028, 'Y', 22, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50026, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Column ID', 'Y', 50002, 50025, 'Y', 22, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50027, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Column Type', 'Y', 50002, 50036, 'Y', 22, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50028, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Column Value', 'Y', 50002, 50035, 'Y', 2000, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50029, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:53', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Uninstall', 'Y', 50002, 50033, 'Y', 1, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50030, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:54', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Backup File', 'Y', 50002, 50038, 'Y', 255, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50031, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:54', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:04:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Original File', 'Y', 50002, 50027, 'Y', 255, 'N', 110, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50032, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:05', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:05:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 'EMail', 'Y', 50003, 50045, 'N', 60, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50033, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:05', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed', 'Y', 50003, 50055, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50034, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:05', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IsActive', 'Y', 50003, 50057, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50035, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:05', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:05', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Y', 50003, 50041, 'Y', 22, 'Y', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50036, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:06', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Y', 50003, 50061, 'Y', 22, 'Y', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50037, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package ID', 'Y', 50003, 50040, 'Y', 22, 'Y', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50038, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Name', 'Y', 50003, 50046, 'Y', 22, 'Y', 40, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50039, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Version', 'Y', 50003, 50047, 'Y', 20, 'Y', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50040, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Description', 'Y', 50003, 50058, 'Y', 1000, 'Y', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50041, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:06', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package installed on', 'Package installed on', 'Y', 50003, 50042, 'Y', 10, 'Y', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50042, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:07', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Installed by', 'Installed by', 'Package was installed by', 'Y', 50003, 50060, 'Y', 10, 'Y', 80, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50043, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:07', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Status', 'Status of package installation', 'Y', 50003, 50056, 'Y', 22, 'Y', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50044, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:07', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package created on', 'Date package was created on', 'Y', 50003, 50043, 'Y', 0, 'Y', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50045, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:07', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package last updated on', 'Date package was last updated on', 'Y', 50003, 50050, 'Y', 0, 'Y', 110, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50046, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:07', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Creator', 'Y', 50003, 50059, 'Y', 60, 'Y', 120, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50047, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Creator Contact', 'Y', 50003, 50044, 'Y', 60, 'Y', 130, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50048, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Min. Release No.', 'Y', 50003, 50054, 'Y', 20, 'Y', 140, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50049, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Min. Version No.', 'Y', 50003, 50049, 'Y', 20, 'Y', 150, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50050, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:33', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Reverse Package', 'Y', 50003, 50048, 'Y', 1, 'N', 160, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50051, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:08', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:06:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Uninstalled', 'Y', 50003, 50053, 'Y', 1, 'N', 170, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50052, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:15', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IsActive', 'Y', 50004, 50072, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50053, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Y', 50004, 50062, 'Y', 22, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50054, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Y', 50004, 50063, 'Y', 22, 'N', 20, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50055, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package ID', 'Y', 50004, 50066, 'Y', 60, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50056, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:33', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Detail ID', 'Y', 50004, 50065, 'Y', 22, 'N', 40, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50057, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Record Backup ID', 'Y', 50004, 50069, 'Y', 22, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50058, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:16', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Name', 'Y', 50004, 50073, 'Y', 60, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50059, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:17', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Action', 'Y', 50004, 50068, 'Y', 20, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50060, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:17', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:39', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Original ID', 'Y', 50004, 50064, 'Y', 22, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50061, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:17', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Success', 'Indicates Success', 'Y', 50004, 50074, 'Y', 20, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50062, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:17', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Table ID', 'Y', 50004, 50067, 'Y', 22, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50063, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:17', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:44', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Table Name', 'Y', 50004, 50075, 'Y', 60, 'N', 110, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50064, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Type', 'Y', 50004, 50076, 'Y', 60, 'N', 120, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50065, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:07:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Uninstalled', 'Indicates if an object has been uninstalled or reversed', 'Y', 50004, 50077, 'Y', 1, 'N', 130, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50066, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_ID', 'N', 50005, 50080, 'N', 22, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50067, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:06', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed', 'N', 50005, 50087, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50068, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IsActive', 'N', 50005, 50095, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50069, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:29', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'N', 50005, 50081, 'Y', 22, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50070, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'N', 50005, 50099, 'Y', 22, 'N', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50071, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Name of Package', 'Name of Package', 'N', 50005, 50086, 'Y', 22, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50072, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Version', 'Package Version', 'Y', 50005, 50094, 'Y', 0, 'N', 40, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50073, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 'UserName', 'Creator of Package', 'Y', 50005, 50090, 'Y', 22, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50074, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Email Address', 'Email Address creator of the package', 'Y', 50005, 50084, 'Y', 22, 'N', 60, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50075, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:30', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Creation Directory', 'N', 50005, 50096, 'Y', 255, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50076, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Created By', 'User who created the package', 'N', 50005, 50083, 'Y', '@Processed@="Y"', 0, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50077, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:25', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Create Date', 'Date when Package was created', 'N', 50005, 50098, 'Y', '@Processed@="Y"', 0, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50078, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Version', 'Y', 50005, 50089, 'Y', 20, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50079, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'ReleaseNo', 'Release Number', 'Y', 50005, 50088, 'Y', 20, 'N', 110, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50080, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed By', 'User who Processed the package', 'N', 50005, 50091, 'Y', '@Processed@="Y"', 0, 'N', 120, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50081, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed Date', 'Date when the package was processed', 'N', 50005, 50092, 'Y', '@Processed@="Y"', 0, 'N', 130, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50082, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:31', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Description of Package', 'N', 50005, 50097, 'Y', 1000, 'N', 140, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50083, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:32', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Instructions', 'Y', 50005, 50085, 'Y', 1000, 'N', 150, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50084, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:32', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Type', 'Defines the type of package.  XML File Local and Remote', 'Y', 50005, 50082, 'Y', 1, 'N', 160, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50085, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:32', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:09:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Export Package', 'N', 50005, 50093, 'Y', 1, 'N', 170, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50086, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:58', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Detail_ID', 'N', 50006, 50100, 'N', 22, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50087, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:07', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Item Name', 'N', 50006, 50127, 'N', 0, 'N', 0, 1, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50088, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:09', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processing', 'N', 50006, 50124, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50089, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:12', 'MM/DD/YYYY HH24:MI:SS'), 0, 'IsActive', 'N', 50006, 50109, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50090, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:13', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed', 'N', 50006, 50125, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50091, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:15', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Build ID', 'N', 50006, 50132, 'N', 22, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50092, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:59', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'N', 50006, 50101, 'Y', 22, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50093, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'N', 50006, 50133, 'Y', 22, 'N', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50094, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Name', 'N', 50006, 50126, 'Y', 60, 'Y', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50095, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Line No', 'Y', 50006, 50128, 'Y', 10, 'N', 40, 1, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50096, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Type', 'N', 50006, 50120, 'Y', 10, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50097, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Menu', 'N', 50006, 50104, 'Y', '@Type@=''M''', 0, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50098, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:27', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Source File Name', 'Source file name', 'Y', 50006, 50111, 'Y', '@Type@=''C''', 255, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50099, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:29', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Source File Directory', 'Current location of source file', 'N', 50006, 50110, 'Y', '@Type@=''C''', 255, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50100, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:30', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Target Directory', 'Directory where the source file will be copied to in the package', 'Y', 50006, 50121, 'Y', '@Type@=''C''', 255, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50101, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Destination File Name', 'Y', 50006, 50112, 'Y', '@Type@=''SNI''', 255, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50102, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Destination Directory', 'Y', 50006, 50113, 'Y', '@Type@=''C''|@Type@=''SNI''', 255, 'N', 110, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50103, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:35', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Table', 'N', 50006, 50130, 'Y', '@Type@=''T''|@Type@=''D''', 22, 'N', 120, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50104, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:01', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:37', 'MM/DD/YYYY HH24:MI:SS'), 0, 'DBType', 'Indicates type of database', 'Indicates the type of database used that the SQL command is for.', 'Y', 50006, 50115, 'Y', '@Type@=''SQL''', 22, 'N', 130, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50105, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SQLStatement', 'Y', 50006, 50122, 'Y', '@Type@=''D''|Type@=''SQL''', 255, 'N', 140, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50106, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Old Code', 'Code to replace', 'Y', 50006, 50135, 'Y', '@Type@=''SNI''', 2000, 'N', 150, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50107, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'New Code', 'Code to replace old code', 'Y', 50006, 50134, 'Y', '@Type@=''SNI''', 2000, 'N', 160, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50108, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Form', 'N', 50006, 50102, 'Y', '@Type@=''X''', 22, 'N', 170, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50109, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Process', 'N', 50006, 50105, 'Y', '@Type@=''P''', 22, 'N', 180, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50110, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:02', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Workflow', 'N', 50006, 50108, 'Y', '@Type@=''F''', 22, 'N', 190, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50111, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Window', 'Y', 50006, 50107, 'Y', '@Type@=''W''', 0, 'N', 200, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50112, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Workbench', 'N', 50006, 50129, 'Y', '@Type@=''B''', 22, 'N', 210, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50113, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:54', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Role', 'Role', 'Y', 50006, 50106, 'Y', '@Type@=''S''', 22, 'N', 220, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50114, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:56', 'MM/DD/YYYY HH24:MI:SS'), 0, 'ReportView', 'Contain the Report View ID', 'Y', 50006, 50131, 'Y', '@Type@=''R''', 22, 'N', 230, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50115, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:58', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Import Format', 'AD_ImpFormat_ID', 'Contains the Impformat ID', 'Y', 50006, 50103, 'Y', '@Type@=''IMP''', 22, 'N', 240, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50116, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:12:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 'ReleaseNo', 'Y', 50006, 50123, 'Y', '@Type@=''C'' | @Type@=''SNI''', 10, 'N', 250, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50117, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:04', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:13:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Notes', 'N', 50006, 50114, 'Y', 1000, 'N', 260, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50118, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:36', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:57', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Common_ID', 'Y', 50007, 50136, 'N', 10, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50119, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:36', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:14:59', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 50007, 50149, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50120, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:36', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:01', 'MM/DD/YYYY HH24:MI:SS'), 0, 'PK_Name', 'Y', 50007, 50146, 'N', 60, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50121, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Name 2', 'Additional Name', 'Y', 50007, 50147, 'N', 60, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50122, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:06', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Process Now', 'Y', 50007, 50159, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50123, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:08', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Processed', 'The document has been processed', 'The Processed checkbox indicates that a document has been processed.', 'Y', 50007, 50145, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50124, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:11', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 50007, 50137, 'Y', 10, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50125, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 'Y', 50007, 50166, 'Y', 10, 'N', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50126, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:37', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:17', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Line No', 'Unique line for this document', 'Indicates the unique line for a document.  It will also control the display order of the lines within a document.', 'Y', 50007, 50148, 'Y', 22, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50127, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:19', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Type', 'Type of Validation (SQL Java Script Java Language)', 'The Type indicates the type of validation that will occur.  This can be SQL Java Script or Java Language.', 'Y', 50007, 50156, 'Y', 10, 'N', 40, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50128, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:22', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Menu', 'Identifies a Menu', 'The Menu identifies a unique Menu.  Menus are used to control the display of those screens a user has access to.', 'Y', 50007, 50165, 'Y', '@Type@=''M''', 10, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50129, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'File Name', 'Name of the local file or URL', 'Name of a file in the local directory space - or URL (file://.. http://.. ftp://..)', 'Y', 50007, 50151, 'Y', '@Type@=''C''', 255, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50130, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:26', 'MM/DD/YYYY HH24:MI:SS'), 0, 'File Directory', 'Y', 50007, 50150, 'Y', '@Type@=''C''', 255, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50131, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:38', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Target Directory', 'Y', 50007, 50157, 'Y', '@Type@=''C''', 255, 'N', 80, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50132, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:32', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Destination Directory', 'Y', 50007, 50152, 'Y', '@Type@=''C''', 255, 'N', 90, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50133, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:34', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Table', 'Table for the Fields', 'The Table indicates the table in which a field or fields reside.', 'Y', 50007, 50141, 'Y', '@Type@=''T''|@Type@=''D''', 10, 'N', 100, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50134, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:36', 'MM/DD/YYYY HH24:MI:SS'), 0, 'DBType', 'Indicates the type of database.', 'This field indicates the type of database.', 'Y', 50007, 50144, 'Y', 22, 'N', 110, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50135, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:38', 'MM/DD/YYYY HH24:MI:SS'), 0, 'SQLStatement', 'Y', 50007, 50158, 'Y', '@Type@=''D''|Type@=''SQL''', 255, 'N', 120, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50136, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:40', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Special Form', 'Special Form', 'The Special Form field identifies a unique Special Form in the system.', 'Y', 50007, 50138, 'Y', '@Type@=''X''', 10, 'N', 130, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50137, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:42', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Process', 'Process or Report', 'The Process field identifies a unique Process or Report in the system.', 'Y', 50007, 50164, 'Y', '@Type@=''P''', 10, 'N', 140, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50138, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:39', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:43', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Workflow', 'Workflow or combination of tasks', 'The Workflow field identifies a unique Workflow in the system.', 'Y', 50007, 50161, 'Y', '@Type@=''F''', 10, 'N', 150, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50139, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Window', 'Data entry or display window', 'The Window field identifies a unique Window in the system.', 'Y', 50007, 50162, 'Y', '@Type@=''W''', 10, 'N', 160, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50140, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Workbench', 'Collection of windows reports', 'Y', 50007, 50142, 'Y', '@Type@=''B''', 10, 'N', 170, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50141, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Role', 'Responsibility Role', 'The Role determines security and access a user who has this Role will have in the System.', 'Y', 50007, 50163, 'Y', '@Type@=''S''', 10, 'N', 180, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50142, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:50', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Report View', 'View used to generate this report', 'The Report View indicates the view used to generate this report.', 'Y', 50007, 50140, 'Y', '@Type@=''R''', 10, 'N', 190, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50143, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Import Format', 'AD_ImpFormat_ID', 'Contains the Impformat ID', 'Y', 50007, 50139, 'Y', '@Type@=''IMP''', 0, 'N', 200, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50144, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:40', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:15:55', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Notes', 'Optional short description of the record', 'A description is limited to 255 characters.', 'Y', 50007, 50153, 'Y', 1000, 'N', 210, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50145, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:47', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Proc_ID', 'Y', 50008, 50171, 'N', 10, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50146, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g. you cannot delete a Business Partner if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 50008, 50176, 'N', 1, 'N', 0, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50147, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:06', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 50008, 50167, 'Y', 10, 'N', 10, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50148, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:14', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.', 'Y', 50008, 50168, 'Y', 10, 'N', 20, 0, 'Y', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50149, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:21', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Source Type', 'Indicate distribution method of package', 'Indicate the method of distribution of package.  Such as File or WebService based.', 'Y', 50008, 50173, 'Y', 10, 'N', 30, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50150, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Package Source File', 'The path and file name of the compressed package', 'The path and file name of the package.', 'Y', 50008, 50172, 'Y', 255, 'N', 40, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50151, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:25', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Source Code Directory', 'Adempiere Source Code Directory', 'Where Adempiere Source Code is located.  The installation process will create a directory a "packages" directory if necessary and expand the package underneath it.', 'Y', 50008, 50170, 'Y', 255, 'N', 50, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50152, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:28', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Override Dictionary Settings', 'Override "D" entity dictionary settings', 'While process the package all records will be updated by selecting "Yes".  If "No" is selected then the package will not update any entity dictionary settings with a "D"', 'Y', 50008, 50169, 'Y', 1, 'N', 60, 0, 'N', 'N', 'N', 'N', 'U');
Insert into AD_FIELD
   (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, ISDISPLAYED, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE)
 Values
   (50153, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:49', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:31', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Import', 'Start the import process', 'Y', 50008, 50177, 'Y', 1, 'N', 70, 0, 'N', 'N', 'N', 'N', 'U');
COMMIT;

Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:23', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:23', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Backup', 'Table AD_Package_Imp_Backup', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp', 'Table AD_Package_Imp', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Inst', 'Table AD_Package_Imp_Inst', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:45:24', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Detail', 'Table AD_Package_Imp_Detail', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:18', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp', 'Table AD_Package_Exp', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/11/2006 23:46:33', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:46:33', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Detail', 'Table AD_Package_Exp_Detail', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:04', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:04', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Exp_Common', 'Table AD_Package_Exp_Common', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
Insert into AD_SEQUENCE
   (AD_SEQUENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, ISAUTOSEQUENCE, INCREMENTNO, STARTNO, CURRENTNEXT, CURRENTNEXTSYS, ISAUDITED, ISTABLEID, STARTNEWYEAR)
 Values
   (50008, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:41', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:41', 'MM/DD/YYYY HH24:MI:SS'), 0, 'AD_Package_Imp_Proc', 'Table AD_Package_Imp_Proc', 'Y', 1, 1000000, 1000000, 50000, 'N', 'Y', 'N');
COMMIT;

Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ENTITYTYPE)
 Values
   (50001, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 'Application Packaging', 0, 'Import and export packaging', 'Y', 'N', 'N', 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, ENTITYTYPE)
 Values
   (50002, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 'Installed Packages', 0, 'Installed Packages', 'N', 'N', 'N', 'W', 50001, 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, ENTITYTYPE)
 Values
   (50003, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:44', 'MM/DD/YYYY HH24:MI:SS'), 'Package Maintenance', 0, 'Package installation history and maintenance', 'N', 'N', 'N', 'W', 50002, 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, ENTITYTYPE)
 Values
   (50004, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 'PackOut - Create a package', 0, 'Package build Application', 'N', 'N', 'N', 'W', 50003, 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, ENTITYTYPE)
 Values
   (50005, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 'Common Package Elements', 0, 'Maintain Common Package Elements', 'N', 'N', 'N', 'W', 50004, 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, ENTITYTYPE)
 Values
   (50006, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 'PackIn - Import a package', 0, 'Import a package', 'N', 'N', 'N', 'W', 50005, 'U');
Insert into AD_MENU
   (AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_PROCESS_ID, ENTITYTYPE)
 Values
   (50007, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 'Copy Role', 0, 'Copies one role to another role', 'N', 'N', 'N', 'P', 50010, 'U');
COMMIT;

Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50001, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:45', 'MM/DD/YYYY HH24:MI:SS'), 0, 153, 13);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50002, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 50001, 3);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50003, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 50001, 4);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50007, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:47', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:47', 'MM/DD/YYYY HH24:MI:SS'), 0, 367, 4);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50005, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 50001, 0);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50006, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 50001, 2);
Insert into AD_TREENODEMM
   (AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
 Values
   (10, 50004, 0, 0, 'Y', TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:17:46', 'MM/DD/YYYY HH24:MI:SS'), 0, 50001, 1);
COMMIT;

Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50001, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50001, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50002, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50002, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50003, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50003, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50004, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50004, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50005, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:51', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_WINDOW_ACCESS
   (AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50005, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
COMMIT;

Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50002, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50002, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50004, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50004, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50008, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:22:03', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50008, 50001, 0, 0, 'Y', TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/11/2006 23:47:52', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
Insert into AD_PROCESS_ACCESS
   (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
 Values
   (50010, 0, 0, 0, 'Y', TO_DATE('12/12/2006 00:20:48', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('12/12/2006 00:20:48', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Y');
COMMIT;

------------------------
-- insert new messages
------------------------

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE, msgtext, msgtype,
             entitytype
            )
     VALUES (50000, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'CloseAllWindows', 'Close All Windows', 'I',
             'D'
            );

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE, msgtext, msgtype,
             entitytype
            )
     VALUES (50001, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'CloseOtherWindows', 'Close Other Windows', 'I',
             'D'
            );

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE,
             msgtext, msgtype, entitytype
            )
     VALUES (50002, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'ValidateConnectionOnStartup',
             'Validate Connection on Startup', 'I', 'D'
            );

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE,
             msgtext, msgtype, entitytype
            )
     VALUES (50003, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'SingleInstancePerWindow',
             'Single Instance per Window', 'I', 'D'
            );

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE, msgtext,
             msgtype, entitytype
            )
     VALUES (50004, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'OpenWindowMaximized', 'Open Window Maximized',
             'I', 'D'
            );
            
INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE, msgtext,
             msgtype, entitytype
            )
     VALUES (50005, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'DeleteSelection', 'Delete Selected Items',
             'I', 'D'
            );         

INSERT INTO ad_message
            (ad_message_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby, VALUE, msgtext,
             msgtype, entitytype
            )
     VALUES (50006, 0, 0, 'Y', SYSDATE,
             0, SYSDATE, 0, 'SaveParentFirst', 'Save Parent Tab First',
             'I', 'D'
            );         

COMMIT ;

-----------------------
-- update sys sequences
-----------------------

UPDATE ad_sequence
   SET currentnextsys = 50000
 WHERE istableid = 'Y' AND currentnextsys < 50000;

-------
-- scripts from 3.1.0
-------

UPDATE w_store
   SET webparam1 = 'ADempiere120x60.gif'
 WHERE w_store_id = 11;

UPDATE w_store_trl
   SET webparam1 = 'ADempiere120x60.gif'
 WHERE w_store_id = 11;

COMMIT ;

UPDATE m_product
   SET descriptionurl = 'http://www.adempiere.com/partner/index.html'
 WHERE descriptionurl = 'http://www.compiere.org/partner/index.html';

UPDATE m_product
   SET imageurl = 'http://www.adempiere.org/product/icons/C32.gif'
 WHERE imageurl = 'http://www.compiere.org/product/icons/C32.gif';

UPDATE ad_message
   SET VALUE = 'AdempiereSys'
 WHERE VALUE = 'CompiereSys';

COMMIT ; 

-- PLEASE CHECK THE SEQUENCES BY HAND - USE:
-- select * from user_sequences;

UPDATE AD_SYSTEM SET VERSION='2006-11-02';

UPDATE ad_system
   SET releaseno = '312'
 WHERE ad_system_id = 0;

COMMIT;