/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for R_RequestType
 *  @author iDempiere (generated) 
 *  @version Release 5.1
 */
public interface I_R_RequestType 
{

    /** TableName=R_RequestType */
    public static final String Table_Name = "R_RequestType";

    /** AD_Table_ID=529 */
    public static final int Table_ID = 529;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 6 - System - Client 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(6);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Client.
	  * Client/Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within client
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within client
	  */
	public int getAD_Org_ID();

    /** Column name AutoDueDateDays */
    public static final String COLUMNNAME_AutoDueDateDays = "AutoDueDateDays";

	/** Set Auto Due Date Days.
	  * Automatic Due Date Days
	  */
	public void setAutoDueDateDays (int AutoDueDateDays);

	/** Get Auto Due Date Days.
	  * Automatic Due Date Days
	  */
	public int getAutoDueDateDays();

    /** Column name ConfidentialType */
    public static final String COLUMNNAME_ConfidentialType = "ConfidentialType";

	/** Set Confidentiality.
	  * Type of Confidentiality
	  */
	public void setConfidentialType (String ConfidentialType);

	/** Get Confidentiality.
	  * Type of Confidentiality
	  */
	public String getConfidentialType();

    /** Column name ContentColor */
    public static final String COLUMNNAME_ContentColor = "ContentColor";

	/** Set Content Color.
	  * Content color of calendar dashlet
	  */
	public void setContentColor (String ContentColor);

	/** Get Content Color.
	  * Content color of calendar dashlet
	  */
	public String getContentColor();

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name Description */
    public static final String COLUMNNAME_Description = "Description";

	/** Set Description.
	  * Optional short description of the record
	  */
	public void setDescription (String Description);

	/** Get Description.
	  * Optional short description of the record
	  */
	public String getDescription();

    /** Column name DueDateTolerance */
    public static final String COLUMNNAME_DueDateTolerance = "DueDateTolerance";

	/** Set Due Date Tolerance.
	  * Tolerance in days between the Date Next Action and the date the request is regarded as overdue
	  */
	public void setDueDateTolerance (int DueDateTolerance);

	/** Get Due Date Tolerance.
	  * Tolerance in days between the Date Next Action and the date the request is regarded as overdue
	  */
	public int getDueDateTolerance();

    /** Column name HeaderColor */
    public static final String COLUMNNAME_HeaderColor = "HeaderColor";

	/** Set Header Color.
	  * Header color of calendar dashlet
	  */
	public void setHeaderColor (String HeaderColor);

	/** Get Header Color.
	  * Header color of calendar dashlet
	  */
	public String getHeaderColor();

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name IsAutoChangeRequest */
    public static final String COLUMNNAME_IsAutoChangeRequest = "IsAutoChangeRequest";

	/** Set Create Change Request.
	  * Automatically create BOM (Engineering) Change Request
	  */
	public void setIsAutoChangeRequest (boolean IsAutoChangeRequest);

	/** Get Create Change Request.
	  * Automatically create BOM (Engineering) Change Request
	  */
	public boolean isAutoChangeRequest();

    /** Column name IsConfidentialInfo */
    public static final String COLUMNNAME_IsConfidentialInfo = "IsConfidentialInfo";

	/** Set Confidential Info.
	  * Can enter confidential information
	  */
	public void setIsConfidentialInfo (boolean IsConfidentialInfo);

	/** Get Confidential Info.
	  * Can enter confidential information
	  */
	public boolean isConfidentialInfo();

    /** Column name IsDefault */
    public static final String COLUMNNAME_IsDefault = "IsDefault";

	/** Set Default.
	  * Default value
	  */
	public void setIsDefault (boolean IsDefault);

	/** Get Default.
	  * Default value
	  */
	public boolean isDefault();

    /** Column name IsEMailWhenDue */
    public static final String COLUMNNAME_IsEMailWhenDue = "IsEMailWhenDue";

	/** Set EMail when Due.
	  * Send EMail when Request becomes due
	  */
	public void setIsEMailWhenDue (boolean IsEMailWhenDue);

	/** Get EMail when Due.
	  * Send EMail when Request becomes due
	  */
	public boolean isEMailWhenDue();

    /** Column name IsEMailWhenOverdue */
    public static final String COLUMNNAME_IsEMailWhenOverdue = "IsEMailWhenOverdue";

	/** Set EMail when Overdue.
	  * Send EMail when Request becomes overdue
	  */
	public void setIsEMailWhenOverdue (boolean IsEMailWhenOverdue);

	/** Get EMail when Overdue.
	  * Send EMail when Request becomes overdue
	  */
	public boolean isEMailWhenOverdue();

    /** Column name IsIndexed */
    public static final String COLUMNNAME_IsIndexed = "IsIndexed";

	/** Set Indexed.
	  * Index the document for the internal search engine
	  */
	public void setIsIndexed (boolean IsIndexed);

	/** Get Indexed.
	  * Index the document for the internal search engine
	  */
	public boolean isIndexed();

    /** Column name IsInvoiced */
    public static final String COLUMNNAME_IsInvoiced = "IsInvoiced";

	/** Set Invoiced.
	  * Is this invoiced?
	  */
	public void setIsInvoiced (boolean IsInvoiced);

	/** Get Invoiced.
	  * Is this invoiced?
	  */
	public boolean isInvoiced();

    /** Column name IsSelfService */
    public static final String COLUMNNAME_IsSelfService = "IsSelfService";

	/** Set Self-Service.
	  * This is a Self-Service entry or this entry can be changed via Self-Service
	  */
	public void setIsSelfService (boolean IsSelfService);

	/** Get Self-Service.
	  * This is a Self-Service entry or this entry can be changed via Self-Service
	  */
	public boolean isSelfService();

    /** Column name Name */
    public static final String COLUMNNAME_Name = "Name";

	/** Set Name.
	  * Alphanumeric identifier of the entity
	  */
	public void setName (String Name);

	/** Get Name.
	  * Alphanumeric identifier of the entity
	  */
	public String getName();

    /** Column name R_RequestType_ID */
    public static final String COLUMNNAME_R_RequestType_ID = "R_RequestType_ID";

	/** Set Request Type.
	  * Type of request (e.g. Inquiry, Complaint, ..)
	  */
	public void setR_RequestType_ID (int R_RequestType_ID);

	/** Get Request Type.
	  * Type of request (e.g. Inquiry, Complaint, ..)
	  */
	public int getR_RequestType_ID();

    /** Column name R_RequestType_UU */
    public static final String COLUMNNAME_R_RequestType_UU = "R_RequestType_UU";

	/** Set R_RequestType_UU	  */
	public void setR_RequestType_UU (String R_RequestType_UU);

	/** Get R_RequestType_UU	  */
	public String getR_RequestType_UU();

    /** Column name R_StatusCategory_ID */
    public static final String COLUMNNAME_R_StatusCategory_ID = "R_StatusCategory_ID";

	/** Set Status Category.
	  * Request Status Category
	  */
	public void setR_StatusCategory_ID (int R_StatusCategory_ID);

	/** Get Status Category.
	  * Request Status Category
	  */
	public int getR_StatusCategory_ID();

	public org.compiere.model.I_R_StatusCategory getR_StatusCategory() throws RuntimeException;

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();
}
