/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for W_Advertisement
 *  @author iDempiere (generated) 
 *  @version Release 5.1
 */
public interface I_W_Advertisement 
{

    /** TableName=W_Advertisement */
    public static final String Table_Name = "W_Advertisement";

    /** AD_Table_ID=579 */
    public static final int Table_ID = 579;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 3 - Client - Org 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(3);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Client.
	  * Client/Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within client
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within client
	  */
	public int getAD_Org_ID();

    /** Column name AdText */
    public static final String COLUMNNAME_AdText = "AdText";

	/** Set Advertisement Text.
	  * Text of the Advertisement
	  */
	public void setAdText (String AdText);

	/** Get Advertisement Text.
	  * Text of the Advertisement
	  */
	public String getAdText();

    /** Column name AD_User_ID */
    public static final String COLUMNNAME_AD_User_ID = "AD_User_ID";

	/** Set User/Contact.
	  * User within the system - Internal or Business Partner Contact
	  */
	public void setAD_User_ID (int AD_User_ID);

	/** Get User/Contact.
	  * User within the system - Internal or Business Partner Contact
	  */
	public int getAD_User_ID();

	public org.compiere.model.I_AD_User getAD_User() throws RuntimeException;

    /** Column name C_BPartner_ID */
    public static final String COLUMNNAME_C_BPartner_ID = "C_BPartner_ID";

	/** Set Business Partner .
	  * Identifies a Business Partner
	  */
	public void setC_BPartner_ID (int C_BPartner_ID);

	/** Get Business Partner .
	  * Identifies a Business Partner
	  */
	public int getC_BPartner_ID();

	public org.compiere.model.I_C_BPartner getC_BPartner() throws RuntimeException;

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name Description */
    public static final String COLUMNNAME_Description = "Description";

	/** Set Description.
	  * Optional short description of the record
	  */
	public void setDescription (String Description);

	/** Get Description.
	  * Optional short description of the record
	  */
	public String getDescription();

    /** Column name Help */
    public static final String COLUMNNAME_Help = "Help";

	/** Set Comment/Help.
	  * Comment or Hint
	  */
	public void setHelp (String Help);

	/** Get Comment/Help.
	  * Comment or Hint
	  */
	public String getHelp();

    /** Column name ImageURL */
    public static final String COLUMNNAME_ImageURL = "ImageURL";

	/** Set Image URL.
	  * URL of  image
	  */
	public void setImageURL (String ImageURL);

	/** Get Image URL.
	  * URL of  image
	  */
	public String getImageURL();

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name IsSelfService */
    public static final String COLUMNNAME_IsSelfService = "IsSelfService";

	/** Set Self-Service.
	  * This is a Self-Service entry or this entry can be changed via Self-Service
	  */
	public void setIsSelfService (boolean IsSelfService);

	/** Get Self-Service.
	  * This is a Self-Service entry or this entry can be changed via Self-Service
	  */
	public boolean isSelfService();

    /** Column name Name */
    public static final String COLUMNNAME_Name = "Name";

	/** Set Name.
	  * Alphanumeric identifier of the entity
	  */
	public void setName (String Name);

	/** Get Name.
	  * Alphanumeric identifier of the entity
	  */
	public String getName();

    /** Column name Processing */
    public static final String COLUMNNAME_Processing = "Processing";

	/** Set Process Now	  */
	public void setProcessing (boolean Processing);

	/** Get Process Now	  */
	public boolean isProcessing();

    /** Column name PublishStatus */
    public static final String COLUMNNAME_PublishStatus = "PublishStatus";

	/** Set Publication Status.
	  * Status of Publication
	  */
	public void setPublishStatus (String PublishStatus);

	/** Get Publication Status.
	  * Status of Publication
	  */
	public String getPublishStatus();

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();

    /** Column name ValidFrom */
    public static final String COLUMNNAME_ValidFrom = "ValidFrom";

	/** Set Valid from.
	  * Valid from including this date (first day)
	  */
	public void setValidFrom (Timestamp ValidFrom);

	/** Get Valid from.
	  * Valid from including this date (first day)
	  */
	public Timestamp getValidFrom();

    /** Column name ValidTo */
    public static final String COLUMNNAME_ValidTo = "ValidTo";

	/** Set Valid to.
	  * Valid to including this date (last day)
	  */
	public void setValidTo (Timestamp ValidTo);

	/** Get Valid to.
	  * Valid to including this date (last day)
	  */
	public Timestamp getValidTo();

    /** Column name Version */
    public static final String COLUMNNAME_Version = "Version";

	/** Set Version.
	  * Version of the table definition
	  */
	public void setVersion (int Version);

	/** Get Version.
	  * Version of the table definition
	  */
	public int getVersion();

    /** Column name W_Advertisement_ID */
    public static final String COLUMNNAME_W_Advertisement_ID = "W_Advertisement_ID";

	/** Set Advertisement.
	  * Web Advertisement
	  */
	public void setW_Advertisement_ID (int W_Advertisement_ID);

	/** Get Advertisement.
	  * Web Advertisement
	  */
	public int getW_Advertisement_ID();

    /** Column name W_Advertisement_UU */
    public static final String COLUMNNAME_W_Advertisement_UU = "W_Advertisement_UU";

	/** Set W_Advertisement_UU	  */
	public void setW_Advertisement_UU (String W_Advertisement_UU);

	/** Get W_Advertisement_UU	  */
	public String getW_Advertisement_UU();

    /** Column name W_ClickCount_ID */
    public static final String COLUMNNAME_W_ClickCount_ID = "W_ClickCount_ID";

	/** Set Click Count.
	  * Web Click Management
	  */
	public void setW_ClickCount_ID (int W_ClickCount_ID);

	/** Get Click Count.
	  * Web Click Management
	  */
	public int getW_ClickCount_ID();

	public org.compiere.model.I_W_ClickCount getW_ClickCount() throws RuntimeException;

    /** Column name W_CounterCount_ID */
    public static final String COLUMNNAME_W_CounterCount_ID = "W_CounterCount_ID";

	/** Set Counter Count.
	  * Web Counter Count Management
	  */
	public void setW_CounterCount_ID (int W_CounterCount_ID);

	/** Get Counter Count.
	  * Web Counter Count Management
	  */
	public int getW_CounterCount_ID();

	public org.compiere.model.I_W_CounterCount getW_CounterCount() throws RuntimeException;

    /** Column name WebParam1 */
    public static final String COLUMNNAME_WebParam1 = "WebParam1";

	/** Set Web Parameter 1.
	  * Web Site Parameter 1 (default: header image)
	  */
	public void setWebParam1 (String WebParam1);

	/** Get Web Parameter 1.
	  * Web Site Parameter 1 (default: header image)
	  */
	public String getWebParam1();

    /** Column name WebParam2 */
    public static final String COLUMNNAME_WebParam2 = "WebParam2";

	/** Set Web Parameter 2.
	  * Web Site Parameter 2 (default index page)
	  */
	public void setWebParam2 (String WebParam2);

	/** Get Web Parameter 2.
	  * Web Site Parameter 2 (default index page)
	  */
	public String getWebParam2();

    /** Column name WebParam3 */
    public static final String COLUMNNAME_WebParam3 = "WebParam3";

	/** Set Web Parameter 3.
	  * Web Site Parameter 3 (default left - menu)
	  */
	public void setWebParam3 (String WebParam3);

	/** Get Web Parameter 3.
	  * Web Site Parameter 3 (default left - menu)
	  */
	public String getWebParam3();

    /** Column name WebParam4 */
    public static final String COLUMNNAME_WebParam4 = "WebParam4";

	/** Set Web Parameter 4.
	  * Web Site Parameter 4 (default footer left)
	  */
	public void setWebParam4 (String WebParam4);

	/** Get Web Parameter 4.
	  * Web Site Parameter 4 (default footer left)
	  */
	public String getWebParam4();
}
