package idempiere.lab.plugin.factory;

import idempiere.lab.plugin.model.MCorporation;
import idempiere.lab.plugin.model.MCorporationGroup;
import idempiere.lab.plugin.model.MGroupCorporation;
import idempiere.lab.plugin.model.MOrderLab;

import java.sql.ResultSet;

import org.adempiere.base.IModelFactory;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class IDempiereLabPluginModelFactory implements IModelFactory {

	@Override
	public Class<?> getClass(String tableName) {
		if(tableName.equals(MOrder.Table_Name)){
			return MOrderLab.class;
		}else if(tableName.equals(MCorporation.Table_Name)){
			return MCorporation.class;
		}else if(tableName.equals(MCorporationGroup.Table_Name)){
			return MCorporationGroup.class;
		}else if(tableName.equals(MGroupCorporation.Table_Name)){
			return MGroupCorporation.class;
		}
		return null;
	}

	@Override
	public PO getPO(String tableName, int Record_ID, String trxName) {
		if(tableName.equals(MOrder.Table_Name)){
			return  new MOrderLab(Env.getCtx(), Record_ID, trxName);
		}else if(tableName.equals(MCorporation.Table_Name)){
			return  new MCorporation(Env.getCtx(), Record_ID, trxName);
		}else if(tableName.equals(MCorporationGroup.Table_Name)){
			return  new MCorporationGroup(Env.getCtx(), Record_ID, trxName);
		}else if(tableName.equals(MGroupCorporation.Table_Name)){
			return  new MGroupCorporation(Env.getCtx(), Record_ID, trxName);
		}
		return null;
	}

	@Override
	public PO getPO(String tableName, ResultSet rs, String trxName) {
		if(tableName.equals(MOrder.Table_Name)){
			return  new MOrderLab(Env.getCtx(), rs, trxName);
		}else if(tableName.equals(MCorporation.Table_Name)){
			return  new MCorporation(Env.getCtx(), rs, trxName);
		}else if(tableName.equals(MCorporationGroup.Table_Name)){
			return  new MCorporationGroup(Env.getCtx(), rs, trxName);
		}else if(tableName.equals(MGroupCorporation.Table_Name)){
			return  new MGroupCorporation(Env.getCtx(), rs, trxName);
		}
		return null;
	}

}
