package idempiere.lab.plugin.factory;

import java.util.logging.Level;

import org.adempiere.base.IProcessFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.process.ProcessCall;
import org.compiere.util.CLogger;

public class IDempiereLabPluginProcessFactory implements IProcessFactory {

	private final static CLogger log = CLogger.getCLogger(IDempiereLabPluginProcessFactory.class);

	/**
	 * default constructor
	 */
	public IDempiereLabPluginProcessFactory() {
	}

	/* (non-Javadoc)
	 * @see org.adempiere.base.IProcessFactory#newProcessInstance(java.lang.String)
	 */
	@Override
	public ProcessCall newProcessInstance(String className) {

		if (className.startsWith("idempiere.lab.plugin"))
		{
			ProcessCall process = null;
			process = EquinoxExtensionLocator.instance().locate(ProcessCall.class, "org.adempiere.base.Process", className, null).getExtension();
			if (process == null) {
				//Get Class
				Class<?> processClass = null;
				//use context classloader if available
				ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
				if (classLoader != null)
				{
					try
					{
						processClass = classLoader.loadClass(className);
					}
					catch (ClassNotFoundException ex)
					{
						if (log.isLoggable(Level.FINE))log.log(Level.FINE, className, ex);
					}
				}
				if (processClass == null)
				{
					classLoader = this.getClass().getClassLoader();
					try
					{
						processClass = classLoader.loadClass(className);
					}
					catch (ClassNotFoundException ex)
					{
						log.log(Level.WARNING, className, ex);
						return null;
					}
				}

				if (processClass == null) {
					return null;
				}

				//Get Process
				try
				{
					process = (ProcessCall)processClass.newInstance();
				}
				catch (Exception ex)
				{
					log.log(Level.WARNING, "Instance for " + className, ex);
					return null;
				}
			}
			return process;
		}//if (className.startsWith("jpiere.plugin.bulkimport.process"))
		return null;
	}

}
