#
#  The pkgbuild build engine
#
#  Copyright (C) 2004, 2005 Sun Microsystems, Inc.
#
#  pkgbuild is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License 
#  version 2 published by the Free Software Foundation.
#
#  pkgbuild is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  As a special exception to the GNU General Public License, if you
#  distribute this file as part of a program that contains a
#  configuration script generated by Autoconf, you may include it under
#  the same distribution terms that you use for the rest of that program.
#
#  Authors:  Laszlo Peter  <laca@sun.com>
#

use strict;
use warnings;

package rpm_file;

sub get_glob ($);

use overload ('""' => \&get_glob);

my @_all_verify =  ('owner', 'group', 'mode', 'md5', 'size', 'maj', 'min',
		    'symlink', 'mtime');

# Create a new rpm_file object.
sub new ($$$;$$$$$$$$$) {
    my $class = shift;
    my $package = shift;
    my $glob = shift;
    my $attribs = shift;
    my $defattribs = shift;
    my $verify = shift;
    my $is_recursive = shift;
    my $is_doc = shift;
    my $is_config = shift;
    my $ips_tags = shift;
    my $class_name = shift;
    my $is_ghost = shift;
    my $is_hardlink = shift;
    my $self = {};

    if (not @$defattribs) {
       $defattribs = [ '-', '-', '-', '-' ];
    }

    if (not @$verify) {
	my @new_verify = (@_all_verify);
	$verify = \@new_verify;
    } else {
	$verify = _process_verify ($verify);
    }

    if (not defined $is_recursive) {
	$is_recursive = 1;
    }

    if (not defined $is_doc) {
	$is_doc = 0;
    }

    if (not defined $is_config) {
	$is_config = 0;
    }

    if (not @$ips_tags) {
       $ips_tags = [];
    }

    if (not defined $is_ghost) {
	$is_ghost = 0;
    }

    if (not defined $is_hardlink) {
	$is_hardlink = 0;
    }

    $self->{_package} = $package;
    $self->{_glob} = $glob;
    # ensure that _attributes and _defattributes
    # are references to a copy of the list passed in,
    # not a reference to the list passed in as the 
    # called may change them
    $self->{_attributes} = [ @$attribs ];
    $self->{_defattributes} = [ @$defattribs ];
    $self->{_verify} = $verify;
    $self->{_is_doc} = $is_doc;
    $self->{_is_config} = $is_config;
    $self->{_ips_tags} = [ @$ips_tags ];
    $self->{_is_ghost} = $is_ghost;
    $self->{_is_hardlink} = $is_hardlink;
    $self->{_is_recursive} = $is_recursive;
    $self->{_compression} = undef;
    $self->{_doc_subdir} = undef;
    if (defined ($class_name)) {
	$self->{_class} = $class_name;
    } else {
	$self->{_class} = "none";
    }

    return (bless $self, $class);
}

sub _process_verify ($) {
    my $verify_ref = shift;

    my @verify = (@$verify_ref);

    if ($verify[0] ne "not") {
	return \@verify;
    }

    my @new_verify = ();

    foreach my $name (@_all_verify) {
	my $do_add = 1;
	for (my $i = 1; $i <= $#verify; $i++) {
	    if ($name eq $verify[$i]) {
		$do_add = 0;
		last;
	    }
	}
	if ($do_add) {
	    push (@new_verify, $name);
	}
    }

    return \@new_verify;
}

sub get_all_verify () {
    return (@_all_verify);
}

sub set_compression ($$) {
    my $self = shift;
    my $compression = shift;

    $self->{_compression} = $compression;
}

sub get_compression ($) {
    my $self = shift;

    return $self->{_compression};
}

sub set_doc_subdir ($$) {
    my $self = shift;
    my $subdir = shift;

    $self->{_doc_subdir} = $subdir;
}

sub get_doc_subdir ($) {
    my $self = shift;

    return $self->{_doc_subdir};
}

sub get_defattributes ($) {
    my $self = shift;

    my $ref = $self->{_defattributes};
    return @$ref;
}

sub get_attributes ($) {
    my $self = shift;

    my $ref = $self->{_attributes};
    return @$ref;
}

sub get_package ($) {
    my $self = shift;

    return $self->{_package};
}

sub get_verify ($) {
    my $self = shift;

    my $ref = $self->{_verify};
    return @$ref;
}

sub has_verify ($$) {
    my $self = shift;
    my $name = shift;

    my $ref = $self->{_verify};
    foreach my $val (@$ref) {
	if ($val eq $name) {
	    return 1;
	}
    }

    return 0;
}

sub is_doc ($) {
    my $self = shift;

    return $self->{_is_doc};
}

sub is_config ($) {
    my $self = shift;

    return $self->{_is_config};
}

sub ips_tags ($) {
    my $self = shift;

    return $self->{_ips_tags};
}

sub is_ghost ($) {
    my $self = shift;

    return $self->{_is_ghost};
}

sub is_hardlink ($) {
    my $self = shift;

    return $self->{_is_hardlink};
}

sub is_recursive ($) {
    my $self = shift;

    return $self->{_is_recursive};
}

sub get_glob ($) {
    my $self = shift;

    return $self->{_glob};
}

sub get_class ($) {
    my $self = shift;

    return $self->{_class};
}

1;
