/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx;

import com.mylyane.afx.IFactory;

public interface IPool {
    public static final int NORMAL = 0;
    public static final int OVER = 1;

    public void setFactory(IFactory var1);

    public Object get();

    public Object[] getPoolSnap();

    public int size();

    public int replace(Object var1);

    public void setCapacity(int var1);

    public void initAsync(int var1, int var2);

    public static class Default
    implements IPool {
        public static final int DEFAULT_SIZE = 30;
        public static boolean DEBUG = false;
        protected IFactory factory;
        protected Object[] pools;
        protected int pk_index;
        protected int capacity = 30;
        protected boolean init = false;

        public static IPool GetInstance() {
            return new Default();
        }

        public Default() {
            if (DEBUG) {
                // empty if block
            }
        }

        public void setFactory(IFactory iFactory) {
            if (this.factory != null) {
                System.out.println("IFactory instance already exists.");
            }
            this.factory = iFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCapacity(int n) {
            if (!this.init) {
                this.initAsync(n, 0);
            } else {
                Default default_ = this;
                synchronized (default_) {
                    if (this.capacity == n) {
                        return;
                    }
                    Object[] objectArray = new Object[n];
                    int n2 = this.pk_index;
                    if (n2 > n) {
                        this.pk_index = n2 = n;
                    }
                    System.arraycopy(this.pools, 0, objectArray, 0, n2);
                    this.pools = objectArray;
                }
            }
        }

        public synchronized void initAsync(int n, int n2) {
            if (!this.init) {
                int n3 = this.capacity;
                if (n3 < n) {
                    this.capacity = n3 = n;
                }
                this.pk_index = n;
                Object[] objectArray = new Object[n3];
                IFactory iFactory = this.factory;
                while (n-- > 0) {
                    objectArray[n] = iFactory.create();
                }
                this.pools = objectArray;
                this.init = true;
            }
        }

        public synchronized Object get() {
            int n = this.pk_index;
            Object[] objectArray = this.pools;
            while (n-- > 0) {
                Object object = objectArray[n];
                if (object == null) continue;
                this.pk_index = n;
                objectArray[n] = null;
                return object;
            }
            return this.factory.create();
        }

        public synchronized int replace(Object object) {
            int n = 0;
            int n2 = this.pk_index;
            if (n2 >= this.capacity) {
                System.out.println("MultiPool: capacity over!");
                n = 1;
            } else {
                this.pools[n2] = object;
                this.pk_index = n2 + 1;
            }
            return n;
        }

        public synchronized int size() {
            return this.pk_index;
        }

        public synchronized Object[] getPoolSnap() {
            Object[] objectArray;
            if (this.pk_index > 0) {
                objectArray = new Object[this.pk_index];
                System.arraycopy(this.pools, 0, objectArray, 0, this.pk_index);
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
    }
}

