/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx.swing;

import com.mylyane.afx.IUserInputFrame;
import com.mylyane.afx.UIModule;
import com.mylyane.ui.swing.SimpleTextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class SimpleInfomaionWindow
extends JWindow {
    private static final Border DEFALUT_BORDER = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray, 2), "Infomaion.", 1, 2, new Font("Serif", 1, 14), Color.white);
    private JPanel content;
    private boolean onhtml_edit = false;

    public SimpleInfomaionWindow() {
    }

    public SimpleInfomaionWindow(Window window) {
        this(window, false);
    }

    public SimpleInfomaionWindow(Window window, boolean bl) {
        super(window);
        if (bl) {
            this.setDoubleClickOnClose();
        }
    }

    protected void windowInit() {
        super.windowInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.darkGray);
        jPanel.setBorder(DEFALUT_BORDER);
        super.setContentPane(jPanel);
        super.setForeground(Color.white);
        this.content = jPanel;
        this.getPage();
    }

    private JEditorPane getPage() {
        Component component;
        if (this.content.getComponentCount() > 0 && (component = this.content.getComponent(0)) != null && component instanceof JEditorPane) {
            return (JEditorPane)component;
        }
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setForeground(Color.white);
        jEditorPane.setBackground(Color.black);
        this.content.add((Component)jEditorPane, "Center");
        return jEditorPane;
    }

    private int getMaxStringWidth(String string, Font font) {
        String[] stringArray = UIModule.SplitString(string, '\n');
        int n = 0;
        FontMetrics fontMetrics = super.getGraphics().getFontMetrics(font);
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = SwingUtilities.computeStringWidth(fontMetrics, stringArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void setDoubleClickOnClose() {
        super.enableEvents(16L);
        this.getPage().setToolTipText("It close by double-clicking border...");
    }

    public void setInfomationText(String string) {
        this.setInfomationText(string, false);
    }

    public void setInfomationText(String string, boolean bl) {
        JEditorPane jEditorPane = this.getPage();
        if (bl) {
            jEditorPane.setContentType("text/html");
        } else {
            jEditorPane.setContentType("text/plain");
            int n = this.getMaxStringWidth(string, jEditorPane.getFont());
            Dimension dimension = jEditorPane.getPreferredSize();
            dimension.width = n + 20;
            jEditorPane.setPreferredSize(dimension);
        }
        jEditorPane.setText(string);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            if (mouseEvent.getClickCount() >= 2) {
                super.dispose();
            } else {
                super.toFront();
            }
            mouseEvent.consume();
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            new Thread(){

                public void run() {
                    SimpleInfomaionWindow.this.htmlEditEvent();
                }
            }.start();
            mouseEvent.consume();
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    private void htmlEditEvent() {
        if (this.onhtml_edit) {
            return;
        }
        JEditorPane jEditorPane = this.getPage();
        this.onhtml_edit = true;
        IUserInputFrame iUserInputFrame = SimpleTextPane.CreateSimpleEditor("Edit Source.", new String[]{"Contents"});
        iUserInputFrame.setText(0, jEditorPane.getText());
        iUserInputFrame.showInputFrame();
        String[] stringArray = iUserInputFrame.getResults();
        iUserInputFrame.release();
        try {
            if (stringArray != null && stringArray.length > 0) {
                jEditorPane.setText(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.onhtml_edit = false;
    }
}

