/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.afx.swing;

import com.mylyane.afx.UIModule;
import com.mylyane.afx.swing.IIconManager;
import com.mylyane.afx.swing.SimpleInfomaionWindow;
import com.mylyane.io.MultiFileFilter;
import com.mylyane.net.URLUtility;
import com.mylyane.util.QON;
import com.mylyane.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class SwingUIModule
extends UIModule {
    public static IFileFilterEx GetDefaultFileFilterEx() {
        return new SharedFilter();
    }

    public static JFrame CreateDefaultJFrame(String string, boolean bl) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(bl ? 3 : 0);
        return jFrame;
    }

    public static JInternalFrame CreateDefaultJInternalFrame(String string, boolean bl) {
        return new JInternalFrame(string, true, bl, true, true);
    }

    public static JInternalFrame CreateJInternalFrameByPane(String string, boolean bl, Container container) {
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, bl, true, true);
        jInternalFrame.getContentPane().add(container);
        jInternalFrame.pack();
        return jInternalFrame;
    }

    public static LineMetrics GetLineMetrics(Graphics graphics, Font font, String string) {
        return SwingUIModule.GetLineMetrics(graphics, font, string, 0, string.length());
    }

    public static LineMetrics GetLineMetrics(Graphics graphics, Font font, String string, int n, int n2) {
        return graphics instanceof Graphics2D ? font.getLineMetrics(string, n, n2, ((Graphics2D)graphics).getFontRenderContext()) : null;
    }

    public static Rectangle2D GetStringBounds(Graphics graphics, Font font, String string) {
        return SwingUIModule.GetStringBounds(graphics, font, string, 0, string.length());
    }

    public static Rectangle2D GetStringBounds(Graphics graphics, Font font, String string, int n, int n2) {
        return graphics instanceof Graphics2D ? font.getStringBounds(string, n, n2, ((Graphics2D)graphics).getFontRenderContext()) : null;
    }

    public static void DispatchActionPerform(JComponent jComponent, String string) {
        AbstractButton abstractButton = SwingUIModule.FindButton(jComponent, string);
        if (abstractButton != null) {
            abstractButton.doClick(0);
        }
    }

    public static AbstractButton FindButton(JComponent jComponent, String string) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            AbstractButton abstractButton;
            if (!(componentArray[i] instanceof AbstractButton) || !(abstractButton = (AbstractButton)componentArray[i]).getActionCommand().equals(string) || !abstractButton.isEnabled()) continue;
            return abstractButton;
        }
        return null;
    }

    public static JFrame CreateStdJFrameByPane(String string, Container container, boolean bl, boolean bl2) {
        JFrame jFrame = new JFrame(string);
        if (container != null) {
            jFrame.setContentPane(container);
            jFrame.pack();
        }
        jFrame.setDefaultCloseOperation(bl ? 3 : 0);
        if (bl2) {
            SwingUIModule.ToCenterScreen(jFrame);
        }
        return jFrame;
    }

    public static JOptionPane CreateStdInputPane(String string, String string2) {
        JOptionPane jOptionPane = new JOptionPane(string, 3, 2, null, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(string2);
        jOptionPane.selectInitialValue();
        return jOptionPane;
    }

    public static Color ShowColorDialog(Component component, String string) {
        return JColorChooser.showDialog(component, string, Color.white);
    }

    public static JPopupMenu CreateJPopupByParams(String string, Font font, ActionListener actionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (string.charAt(0) == '*') {
            SwingUIModule.CJRB(string.substring(1), jPopupMenu, font, actionListener);
        } else {
            SwingUIModule.CJH(string, jPopupMenu, font, actionListener);
        }
        return jPopupMenu;
    }

    public static JPopupMenu CreateJPopupByParamsEx(String string, String string2, IIconManager iIconManager, ActionListener actionListener) {
        return (JPopupMenu)SwingUIModule.CJH2(string, string2, new JPopupMenu(), iIconManager, actionListener);
    }

    private static JComponent CJH2(String string, String string2, JComponent jComponent, IIconManager iIconManager, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        String[] stringArray2 = SwingUIModule.SplitString(string2, '|');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        try {
            Method method = jComponent.getClass().getMethod("addSeparator", null);
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i];
                if (string3.equals("-")) {
                    method.invoke((Object)jComponent, (Object[])null);
                    continue;
                }
                boolean bl = true;
                if (string3.charAt(0) == '!') {
                    string3 = string3.substring(1);
                    bl = false;
                }
                Icon icon = iIconManager == null ? null : iIconManager.getIcon(stringArray2[i]);
                JMenuItem jMenuItem = new JMenuItem(string3, icon);
                jMenuItem.setActionCommand(stringArray2[i]);
                jMenuItem.setEnabled(bl);
                jMenuItem.addActionListener(actionListener);
                jComponent.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return jComponent;
    }

    public static JMenu CreateJMenuByParams(String string, Font font, ActionListener actionListener) {
        JMenu jMenu = new JMenu();
        if (string.length() > 0) {
            if (string.charAt(0) == '*') {
                SwingUIModule.CJRB(string.substring(1), jMenu, font, actionListener);
            } else {
                SwingUIModule.CJH(string, jMenu, font, actionListener);
            }
        }
        return jMenu;
    }

    private static JComponent CJH(String string, JComponent jComponent, Font font, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        try {
            Method method = jComponent.getClass().getMethod("addSeparator", null);
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (string2.equals("-")) {
                    method.invoke((Object)jComponent, (Object[])null);
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem();
                if (string2.charAt(0) == '!') {
                    string2 = string2.substring(1);
                    jMenuItem.setEnabled(false);
                }
                jMenuItem.setText(string2);
                if (font != null) {
                    jMenuItem.setFont(font);
                }
                jMenuItem.addActionListener(actionListener);
                jComponent.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return jComponent;
    }

    public static void SetJMenuItemActionCommandsByParams(String string, JComponent jComponent) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        int n = stringArray.length;
        if (n == 1 && stringArray[0].length() == 0) {
            return;
        }
        boolean bl = jComponent instanceof JPopupMenu;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-")) continue;
            JMenuItem jMenuItem = bl ? (JMenuItem)jComponent.getComponent(i) : ((JMenu)jComponent).getItem(i);
            jMenuItem.setActionCommand(string2);
        }
    }

    public static JPopupMenu CreateJRadioButtonPopupByParams(String string, Font font, ActionListener actionListener) {
        return (JPopupMenu)SwingUIModule.CJRB(string, new JPopupMenu(), font, actionListener);
    }

    public static JMenu CreateJRadioButtonMenuByParams(String string, Font font, ActionListener actionListener) {
        return (JMenu)SwingUIModule.CJRB(string, new JMenu(), font, actionListener);
    }

    private static JComponent CJRB(String string, JComponent jComponent, Font font, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            char c = string2.charAt(0);
            if (c == '@') {
                string2 = string2.substring(1);
                jRadioButtonMenuItem.setSelected(true);
            } else if (c == '!') {
                string2 = string2.substring(1);
                jRadioButtonMenuItem.setEnabled(false);
            }
            jRadioButtonMenuItem.setText(string2);
            if (font != null) {
                jRadioButtonMenuItem.setFont(font);
            }
            jRadioButtonMenuItem.addActionListener(actionListener);
            jComponent.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jComponent;
    }

    public static JMenuBar BuildJMenuBarByParams(JMenuBar jMenuBar, String string, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '\u0000');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
        }
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = SwingUIModule.SplitString(stringArray[i], '\n');
            JMenu jMenu = SwingUIModule.CreateJMenuByParams(stringArray2[1], null, actionListener);
            jMenu.setText(stringArray2[0]);
            jMenuBar.add(jMenu);
            if (stringArray2[2].length() == 0) continue;
            SwingUIModule.SetJMenuItemActionCommandsByParams(stringArray2[2], jMenu);
        }
        return jMenuBar;
    }

    public static JMenuBar BuildJMenuBarByParamsEx(String string, char c, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, c);
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        JMenuBar jMenuBar = new JMenuBar();
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = SwingUIModule.SplitString(stringArray[i], '\n');
            JMenu jMenu = SwingUIModule.CreateJMenuByParams(stringArray2[1], null, actionListener);
            jMenu.setText(stringArray2[0]);
            jMenuBar.add(jMenu);
            if (stringArray2.length == 2) continue;
            SwingUIModule.SetJMenuItemActionCommandsByParams(stringArray2[2], jMenu);
        }
        return jMenuBar;
    }

    public static void SetAcceleratorTo(JMenuBar jMenuBar, String string) {
        String[] stringArray = SwingUIModule.SplitString(string, '\n');
        int n = stringArray.length;
        if (n != 3) {
            return;
        }
        String[] stringArray2 = SwingUIModule.SplitString(stringArray[1], '|');
        String[] stringArray3 = SwingUIModule.SplitString(stringArray[2], '|');
        JMenu jMenu = jMenuBar.getMenu(QON.parseInt(stringArray[0]));
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            jMenu.getItem(QON.parseInt(stringArray2[i])).setAccelerator(KeyStroke.getKeyStroke(stringArray3[i]));
        }
    }

    public static Icon CreateImageIcon(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            try {
                uRL = URLUtility.CreateURLByUserDir(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static Icon[] CreateImageIcons(String string) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        Icon[] iconArray = new Icon[n];
        for (int i = 0; i < n; ++i) {
            URL uRL;
            String string2 = stringArray[i];
            char c = string2.charAt(0);
            if (c == '-') continue;
            if (c == '!') {
                string2 = string2.substring(1);
            }
            if ((uRL = ClassLoader.getSystemResource(string2)) == null) {
                try {
                    uRL = URLUtility.CreateURLByUserDir(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) continue;
            iconArray[i] = new ImageIcon(uRL);
        }
        return iconArray;
    }

    static SIPlaceholder SplitAndExtractIcons(String string, IIconManager iIconManager) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        Icon[] iconArray = new Icon[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            char c = string2.charAt(0);
            if (c == '-') continue;
            if (c == '!') {
                string2 = string2.substring(1);
            }
            iconArray[i] = iIconManager.getIcon(string2);
        }
        SIPlaceholder sIPlaceholder = new SIPlaceholder();
        sIPlaceholder.items = stringArray;
        sIPlaceholder.icons = iconArray;
        return sIPlaceholder;
    }

    public static JToolBar CreateIconToolBarByParams(String string, int n, int n2, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '\n');
        String[] stringArray2 = null;
        if (stringArray.length < 2) {
            return null;
        }
        if (stringArray.length == 3) {
            stringArray2 = SwingUIModule.SplitString(stringArray[2], '|');
        }
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMargin(new Insets(n, n, n, n));
        Icon[] iconArray = SwingUIModule.CreateImageIcons(stringArray[0]);
        String[] stringArray3 = SwingUIModule.SplitString(stringArray[1], '|');
        stringArray = SwingUIModule.SplitString(stringArray[0], '|');
        Insets insets = new Insets(n2, n2, n2, n2);
        for (int i = 0; i < iconArray.length; ++i) {
            Icon icon = iconArray[i];
            if (icon == null) {
                jToolBar.addSeparator();
                continue;
            }
            JButton jButton = new JButton(null, icon);
            if (stringArray[i].charAt(0) == '!') {
                jButton.setEnabled(false);
            }
            jButton.setActionCommand(stringArray3[i]);
            jButton.addActionListener(actionListener);
            jButton.setMargin(insets);
            if (stringArray2 != null) {
                jButton.setToolTipText(stringArray2[i]);
            }
            jToolBar.add((Component)jButton, null);
        }
        return jToolBar;
    }

    public static JToolBar CreateIconToolBarByParamsEx(String string, int n, int n2, ActionListener actionListener, IIconManager iIconManager) {
        String[] stringArray = null;
        Object object = SwingUIModule.SplitString(string, '\n');
        if (((String[])object).length < 1) {
            return null;
        }
        if (((String[])object).length == 2) {
            stringArray = SwingUIModule.SplitString(object[1], '|');
        }
        Object object2 = SwingUIModule.SplitAndExtractIcons(object[0], iIconManager);
        Icon[] iconArray = ((SIPlaceholder)object2).icons;
        String[] stringArray2 = ((SIPlaceholder)object2).items;
        object = new JToolBar();
        ((JToolBar)object).setMargin(new Insets(n, n, n, n));
        object2 = new Insets(n2, n2, n2, n2);
        for (int i = 0; i < iconArray.length; ++i) {
            Icon icon = iconArray[i];
            if (icon == null) {
                ((JToolBar)object).addSeparator();
                continue;
            }
            String string2 = stringArray2[i];
            JButton jButton = new JButton(null, icon);
            if (string2.charAt(0) == '!') {
                jButton.setEnabled(false);
                string2 = string2.substring(1);
            }
            jButton.setActionCommand(string2);
            jButton.addActionListener(actionListener);
            jButton.setMargin((Insets)object2);
            if (stringArray != null) {
                jButton.setToolTipText(stringArray[i]);
            }
            ((Container)object).add((Component)jButton, null);
        }
        return object;
    }

    public static AbstractButton[] CreateJButtonByParams(JComponent jComponent, String string, String string2, ActionListener actionListener) {
        String[] stringArray = SwingUIModule.SplitString(string, '|');
        String[] stringArray2 = string2 != null && string2.length() > 2 ? SwingUIModule.SplitString(string2, '|') : null;
        int n = stringArray.length;
        AbstractButton[] abstractButtonArray = new AbstractButton[n];
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            JButton jButton = new JButton();
            if (string3.charAt(0) == '!') {
                string3 = string3.substring(1);
                jButton.setEnabled(false);
            }
            jButton.setText(string3);
            jButton.addActionListener(actionListener);
            if (stringArray2 != null) {
                jButton.setActionCommand(stringArray2[i]);
            }
            jComponent.add(jButton);
            abstractButtonArray[i] = jButton;
        }
        return abstractButtonArray;
    }

    public static JWindow PopupInfomation(String string, Object[] objectArray, Container container) {
        return SwingUIModule.PopupInfomation(string, objectArray, container, 4000, false);
    }

    public static JWindow PopupInfomation(String string, Object[] objectArray, Container container, boolean bl) {
        return SwingUIModule.PopupInfomation(string, objectArray, container, 4000, bl);
    }

    public static JWindow PopupInfomation(String string, Object[] objectArray, Container container, int n, boolean bl) {
        return SwingUIModule.PopupInfomation(Utility.Format(string, objectArray), container, n, bl);
    }

    public static JWindow PopupInfomation(String string, Container container, final int n, boolean bl) {
        Window window = container instanceof Window ? (Window)container : SwingUIModule.FindTopWindow(container);
        final IPopupInfoOwner iPopupInfoOwner = container instanceof IPopupInfoOwner ? (IPopupInfoOwner)((Object)container) : null;
        final SimpleInfomaionWindow simpleInfomaionWindow = new SimpleInfomaionWindow(window, n == -1);
        simpleInfomaionWindow.setInfomationText(string, bl);
        simpleInfomaionWindow.pack();
        SwingUIModule.ToCenterByWindow(simpleInfomaionWindow, window);
        if (n > 0) {
            new Thread("Popup-Infomation-Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block8: {
                        try {
                            try {
                                if (iPopupInfoOwner != null) {
                                    iPopupInfoOwner.beforeVisible(simpleInfomaionWindow);
                                }
                                simpleInfomaionWindow.setVisible(true);
                                Thread.sleep(n);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var3_2 = null;
                                if (iPopupInfoOwner != null) {
                                    iPopupInfoOwner.beforeDispose(simpleInfomaionWindow);
                                }
                                simpleInfomaionWindow.dispose();
                                return;
                            }
                            Object var3_1 = null;
                            if (iPopupInfoOwner == null) break block8;
                            iPopupInfoOwner.beforeDispose(simpleInfomaionWindow);
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (iPopupInfoOwner != null) {
                                iPopupInfoOwner.beforeDispose(simpleInfomaionWindow);
                            }
                            simpleInfomaionWindow.dispose();
                            throw throwable;
                        }
                    }
                    simpleInfomaionWindow.dispose();
                }
            }.start();
        }
        return simpleInfomaionWindow;
    }

    public static interface IPopupInfoOwner {
        public void beforeVisible(JWindow var1);

        public void beforeDispose(JWindow var1);
    }

    static final class SIPlaceholder {
        String[] items;
        Icon[] icons;

        SIPlaceholder() {
        }
    }

    static final class SharedFilter
    extends FileFilter
    implements IFileFilterEx {
        String desc = "text format file.";
        String[] ex_arry;

        SharedFilter() {
        }

        public FileFilter toFileFilter() {
            return this;
        }

        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiFileFilter.GetExtension(file);
                String[] stringArray = this.ex_arry;
                if (stringArray != null && string != null) {
                    int n = stringArray.length;
                    while (n-- > 0) {
                        if (!string.equals(stringArray[n])) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public void setExtensions(Object object) {
            if (object instanceof String[]) {
                this.ex_arry = (String[])object;
            } else if (object instanceof String) {
                this.ex_arry = UIModule.SplitString((String)object, '|');
            }
        }

        public String[] getExtensions() {
            return this.ex_arry;
        }
    }

    public static interface IFileFilterEx {
        public boolean accept(File var1);

        public String getDescription();

        public void setDescription(String var1);

        public void setExtensions(Object var1);

        public String[] getExtensions();

        public FileFilter toFileFilter();
    }
}

