/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Map;

public class DropTargetDelegate
implements DropTargetListener {
    public static final int FILE_LIST = 1;
    public static final int PLAIN_TEXT = 2;
    public static final int UNICODE_TEXT = 4;
    public static final int RTF_TEXT = 8;
    public static final int HTML_FORMAT = 16;
    private static final int MASK = 31;
    private static Map JDATA_FLAVOR_MAP;
    private DropTarget drop_target;
    private IDropTargetPlace place;
    private DataFlavor[] accept_flavors;

    public static DropTargetDelegate NewInstance(Component component) {
        DropTargetDelegate dropTargetDelegate = new DropTargetDelegate((IDropTargetPlace)((Object)component));
        dropTargetDelegate.drop_target = new DropTarget(component, dropTargetDelegate);
        return dropTargetDelegate;
    }

    public static DropTargetDelegate NewInstance(Component component, IDropTargetPlace iDropTargetPlace) {
        DropTargetDelegate dropTargetDelegate = new DropTargetDelegate(iDropTargetPlace);
        dropTargetDelegate.drop_target = new DropTarget(component, dropTargetDelegate);
        return dropTargetDelegate;
    }

    private static Map GetSystemFlovorMap(DropTarget dropTarget) {
        Map<String, DataFlavor> map;
        FlavorMap flavorMap = dropTarget.getFlavorMap();
        JDATA_FLAVOR_MAP = map = flavorMap.getFlavorsForNatives(null);
        return map;
    }

    private DropTargetDelegate() {
    }

    public DropTargetDelegate(IDropTargetPlace iDropTargetPlace) {
        this.place = iDropTargetPlace;
    }

    public DropTarget getDropTarget() {
        return this.drop_target;
    }

    public void setAcceptTypes(int n) {
        Map map = JDATA_FLAVOR_MAP;
        if (map == null) {
            map = DropTargetDelegate.GetSystemFlovorMap(this.drop_target);
        }
        int n2 = 0;
        for (int i = n & 0x1F; i != 0; i >>= 1) {
            if ((i & 1) == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        DataFlavor[] dataFlavorArray = new DataFlavor[n2];
        if ((n & 1) == 1) {
            dataFlavorArray[--n2] = (DataFlavor)map.get("HDROP");
        }
        if ((n & 2) == 2) {
            dataFlavorArray[--n2] = (DataFlavor)map.get("TEXT");
        }
        if ((n & 4) == 4) {
            dataFlavorArray[--n2] = (DataFlavor)map.get("UNICODE TEXT");
        }
        if ((n & 8) == 8) {
            dataFlavorArray[--n2] = (DataFlavor)map.get("Rich Text Format");
        }
        if ((n & 0x10) == 16) {
            dataFlavorArray[--n2] = (DataFlavor)map.get("HTML Format");
        }
        this.addDataFlavors(dataFlavorArray);
    }

    public void addDataFlavors(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray != null && dataFlavorArray.length > 0) {
            DataFlavor[] dataFlavorArray2 = this.accept_flavors;
            int n = dataFlavorArray2 != null ? dataFlavorArray2.length : 0;
            int n2 = n + dataFlavorArray.length;
            DataFlavor[] dataFlavorArray3 = new DataFlavor[n2];
            if (n > 0) {
                System.arraycopy(dataFlavorArray2, 0, dataFlavorArray3, 0, n);
            }
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray3, n, dataFlavorArray.length);
            this.accept_flavors = dataFlavorArray3;
        }
    }

    private static boolean CheckSupport(DropTargetDragEvent dropTargetDragEvent, DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        if (dataFlavorArray != null) {
            for (int i = dataFlavorArray.length - 1; i >= 0; --i) {
                if (!dropTargetDragEvent.isDataFlavorSupported(dataFlavorArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static DataFlavor GetDataFlavor(DropTargetDropEvent dropTargetDropEvent, DataFlavor[] dataFlavorArray) {
        DataFlavor dataFlavor = null;
        if (dataFlavorArray != null) {
            for (int i = dataFlavorArray.length - 1; i >= 0; --i) {
                if (!dropTargetDropEvent.isDataFlavorSupported(dataFlavorArray[i])) continue;
                dataFlavor = dataFlavorArray[i];
                break;
            }
        }
        return dataFlavor;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!DropTargetDelegate.CheckSupport(dropTargetDragEvent, this.accept_flavors)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!DropTargetDelegate.CheckSupport(dropTargetDragEvent, this.accept_flavors)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(3);
        DataFlavor dataFlavor = DropTargetDelegate.GetDataFlavor(dropTargetDropEvent, this.accept_flavors);
        if (dataFlavor != null) {
            try {
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    this.place.onDrop(transferable.getTransferData(dataFlavor));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var5_6 = null;
                    dropTargetDropEvent.dropComplete(true);
                }
                Object var5_5 = null;
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                dropTargetDropEvent.dropComplete(true);
                throw throwable;
            }
        } else {
            this.place.onDrop(dropTargetDropEvent.getTransferable());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    protected void finalize() {
        this.drop_target = null;
        this.place = null;
        this.accept_flavors = null;
    }

    public static interface IDropTargetPlace {
        public void onDrop(Object var1);
    }
}

