/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.sound;

import com.mylyane.afx.UIModule;
import java.applet.AudioClip;
import java.net.URL;
import sun.applet.AppletAudioClip;

public class AudioClipManager {
    private int count = 0;
    private AudioClip[] sounds;
    private int playing = -1;

    private boolean ldSnds(String[] stringArray, Class clazz) {
        AudioClip[] audioClipArray = null;
        try {
            int n = stringArray.length;
            audioClipArray = new AudioClip[n];
            for (int i = 0; i < n; ++i) {
                URL uRL = clazz.getResource(stringArray[i]);
                if (uRL == null) {
                    return false;
                }
                audioClipArray[i] = new AppletAudioClip(uRL);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.sounds = audioClipArray;
        this.count = audioClipArray.length;
        return true;
    }

    public synchronized boolean loadSounds(Class clazz, String string, char c) {
        String[] stringArray = UIModule.SplitString(string, c);
        return this.ldSnds(stringArray, clazz);
    }

    public int size() {
        return this.count;
    }

    public synchronized void play(int n) {
        if (this.count == 0) {
            return;
        }
        try {
            if (this.playing >= 0) {
                this.sounds[this.playing].stop();
            }
            this.sounds[n].play();
            this.playing = n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public synchronized void stop(int n) {
        if (this.count == 0) {
            return;
        }
        try {
            this.sounds[n].stop();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public synchronized void loop(int n) {
        if (this.count == 0) {
            return;
        }
        try {
            if (this.playing >= 0 || this.playing == n) {
                this.sounds[this.playing].stop();
            }
            this.sounds[n].loop();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void release() {
        this.sounds = null;
        this.count = 0;
    }
}

