/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui;

import com.mylyane.afx.IStatusInformation;

public class DelayStatus
extends Thread {
    private int time;
    private boolean b_delay;
    private boolean b_runnable;
    private Object lock = new Object();
    private IStatusInformation status;

    public DelayStatus(String string) {
        this((ThreadGroup)null, string);
    }

    public DelayStatus(ThreadGroup threadGroup, String string) {
        super(threadGroup, null, string);
        this.init(null, 5000, false);
    }

    public DelayStatus(IStatusInformation iStatusInformation, int n, boolean bl) {
        super(null, null, "Delay-Status");
        this.init(iStatusInformation, n, bl);
    }

    private void init(IStatusInformation iStatusInformation, int n, boolean bl) {
        this.status = iStatusInformation == null ? new Status("Ready.") : iStatusInformation;
        this.time = n;
        this.b_delay = true;
        this.b_runnable = false;
        if (bl) {
            this.begin();
        }
    }

    private void checkInternal() {
        if (!this.b_runnable) {
            throw new IllegalThreadStateException("It has not started yet. This problem happens because it did not call begin.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Object object) {
        this.checkInternal();
        Object object2 = this.lock;
        synchronized (object2) {
            this.b_delay = false;
            this.status.setStatus(object);
            this.status.showStatus();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(int n) {
        if (!this.b_runnable) {
            this.time = n;
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.b_delay = false;
                this.time = n;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.checkInternal();
        Object object = this.lock;
        synchronized (object) {
            this.b_runnable = false;
            this.b_delay = false;
            this.lock.notifyAll();
        }
    }

    public boolean begin() {
        boolean bl = true;
        if (!super.isAlive()) {
            this.b_runnable = true;
            super.start();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                do {
                    this.lock.wait(this.time);
                    if (this.b_delay) {
                        this.status.showStatus();
                    }
                    this.b_delay = true;
                    this.lock.notifyAll();
                } while (this.b_runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class Status
    implements IStatusInformation {
        private Object msg;
        private Object default_msg;

        Status(Object object) {
            this.default_msg = object;
            this.msg = null;
        }

        public void showStatus() {
            Object object = this.msg;
            if (object == null) {
                object = this.default_msg;
            }
            System.out.println(object);
            this.msg = null;
        }

        public void setStatus(Object object) {
            this.msg = object;
        }
    }
}

