/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.UIModule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String PREV_STRINGs = "abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\nThe Java language!";
    private JPanel actionPane = null;
    private JPanel fieldPane = null;
    private JPanel listsPane = null;
    private JPanel paramPane = null;
    private JButton accept = null;
    private JButton cancel = null;
    private JButton ok = null;
    private JTextArea prevPane = null;
    private JList fontList = null;
    private JList sizeList = null;
    private JList styleList = null;
    private JTextField name = null;
    private JTextField size = null;
    private JTextField style = null;
    private JFrame frame = null;
    private Component client = null;
    private Font prevFont = null;

    public static void main(String[] stringArray) {
        JFontChooser jFontChooser = new JFontChooser();
        JFrame jFrame = jFontChooser.createFontFrame(null);
        jFrame.setDefaultCloseOperation(3);
        UIModule.ToCenterScreen(jFrame);
        jFrame.setVisible(true);
    }

    public JFontChooser() {
        this.initialize();
    }

    public void setClientComponent(Component component) {
        this.client = component;
    }

    public void setPrevText(String string) {
        if (this.prevPane != null) {
            this.prevPane.setText(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Component component = this.client;
        Font font = null;
        Object object = actionEvent.getSource();
        boolean bl2 = bl = object == this.ok;
        if (bl || object == this.accept) {
            font = this.preview();
        }
        if (font != null && component != null) {
            component.setFont(font);
        }
        if ((bl || object == this.cancel) && this.frame != null) {
            this.release();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.fontList) {
            this.name.setText((String)this.fontList.getSelectedValue());
        } else if (object == this.styleList) {
            this.style.setText((String)this.styleList.getSelectedValue());
        } else if (object == this.sizeList) {
            this.size.setText((String)this.sizeList.getSelectedValue());
        }
        this.preview();
    }

    public JFrame createFontFrame(Component component) {
        JFrame jFrame = new JFrame("JFontChooser.");
        jFrame.getContentPane().setLayout(new BorderLayout(2, 2));
        jFrame.setDefaultCloseOperation(2);
        jFrame.getContentPane().add((Component)this, "Center");
        jFrame.pack();
        jFrame.setResizable(false);
        this.client = component;
        this.setFontParam(component.getFont());
        this.frame = jFrame;
        return this.frame;
    }

    public synchronized JFrame getJFrame() {
        return this.frame;
    }

    public Font getPreviewFont() {
        return this.prevFont;
    }

    public void release() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        super.removeAll();
        this.paramPane.removeAll();
        this.fieldPane.removeAll();
        this.listsPane.removeAll();
        this.actionPane.removeAll();
    }

    private void setFontParam(Font font) {
        if (font == null) {
            return;
        }
        this.name.setText(font.getFamily());
        int n = font.getStyle();
        String string = null;
        switch (n) {
            case 0: {
                string = "PLAIN";
                break;
            }
            case 2: {
                string = "ITALIC";
                break;
            }
            case 1: {
                string = "BOLD";
                break;
            }
            case 3: {
                string = "BOLD|ITALIC";
            }
        }
        if (string != null) {
            this.style.setText(string);
        }
        this.size.setText(font.getSize() + "");
        this.prevPane.setFont(font);
        this.prevFont = font;
    }

    private Font preview() {
        String string;
        String string2;
        Font font = null;
        String string3 = this.name.getText();
        if (string3 != null && string3.length() > 0 && (string2 = this.style.getText()) != null && string2.length() > 0 && (string = this.size.getText()) != null && string.length() > 0) {
            int n = string2.equalsIgnoreCase("plain") ? 0 : (string2.equalsIgnoreCase("italic") ? 2 : (string2.equalsIgnoreCase("bold") ? 1 : 3));
            int n2 = Integer.parseInt(string);
            font = new Font(string3, n, n2);
            this.prevPane.setFont(font);
            this.prevFont = font;
        }
        return font;
    }

    private void initialize() {
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.getParamPane(), "Center");
        this.add((Component)this.getActionPane(), "East");
        this.add((Component)this.getPrevPane(), "South");
        this.setPreferredSize(new Dimension(480, 260));
    }

    private JPanel getParamPane() {
        if (this.paramPane == null) {
            this.paramPane = new JPanel();
            BorderLayout borderLayout = new BorderLayout(2, 2);
            this.paramPane.setLayout(borderLayout);
            this.paramPane.add((Component)this.getFieldPane(), "North");
            this.paramPane.add((Component)this.getListsPane(), "Center");
        }
        return this.paramPane;
    }

    private JPanel getFieldPane() {
        if (this.fieldPane == null) {
            this.fieldPane = new JPanel();
            GridLayout gridLayout = new GridLayout(1, 3, 2, 2);
            this.fieldPane.setLayout(gridLayout);
            this.fieldPane.add((Component)this.getNameField(), null);
            this.fieldPane.add((Component)this.getStyle(), null);
            this.fieldPane.add((Component)this.getSizeField(), null);
        }
        return this.fieldPane;
    }

    private JTextField getNameField() {
        if (this.name == null) {
            this.name = new JTextField();
        }
        return this.name;
    }

    private JTextField getStyle() {
        if (this.style == null) {
            this.style = new JTextField();
        }
        return this.style;
    }

    private JTextField getSizeField() {
        if (this.size == null) {
            this.size = new JTextField();
        }
        return this.size;
    }

    private JList getFontList() {
        if (this.fontList == null) {
            JList<String> jList = new JList<String>();
            jList.setSelectionMode(0);
            jList.setListData(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            jList.addListSelectionListener(this);
            this.fontList = jList;
        }
        return this.fontList;
    }

    private JList getStyleList() {
        if (this.styleList == null) {
            JList<Object> jList = new JList<Object>();
            jList.setSelectionMode(0);
            jList.setListData(new Object[]{"PLAIN", "ITALIC", "BOLD", "BOLD|ITALIC"});
            jList.addListSelectionListener(this);
            this.styleList = jList;
        }
        return this.styleList;
    }

    private JList getSizeList() {
        if (this.sizeList == null) {
            JList<Object> jList = new JList<Object>();
            jList.setSelectionMode(0);
            jList.setListData(new Object[]{"8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58"});
            jList.addListSelectionListener(this);
            this.sizeList = jList;
        }
        return this.sizeList;
    }

    private JPanel getListsPane() {
        if (this.listsPane == null) {
            this.listsPane = new JPanel();
            GridLayout gridLayout = new GridLayout(1, 3, 2, 2);
            this.listsPane.setLayout(gridLayout);
            JScrollPane jScrollPane = new JScrollPane(this.getFontList(), 20, 30);
            this.listsPane.add((Component)jScrollPane, null);
            this.listsPane.add((Component)this.getStyleList(), null);
            jScrollPane = new JScrollPane(this.getSizeList(), 20, 30);
            this.listsPane.add((Component)jScrollPane, null);
        }
        return this.listsPane;
    }

    private JComponent getPrevPane() {
        if (this.prevPane == null) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setPreferredSize(new Dimension(10, 100));
            jTextArea.setBorder(BorderFactory.createBevelBorder(1));
            jTextArea.setText(PREV_STRINGs);
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(true);
            this.prevPane = jTextArea;
        }
        return this.prevPane;
    }

    private JPanel getActionPane() {
        if (this.actionPane == null) {
            this.actionPane = new JPanel();
            this.actionPane.add((Component)this.getOk(), null);
            this.actionPane.add((Component)this.getAccept(), null);
            this.actionPane.add((Component)this.getCancel(), null);
            this.actionPane.setPreferredSize(new Dimension(80, 20));
        }
        return this.actionPane;
    }

    private JButton getOk() {
        if (this.ok == null) {
            this.ok = new JButton();
            this.ok.setText("OK");
            this.ok.setPreferredSize(new Dimension(75, 26));
            this.ok.addActionListener(this);
        }
        return this.ok;
    }

    private JButton getAccept() {
        if (this.accept == null) {
            this.accept = new JButton();
            this.accept.setText("Accept");
            this.accept.setPreferredSize(new Dimension(75, 26));
            this.accept.addActionListener(this);
        }
        return this.accept;
    }

    private JButton getCancel() {
        if (this.cancel == null) {
            this.cancel = new JButton();
            this.cancel.setPreferredSize(new Dimension(75, 26));
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(this);
        }
        return this.cancel;
    }
}

