/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.IUserInputFrame;
import com.mylyane.afx.swing.SwingUIModule;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JUserInputFrame
extends JFrame
implements ActionListener,
IUserInputFrame {
    JButton accept_btn = new JButton("Accept");
    JButton cancel_btn = new JButton("Cancel");
    JTextField[] str_params;
    private boolean accepted = false;

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"About this file ", "/* content panel. */ ", "test ", " mylyane@agate.plala.or.jp "};
        JUserInputFrame jUserInputFrame = new JUserInputFrame();
        jUserInputFrame.createUI(stringArray2);
        SwingUIModule.ToCenterScreen(jUserInputFrame);
        jUserInputFrame.setVisible(true);
    }

    public JUserInputFrame() {
        this("No title.");
    }

    public JUserInputFrame(String string) {
        super(string);
        this.initButtons();
    }

    private void initButtons() {
        Font font = new Font("DialogInput", 2, 11);
        this.accept_btn.setFont(font);
        this.accept_btn.setBorder(BorderFactory.createLineBorder(Color.black));
        this.accept_btn.setDoubleBuffered(true);
        this.cancel_btn.setFont(font);
        this.cancel_btn.setBorder(BorderFactory.createLineBorder(Color.black));
        this.cancel_btn.setDoubleBuffered(true);
        this.accept_btn.addActionListener(this);
        this.cancel_btn.addActionListener(this);
    }

    private void removeTextFileds() {
        JTextField[] jTextFieldArray = this.str_params;
        if (jTextFieldArray == null) {
            return;
        }
        int n = jTextFieldArray.length;
        while (n-- > 0) {
            jTextFieldArray[n] = null;
        }
        this.str_params = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.accept_btn) {
            this.accepted = true;
        }
        super.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResults() {
        String[] stringArray;
        if (Thread.currentThread().getName().equals("main")) {
            SyncThread syncThread = new SyncThread((JUserInputFrame)this);
            try {
                stringArray = this;
                synchronized (this) {
                    syncThread.start();
                    while (syncThread.isAlive()) {
                        this.wait(200L);
                    }
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            try {
                while (super.isShowing()) {
                    Thread.sleep(500L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        {
            if (!this.accepted || this.str_params == null) {
                return null;
            }
            int n = this.str_params.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.str_params[i].getText();
            }
            return stringArray;
        }
    }

    public void setText(int n, String string) {
        JTextField[] jTextFieldArray = this.str_params;
        if (jTextFieldArray == null) {
            return;
        }
        try {
            jTextFieldArray[n].setText(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("invalid index!");
        }
    }

    public void showInputFrame() {
        super.setVisible(true);
    }

    public void createUI(String[] stringArray) {
        this.removeTextFileds();
        this.str_params = new JTextField[stringArray.length];
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridLayout(stringArray.length + 1, 2, 3, 3));
        Font font = new Font("DialogInput", 0, 11);
        for (int i = 0; i < stringArray.length; ++i) {
            JLabel jLabel = new JLabel(stringArray[i], 4);
            JTextField jTextField = new JTextField();
            jLabel.setFont(font);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            this.str_params[i] = jTextField;
        }
        jPanel.add(this.accept_btn);
        jPanel.add(this.cancel_btn);
        this.pack();
    }

    public void release() {
        super.dispose();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        this.accept_btn = null;
        this.cancel_btn = null;
        this.removeTextFileds();
    }

    private static class SyncThread
    extends Thread {
        JUserInputFrame ctrl;

        SyncThread(JUserInputFrame jUserInputFrame) {
            super("SyncThread");
            this.ctrl = jUserInputFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String[] stringArray;
            try {
                stringArray = this.ctrl;
                synchronized (this.ctrl) {
                    while (this.ctrl.isShowing()) {
                        SyncThread.sleep(500L);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            {
                stringArray = this.ctrl.getResults();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        System.out.println(stringArray[i]);
                    }
                }
                this.ctrl = null;
                return;
            }
        }
    }
}

