/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import com.mylyane.afx.UIModule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public final class MicroButtonPane
extends JPanel
implements Serializable,
SwingConstants {
    private static final Font MICRO_FONT = new Font("Dialog", 1, 8);
    private static final Insets MICRO_INSETS = new Insets(0, 0, 0, 0);
    private static final Border MICRO_BORDER = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
    private JButton[] buttons;

    public MicroButtonPane(String string, String string2, int n, int n2, Object object) {
        this.init(string, string2, n, object);
        this.setPushed(n2);
    }

    private void init(String string, String string2, int n, Object object) {
        String[] stringArray = UIModule.SplitString(string, '|');
        Dimension dimension = new Dimension(UIModule.GetStringWidth(MICRO_FONT, stringArray[0]) + 10, 10);
        int n2 = stringArray.length;
        String[] stringArray2 = string2 == null ? new String[n2] : UIModule.SplitString(string2, '|');
        JButton[] jButtonArray = new JButton[n2];
        GridLayout gridLayout = n == 1 ? new GridLayout(n2, 1) : new GridLayout(1, n2);
        this.setLayout(gridLayout);
        try {
            for (int i = 0; i < n2; ++i) {
                JButton jButton = this.createButton(stringArray[i], stringArray2[i], dimension);
                if (object != null) {
                    if (object instanceof IButtonCreationCallBack) {
                        ((IButtonCreationCallBack)object).onCreate(jButton, i);
                    } else if (object instanceof ActionListener) {
                        jButton.addActionListener((ActionListener)object);
                    }
                }
                jButtonArray[i] = (JButton)this.add(jButton);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.out.println("ERROR!:MicroButtonPane.init, message is :".concat(arrayIndexOutOfBoundsException.getMessage()));
        }
        this.buttons = jButtonArray;
    }

    private JButton createButton(String string, String string2, Dimension dimension) {
        JButton jButton = new JButton(string);
        jButton.setFont(MICRO_FONT);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setMargin(MICRO_INSETS);
        jButton.setActionCommand(string2);
        jButton.setBorder(MICRO_BORDER);
        return jButton;
    }

    public void setPushed(int n) {
        JButton[] jButtonArray = this.buttons;
        if (jButtonArray == null) {
            System.out.println("Buttons not initialized...");
            return;
        }
        for (int i = 0; i < jButtonArray.length; ++i) {
            if (i == n) {
                jButtonArray[i].setBackground(Color.white);
                continue;
            }
            jButtonArray[i].setBackground(Color.lightGray);
        }
    }

    public int getPushedIndex() {
        JButton[] jButtonArray = this.buttons;
        if (jButtonArray == null) {
            System.out.println("Buttons not initialized...");
            return -1;
        }
        for (int i = 0; i < jButtonArray.length; ++i) {
            if (jButtonArray[i].getBackground() != Color.white) continue;
            return i;
        }
        return -1;
    }

    public static interface IButtonCreationCallBack {
        public void onCreate(JButton var1, int var2);
    }
}

