/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.ui.swing;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class SearchResultWalkAction
extends AbstractAction {
    public static final String SEARCH_FROM = "search-from-object";
    protected Vector results;
    protected IWalkDelegate delegate;

    public SearchResultWalkAction() {
        super("Visit next", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        this.results = new Vector(30);
    }

    protected synchronized void finalize() {
        if (this.results != null) {
            this.results.removeAllElements();
            this.results = null;
        }
        if (this.delegate != null) {
            this.delegate.setOwner(null);
            this.delegate = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.walkNext();
    }

    public boolean is(int n) {
        return this.delegate.isInstanceFor(n);
    }

    public void setWalkDelegate(IWalkDelegate iWalkDelegate) {
        this.delegate = iWalkDelegate;
        if (iWalkDelegate != null) {
            iWalkDelegate.setOwner(this);
        }
    }

    public void setMode(int n) {
        if (this.delegate != null) {
            this.delegate.setMode(n);
        }
    }

    public void add(Object object) {
        this.results.addElement(object);
    }

    public Object get(int n) {
        return this.results.get(n);
    }

    public int size() {
        return this.results.size();
    }

    public void reset() {
        this.results.removeAllElements();
        this.putValue(SEARCH_FROM, null);
        this.delegate.update(this.results);
    }

    public String getSearchWord() {
        return this.delegate.getSearchWord();
    }

    public void notifyOfSearchDone(Object object, String string) {
        this.putValue(SEARCH_FROM, object);
        this.delegate.update(this.results);
        this.delegate.setSearchWord(string);
    }

    public void walkNext() {
        this.delegate.walkNext();
    }

    public static interface IWalkDelegate {
        public void update(Vector var1);

        public void setSearchWord(String var1);

        public String getSearchWord();

        public void setMode(int var1);

        public void walkNext();

        public void setOwner(SearchResultWalkAction var1);

        public boolean isInstanceFor(int var1);
    }
}

