/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

import com.mylyane.lang.B2C;
import com.mylyane.lang.CharUtility;
import com.mylyane.lang.CharsBuffer;
import com.mylyane.util.QON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class IOUtility {
    private static CharsBuffer MY_BUF = new CharsBuffer(100);

    public static boolean SolveDir(String string) {
        File file = new File(string);
        return file.exists() ? true : file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String CreatePathByUserDir(String string) {
        CharsBuffer charsBuffer;
        CharsBuffer charsBuffer2 = charsBuffer = MY_BUF;
        synchronized (charsBuffer) {
            charsBuffer.flush();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return charsBuffer.append(System.getProperty("user.dir")).append(File.separatorChar).append(string).flushToString();
        }
    }

    public static String SolveDirByUserDir(String string) {
        String string2 = IOUtility.CreatePathByUserDir(string);
        return IOUtility.SolveDir(string2) ? string2 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String CreatePath(String string, String string2) {
        if (string != null && string.length() > 0) {
            CharsBuffer charsBuffer;
            char c = File.separatorChar;
            CharsBuffer charsBuffer2 = charsBuffer = MY_BUF;
            synchronized (charsBuffer) {
                charsBuffer.flush();
                charsBuffer.add(string);
                if (charsBuffer.charAt(charsBuffer.length() - 1) != c) {
                    charsBuffer.add(c);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return charsBuffer.append(string2).flushToString();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String CreatePathAndSolve(String string, String string2) {
        char c = File.separatorChar;
        if (string != null && string.length() > 0) {
            CharsBuffer charsBuffer;
            CharsBuffer charsBuffer2 = charsBuffer = MY_BUF;
            synchronized (charsBuffer) {
                charsBuffer.flush();
                charsBuffer.add(string);
                if (charsBuffer.charAt(charsBuffer.length() - 1) != c) {
                    charsBuffer.add(c);
                }
                charsBuffer.add(string2);
                int n = charsBuffer.lastIndexOf(c);
                if (IOUtility.SolveDir(charsBuffer.substring(0, n))) {
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return charsBuffer.flushToString();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        } else {
            int n = string2.lastIndexOf(c);
            if (n < 0) {
                n = string2.length();
            }
            if (IOUtility.SolveDir(string2.substring(0, n))) {
                return string2;
            }
        }
        {
            throw new RuntimeException("Faild creation... invalid String parameter or can't made directory.");
        }
    }

    public static String ExtractName(String string) {
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        return string;
    }

    public static boolean CreateFile(InputStream inputStream, String string) {
        try {
            byte[] byArray = IOUtility.ReadFitfullyAsBinary(inputStream, inputStream.available());
            return IOUtility.CreateFile(byArray, 0, byArray.length, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean CreateFile(byte[] byArray, int n, int n2, String string) {
        boolean bl = true;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray, n, n2);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static final boolean Dump(Object object, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = object.toString().getBytes();
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static Object ReadLocalStream(Object object, boolean bl) throws Exception {
        String string = object instanceof File ? ((File)object).getAbsolutePath() : (String)object;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        return byArray;
    }

    public static int ReadLocalStream(Object object, byte[] byArray) throws Exception {
        String string = object instanceof File ? ((File)object).getAbsolutePath() : (String)object;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        if (n > byArray.length) {
            n = byArray.length;
        }
        n = fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        return n;
    }

    public static char[] ReadLocalStreamAsChar(Object object, boolean bl) throws Exception {
        byte[] byArray = (byte[])IOUtility.ReadLocalStream(object, false);
        return bl ? B2C.ConvertDefault(byArray, byArray.length) : CharUtility.ConvertSingle(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void SerializeObject(Object object, String string) throws Exception {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            Object var5_3 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (objectOutputStream == null) throw throwable;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object RestoreObject(String string) throws Exception {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            Object var5_3 = null;
            if (objectInputStream == null) return object;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (objectInputStream == null) throw throwable;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return object;
    }

    public static final byte[] GrowBuffer(byte[] byArray, int n) {
        return IOUtility.GrowBuffer(byArray, byArray.length, n);
    }

    public static final byte[] GrowBuffer(byte[] byArray, int n, int n2) {
        if (n2 <= 0 || n <= 0) {
            return byArray;
        }
        int n3 = byArray.length + n2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static final byte[] TrimBuffer(byte[] byArray, int n) {
        if (n > byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static final byte[] TrimBufferR(byte[] byArray, int n) {
        if (n <= 0) {
            return byArray;
        }
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static final byte[] CopyBuffer(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static int WriteInt(byte[] byArray, int n, int n2) {
        return IOUtility.WriteNumber(byArray, n, n2, 32);
    }

    public static void WriteWord(byte[] byArray, int n, int n2) {
        int n3 = 255;
        byArray[n++] = (byte)(n2 >> 8 & n3);
        byArray[n] = (byte)(n2 & n3);
    }

    public static int WriteAny(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n + n2;
    }

    public static int WriteNumber(byte[] byArray, int n, int n2, int n3) {
        if ((n3 /= 8) > 4) {
            n3 = 4;
        } else {
            if (n3 < 1) {
                return n;
            }
            if (n < 0) {
                n = 0;
            }
        }
        int n4 = n + n3;
        if (n4 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("cannot write, offset=".concat(QON.toString(n)));
        }
        long l = 255L;
        int n5 = 0;
        do {
            byArray[n + --n3] = (byte)((long)(n2 >> n5) & l);
            n5 += 8;
        } while (n3 > 0);
        return n4;
    }

    public static void WriteLittleAny(byte[] byArray, int n, long l, int n2) {
        int n3 = n2 / 8;
        int n4 = 0;
        long l2 = 255L;
        if (n3 > 8) {
            n3 = 8;
        }
        n3 += n;
        while (n < n3) {
            byArray[n] = (byte)(l >> n4 & l2);
            n4 += 8;
            ++n;
        }
    }

    public static long ReadLittleAny(byte[] byArray, int n, int n2) {
        int n3 = n2 / 8;
        int n4 = 0;
        long l = 0L;
        long l2 = 255L;
        if (n3 > 8) {
            n3 = 8;
        }
        n3 += n;
        while (n < n3) {
            l |= ((long)byArray[n] & l2) << n4;
            n4 += 8;
            ++n;
        }
        return l;
    }

    public static void Write64Little(byte[] byArray, int n, long l) {
        IOUtility.WriteLittleAny(byArray, n, l, 64);
    }

    public static long Read64Little(byte[] byArray, int n) {
        return IOUtility.ReadLittleAny(byArray, n, 64);
    }

    public static void Write16Little(byte[] byArray, int n, int n2) {
        IOUtility.WriteLittleAny(byArray, n, (long)n2 & 0xFFFFL, 16);
    }

    public static void Write32Little(byte[] byArray, int n, int n2) {
        IOUtility.WriteLittleAny(byArray, n, (long)n2 & 0xFFFFFFFFL, 32);
    }

    public static char Read16Little(byte[] byArray, int n) {
        return (char)(IOUtility.ReadLittleAny(byArray, n, 16) & 0xFFFFL);
    }

    public static int Read32Little(byte[] byArray, int n) {
        return (int)(IOUtility.ReadLittleAny(byArray, n, 32) & 0xFFFFFFFFL);
    }

    public static byte[] ReadFitfullyAsBinary(InputStream inputStream) throws Exception {
        return IOUtility.ReadFitfullyAsBinary(inputStream, 1024);
    }

    public static byte[] ReadFitfullyAsBinary(InputStream inputStream, int n) throws Exception {
        int n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[]{};
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
            byArray2 = new byte[n2 + n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
            System.arraycopy(byArray, 0, byArray2, n3, n2);
            n3 += n2;
            byArray3 = byArray2;
        }
        inputStream.close();
        return byArray2;
    }

    public static byte[] ReadFitfullyAsBinary(URL uRL) throws Exception {
        return IOUtility.ReadFitfullyAsBinary(uRL.openConnection().getInputStream(), 1024);
    }

    public static byte[] ReadBinaryFromUnknownSize(InputStream inputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, n - n3)) != -1) {
            if ((n3 += n2) != n || n3 < n) continue;
            n = n3 << 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            byArray = byArray2;
        }
        inputStream.close();
        return IOUtility.TrimBuffer(byArray, n3);
    }

    public static byte[] ReadStreamAvailable(InputStream inputStream, int n, boolean bl) throws Exception {
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        if (bl) {
            inputStream.close();
        }
        return byArray;
    }

    public static InputStream OpenStream(String string) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && new File(string).exists()) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    public static InputStreamReader OpenStreamReader(String string) throws Exception {
        return new InputStreamReader(IOUtility.OpenStream(string));
    }

    public static char[] ReadStreamAsChar(Object object, boolean bl) throws Exception {
        InputStream inputStream = object instanceof String ? IOUtility.OpenStream((String)object) : (object instanceof URL ? ((URL)object).openStream() : (InputStream)object);
        byte[] byArray = IOUtility.ReadFitfullyAsBinary(inputStream, 1024);
        return bl ? B2C.ConvertDefault(byArray, byArray.length) : CharUtility.ConvertSingle(byArray);
    }

    public static char[] ReadResourceTextFromZip(InputStream inputStream, String string) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().indexOf(string) >= 0) {
                byte[] byArray = zipEntry.getMethod() == 0 ? IOUtility.ReadStreamAvailable(zipInputStream, (int)zipEntry.getSize(), true) : IOUtility.ReadFitfullyAsBinary(zipInputStream, 1024);
                return CharUtility.ConvertSingle(byArray);
            }
            zipInputStream.closeEntry();
        }
        return null;
    }

    public static InputStream GetZipInputStreamByName(InputStream inputStream, String string) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().equals(string)) {
                return zipInputStream;
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] ReadStreamFromZip(URL uRL, String string) {
        boolean bl;
        InputStream inputStream;
        byte[] byArray;
        block8: {
            byArray = null;
            inputStream = null;
            bl = false;
            inputStream = IOUtility.GetZipInputStreamByName(uRL.openStream(), string);
            if (inputStream == null) break block8;
            return IOUtility.ReadFitfullyAsBinary(inputStream, 1024);
        }
        Object var7_5 = null;
        if (bl) return byArray;
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_6 = null;
                if (bl) return byArray;
                if (inputStream == null) return byArray;
                try {
                    inputStream.close();
                    return byArray;
                }
                catch (IOException iOException) {}
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) throw throwable;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static byte[] ReadBinaryFromZip(Object object, String string) throws Exception {
        ZipFile zipFile = new ZipFile(object instanceof File ? (File)object : new File((String)object));
        return IOUtility.ReadBinaryFromZip(zipFile, string, true);
    }

    public static byte[] ReadBinaryFromZip(ZipFile zipFile, String string, boolean bl) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            if (bl) {
                zipFile.close();
            }
            return null;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] byArray = zipEntry.getMethod() == 0 ? IOUtility.ReadStreamAvailable(inputStream, (int)zipEntry.getSize(), true) : IOUtility.ReadFitfullyAsBinary(inputStream, 1024);
        if (bl) {
            zipFile.close();
        }
        return byArray;
    }

    public static String ReadLineFromStdIn(BufferedReader bufferedReader, String string) throws IOException {
        if (bufferedReader == null) {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        if (string != null) {
            System.out.print(string);
            System.out.flush();
        }
        return bufferedReader.readLine();
    }
}

