/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.util;

import com.mylyane.lang.CharUtility;
import com.mylyane.util.ITokenizer;
import java.io.Serializable;

public abstract class XTokenizer
implements Serializable,
ITokenizer {
    protected char[] m_str;
    protected int m_cp;
    protected int m_limit;
    protected char[] m_delim_table;
    protected char m_max_delim_value;

    public static char[] RegistDelimiters(char[] cArray, char[] cArray2, char c) {
        CharUtility.RepeatChar(cArray, 0, cArray.length, '\u0000');
        for (int i = 0; i < cArray2.length; ++i) {
            char c2 = cArray2[i];
            if (c2 >= c) continue;
            cArray[c2] = c2;
        }
        return cArray;
    }

    public XTokenizer(String string, String string2, char c) {
        this.m_str = string != null ? string.toCharArray() : null;
        this.m_limit = string != null ? string.length() : 0;
        this.m_delim_table = new char[c];
        this.registDelimiters(string2.toCharArray(), c);
    }

    public XTokenizer(String string) {
        this(string, " \t\n\r", '\u0080');
    }

    protected final void registDelimiters(char[] cArray, char c) {
        CharUtility.RepeatChar(this.m_delim_table, 0, this.m_delim_table.length, '\u0000');
        char c2 = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            char c3 = cArray[i];
            if (c3 < c) {
                this.m_delim_table[c3] = c3;
            }
            if (c2 >= c3) continue;
            c2 = c3;
        }
        this.m_max_delim_value = c2;
    }

    protected final int NTO(int n) {
        char c;
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim_table;
        int n2 = cArray.length;
        while (n < n2 && (c = cArray[n]) <= this.m_max_delim_value && cArray2[c] != '\u0000') {
            ++n;
        }
        return n;
    }

    protected final int TE(int n) {
        char c;
        char[] cArray = this.m_str;
        char[] cArray2 = this.m_delim_table;
        int n2 = cArray.length;
        char c2 = this.m_max_delim_value;
        while (n < n2 && ((c = cArray[n]) > c2 || cArray2[c] == '\u0000')) {
            ++n;
        }
        return n;
    }

    public void changeCond(String string) {
        if (string == null) {
            string = "";
        }
        this.changeCond(string.toCharArray());
    }

    public void changeCond(char[] cArray) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        this.m_str = cArray;
        this.m_limit = cArray.length;
        this.m_cp = 0;
    }

    public abstract void changeDelim(String var1, boolean var2);

    public abstract boolean eol();

    public abstract boolean hasMoreTokens();

    public abstract void skip(int var1);

    public abstract String currentToken();

    public abstract String nextToken();

    public abstract String nextToken(String var1);

    public abstract int currentTokenHash();

    public abstract int nextTokenHash();

    public abstract char tokenCharAt(int var1, boolean var2);

    public abstract void setCommentChars(String var1);

    public abstract void skipComments();

    public abstract int countTokens();

    public abstract void reset();
}

