/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.DbmSession;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutionMDbm {
    private static final int ONE_SEND_KEY = 48;
    private static final int BASE_HEAD_LENGTH = 12;

    ExecutionMDbm() {
    }

    public static final void execution(byte[] bin, DbmSession session) throws Exception {
        block23: {
            if (session == null || session.isClosed()) {
                return;
            }
            if (bin == null || bin.length < 8) {
                ExecutionMDbm.returnError(session, "\u4e0d\u660e\u306a\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u3059");
                return;
            }
            if (MDbmManager.getInstance().isClose()) {
                ExecutionMDbm.returnError(session, "MDbm\u30de\u30cd\u30fc\u30b8\u30e3\u306f\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
                return;
            }
            try {
                int type = ExecutionMDbm.getSendType(bin);
                switch (type) {
                    case 1: {
                        ExecutionMDbm.resultClose(session);
                        break;
                    }
                    case 2: {
                        ExecutionMDbm.resultCommit(session);
                        break;
                    }
                    case 3: {
                        ExecutionMDbm.resultRollback(session);
                        break;
                    }
                    case 4: {
                        ExecutionMDbm.resultCheck(session);
                        break;
                    }
                    case 17: {
                        ExecutionMDbm.resultPut(bin, session);
                        break;
                    }
                    case 18: {
                        ExecutionMDbm.resultRemove(bin, session);
                        break;
                    }
                    case 19: {
                        ExecutionMDbm.resultGet(bin, session);
                        break;
                    }
                    case 20: {
                        ExecutionMDbm.resultContains(bin, session);
                        break;
                    }
                    case 257: {
                        ExecutionMDbm.resulSize(session);
                        break;
                    }
                    case 258: {
                        ExecutionMDbm.resultDirectory(session);
                        break;
                    }
                    case 259: {
                        ExecutionMDbm.resulInitKey(session);
                        break;
                    }
                    case 260: {
                        ExecutionMDbm.resulHasKey(session);
                        break;
                    }
                    case 261: {
                        ExecutionMDbm.resulGetKey(session);
                        break;
                    }
                    case 513: {
                        ExecutionMDbm.resultSequenceId(bin, session);
                        break;
                    }
                    default: {
                        ExecutionMDbm.returnError(session, "\u4e0d\u660e\u306a\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u3059");
                        break;
                    }
                }
            }
            catch (Exception e) {
                try {
                    ExecutionMDbm.returnError(session, e.getLocalizedMessage());
                }
                catch (Exception ee) {
                    if (session == null) break block23;
                    session.destroy();
                }
            }
        }
    }

    private static final int getSendType(byte[] bin) throws Exception {
        return ConvertParam.convertInt((int)4, (byte[])bin);
    }

    private static final void resultClose(DbmSession session) throws Exception {
        ExecutionMDbm.out("close");
        session.mdbm().close();
        session.destroy();
    }

    private static final void resultCommit(DbmSession session) throws Exception {
        ExecutionMDbm.out("commit");
        session.mdbm().commit();
        session.clearKeys();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultRollback(DbmSession session) throws Exception {
        ExecutionMDbm.out("rollback");
        session.mdbm().rollback();
        session.clearKeys();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultCheck(DbmSession session) throws Exception {
        ExecutionMDbm.out("check");
        session.mdbm().check();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultPut(byte[] bin, DbmSession session) throws Exception {
        ExecutionMDbm.out("put");
        int pnt = 8;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        int valLen = ConvertParam.convertInt((int)(pnt += keyLen), (byte[])bin);
        byte[] value = new byte[valLen];
        System.arraycopy(bin, pnt += 4, value, 0, valLen);
        session.mdbm().put(key, value);
        key = null;
        value = null;
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultRemove(byte[] bin, DbmSession session) throws Exception {
        ExecutionMDbm.out("remove");
        int pnt = 8;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        session.mdbm().remove(key);
        key = null;
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultGet(byte[] bin, DbmSession session) throws Exception {
        ExecutionMDbm.out("get");
        int pnt = 8;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        byte[] ret = session.mdbm().get(key);
        key = null;
        ExecutionMDbm.returnData(session, ret);
    }

    private static final void resultContains(byte[] bin, DbmSession session) throws Exception {
        ExecutionMDbm.out("contains");
        int pnt = 8;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        boolean ret = session.mdbm().containsKey(key);
        key = null;
        ExecutionMDbm.returnBool(session, ret);
    }

    private static final void resulSize(DbmSession session) throws Exception {
        ExecutionMDbm.out("size");
        int ret = session.mdbm().size();
        ExecutionMDbm.returnSize(session, ret);
    }

    private static final void resultDirectory(DbmSession session) throws Exception {
        ExecutionMDbm.out("directory");
        String ret = session.mdbm().getDirectory();
        if (ret == null || ret.length() <= 0) {
            ExecutionMDbm.returnData(session, null);
        } else {
            ExecutionMDbm.returnData(session, ret.getBytes("UTF8"));
        }
    }

    private static final void resulInitKey(DbmSession session) throws Exception {
        ExecutionMDbm.out("initKey");
        session.clearKeys();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resulHasKey(DbmSession session) throws Exception {
        ExecutionMDbm.out("hasKey");
        Enumeration<byte[]> keys = session.getKeys();
        if (keys == null) {
            keys = session.mdbm().elements();
            session.setKeys(keys);
        }
        boolean ret = keys.hasMoreElements();
        ExecutionMDbm.returnBool(session, ret);
    }

    private static final void resulGetKey(DbmSession session) throws Exception {
        ExecutionMDbm.out("getKey");
        Enumeration<byte[]> keys = session.getKeys();
        if (keys == null) {
            keys = session.mdbm().elements();
            session.setKeys(keys);
        }
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int i = 0;
        while (i < 48) {
            byte[] b = keys.nextElement();
            if (b == null) break;
            ret.add(b);
            ++i;
        }
        ExecutionMDbm.returnKey(session, ret);
    }

    private static final void resultSequenceId(byte[] bin, DbmSession session) throws Exception {
        ExecutionMDbm.out("sequenceId");
        int no = ConvertParam.convertInt((int)8, (byte[])bin);
        long ret = session.mdbm().sequenceId(no);
        ExecutionMDbm.returnId(session, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnSuccess(DbmSession session) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return success");
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)8));
            o.write(ConvertParam.convertInt((int)1));
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnError(DbmSession session, String message) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return error");
        if (message == null || (message = message.trim()).length() <= 0) {
            message = "error";
        }
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            byte[] b = message.getBytes("UTF8");
            o.write(ConvertParam.convertInt((int)(12 + b.length)));
            o.write(ConvertParam.convertInt((int)2));
            o.write(ConvertParam.convertInt((int)b.length));
            o.write(b);
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnBool(DbmSession session, boolean bool) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return bool");
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)9));
            o.write(ConvertParam.convertInt((int)16));
            o.write(ConvertParam.convertBoolean((boolean)bool));
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnData(DbmSession session, byte[] data) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return data");
        int len = 0;
        if (data != null) {
            len = data.length;
        }
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)(12 + len)));
            o.write(ConvertParam.convertInt((int)17));
            o.write(ConvertParam.convertInt((int)len));
            if (len > 0) {
                o.write(data);
            }
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnKey(DbmSession session, ArrayList<byte[]> data) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return key");
        int len = 0;
        if (data != null) {
            len = data.size();
        }
        int next = 0;
        int i = 0;
        while (i < len) {
            byte[] b = data.get(i);
            next += b.length + 4;
            ++i;
        }
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)(12 + next)));
            o.write(ConvertParam.convertInt((int)18));
            o.write(ConvertParam.convertInt((int)len));
            int i2 = 0;
            while (i2 < len) {
                byte[] b = data.get(i2);
                o.write(ConvertParam.convertInt((int)b.length));
                o.write(b);
                ++i2;
            }
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnSize(DbmSession session, int size) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return size");
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)12));
            o.write(ConvertParam.convertInt((int)19));
            o.write(ConvertParam.convertInt((int)size));
            o.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void returnId(DbmSession session, long id) throws Exception {
        OutputStream o;
        ExecutionMDbm.out("return id");
        OutputStream outputStream = o = session.outputStream();
        synchronized (outputStream) {
            o.write(ConvertParam.convertInt((int)16));
            o.write(ConvertParam.convertInt((int)20));
            o.write(ConvertParam.convertLong((long)id));
            o.flush();
        }
    }

    private static final void out(String msg) {
    }
}

