package org.maachang.dbm.engine ;

/**
 * 次キー内容取得用オブジェクト.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class NextKey {
    
    /**
     * ポジション.
     */
    private int pos = -1 ;
    
    /**
     * キー内容.
     */
    private byte[] key = null ;
    
    /**
     * コンストラクタ.
     */
    public NextKey() {
        
    }
    
    /**
     * ポジションを設定.
     * <BR>
     * @param pos 対象のポジションを設定します.
     */
    public void setPos( int pos ) {
        this.pos = pos ;
    }
    
    /**
     * ポジションを取得.
     * <BR>
     * @return int 対象のポジション情報が返されます.
     */
    public int getPos() {
        return this.pos ;
    }
    
    /**
     * キー内容を設定.
     * <BR>
     * @param key 対象のキー内容を設定します.
     */
    public void setKey( byte[] key ) {
        this.key = key ;
    }
    
    /**
     * キー内容を取得.
     * <BR>
     * @return byte[] 対象のキー内容が返されます.
     */
    public byte[] getKey() {
        return this.key ;
    }
}
