/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.lang.reflect.Field;
import org.maachang.reflect.FastClassElement;
import org.maachang.reflect.FastReflectClass;
import org.maachang.reflect.FastReflectUtil;

public abstract class FastReflect {
    private FastReflect() {
    }

    public static final Class getClass(String name) throws ClassNotFoundException {
        return FastReflect.getClass(null, name);
    }

    public static final Class getClass(ClassLoader loader, String name) throws ClassNotFoundException {
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return em.getClassObject();
    }

    public static final Object newInstance(String name) throws Exception {
        return FastReflect.newInstance(null, name, (Object[])null);
    }

    public static final Object newInstance(ClassLoader loader, String name) throws Exception {
        return FastReflect.newInstance(loader, name, (Object[])null);
    }

    public static final Object newInstance(String name, Object ... args) throws Exception {
        return FastReflect.newInstance(null, name, args);
    }

    public static final Object newInstance(ClassLoader loader, String name, Object ... args) throws Exception {
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Class[] types = FastReflectUtil.getParamsType(args);
        do {
            Object ret;
            if ((ret = em.newInstance(types, args, loader)) == null) continue;
            return ret;
        } while ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null);
        throw new NoSuchMethodException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306b\u5bfe\u3057\u3066\u3001\u5bfe\u8c61\u5f15\u6570\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public static final Object newInstanceTo(ClassLoader loader, String name, Object[] args, Class[] types) throws Exception {
        FastClassElement em = FastReflectClass.getClass(loader, name);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        }
        do {
            Object ret;
            if ((ret = em.newInstance(types, args, loader)) == null) continue;
            return ret;
        } while ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null);
        throw new NoSuchMethodException("\u6307\u5b9a\u30af\u30e9\u30b9 " + name + " \u306b\u5bfe\u3057\u3066\u3001\u5bfe\u8c61\u5f15\u6570\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
    }

    public static final void setField(String clazzName, Object target, String name, Object value) throws Exception {
        FastReflect.setField(null, clazzName, target, name, value);
    }

    public static final void setField(ClassLoader loader, String clazzName, Object target, String name, Object value) throws Exception {
        Field f;
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        while ((f = em.getField(target == null, name)) == null) {
            if ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        f.set(target, value);
    }

    public static final void setField(Class clazz, Object target, String name, Object value) throws Exception {
        FastReflect.setField(null, clazz, target, name, value);
    }

    public static final void setField(ClassLoader loader, Class clazz, Object target, String name, Object value) throws Exception {
        Field f;
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        while ((f = em.getField(target == null, name)) == null) {
            if ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        f.set(target, value);
    }

    public static final Object getField(String clazzName, Object target, String name) throws Exception {
        return FastReflect.getField(null, clazzName, target, name);
    }

    public static final Object getField(ClassLoader loader, String clazzName, Object target, String name) throws Exception {
        Field f;
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        while ((f = em.getField(target == null, name)) == null) {
            if ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return f.get(target);
    }

    public static final Object getField(Class clazz, Object target, String name) throws Exception {
        return FastReflect.getField(null, clazz, target, name);
    }

    public static final Object getField(ClassLoader loader, Class clazz, Object target, String name) throws Exception {
        Field f;
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        while ((f = em.getField(target == null, name)) == null) {
            if ((em = FastReflectClass.getClass(loader, em.getSuperClassName())) != null) continue;
            throw new NoSuchFieldException("\u6307\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return f.get(target);
    }

    public static final Object invoke(String clazzName, Object target, String name) throws Exception {
        return FastReflect.invoke(null, clazzName, target, name, (Object[])null);
    }

    public static final Object invoke(ClassLoader loader, String clazzName, Object target, String name) throws Exception {
        return FastReflect.invoke(loader, clazzName, target, name, (Object[])null);
    }

    public static final Object invoke(Class clazz, Object target, String name) throws Exception {
        return FastReflect.invoke(null, clazz, target, name, (Object[])null);
    }

    public static final Object invoke(ClassLoader loader, Class clazz, Object target, String name) throws Exception {
        return FastReflect.invoke(loader, clazz, target, name, (Object[])null);
    }

    public static final Object invoke(String clazzName, Object target, String name, Object ... args) throws Exception {
        return FastReflect.invoke(null, clazzName, target, name, args);
    }

    public static final Object invoke(ClassLoader loader, String clazzName, Object target, String name, Object ... args) throws Exception {
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Object[] ret = new Object[1];
        Class[] types = FastReflectUtil.getParamsType(args);
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invoke(Class clazz, Object target, String name, Object ... args) throws Exception {
        return FastReflect.invoke(null, clazz, target, name, args);
    }

    public static final Object invoke(ClassLoader loader, Class clazz, Object target, String name, Object ... args) throws Exception {
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        Object[] ret = new Object[1];
        Class[] types = FastReflectUtil.getParamsType(args);
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invokeTo(ClassLoader loader, String clazzName, Object target, String name, Object[] args, Class[] types) throws Exception {
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        }
        Object[] ret = new Object[1];
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }

    public static final Object invokeTo(ClassLoader loader, Class clazz, Object target, String name, Object[] args, Class[] types) throws Exception {
        String clazzName = clazz.getName();
        FastClassElement em = FastReflectClass.getClass(loader, clazzName);
        if (em == null) {
            throw new ClassNotFoundException("\u6307\u5b9a\u30af\u30e9\u30b9 " + clazzName + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (args != null && args.length > 0 && types == null) {
            types = FastReflectUtil.getParamsType(args);
        }
        Object[] ret = new Object[1];
        while (!em.invokeMethod(ret, target, name, loader, types, args)) {
            String spclazz = em.getSuperClassName();
            if (spclazz == null) {
                throw new NoSuchMethodException("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 " + name + " \u306f\u30af\u30e9\u30b9 " + clazzName + " \u306b\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            em = FastReflectClass.getClass(loader, spclazz);
        }
        return ret[0];
    }
}

