/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _EXT_H_
#define _EXT_H_

extern int _global_length(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isNull(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isBool(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isChar(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isNumber(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isInt(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isFloat(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isString(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isArray(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_isObject(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toBool(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toChar(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toInt(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toFloat(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toNumber(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int _global_toString(exec_t* ex, int argc, var_t* argv, var_t* res);
extern int global_callFunc(exec_t* ex, int sym, int argc, var_t* argv, var_t* res);
extern int string_add(string_t* str, char *s, int n);
extern int string_get(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_del(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_set(exec_t* ex, string_t* str, int i, var_t* v);
extern int string_match(exec_t* ex, char *s1, int n1, var_t* val, var_t* res);
extern void* string_alloc(exec_t* ex);
extern void string_free(exec_t* ex, void *v);
extern void string_trace(void *p);
extern void string_clear(exec_t* ex, void *p);
extern int string_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int string_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int string_setLength(exec_t* ex, void *p, int n);
extern int string_getLength(exec_t* ex, void *p);
extern int string_toBool(var_t* v);
extern int string_toChar(var_t* v);
extern int string_toInt(var_t* v);
extern double string_toFloat(var_t* v);
extern int string_toString(var_t* v, char **s, int *n);
extern int string_toNumber(var_t* v, double *f, int *i);
extern int string_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int regex_exec(void *p, char *s, int n, int i, int so[10], int eo[10]);
extern int regex_comp(void *p, char *s, int n, int f);
extern void regex_free(exec_t* ex, void *p);
extern void* regex_alloc(exec_t* ex);
extern void regex_clear(exec_t* ex, void* p);
extern void regex_trace(void *p);
extern void* array_alloc(exec_t* ex);
extern void array_free(exec_t* ex, void *v);
extern int array_push(exec_t* ex, array_t* arr, var_t* v);
extern int array_pop(exec_t* ex, array_t* arr, var_t* v);
extern int array_get(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_del(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_set(exec_t* ex, array_t* arr, int i, var_t* v);
extern int array_add(exec_t* ex, array_t* arr, int i, var_t* v);
extern void array_trace(void *p);
extern void array_clear(exec_t* ex, void *p);
extern int array_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int array_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int array_setLength(exec_t* ex, void *p, int n);
extern int array_getLength(exec_t* ex, void *p);
extern int array_toBool(var_t* v);
extern int array_toChar(var_t* v);
extern int array_toInt(var_t* v);
extern double array_toFloat(var_t* v);
extern int array_toString(var_t* v, char **s, int *n);
extern int array_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern void* refer_alloc(exec_t* ex);
extern void refer_free(exec_t* ex, void *v);
extern void refer_clear(exec_t* ex, void *p);
extern void refer_trace(void *p);
extern int refer_reserv(exec_t* ex, array_t *arr, var_t* obj, var_t* key);
extern int refer_set(exec_t* ex, var_t* v, var_t* val);
extern int refer_resolv(exec_t* ex, array_t *arr, var_t* obj, var_t* key);
extern int refer_get(exec_t* ex, var_t* v, var_t* res);
extern int refer_del(exec_t* ex, var_t* v, var_t* res);
extern int refer_call(exec_t* ex, var_t *v, int argc, var_t* argv, var_t* res);
extern void* object_alloc(exec_t* ex);
extern void object_free(exec_t* ex, void *v);
extern int object_get(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_del(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_set(exec_t* ex, object_t* obj, int k, var_t* v);
extern int object_each(object_t* obj, int i, each_t* e);
extern void object_trace(void *p);
extern void object_clear(exec_t* ex, void *p);
extern int object_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int object_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v);
extern int object_setLength(exec_t* ex, void *p, int n);
extern int object_getLength(exec_t* ex, void *p);
extern int object_toBool(var_t* v);
extern int object_toChar(var_t* v);
extern int object_toInt(var_t* v);
extern double object_toFloat(var_t* v);
extern int object_toString(var_t* v, char **s, int *n);
extern int object_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern void* frame_alloc(exec_t* ex);
extern void frame_free(exec_t* ex, void *v);
extern void frame_clear(exec_t* ex, void *p);
extern void frame_trace(void *p);
extern int frame_getLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_delLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_setLocal(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_get(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_del(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_set(exec_t* ex, object_t* fp, int k, var_t* v);
extern int frame_getItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int frame_delItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int frame_setItem(exec_t* ex, void *p, var_t* k, var_t* v);
extern int file_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern void* dbm_open(char* path, char* mode);
extern int dbm_getItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_setItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_delItem(exec_t* ex, void* p, var_t* k, var_t* v);
extern int dbm_eachItem(exec_t* ex, void* p, int i, var_t* k, var_t* v);
extern int dbm_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res);
extern int string_to_symbol(char *s, int n);
extern int chars_to_symbol(char* s);
extern int symbol_to_string(int k, char** s, int *n);
extern char* symbol_to_chars(int k);
extern void free_names();
extern void* alloc_link(exec_t* ex, size_t sz, proto_t* proto);
extern void trace_link(link_t* p);
extern void trace_links(exec_t* ex);
extern void* free_link(exec_t* ex, void *v);
extern void free_links(exec_t* ex, void *v);
extern void trace_var(var_t* v);
extern int lock_var(exec_t* ex, var_t* v);
extern int unlock_var(exec_t* ex, var_t* v);
extern int delete_var(exec_t* ex, var_t* v);
extern void copy_var(var_t* v1, var_t* v2);
extern char* typeof_var(var_t* v);
extern int var_add(exec_t* ex, var_t* v1, var_t* v2, var_t* v3);
extern int var_cmpAsNumber(var_t* v1, var_t* v2);
extern int var_cmpAsString(var_t* v1, var_t* v2);
extern int var_cmp(var_t* v1, var_t* v2);
extern int var_toBool(var_t* v);
extern int var_toChar(var_t* v);
extern int var_toInt(var_t* v);
extern double var_toFloat(var_t* v);
extern int var_toString(var_t* v, char **s, int *n);
extern int var_toNumber(var_t* v, double *f, int *i);
extern char* var_toChars(var_t* v);
extern int var_toSymbol(var_t* v);
extern int var_getLength(exec_t* ex, var_t* v, var_t* res);
extern int var_setLength(exec_t* ex, var_t* v, var_t* val);
extern int var_getItem(exec_t* ex, var_t* v, var_t* key, var_t* res);
extern int var_setItem(exec_t* ex, var_t* v, var_t* key, var_t* val);
extern int var_delItem(exec_t* ex, var_t* v, var_t* key, var_t* res);
extern int var_eachItem(exec_t* ex, var_t* v, int i, var_t* key, var_t* val);
extern int var_callFunc(exec_t* ex, var_t* v, int sym, int argc, var_t* argv, var_t* res);
extern void new_null (var_t* v);
extern void new_bool(var_t* v, int i);
extern void new_char (var_t* v, int i);
extern void new_int (var_t* v, int i);
extern void new_symbol (var_t* v, int i);
extern void new_float (var_t* v, double f);
extern void new_label (var_t* v, char *p);
extern void new_function (var_t* v, char *p);
extern void new_class (var_t* v, char *p);
extern void new_file(var_t* v, FILE* fp);
extern void new_dbm(var_t* v, void *p);
extern void new_string_with (exec_t* ex, var_t* v, char *s, int n);
extern void new_string_copy (exec_t* ex, var_t* v, char *s, int n);
extern void new_string (exec_t* ex, var_t* v, void *p);
extern void new_regex (exec_t* ex, var_t* v, char *s, int n, int i);
extern void new_array (exec_t* ex, var_t* v, void *p);
extern void new_refer (exec_t* ex, var_t* v, void *p);
extern void new_object (exec_t* ex, var_t* v, void* p);
extern void new_frame (exec_t* ex, var_t* v, void *p);
extern int serial_to_bytes(exec_t* ex, var_t* v, char **s, int *n);
extern int unserial_from_bytes(exec_t* ex, var_t* v, char *s, int n);
extern int trace_to_bytes(exec_t* ex, var_t* v, char **s, int *n);
extern int untrace_from_bytes(exec_t* ex, var_t* v, char *s, int n);
extern int printf_to_file(FILE* fp, char *s, var_t* va, int vn);
extern int printf_to_bytes(char **d, char *s, var_t* va, int vn);
extern int echo_to_file(exec_t* ex, FILE* fp, char *s, int n);
extern int echo_to_bytes(exec_t* ex, char **d, char *s, int n);
extern int strtotime(char *src, int len, int gm);
extern int timetostr(char dst[BUFSIZ], char *fmt, int n, int t, int gm);
extern int pack_to_bytes(char **dst, char* fmt, var_t* va, int vn);
extern int unpack_from_bytes(exec_t* ex, char *fmt, char *src, int len, var_t* res);
extern int strnmd5(char *d, char *s, unsigned long n);
extern char* strcrypt(char* pw, char* salt);
extern int base64_encode(char *d, char *s, int n);
extern int base64_decode(char *d, char *s, int n);
extern int quotedprintable_encode(char *d, char* s, int n);
extern int quotedprintable_decode(char *d, char* s, int n);
extern int url_encode(char *d, char *s, int n);
extern int url_decode(char *d, char *s, int n);
extern int encode(char **d, char *s, int n, int q);
extern int decode(char **d, char *s, int n, int q);
extern int quote_escape(char *d, char *s, int n, int q);
extern int quote_unescape(char *d, char *s, int n, int q);
extern int quote(char **d, char *s, int n, int q);
extern int unquote(char **d, char *s, int n);
extern int jcodeof(char *s, int n);
extern int to_euc(char *d, char *s, int n);
extern int to_sjis(char *d, char *s, int n);
extern int to_jis(char *d, char *s, int n);
extern int to_utf8(char *d, char *s, int n);
extern int jconv(char **d, char *s, int n, int j);

#endif /* _EXT_H_ */
