/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/************************************************************
 *
 ************************************************************/
static char ini_perm[] = {
57,49,41,33,25,17,9,1,59,51,43,35,27,19,11,3,
61,53,45,37,29,21,13,5,63,55,47,39,31,23,15,7,
56,48,40,32,24,16,8,0,58,50,42,34,26,18,10,2,
60,52,44,36,28,20,12,4,62,54,46,38,30,22,14,6,
};

static char fin_perm[] = {
39,7,47,15,55,23,63,31,38,6,46,14,54,22,62,30,
37,5,45,13,53,21,61,29,36,4,44,12,52,20,60,28,
35,3,43,11,51,19,59,27,34,2,42,10,50,18,58,26,
33,1,41,9,49,17,57,25,32,0,40,8,48,16,56,24,
};

static char sel_perm[] = {
15,6,19,20,28,11,27,16,0,14,22,25,4,17,30,9,
1,7,23,13,31,26,2,8,18,12,29,5,21,10,3,24,
};

static char sel_func[8][64] = {
{14, 4,13, 1, 2,15,11, 8, 3,10, 6,12, 5, 9, 0, 7,
0,15, 7, 4,14, 2,13, 1,10, 6,12,11, 9, 5, 3, 8,
4, 1,14, 8,13, 6, 2,11,15,12, 9, 7, 3,10, 5, 0,
15,12, 8, 2, 4, 9, 1, 7, 5,11, 3,14,10, 0, 6,13},
{15, 1, 8,14, 6,11, 3, 4, 9, 7, 2,13,12, 0, 5,10,
3,13, 4, 7,15, 2, 8,14,12, 0, 1,10, 6, 9,11, 5,
0,14, 7,11,10, 4,13, 1, 5, 8,12, 6, 9, 3, 2,15,
13, 8,10, 1, 3,15, 4, 2,11, 6, 7,12, 0, 5,14, 9},
{10, 0, 9,14, 6, 3,15, 5, 1,13,12, 7,11, 4, 2, 8,
13, 7, 0, 9, 3, 4, 6,10, 2, 8, 5,14,12,11,15, 1,
13, 6, 4, 9, 8,15, 3, 0,11, 1, 2,12, 5,10,14, 7,
1,10,13, 0, 6, 9, 8, 7, 4,15,14, 3,11, 5, 2,12},
{7,13,14, 3, 0, 6, 9,10, 1, 2, 8, 5,11,12, 4,15,
13, 8,11, 5, 6,15, 0, 3, 4, 7, 2,12, 1,10,14, 9,
10, 6, 9, 0,12,11, 7,13,15, 1, 3,14, 5, 2, 8, 4,
3,15, 0, 6,10, 1,13, 8, 9, 4, 5,11,12, 7, 2,14},
{ 2,12, 4, 1, 7,10,11, 6, 8, 5, 3,15,13, 0,14, 9,
14,11, 2,12, 4, 7,13, 1, 5, 0,15,10, 3, 9, 8, 6,
4, 2, 1,11,10,13, 7, 8,15, 9,12, 5, 6, 3, 0,14,
11, 8,12, 7, 1,14, 2,13, 6,15, 0, 9,10, 4, 5, 3},
{12, 1,10,15, 9, 2, 6, 8, 0,13, 3, 4,14, 7, 5,11,
10,15, 4, 2, 7,12, 9, 5, 6, 1,13,14, 0,11, 3, 8,
9,14,15, 5, 2, 8,12, 3, 7, 0, 4,10, 1,13,11, 6,
4, 3, 2,12, 9, 5,15,10,11,14, 1, 7, 6, 0, 8,13},
{ 4,11, 2,14,15, 0, 8,13, 3,12, 9, 7, 5,10, 6, 1,
13, 0,11, 7, 4, 9, 1,10,14, 3, 5,12, 2,15, 8, 6,
1, 4,11,13,12, 3, 7,14,10,15, 6, 8, 0, 5, 9, 2,
6,11,13, 8, 1, 4,10, 7, 9, 5, 0,15,14, 2, 3,12},
{13, 2, 8, 4, 6,15,11, 1,10, 9, 3,14, 5, 0,12, 7,
1,15,13, 8,10, 3, 7, 4,12, 5, 6,11, 0,14, 9, 2,
7,11, 4, 1, 9,12,14, 2, 0, 6,10,13,15, 3, 5, 8,
2, 1,14, 7, 4,10, 8,13,15,12, 9, 0, 3, 5, 6,11},
};

static void encrypt(char* block,
	char KS[16][48], char E[48], char L[64])
{
	static char X[32];
	static char F[32];
	static char S[48];
	char *R = L + 32;
	int i, j, k, t;
	
	for (j = 0; j < 64; j++)
		L[j] = block[(int)ini_perm[j]];
	
	for (i=0; i < 16; i++) {
		memcpy(X, R, 32);
		for (j=0; j < 48; j++)
			S[j] = R[E[j] - 1] ^ KS[i][j];
		for (j=0; j < 8; j++) {
			t = 6 * j;
			k = sel_func[j][(S[t+0] << 5)
				+ (S[t+1] << 3)
				+ (S[t+2] << 2)
				+ (S[t+3] << 1)
				+ (S[t+4] << 0)
				+ (S[t+5] << 4)];
			t = 4 * j;
			F[t+0] = (k >> 3) & 01;
			F[t+1] = (k >> 2) & 01;
			F[t+2] = (k >> 1) & 01;
			F[t+3] = (k >> 0) & 01;
		}
		for (j=0; j < 32; j++)
			R[j] = L[j] ^ F[(int)sel_perm[j]];
		memcpy(L, X, 32);
	}
	for (j=0; j < 32; j++) {
		t = L[j];
		L[j] = R[j];
		R[j] = t;
	}
	for (j = 0; j < 64; j++)
		block[j] = L[(int)fin_perm[j]];
}

/************************************************************
 *
 ************************************************************/
static char shifts[] = {
1,1,2,2,2,2,2,2,1,2,2,2,2,2,2,1,
};

static char choice1_L[] = {
56,48,40,32,24,16,8,0,
57,49,41,33,25,17,9,1,
58,50,42,34,26,18,10,2,
59,51,43,35,
};

static char choice1_R[] = {
62,54,46,38,30,22,14,6,
61,53,45,37,29,21,13,5,
60,52,44,36,28,20,12,4,
27,19,11,3,
};

static char choice2_L[] = {
13,16,10,23,0,4,2,27,
14,5,20,9,22,18,11,3,
25,7,15,6,26,19,12,1,
};

static char choice2_R[] = {
12,23,2,8,18,26,1,11,
22,16,4,19,15,20,10,27,
5,24,17,13,21,7,0,3,
};

static char ebits[] = {
32, 1, 2, 3, 4, 5, 4, 5,
 6, 7, 8, 9, 8, 9,10,11,
 12,13,12,13,14,15,16,17,
16,17,18,19,20,21,20,21,
22,23,24,25,24,25,26,27,
28,29,28,29,30,31,32, 1,
};

char* strcrypt(char* pw, char* salt)
{
	static char KS[16][48];
	static char E[48];
	static char L[64];
	static char block[66];
	static char buf[16];
	char *R = L + 32;
	int i, j, c, t;
	
	memset(buf, 0, 16);
	memset(block, 0, 66);
	
	for (i=0; (i < 64) && ((c = *pw++) != 0); ) {
		for (j=6; j >= 0; j--, i++)
			block[i] = (c>>j) & 01;
		i++;
	}
	
	for (i=0; i < 28; i++) {
		L[i] = block[(int)choice1_L[i]];
		R[i] = block[(int)choice1_R[i]];
	}
	for (i=0; i < 16; i++) {
		for (j=0; j < shifts[i]; j++) {
			L[28] = L[0];
			memcpy(L, L+1, 28);
			R[28] = R[0];
			memcpy(R, R+1, 28);
		}
		for (j=0; j < 24; j++) {
			KS[i][j   ] = L[(int)choice2_L[j]];
			KS[i][j+24] = R[(int)choice2_R[j]];
		}
	}
	
	memcpy(E, ebits, 48);
	for (i=0; i < 2; i++) {
		c = *salt++;
		buf[i] = c;
		if (c > 'Z') c -= 6;
		if (c > '9') c -= 7;
		c -= '.';
		for (j=0; j < 6; j++) {
			if ((c >> j) & 01) {
				t = E[6*i + j];
				E[6*i + j] = E[6*i + j+24];
				E[6*i + j+24] = t;
			}
		}
	}
	
	memset(block, 0, 66);
	memset(L, 0, 64);
	
	for (i=0; i < 25; i++)
		encrypt(block, KS, E, L);
	
	for (i=0; i < 11; i++) {
		c = 0;
		for (j=0; j < 6; j++) {
			c <<= 1;
			c |= block[6*i + j];
		}
		c += '.';
		if (c > '9') c += 7;
		if (c > 'Z') c += 6;
		buf[i+2] = c;
	}
	
	buf[i+2] = 0;
	
	if (buf[1] == 0) {
		buf[1] = buf[0];
	}
	
	return buf;
}
