/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
static int skip_brace(char **s, char *e, int q);

static int issymbols(char *s, int n)
{
	if (!n-- || !(isalpha(*s) || (*s == '_'))) return 0;
	for (s++; n-- > 0; s++) {
		if (!(isalnum(*s) || (*s == '_'))) return 0;
	}
	return 1;
}
static int skip_symbol(char **s, char *e)
{
	int c;
	if ((*s >= e) || !(isalpha(**s) || (**s == '_'))) return 0;
	while ((*s < e) && (isalnum(**s) || (**s == '_'))) (*s)++;
	if ((*s < e) && ((c = **s) != 0)) {
		if (c == '.') {
			(*s)++;
			if (!skip_symbol(s, e)) return 0;
			return c;
		}
		else if ((c == '[') || (c =='(')) {
			(*s)++;
			if (!skip_brace(s, e, c)) return 0;
			return c;
		}
	}
	return 1;
}
static int skip_quote(char **s, char *e, int q)
{
	while ((*s < e) && **s && (**s != q)) {
		if ((*(*s)++ == '\\') && **s) (*s)++;
	}
	if ((*s >= e) || (**s != q)) return 0;
	(*s)++;
	return 1;
}
static int skip_number(char **s, char *e)
{
	if (strchr("+-.", **s)) (*s)++;
	if ((*s >= e) || !isdigit(**s)) return 0;
	(*s)++;
	while ((*s < e) && (isalnum(**s) || (**s == '.'))) (*s)++;
	return 1;
}
static int skip_brace(char **s, char *e, int q)
{
	int c;
	switch (q) {
	case '{': q='}'; break;
	case '[': q=']'; break;
	case '(': q=')'; break;
	}
	while ((*s < e) && isspace(**s)) (*s)++;
	if (!(c = **s)) return 0;
	else if ((c == '"') || (c == '\'')) {
		(*s)++;
		if (!skip_quote(s, e, c)) return 0;
	}
	else if ((c == '{') || (c == '(')) {
		(*s)++;
		if (!skip_brace(s, e, c)) return 0;
	}
	else if ((q == ')') && (c == ',')) {
		(*s)++;
		if (!skip_brace(s, e, q)) return 0;
	}
	else if (isalpha(c) || (c == '_')) {
		if (!skip_symbol(s, e)) return 0;
	}
	else if (isdigit(c) || strchr("+-.", c)) {
		if (!skip_number(s, e)) return 0;
	}
	while ((*s < e) && isspace(**s)) (*s)++;
	if ((*s >= e) || (**s != q)) return 0;
	(*s)++;
	return 1;
}

/************************************************************
 *
 ************************************************************/
static int echo_to_stream(exec_t* ex, stream_t* st, char *s, int n)
{
	var_t v;
	char *e, *f;
	int c, m, r;
	
	e = s + n;
	f = s;
	n = 0;
	while (skip_quote(&f, e, '$')) {
		if ((m = (f - 1) - s) > 0) {
			n += stream_write(st, s, m);
		}
		v.type = 0;
		r = 0;
		c = *f++;
		if (c == '$') {
			new_int(&v, getpid());
			r = 1;
		} else if (isalpha(c) || (c == '_')) {
			s = --f;
			if (skip_symbol(&f, e)) {
				assert((m = f - s) > 0);
				if (issymbols(s, m)) {
					c = string_to_symbol(s, m);
					r = frame_get(ex, ex->fp, c, &v);
				} else {
					r = eval_bytes(ex, s, m, &v);
				}
			}
		} else if ((c == '{') || (c == '(')) {
			s = f;
			if (skip_brace(&f, e, c)) {
				if ((m = (f - 1) - s) > 0) {
					r = eval_bytes(ex, s, m, &v);
				}
			}
		}
		if (r) {
			if (var_toString(&v, &s, &m)) {
				n += stream_write(st, s, m);
			}
		}
		s = f;
	}
	if ((m = e - s) > 0) {
		n += stream_write(st, s, m);
	}
	stream_flush(st);
	return n;
}

int echo_to_file(exec_t* ex, FILE* fp, char *s, int n)
{
	stream_t st;
	memset(&st, 0, sizeof(stream_t));
	st.fp = fp;
	n = echo_to_stream(ex, &st, s, n);
	return n;
}
int echo_to_bytes(exec_t* ex, char **d, char *s, int n)
{
	stream_t st;
	memset(&st, 0, sizeof(stream_t));
	n = echo_to_stream(ex, &st, s, n);
	*d = st.sp;
	return n;
}
