/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

/************************************************************
 *
 ************************************************************/
static inline int itob(int c) {
	if (c < 26) return (c + 'A');
	else if (c < 52) return ((c - 26) + 'a');
	else if (c < 62) return ((c - 52) + '0');
	else if (c==62) return '+';
	else if (c==63) return '/';
	return '0';
}
int base64_encode(char *d, char *s, int n)
{
	char *e;
	int c,b,m;
	e = s + n;
	n=m=b=0;
	while (s < e) {
		c = *s++;
		if (!m) {
			d[n++]=itob(c>>2);
			b=(c & 0x3) << 4;
			m=2;
		} else if (m==2) {
			d[n++]=itob(b | (c>>4));
			b=(c & 0xF) << 2;
			m=4;
		} else if (m==4) {
			d[n++]=itob(b | (c>>6));
			d[n++]=itob(c & 0x3F);
			b = 0;
			m=0;
		}
	}
	if (m) {
		d[n++]=itob(b);
		while (m < 6) {
			d[n++]='=';
			m+=2;
		}
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
static inline int btoi(int c) {
	if (isupper(c)) return (c - 'A');
	else if (islower(c)) return ((c - 'a') + 26);
	else if (isdigit(c)) return ((c - '0') + 52);
	else if (c=='+') return 62;
	else if (c=='/') return 63;
	return 0;
}
int base64_decode(char *d, char *s, int n)
{
	char *e;
	int c,b,m;
	e = s + n;
	n=m=b=0;
	while ((s < e) && ((c=*s++)!=0)) {
		if (c==0x0A || c==0x0D) continue;
		if (! (isalnum(c) || c=='+' || c=='/') ) break;
		c = btoi(c);
		if (!m) {
			b=c << 2; m=6;
		} else if (m==6) {
			d[n++]=b | (c>>4);
			b=(c & 0xF) << 4; m=4;
		} else if (m==4) {
			d[n++]=b | (c>>2);
			b=(c & 0x3) << 6; m=2;
		} else if (m==2) {
			d[n++]=b | c;
			b=0; m=0;
		}
	}
	while (c=='=') {
		m-=2;
		c=*s++;
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
int quotedprintable_encode(char *d, char* s, int n) {
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s < e) && ((c=*s++)!=0)) {
		if ((c != '=') && (isspace(c) || isprint(c))) {
			d[n++]=c;
			continue;
		}
		d[n++]='=';
		d[n++]=itoX(c >> 4);
		d[n++]=itoX(c & 0xF);
	}
	d[n]=0;
	return n;
}

int quotedprintable_decode(char *d, char* s, int n)
{
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s < e) && ((c=*s++)!=0)) {
		if (c=='=') {
			while ((s < e) && isspace(*s)) s++;
			if ((s < e) && isxdigit(*s)) {
				c = xtoi(*s++);
				if ((s < e) && isxdigit(*s)) {
					c = (c << 4) | xtoi(*s++);
				}
			}
		}
		d[n++]=c;
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
int url_encode(char *d, char *s, int n)
{
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s<e) && ((c=*s++)!=0)) {
		if (isalnum(c) || strchr("_-.", c)) {
			d[n++] = c;
		} else {
			d[n++] = '%';
			d[n++] = itoX(c >> 4);
			d[n++] = itoX(c & 0xF);
		}
	}
	d[n]=0;
	return n;
}
int url_decode(char *d, char *s, int n)
{
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s < e) && ((c=*s++)!=0)) {
		if (c=='%') {
			if ((s < e) && isxdigit(*s)) {
				c  = xtoi(*s++);
				if ((s < e) && isxdigit(*s)) {
					c = (c << 4) | xtoi(*s++);
				}
			}
		} else if (c=='+') {
			c = ' ';
		}
		d[n++]=c;
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
extern int to_euc(char *d, char *s, int n);
extern int to_sjis(char *d, char *s, int n);
extern int to_jis(char *d, char *s, int n);
extern int to_utf8(char *d, char *s, int n);

static int mime_encode(char *d, char *s, int n)
{
	char *div = ",=:;";
	char *e, *s2, *e2;
	int c, m;
	
	e = s + n;
	s2 = s;
	n = 0;
	while ((s2 < e) && *s2) {
		if (isspace(*s2) || strchr(div, *s2)) {
			s2++;
			continue;
		}
		e2 = s2;
		c = 0;
		if (*e2++ == '"') {
			while ((e2 < e) && *e2 && (*e2 != '"')) {
				if (*e2 == '\\') e2++;
				c += !isprint(*e2++);
			}
		} else {
			while ((e2 < e) && *e2
			&& !isspace(*e2) && !strchr(div, *e2)) {
				c += !isprint(*e2++);
			}
		}
		if (!c) {
			s2 = e2;
			continue;
		}
		if ((m = s2 - s) > 0) {
			n += sputsn(d+n, s, m);
		}
		if (*s2=='"') d[n++]=*s2++;
		if ((m = e2 - s2) < 2) {
			;
		} else {
			s = malloc((m * 4) + 1);
			m = to_jis(s, s2, m);
			n += sputs(d+n, "=?iso-2022-jp?b?");
			n += base64_encode(d+n, s, m);
			n += sputs(d+n, "?=");
			free(s);
		}
		if (*e2=='"') d[n++]=*e2++;
		s = s2 = e2;
	}
	if ((m = e - s) > 0) {
		n += sputsn(d+n, s, m);
	}
	d[n]=0;
	return n;
}
static int mime_decode(char *d, char *s, int n)
{
	char *e, *s2, *e2;
	int q, m;
	
	e = s + n;
	n = 0;
	while ((s < e)
	&& ((s2 = strstr(s, "=?")) != NULL)) {
		if ((m = s2 - s) > 0) {
			n += sputsn(d+n, s, m);
		}
		s = s2 + 2;
		if (((s2 = strchr(s, '?')) != NULL)
		&& isalpha(q = *(++s2)) && (*(++s2) == '?')
		&& ((e2 = strstr(++s2, "?=")) != NULL)
		&& ((e2 + 2) <= e)) {
			if ((m = e2 - s2) > 0) {
				s = malloc(m + 1);
				switch (tolower(q)) {
				case 'q':
					m = quotedprintable_decode(s, s2, m);
					break;
				case 'b':
					m = base64_decode(s, s2, m);
					break;
				default:
					m = 0;
					break;
				}
				if (m > 0) {
					n += to_utf8(d+n, s, m);
				}
				free(s);
			}
			s = e2 + 2;
		}
	}
	if ((m = e - s) > 0) {
		n += sputsn(d+n, s, m);
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
static int html_entity(char *d, char *s, int n)
{
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s < e) && ((c = *s++) != 0)) {
		if (c == '<') {
			n += sputs(d+n, "&lt;");
		} else if (c == '>') {
			n += sputs(d+n, "&gt;");
		} else if (c == '&') {
			n += sputs(d+n, "&amp;");
		} else if (c == '"') {
			n += sputs(d+n, "&quot;");
		} else {
			d[n++] = c;
		}
	}
	d[n] = 0;
	return n;
}
static int html_unentity(char *d, char *s, int n)
{
	static struct { char *s; int n; int c; } ent[] = {
	{"lt",2,'<'},
	{"gt",2,'>'},
	{"amp",3,'&'},
	{"quot",4,'"'},
	{"nbsp",4,'\t'},
	{NULL,0,0}
	};
	
	char *e;
	int i,c;
	
	e  = s + n;
	n = 0;
	while ((s < e) && ((c = *s++) != 0)) {
		if (c == '&') {
			for (i=0; ent[i].s; i++) {
				if (!strncmp(s, ent[i].s, ent[i].n)) {
					s += ent[i].n;
					c = ent[i].c;
					if (*s == ';') s++;
					break;
				}
			}
		}
		d[n++] = c;
	}
	d[n] = 0;
	return n;
}

/************************************************************
 *
 ************************************************************/
int encode(char **d, char *s, int n, int q)
{
	switch (tolower(q)) {
	case 'b':
		*d = malloc((n * 2) + 1);
		n = base64_encode(*d, s, n);
		break;
	case 'q':
		*d = malloc((n * 3) + 1);
		n = quotedprintable_encode(*d, s, n);
		break;
	case 'm':
		*d = malloc((n * 16) + 1);
		n = mime_encode(*d, s, n);
		break;
	case 'h':
		*d = malloc((n * 6) + 1);
		n = html_entity(*d, s, n);
		break;
	case 'u':
	default:
		*d = malloc((n * 3) + 1);
		n = url_encode(*d, s, n);
		break;
	}
	if (!n && *d) {
		free(*d);
		*d = NULL;
	}
	return n;
}
int decode(char **d, char *s, int n, int q)
{
	switch (tolower(q)) {
	case 'b':
		*d = malloc(n + 1);
		n = base64_decode(*d, s, n);
		break;
	case 'q':
		*d = malloc(n + 1);
		n = quotedprintable_decode(*d, s, n);
		break;
	case 'm':
		*d = malloc((n * 2) + 1);
		n = mime_decode(*d, s, n);
		break;
	case 'h':
		*d = malloc(n + 1);
		n = html_unentity(*d, s, n);
		break;
	case 'u':
	default:
		*d = malloc(n + 1);
		n = url_decode(*d, s, n);
		break;
	}
	if (!n && *d) {
		free(*d);
		*d = NULL;
	}
	return n;
}

/************************************************************
 *
 ************************************************************/
int quote_escape(char *d, char *s, int n, int q)
{
	char *e;
	int c;
	if (!q) q = '"';
	e = s + n;
	n = 0;
	while ((s < e) && ((c = *s++) !=0)) {
		if (metac(&c, q)) {
			d[n++] = '\\';
		}
		d[n++]=c;
	}
	d[n]=0;
	return n;
}

int quote_unescape(char *d, char *s, int n, int q)
{
	char *e;
	int c;
	e = s + n;
	n = 0;
	while ((s < e) && ((c = *s++) != 0)) {
		if ((c=='\\') && (s < e)) {
			c = unmetac(&s, q);
		}
		d[n++]=c;
	}
	d[n]=0;
	return n;
}

/************************************************************
 *
 ************************************************************/
int quote(char **d, char *s, int n, int q)
{
	if (!q) q = '"';
	*d = malloc((n * 2) + 3);
	n = quote_escape(*d + 1, s, n, q);
	if (!n && *d) {
		free(*d);
		*d = NULL;
	}
	**d = q;
	*(*d + ++n) = q;
	*(*d + ++n) = 0;
	return n;
}
int unquote(char **d, char *s, int n)
{
	int q;
	if (n-- < 3) return 0;
	if (!(q = *s++)) return 0;
	if (*(s + --n) != q) return 0;
	*d = malloc(n + 1);
	n = quote_unescape(*d, s, n, q);
	if (!n && *d) {
		free(*d);
		*d = NULL;
	}
	return n;
}
