/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

/************************************************************
 *
 ************************************************************/
static unsigned long md5mix(int m, unsigned long a,
unsigned long b, unsigned long c, unsigned long d,
unsigned long e, unsigned long f, int s)
{
	switch (m) {
	case 1: a += ((b & c) | (~b & d)) + e + f; break; 
	case 2: a += ((b & d) | (c & ~d)) + e + f; break;
	case 3: a += (b ^ c ^ d) + e + f; break;
	case 4: a += (c ^ (b | ~d)) + e + f; break;
	}
	return ( ((a << s) | (a >> (32 - s))) + b );
}

static void md5map(unsigned long val[4], char *s)
{
	unsigned long a, b, c, d, e[16];
	int i, j, k;
	
	a = val[0];
	b = val[1];
	c = val[2];
	d = val[3];
	
	for (i=0,j=0; i < 16; i++) {
		e[i] = 0;
		for (k=0; k < 4; k++)
			e[i] |= s[j++] << (k * 8);
	}
	
	a = md5mix(1, a, b, c, d, e[ 0], 0xd76aa478,  7);
	d = md5mix(1, d, a, b, c, e[ 1], 0xe8c7b756, 12);
	c = md5mix(1, c, d, a, b, e[ 2], 0x242070db, 17);
	b = md5mix(1, b, c, d, a, e[ 3], 0xc1bdceee, 22);
	a = md5mix(1, a, b, c, d, e[ 4], 0xf57c0faf,  7);
	d = md5mix(1, d, a, b, c, e[ 5], 0x4787c62a, 12);
	c = md5mix(1, c, d, a, b, e[ 6], 0xa8304613, 17);
	b = md5mix(1, b, c, d, a, e[ 7], 0xfd469501, 22);
	a = md5mix(1, a, b, c, d, e[ 8], 0x698098d8,  7);
	d = md5mix(1, d, a, b, c, e[ 9], 0x8b44f7af, 12);
	c = md5mix(1, c, d, a, b, e[10], 0xffff5bb1, 17);
	b = md5mix(1, b, c, d, a, e[11], 0x895cd7be, 22);
	a = md5mix(1, a, b, c, d, e[12], 0x6b901122,  7);
	d = md5mix(1, d, a, b, c, e[13], 0xfd987193, 12);
	c = md5mix(1, c, d, a, b, e[14], 0xa679438e, 17);
	b = md5mix(1, b, c, d, a, e[15], 0x49b40821, 22);
	
	a = md5mix(2, a, b, c, d, e[ 1], 0xf61e2562,  5);
	d = md5mix(2, d, a, b, c, e[ 6], 0xc040b340,  9);
	c = md5mix(2, c, d, a, b, e[11], 0x265e5a51, 14);
	b = md5mix(2, b, c, d, a, e[ 0], 0xe9b6c7aa, 20);
	a = md5mix(2, a, b, c, d, e[ 5], 0xd62f105d,  5);
	d = md5mix(2, d, a, b, c, e[10], 0x02441453,  9);
	c = md5mix(2, c, d, a, b, e[15], 0xd8a1e681, 14);
	b = md5mix(2, b, c, d, a, e[ 4], 0xe7d3fbc8, 20);
	a = md5mix(2, a, b, c, d, e[ 9], 0x21e1cde6,  5);
	d = md5mix(2, d, a, b, c, e[14], 0xc33707d6,  9);
	c = md5mix(2, c, d, a, b, e[ 3], 0xf4d50d87, 14);
	b = md5mix(2, b, c, d, a, e[ 8], 0x455a14ed, 20);
	a = md5mix(2, a, b, c, d, e[13], 0xa9e3e905,  5);
	d = md5mix(2, d, a, b, c, e[ 2], 0xfcefa3f8,  9);
	c = md5mix(2, c, d, a, b, e[ 7], 0x676f02d9, 14);
	b = md5mix(2, b, c, d, a, e[12], 0x8d2a4c8a, 20);
	
	a = md5mix(3, a, b, c, d, e[ 5], 0xfffa3942,  4);
	d = md5mix(3, d, a, b, c, e[ 8], 0x8771f681, 11);
	c = md5mix(3, c, d, a, b, e[11], 0x6d9d6122, 16);
	b = md5mix(3, b, c, d, a, e[14], 0xfde5380c, 23);
	a = md5mix(3, a, b, c, d, e[ 1], 0xa4beea44,  4);
	d = md5mix(3, d, a, b, c, e[ 4], 0x4bdecfa9, 11);
	c = md5mix(3, c, d, a, b, e[ 7], 0xf6bb4b60, 16);
	b = md5mix(3, b, c, d, a, e[10], 0xbebfbc70, 23);
	a = md5mix(3, a, b, c, d, e[13], 0x289b7ec6,  4);
	d = md5mix(3, d, a, b, c, e[ 0], 0xeaa127fa, 11);
	c = md5mix(3, c, d, a, b, e[ 3], 0xd4ef3085, 16);
	b = md5mix(3, b, c, d, a, e[ 6], 0x04881d05, 23);
	a = md5mix(3, a, b, c, d, e[ 9], 0xd9d4d039,  4);
	d = md5mix(3, d, a, b, c, e[12], 0xe6db99e5, 11);
	c = md5mix(3, c, d, a, b, e[15], 0x1fa27cf8, 16);
	b = md5mix(3, b, c, d, a, e[ 2], 0xc4ac5665, 23);
	
	a = md5mix(4, a, b, c, d, e[ 0], 0xf4292244,  6);
	d = md5mix(4, d, a, b, c, e[ 7], 0x432aff97, 10);
	c = md5mix(4, c, d, a, b, e[14], 0xab9423a7, 15);
	b = md5mix(4, b, c, d, a, e[ 5], 0xfc93a039, 21);
	a = md5mix(4, a, b, c, d, e[12], 0x655b59c3,  6);
	d = md5mix(4, d, a, b, c, e[ 3], 0x8f0ccc92, 10);
	c = md5mix(4, c, d, a, b, e[10], 0xffeff47d, 15);
	b = md5mix(4, b, c, d, a, e[ 1], 0x85845dd1, 21);
	a = md5mix(4, a, b, c, d, e[ 8], 0x6fa87e4f,  6);
	d = md5mix(4, d, a, b, c, e[15], 0xfe2ce6e0, 10);
	c = md5mix(4, c, d, a, b, e[ 6], 0xa3014314, 15);
	b = md5mix(4, b, c, d, a, e[13], 0x4e0811a1, 21);
	a = md5mix(4, a, b, c, d, e[ 4], 0xf7537e82,  6);
	d = md5mix(4, d, a, b, c, e[11], 0xbd3af235, 10);
	c = md5mix(4, c, d, a, b, e[ 2], 0x2ad7d2bb, 15);
	b = md5mix(4, b, c, d, a, e[ 9], 0xeb86d391, 21);
	
	val[0] += a;
	val[1] += b;
	val[2] += c;
	val[3] += d;
}

int strnmd5(char *d, char *s, unsigned long n)
{
	unsigned long val[4];
	char buf[64];
	unsigned long v;
	char c;
	int i, j, k;
	
	val[0] = 0x67452301;
	val[1] = 0xefcdab89;
	val[2] = 0x98badcfe;
	val[3] = 0x10325476;
	
	for (i=0; (i + 64) <= n; i+=64) {
		md5map(val, s + i);
	}
	j = n - i; /* remain strings */
	memset(buf, 0, 64);
	memcpy(buf, s + i, j);
	buf[j] = 0x80;
	if (j >= 56) {
		md5map(val, buf);
		memset(buf, 0, 64);
	}
	for (i=0,j=56; i<2; i++) {
		v = i ? (n >> 29) : (n << 3);
		for (k=0; k < 4; k++)
			buf[j++] = (v >> (k * 8)) & 0xFF;
	}
	md5map(val, buf);
	
	for (i=0,j=0; i < 4; i++) {
		for (k=0; k < 4; k++) {
			c = (val[i] >> (k * 8)) & 0xFF;
			d[j++] = itoX(c >> 4);
			d[j++] = itoX(c & 0xF);
		}
	}
	d[j]=0;
	return j;
}
