/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
typedef struct pf_t pf_t;

struct pf_t {
	int opt;
	int div;
	int pad;
	int pre;
	int min;
	int max;
	int base;
	int left;
	int sign;
	int upper;
	int type;
};

/************************************************************
 *
 ************************************************************/
static int pf_int_to_str(char *s2, unsigned int u, int div, int base, int upper)
{
	char *ns;
	char s1[256];
	int n, m;
	n = m = 0;
	ns = upper ? "0123456789ABCDEF" : "0123456789abcdef";
	while (u > 0) {
		if (div && n && !(n % 3)) s1[m++] = ',';
		s1[m++] = ns[u % base];
		u /= base;
		n++;
	}
	if (!m) s1[m++] = '0';
	n = 0;
	while (m > 0) {
		s2[n++] = s1[--m];
	}
	s2[n] = 0;
	return n;
}
static int pf_float_to_str(char *s, double f, int max, int div)
{
	int n, m, c;
	n = 0;
	m = pf_int_to_str(s, f, div, 10, 0);
	c = (int)(f *= 10) % 10;
	while (max ? (n < max) : (c && n < 6)) {
		if (!n) s[m++] = '.';
		s[m++] = c + '0';
		n++;
		c = (int)(f *= 10) % 10;
	}
	s[m] = 0;
	return m;
}

/************************************************************
 *
 ************************************************************/
static int pf_put_int(pf_t* pf, stream_t* st, int v)
{
	char s[256];
	int n=0, m=0;
	
	if (pf->opt) {
		if (pf->base == 16) {
			n += stream_write(st, "0x", 2);
		} else {
			n += stream_putc(st, '0');
		}
	}
	if (pf->sign && (v < 0)) {
		s[m++] = '-';
		v = -v;
	} else if (pf->pre) {
		s[m++] = pf->pre;
	}
	
	m += pf_int_to_str(s + m, v, pf->div, pf->base, pf->upper);
	
	if (!pf->left) {
		for (pf->min -= m; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	n += stream_write(st, s, m);
	if (pf->left) {
		for (pf->min -= n; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	return n;
}
static int pf_put_float(pf_t* pf, stream_t* st, double f)
{
	char *ks;
	char s[256];
	int n=0, m=0, e, k;
	
	if (f < 0) {
		s[m++] = '-';
		f = -f;
	} else if (pf->pre) {
		s[m++] = pf->pre;
	}
	
	k= 0;
	e = f ? log10(f) : 0;
	if (pf->opt == 'k') {
		e /= 3;
		if (e >= 1) {
			ks = pf->upper ? "KMGTPEZY" : "kmgtpezy";
			k = ks[e - 1];
			e *= 3;
		} else {
			e = 0;
		}
	} else if (pf->opt == 'g') {
		if (!pf->max) pf->max = 6;
		if ((e < pf->max) && (e > -pf->max)) {
			e = pf->max = 0;
		} else {
			pf->max--;
		}
	} else if (pf->opt == 'e') {
		;
	} else {
		e = 0;
	}
	
	if (e) {
		f /= pow(10, e);
	}
	
	m += pf_float_to_str(s + m, f, pf->max, pf->div);
	
	if (k) {
		s[m++] = k;
	} else if (e) {
		s[m++] = pf->upper ? 'E' : 'e';
		s[m++] = (e < 0) ? '-' : '+';
		if (e < 0) e = -e;
		s[m++] = (e / 10) + '0';
		s[m++] = (e % 10) + '0';
	}
	
	if (!pf->left) {
		for (pf->min -= (n + m); pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	
	n += stream_write(st, s, m);
	
	if (pf->left) {
		for (pf->min -= n; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	return n;
}
static int pf_put_char(pf_t* pf, stream_t* st, int c)
{
	int n = 0;
	if (!pf->left) {
		for (pf->min -= (c != 0); pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	if (c) {
		n += stream_putc(st, c);
	}
	if (pf->left) {
		for (pf->min -= n; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	return n;
}
static int pf_put_string(pf_t* pf, stream_t* st, char *s, int m)
{
	int n = 0;
	if ((pf->max > 0) && (m > pf->max)) m = pf->max;
	if (!pf->left) {
		for (pf->min -= m; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	if (m > 0) {
		n += stream_write(st, s, m);
	}
	if (pf->left) {
		for (pf->min -= n; pf->min > 0; pf->min--) {
			n += stream_putc(st, pf->pad);
		}
	}
	return n;
}
static int pf_parse(pf_t* pf, char **s)
{
	int c;
	if (**s == '%') {
		(*s)++;
		return 0;
	}
	memset(pf, 0, sizeof(pf_t));
	pf->pad = ' ';
	pf->base = 10;
	pf->sign = 1;
	while ((c = **s) != 0) {
		if (c=='-') pf->left=1;
		else if (c=='0') pf->pad=c;
		else if (c=='+') pf->pre=c;
		else if (c==' ') pf->pre=c;
		else if (c=='#') pf->opt=1;
		else if (c==',') pf->div=1;
		else break;
		(*s)++;
	}
	if (**s == '*') { (*s)++; pf->min = -1; } 
	else { while (isdigit(**s)) pf->min=(pf->min*10)+(*(*s)++ - '0'); }
	if (**s == '.') { (*s)++;
	if (**s == '*') { (*s)++; pf->max = -1; }
	else { while (isdigit(**s)) pf->max=(pf->max*10)+(*(*s)++ - '0'); } }
	c = **s;
	if (!isalpha(c)) return 0;
	(*s)++;
	pf->upper = isupper(c);
	c = tolower(c);
	if (strchr("doux", c)) {
		pf->type = 'i';
		pf->sign = c == 'd';
		if (c == 'x') pf->base = 16;
		else if (c == 'o') pf->base = 8;
	} else if (strchr("efgk", c)) {
		pf->type = 'f';
		pf->opt = c;
	}
	else if (c == 'c') pf->type = c;
	else if (c == 's') pf->type = c;
	else return 0;
	return pf->type;
}

/************************************************************
 *
 ************************************************************/
static int printf_to_stream(stream_t* st, char *s, var_t* va, int vn)
{
	pf_t pf;
	var_t* v;
	char *e;
	int i, m, n;
	n = 0;
	i = 0;
	e = s;
	while ((e = strchr(e, '%')) != NULL) {
		m = e++ - s;
		if (!pf_parse(&pf, &e)) continue;
		if (m > 0) {
			n += stream_write(st, s, m);
		}
		if (pf.min < 0) pf.min = (i < vn) ? var_toInt(va + i++) : 0;
		if (pf.max < 0) pf.max = (i < vn) ? var_toInt(va + i++) : 0;
		v = (i < vn) ? (va + i++) : NULL;
		switch (pf.type) {
		case 'i':
			n += pf_put_int(&pf, st, v ? var_toInt(v) : 0);
			break;
		case 'f':
			n += pf_put_float(&pf, st, v ? var_toFloat(v) : 0);
			break;
		case 'c':
			n += pf_put_char(&pf, st, v ? var_toChar(v) : 0);
			break;
		case 's':
			if (!v || !var_toString(v, &s, &m)) m = 0;
			n += pf_put_string(&pf, st, s, m);
			break;
		}
		s = e;
	}
	if ((m = strlen(s)) > 0) {
		n += stream_write(st, s, m);
	}
	stream_flush(st);
	return n;
}

int printf_to_file(FILE* fp, char *s, var_t* va, int vn)
{
	stream_t st;
	int n;
	memset(&st, 0, sizeof(stream_t));
	st.fp = fp;
	n = printf_to_stream(&st, s, va, vn);
	return n;
}
int printf_to_bytes(char **d, char *s, var_t* va, int vn)
{
	stream_t st;
	int n;
	memset(&st, 0, sizeof(stream_t));
	n = printf_to_stream(&st, s, va, vn);
	*d = st.sp;
	return n;
}
